/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class BaseDataContext
implements DataContext {
    private final TimeZone timeZone = TimeZone.getDefault();
    private static final SchemaPlus DFLT_SCHEMA = Frameworks.createRootSchema((boolean)false);
    private static final Locale LOCALE = Locale.ENGLISH;
    private final long startTs;
    private final IgniteTypeFactory typeFactory;

    public BaseDataContext(IgniteTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        long ts = U.currentTimeMillis();
        this.startTs = ts + (long)this.timeZone.getOffset(ts);
    }

    public SchemaPlus getRootSchema() {
        return DFLT_SCHEMA;
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public QueryProvider getQueryProvider() {
        return null;
    }

    public Object get(String name) {
        if (DataContext.Variable.TIME_ZONE.camelName.equals(name)) {
            return this.timeZone;
        }
        if (DataContext.Variable.CURRENT_TIMESTAMP.camelName.equals(name)) {
            return this.startTs;
        }
        if (DataContext.Variable.LOCAL_TIMESTAMP.camelName.equals(name)) {
            return this.startTs;
        }
        if (DataContext.Variable.LOCALE.camelName.equals(name)) {
            return LOCALE;
        }
        return null;
    }
}

