/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteRexBuilder
extends RexBuilder {
    public IgniteRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    protected RexLiteral makeLiteral(@Nullable Comparable o, RelDataType type, SqlTypeName typeName) {
        if (o != null && typeName == SqlTypeName.DECIMAL) {
            BigDecimal bd = (BigDecimal)o;
            if (type.getSqlTypeName() == SqlTypeName.BIGINT) {
                try {
                    bd.longValueExact();
                }
                catch (ArithmeticException e) {
                    throw new IgniteSQLException(SqlTypeName.BIGINT.getName() + " overflow", (Throwable)e);
                }
            }
            if (type instanceof IntervalSqlType) {
                bd = bd.multiply(((IntervalSqlType)type).getIntervalQualifier().getUnit().multiplier);
                return super.makeLiteral((Comparable)bd, type, type.getSqlTypeName());
            }
            if (TypeUtils.hasScale(type) && SqlTypeUtil.isNumeric((RelDataType)type)) {
                return super.makeLiteral((Comparable)bd.setScale(type.getScale(), RoundingMode.HALF_UP), type, typeName);
            }
        }
        return super.makeLiteral(o, type, typeName);
    }
}

