/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.internal;

import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TimestampConverter {
    private final Timestamp timestamp;
    private final long nanoTime;

    public static TimestampConverter now(Clock clock) {
        return new TimestampConverter(clock.now(), clock.nowNanos());
    }

    public Timestamp convertNanoTime(long nanoTime) {
        return this.timestamp.addNanos(nanoTime - this.nanoTime);
    }

    private TimestampConverter(Timestamp timestamp, long nanoTime) {
        this.timestamp = timestamp;
        this.nanoTime = nanoTime;
    }
}

