/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Hints;
import org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.runtime.AddPointOperation;
import org.apache.calcite.runtime.AddZTransformer;
import org.apache.calcite.runtime.BufferStyle;
import org.apache.calcite.runtime.CoordinateTransformer;
import org.apache.calcite.runtime.FlipCoordinatesTransformer;
import org.apache.calcite.runtime.HilbertCurve2D;
import org.apache.calcite.runtime.ProjectionTransformer;
import org.apache.calcite.runtime.RemoveHoleTransformer;
import org.apache.calcite.runtime.RemovePointOperation;
import org.apache.calcite.runtime.RemoveRepeatedPointsTransformer;
import org.apache.calcite.runtime.SpatialTypeUtils;
import org.apache.calcite.runtime.SplitOperation;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.locationtech.jts.algorithm.InteriorPoint;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.OctagonalEnvelope;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.GeometryEditor;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurve;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.polygon.ConstrainedDelaunayTriangulator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.util.GeometricShapeFactory;

@Deterministic
@Strict
public class SpatialTypeFunctions {
    private SpatialTypeFunctions() {
    }

    public static @Nullable ByteString ST_AsBinary(Geometry geometry) {
        return SpatialTypeFunctions.ST_AsWKB(geometry);
    }

    public static @Nullable String ST_AsEWKT(Geometry geometry) {
        return SpatialTypeUtils.asEwkt(geometry);
    }

    public static @Nullable String ST_AsGeoJSON(Geometry geometry) {
        return SpatialTypeUtils.asGeoJson(geometry);
    }

    public static @Nullable String ST_AsGML(Geometry geometry) {
        return SpatialTypeUtils.asGml(geometry);
    }

    public static @Nullable String ST_AsText(Geometry geometry) {
        return SpatialTypeFunctions.ST_AsWKT(geometry);
    }

    public static @Nullable ByteString ST_AsEWKB(Geometry geometry) {
        return SpatialTypeFunctions.ST_AsWKB(geometry);
    }

    public static @Nullable ByteString ST_AsWKB(Geometry geometry) {
        return SpatialTypeUtils.asWkb(geometry);
    }

    public static @Nullable String ST_AsWKT(Geometry geometry) {
        return SpatialTypeUtils.asWkt(geometry);
    }

    public static @Nullable Geometry ST_Force2D(Geometry geometry) {
        Function<Coordinate, Coordinate> transform = coordinate -> new Coordinate(coordinate.getX(), coordinate.getY());
        CoordinateTransformer transformer = new CoordinateTransformer(transform);
        return transformer.transform(geometry);
    }

    public static @Nullable Geometry ST_GeomFromEWKB(ByteString ewkb) {
        return SpatialTypeFunctions.ST_GeomFromWKB(ewkb);
    }

    public static @Nullable Geometry ST_GeomFromEWKT(String ewkt) {
        return SpatialTypeUtils.fromEwkt(ewkt);
    }

    public static @Nullable Geometry ST_GeomFromGeoJSON(String geojson) {
        return SpatialTypeUtils.fromGeoJson(geojson);
    }

    public static @Nullable Geometry ST_GeomFromGML(String gml) {
        return SpatialTypeFunctions.ST_GeomFromGML(gml, 0);
    }

    public static @Nullable Geometry ST_GeomFromGML(String gml, int srid) {
        Geometry geometry = SpatialTypeUtils.fromGml(gml);
        geometry.setSRID(srid);
        return geometry;
    }

    public static @Nullable Geometry ST_GeomFromText(String wkt) {
        return SpatialTypeFunctions.ST_GeomFromWKT(wkt);
    }

    public static @Nullable Geometry ST_GeomFromText(String wkt, int srid) {
        return SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
    }

    public static @Nullable Geometry ST_GeomFromWKB(ByteString wkb) {
        return SpatialTypeUtils.fromWkb(wkb);
    }

    public static @Nullable Geometry ST_GeomFromWKB(ByteString wkb, int srid) {
        Geometry geometry = SpatialTypeUtils.fromWkb(wkb);
        geometry.setSRID(srid);
        return geometry;
    }

    public static @Nullable Geometry ST_GeomFromWKT(String wkt) {
        return SpatialTypeFunctions.ST_GeomFromWKT(wkt, 0);
    }

    public static @Nullable Geometry ST_GeomFromWKT(String wkt, int srid) {
        Geometry geometry = SpatialTypeUtils.fromWkt(wkt);
        geometry.setSRID(srid);
        return geometry;
    }

    public static @Nullable Geometry ST_LineFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof LineString ? geometry : null;
    }

    public static @Nullable Geometry ST_LineFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof LineString ? geometry : null;
    }

    public static @Nullable Geometry ST_LineFromWKB(ByteString wkb) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkb);
        return geometry instanceof LineString ? geometry : null;
    }

    public static @Nullable Geometry ST_LineFromWKB(ByteString wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkt, srid);
        return geometry instanceof LineString ? geometry : null;
    }

    public static @Nullable Geometry ST_MLineFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof MultiLineString ? geometry : null;
    }

    public static @Nullable Geometry ST_MLineFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof MultiLineString ? geometry : null;
    }

    public static @Nullable Geometry ST_MPointFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof MultiPoint ? geometry : null;
    }

    public static @Nullable Geometry ST_MPointFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof MultiPoint ? geometry : null;
    }

    public static @Nullable Geometry ST_MPolyFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof MultiPolygon ? geometry : null;
    }

    public static @Nullable Geometry ST_MPolyFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof MultiPolygon ? geometry : null;
    }

    public static @Nullable Geometry ST_PointFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof Point ? geometry : null;
    }

    public static @Nullable Geometry ST_PointFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof Point ? geometry : null;
    }

    public static @Nullable Geometry ST_PointFromWKB(ByteString wkb) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkb);
        return geometry instanceof Point ? geometry : null;
    }

    public static @Nullable Geometry ST_PointFromWKB(ByteString wkb, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkb, srid);
        return geometry instanceof Point ? geometry : null;
    }

    public static @Nullable Geometry ST_PolyFromText(String wkt) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt);
        return geometry instanceof Polygon ? geometry : null;
    }

    public static @Nullable Geometry ST_PolyFromText(String wkt, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKT(wkt, srid);
        return geometry instanceof Polygon ? geometry : null;
    }

    public static @Nullable Geometry ST_PolyFromWKB(ByteString wkb) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkb);
        return geometry instanceof Polygon ? geometry : null;
    }

    public static @Nullable Geometry ST_PolyFromWKB(ByteString wkb, int srid) {
        Geometry geometry = SpatialTypeFunctions.ST_GeomFromWKB(wkb, srid);
        return geometry instanceof Polygon ? geometry : null;
    }

    public static Geometry ST_ReducePrecision(Geometry geom, BigDecimal gridSize) {
        PrecisionModel precisionModel = new PrecisionModel(1.0 / gridSize.doubleValue());
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precisionModel);
        reducer.setPointwise(true);
        return reducer.reduce(geom);
    }

    public static @Nullable Geometry ST_ToMultiPoint(Geometry geom) {
        CoordinateSequence coordinateSequence = SpatialTypeUtils.GEOMETRY_FACTORY.getCoordinateSequenceFactory().create(geom.getCoordinates());
        return SpatialTypeUtils.GEOMETRY_FACTORY.createMultiPoint(coordinateSequence);
    }

    public static @Nullable Geometry ST_ToMultiLine(Geometry geom) {
        GeometryFactory factory = geom.getFactory();
        ArrayList lines = new ArrayList();
        geom.apply(inputGeom -> {
            if (inputGeom instanceof LineString) {
                lines.add(factory.createLineString(inputGeom.getCoordinates()));
            }
        });
        if (lines.isEmpty()) {
            return factory.createMultiLineString();
        }
        return factory.createMultiLineString(lines.toArray(new LineString[lines.size()]));
    }

    public static @Nullable Geometry ST_ToMultiSegments(Geometry geom) {
        GeometryFactory factory = geom.getFactory();
        ArrayList lines = new ArrayList();
        geom.apply(inputGeom -> {
            if (inputGeom instanceof LineString) {
                Coordinate[] coordinates = inputGeom.getCoordinates();
                for (int i = 1; i < coordinates.length; ++i) {
                    Coordinate[] pair = new Coordinate[]{coordinates[i - 1], coordinates[i]};
                    lines.add(factory.createLineString(pair));
                }
            }
        });
        if (lines.isEmpty()) {
            return factory.createMultiLineString();
        }
        return factory.createMultiLineString(lines.toArray(new LineString[lines.size()]));
    }

    public static @Nullable Geometry ST_Force3D(Geometry geometry) {
        Function<Coordinate, Coordinate> transform = coordinate -> new Coordinate(coordinate.getX(), coordinate.getY(), Double.isNaN(coordinate.getZ()) ? 0.0 : coordinate.getZ());
        CoordinateTransformer transformer = new CoordinateTransformer(transform);
        return transformer.transform(geometry);
    }

    private static void ST_MakeGrid(Geometry geom, BigDecimal deltaX, BigDecimal deltaY) {
    }

    private static void ST_MakeGridPoints(Geometry geom, BigDecimal deltaX, BigDecimal deltaY) {
    }

    public static Geometry ST_BoundingCircle(Geometry geom) {
        return new MinimumBoundingCircle(geom).getCircle();
    }

    public static Geometry ST_Expand(Geometry geom, BigDecimal distance) {
        Envelope envelope = geom.getEnvelopeInternal().copy();
        envelope.expandBy(distance.doubleValue());
        return geom.getFactory().toGeometry(envelope);
    }

    public static @Nullable Geometry ST_MakeEllipse(Geometry point, BigDecimal width, BigDecimal height) {
        if (!(point instanceof Point)) {
            return null;
        }
        GeometricShapeFactory factory = new GeometricShapeFactory(point.getFactory());
        factory.setCentre(point.getCoordinate());
        factory.setWidth(width.doubleValue());
        factory.setHeight(height.doubleValue());
        return factory.createEllipse();
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell) {
        return SpatialTypeFunctions.makePolygon(shell, new Geometry[0]);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0) {
        return SpatialTypeFunctions.makePolygon(shell, hole0);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4, Geometry hole5) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4, hole5);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4, Geometry hole5, Geometry hole6) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4, hole5, hole6);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4, Geometry hole5, Geometry hole6, Geometry hole7) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4, hole5, hole6, hole7);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4, Geometry hole5, Geometry hole6, Geometry hole7, Geometry hole8) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4, hole5, hole6, hole7, hole8);
    }

    public static @Nullable Geometry ST_MakePolygon(Geometry shell, Geometry hole0, Geometry hole1, Geometry hole2, Geometry hole3, Geometry hole4, Geometry hole5, Geometry hole6, Geometry hole7, Geometry hole8, Geometry hole9) {
        return SpatialTypeFunctions.makePolygon(shell, hole0, hole1, hole2, hole3, hole4, hole5, hole6, hole7, hole8, hole9);
    }

    private static @Nullable Geometry makePolygon(Geometry shell, Geometry ... holes) {
        if (!(shell instanceof LineString)) {
            throw new RuntimeException("Only supports LINESTRINGs.");
        }
        if (!((LineString)shell).isClosed()) {
            throw new RuntimeException("The LINESTRING must be closed.");
        }
        for (Geometry hole : holes) {
            if (!(hole instanceof LineString)) {
                throw new RuntimeException("Only supports LINESTRINGs.");
            }
            if (((LineString)hole).isClosed()) continue;
            throw new RuntimeException("The LINESTRING must be closed.");
        }
        LinearRing shellRing = shell.getFactory().createLinearRing(shell.getCoordinates());
        LinearRing[] holeRings = new LinearRing[holes.length];
        for (int i = 0; i < holes.length; ++i) {
            holeRings[i] = holes[i].getFactory().createLinearRing(holes[i].getCoordinates());
        }
        return shell.getFactory().createPolygon(shellRing, holeRings);
    }

    public static @Nullable Geometry ST_MinimumDiameter(Geometry geom) {
        return new MinimumDiameter(geom).getDiameter();
    }

    public static @Nullable Geometry ST_MinimumRectangle(Geometry geom) {
        return new MinimumDiameter(geom).getMinimumRectangle();
    }

    public static @Nullable Geometry ST_OctagonalEnvelope(Geometry geom) {
        return new OctagonalEnvelope(geom).toGeometry(geom.getFactory());
    }

    public static Geometry ST_Expand(Geometry geom, BigDecimal deltaX, BigDecimal deltaY) {
        Envelope envelope = geom.getEnvelopeInternal().copy();
        envelope.expandBy(deltaX.doubleValue(), deltaY.doubleValue());
        return geom.getFactory().toGeometry(envelope);
    }

    public static Geometry ST_MakeEnvelope(BigDecimal xMin, BigDecimal yMin, BigDecimal xMax, BigDecimal yMax, int srid) {
        Geometry geom = SpatialTypeFunctions.ST_GeomFromText("POLYGON((" + xMin + " " + yMin + ", " + xMin + " " + yMax + ", " + xMax + " " + yMax + ", " + xMax + " " + yMin + ", " + xMin + " " + yMin + "))", srid);
        return Objects.requireNonNull(geom, "geom");
    }

    public static Geometry ST_MakeEnvelope(BigDecimal xMin, BigDecimal yMin, BigDecimal xMax, BigDecimal yMax) {
        return SpatialTypeFunctions.ST_MakeEnvelope(xMin, yMin, xMax, yMax, 0);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometry ST_MakeLine(Geometry geom1, Geometry geom2) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{geom1.getCoordinate(), geom2.getCoordinate()});
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometry ST_MakeLine(Geometry geom1, Geometry geom2, Geometry geom3) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{geom1.getCoordinate(), geom2.getCoordinate(), geom3.getCoordinate()});
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometry ST_MakeLine(Geometry geom1, Geometry geom2, Geometry geom3, Geometry geom4) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{geom1.getCoordinate(), geom2.getCoordinate(), geom3.getCoordinate(), geom4.getCoordinate()});
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometry ST_MakeLine(Geometry geom1, Geometry geom2, Geometry geom3, Geometry geom4, Geometry geom5) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{geom1.getCoordinate(), geom2.getCoordinate(), geom3.getCoordinate(), geom4.getCoordinate(), geom5.getCoordinate()});
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometry ST_MakeLine(Geometry geom1, Geometry geom2, Geometry geom3, Geometry geom4, Geometry geom5, Geometry geom6) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{geom1.getCoordinate(), geom2.getCoordinate(), geom3.getCoordinate(), geom4.getCoordinate(), geom5.getCoordinate(), geom6.getCoordinate()});
    }

    @Hints(value={"SqlKind:ST_POINT"})
    public static Geometry ST_MakePoint(BigDecimal x, BigDecimal y) {
        return SpatialTypeFunctions.ST_Point(x, y);
    }

    @Hints(value={"SqlKind:ST_POINT3"})
    public static Geometry ST_MakePoint(BigDecimal x, BigDecimal y, BigDecimal z) {
        return SpatialTypeFunctions.ST_Point(x, y, z);
    }

    @Hints(value={"SqlKind:ST_POINT"})
    public static Geometry ST_Point(BigDecimal x, BigDecimal y) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x.doubleValue(), y.doubleValue()));
    }

    @Hints(value={"SqlKind:ST_POINT3"})
    public static Geometry ST_Point(BigDecimal x, BigDecimal y, BigDecimal z) {
        Point g = SpatialTypeUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x.doubleValue(), y.doubleValue(), z.doubleValue()));
        return g;
    }

    public static @Nullable Geometry ST_Extent(Geometry geom) {
        return geom.getEnvelope();
    }

    public static @Nullable Geometry ST_GeometryN(Geometry geom, int n) {
        if (!(geom instanceof GeometryCollection)) {
            return null;
        }
        return geom.getGeometryN(n - 1);
    }

    public static @Nullable Geometry ST_ExteriorRing(Geometry geom) {
        if (geom instanceof Polygon) {
            return ((Polygon)geom).getExteriorRing();
        }
        return null;
    }

    public static Geometry ST_EndPoint(Geometry geom) {
        return SpatialTypeFunctions.ST_PointN(geom, -1);
    }

    public static @Nullable Geometry ST_InteriorRing(Geometry geom, int n) {
        if (geom instanceof Polygon) {
            return ((Polygon)geom).getInteriorRingN(n);
        }
        return null;
    }

    public static boolean ST_IsClosed(Geometry geom) {
        if (geom instanceof LineString) {
            return ((LineString)geom).isClosed();
        }
        if (geom instanceof MultiLineString) {
            return ((MultiLineString)geom).isClosed();
        }
        return false;
    }

    public static boolean ST_Is3D(Geometry geom) {
        return SpatialTypeFunctions.ST_CoordDim(geom) == 3;
    }

    public static boolean ST_IsEmpty(Geometry geom) {
        return geom.isEmpty();
    }

    public static boolean ST_IsRectangle(Geometry geom) {
        return geom.isRectangle();
    }

    public static boolean ST_IsRing(Geometry geom) {
        if (geom instanceof LineString) {
            return ((LineString)geom).isClosed() && geom.isSimple();
        }
        if (geom instanceof MultiLineString) {
            return ((MultiLineString)geom).isClosed() && geom.isSimple();
        }
        return false;
    }

    public static boolean ST_IsSimple(Geometry geom) {
        return geom.isSimple();
    }

    public static boolean ST_IsValid(Geometry geom) {
        return geom.isValid();
    }

    public static int ST_NPoints(Geometry geom) {
        return SpatialTypeFunctions.ST_NumPoints(geom);
    }

    public static int ST_NumGeometries(Geometry geom) {
        return geom.getNumGeometries();
    }

    public static int ST_NumInteriorRing(Geometry geom) {
        return SpatialTypeFunctions.ST_NumInteriorRings(geom);
    }

    public static int ST_NumInteriorRings(Geometry geom) {
        final int[] num = new int[]{0};
        geom.apply(new GeometryFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Polygon) {
                    num[0] = num[0] + ((Polygon)geom).getNumInteriorRing();
                }
            }
        });
        return num[0];
    }

    public static int ST_NumPoints(Geometry geom) {
        return geom.getCoordinates().length;
    }

    public static Geometry ST_PointN(Geometry geom, int n) {
        Coordinate[] coordinates = geom.getCoordinates();
        int i = (coordinates.length + n % coordinates.length) % coordinates.length;
        return geom.getFactory().createPoint(coordinates[i]);
    }

    public static Geometry ST_PointOnSurface(Geometry geom) {
        return geom.getFactory().createPoint(InteriorPoint.getInteriorPoint((Geometry)geom));
    }

    public static int ST_SRID(Geometry geom) {
        return geom.getSRID();
    }

    public static Geometry ST_StartPoint(Geometry geom) {
        return SpatialTypeFunctions.ST_PointN(geom, 0);
    }

    public static @Nullable Double ST_X(Geometry geom) {
        return geom instanceof Point ? Double.valueOf(((Point)geom).getX()) : null;
    }

    public static @Nullable Double ST_XMax(Geometry geom) {
        return geom.getEnvelopeInternal().getMaxX();
    }

    public static @Nullable Double ST_XMin(Geometry geom) {
        return geom.getEnvelopeInternal().getMinX();
    }

    public static @Nullable Double ST_Y(Geometry geom) {
        return geom instanceof Point ? Double.valueOf(((Point)geom).getY()) : null;
    }

    public static @Nullable Double ST_YMax(Geometry geom) {
        return geom.getEnvelopeInternal().getMaxY();
    }

    public static @Nullable Double ST_YMin(Geometry geom) {
        return geom.getEnvelopeInternal().getMinY();
    }

    public static Double ST_Z(Geometry geom) {
        if (geom.getCoordinate() != null) {
            return geom.getCoordinate().getZ();
        }
        return Double.NaN;
    }

    public static Double ST_ZMax(Geometry geom) {
        return Arrays.stream(geom.getCoordinates()).filter(c -> !Double.isNaN(c.getZ())).map(c -> c.getZ()).max(Double::compareTo).orElse(Double.NaN);
    }

    public static Double ST_ZMin(Geometry geom) {
        return Arrays.stream(geom.getCoordinates()).filter(c -> !Double.isNaN(c.getZ())).map(c -> c.getZ()).min(Double::compareTo).orElse(Double.NaN);
    }

    public static Geometry ST_Boundary(Geometry geom) {
        return geom.getBoundary();
    }

    public static Geometry ST_Centroid(Geometry geom) {
        return geom.getCentroid();
    }

    public static int ST_CoordDim(Geometry geom) {
        Coordinate coordinate = geom.getCoordinate();
        if (coordinate != null && !Double.isNaN(coordinate.getZ())) {
            return 3;
        }
        return 2;
    }

    public static int ST_Dimension(Geometry geom) {
        return geom.getDimension();
    }

    public static double ST_Distance(Geometry geom1, Geometry geom2) {
        return geom1.distance(geom2);
    }

    public static String ST_GeometryType(Geometry geom) {
        return SpatialTypeUtils.SpatialType.fromGeometry(geom).name();
    }

    public static int ST_GeometryTypeCode(Geometry geom) {
        return SpatialTypeUtils.SpatialType.fromGeometry(geom).code();
    }

    public static Geometry ST_Envelope(Geometry geom) {
        return geom.getEnvelope();
    }

    private static void ST_Explode(Geometry geom) {
    }

    @Hints(value={"SqlKind:ST_CONTAINS"})
    public static boolean ST_Contains(Geometry geom1, Geometry geom2) {
        return geom1.contains(geom2);
    }

    public static boolean ST_ContainsProperly(Geometry geom1, Geometry geom2) {
        return geom1.contains(geom2) && !geom1.crosses(geom2);
    }

    public static boolean ST_CoveredBy(Geometry geom1, Geometry geom2) {
        return geom1.coveredBy(geom2);
    }

    public static boolean ST_Covers(Geometry geom1, Geometry geom2) {
        return geom1.covers(geom2);
    }

    public static boolean ST_Crosses(Geometry geom1, Geometry geom2) {
        return geom1.crosses(geom2);
    }

    public static boolean ST_Disjoint(Geometry geom1, Geometry geom2) {
        return geom1.disjoint(geom2);
    }

    public static boolean ST_EnvelopesIntersect(Geometry geom1, Geometry geom2) {
        Geometry e1 = geom1.getEnvelope();
        Geometry e2 = geom2.getEnvelope();
        return e1.intersects(e2);
    }

    public static boolean ST_Equals(Geometry geom1, Geometry geom2) {
        return geom1.equals(geom2);
    }

    public static boolean ST_Intersects(Geometry geom1, Geometry geom2) {
        return geom1.intersects(geom2);
    }

    public static boolean ST_OrderingEquals(Geometry geom1, Geometry geom2) {
        if (!geom1.equals(geom2)) {
            return false;
        }
        Coordinate[] coordinates1 = geom1.getCoordinates();
        Coordinate[] coordinates2 = geom2.getCoordinates();
        for (int i = 0; i < coordinates1.length; ++i) {
            if (coordinates1[i].equals((Object)coordinates2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean ST_Overlaps(Geometry geom1, Geometry geom2) {
        return geom1.overlaps(geom2);
    }

    public static boolean ST_Touches(Geometry geom1, Geometry geom2) {
        return geom1.touches(geom2);
    }

    public static boolean ST_Within(Geometry geom1, Geometry geom2) {
        return geom1.within(geom2);
    }

    @Hints(value={"SqlKind:ST_DWITHIN"})
    public static boolean ST_DWithin(Geometry geom1, Geometry geom2, double distance) {
        double distance1 = geom1.distance(geom2);
        return distance1 <= distance;
    }

    public static Geometry ST_Buffer(Geometry geom, double distance, String bufferStyle) {
        BufferStyle style = new BufferStyle(bufferStyle);
        BufferParameters params = style.asBufferParameters();
        double sidedDistance = style.asSidedDistance(distance);
        Geometry result = new BufferOp(geom, params).getResultGeometry(sidedDistance);
        return result;
    }

    public static Geometry ST_Buffer(Geometry geom, double distance) {
        return geom.buffer(distance);
    }

    public static Geometry ST_Buffer(Geometry geom, double distance, int quadSegs) {
        return geom.buffer(distance, quadSegs);
    }

    public static Geometry ST_Buffer(Geometry geom, double distance, int quadSegs, int endCapStyle) {
        return geom.buffer(distance, quadSegs, endCapStyle);
    }

    public static Geometry ST_ConvexHull(Geometry geom) {
        return geom.convexHull();
    }

    public static Geometry ST_Difference(Geometry geom1, Geometry geom2) {
        return geom1.difference(geom2);
    }

    public static Geometry ST_SymDifference(Geometry geom1, Geometry geom2) {
        return geom1.symDifference(geom2);
    }

    public static Geometry ST_Intersection(Geometry geom1, Geometry geom2) {
        return geom1.intersection(geom2);
    }

    public static Geometry ST_OffsetCurve(Geometry linestring, double distance, String bufferStyle) {
        if (!(linestring instanceof LineString)) {
            throw new IllegalArgumentException("ST_OffsetCurve only accepts LineString");
        }
        BufferStyle style = new BufferStyle(bufferStyle);
        BufferParameters params = style.asBufferParameters();
        double sidedDistance = style.asSidedDistance(distance);
        Coordinate[] coordinates = OffsetCurve.rawOffset((LineString)((LineString)linestring), (double)sidedDistance, (BufferParameters)params);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(coordinates);
    }

    public static String ST_Relate(Geometry geom1, Geometry geom2) {
        return geom1.relate(geom2).toString();
    }

    public static boolean ST_Relate(Geometry geom1, Geometry geom2, String iMatrix) {
        return geom1.relate(geom2, iMatrix);
    }

    public static Geometry ST_UnaryUnion(Geometry geom1, Geometry geom2) {
        return geom1.union(geom2);
    }

    @SemiStrict
    public static Geometry ST_UnaryUnion(Geometry geomCollection) {
        return geomCollection.union();
    }

    public static Geometry ST_Transform(Geometry geom, int srid) {
        try {
            ProjectionTransformer projectionTransformer = new ProjectionTransformer(geom.getSRID(), srid);
            return projectionTransformer.transform(geom);
        }
        catch (IllegalStateException e) {
            throw Static.RESOURCE.proj4jEpsgIsMissing().ex();
        }
    }

    public static Geometry ST_SetSRID(Geometry geom, int srid) {
        geom.setSRID(srid);
        return geom;
    }

    public static Geometry ST_LineMerge(Geometry geom) {
        LineMerger merger = new LineMerger();
        merger.add(geom);
        LineString[] geometries = (LineString[])merger.getMergedLineStrings().stream().map(LineString.class::cast).toArray(LineString[]::new);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createMultiLineString(geometries);
    }

    public static Geometry ST_MakeValid(Geometry geometry) {
        return new GeometryFixer(geometry).getResult();
    }

    public static Geometry ST_Polygonize(Geometry geometry) {
        Polygonizer polygonizer = new Polygonizer(true);
        polygonizer.add(geometry);
        return polygonizer.getGeometry();
    }

    public static Geometry ST_PrecisionReducer(Geometry geometry, BigDecimal decimal) {
        double scale = Math.pow(10.0, decimal.doubleValue());
        PrecisionModel precisionModel = new PrecisionModel(scale);
        GeometryPrecisionReducer precisionReducer = new GeometryPrecisionReducer(precisionModel);
        return precisionReducer.reduce(geometry);
    }

    public static Geometry ST_Simplify(Geometry geom, BigDecimal distance) {
        DouglasPeuckerSimplifier simplifier = new DouglasPeuckerSimplifier(geom);
        simplifier.setDistanceTolerance(distance.doubleValue());
        return simplifier.getResultGeometry();
    }

    public static Geometry ST_SimplifyPreserveTopology(Geometry geom, BigDecimal distance) {
        TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier(geom);
        simplifier.setDistanceTolerance(distance.doubleValue());
        return simplifier.getResultGeometry();
    }

    public static Geometry ST_Snap(Geometry geom1, Geometry geom2, BigDecimal snapTolerance) {
        GeometrySnapper snapper = new GeometrySnapper(geom1);
        return snapper.snapTo(geom2, snapTolerance.doubleValue());
    }

    public static Geometry ST_Split(Geometry geom, Geometry blade) {
        return new SplitOperation(geom, blade).split();
    }

    public static Geometry ST_Rotate(Geometry geom, BigDecimal angle) {
        AffineTransformation transformation = new AffineTransformation();
        transformation.rotate(angle.doubleValue());
        return transformation.transform(geom);
    }

    public static Geometry ST_Rotate(Geometry geom, BigDecimal angle, Geometry origin) {
        if (!(origin instanceof Point)) {
            throw new RuntimeException("The origin must be a point");
        }
        Point point = (Point)origin;
        AffineTransformation transformation = new AffineTransformation();
        transformation.rotate(angle.doubleValue(), point.getX(), point.getY());
        return transformation.transform(geom);
    }

    public static Geometry ST_Rotate(Geometry geom, BigDecimal angle, BigDecimal x, BigDecimal y) {
        AffineTransformation transformation = new AffineTransformation();
        transformation.rotate(angle.doubleValue(), x.doubleValue(), y.doubleValue());
        return transformation.transform(geom);
    }

    public static Geometry ST_Scale(Geometry geom, BigDecimal xFactor, BigDecimal yFactor) {
        AffineTransformation transformation = new AffineTransformation();
        transformation.scale(xFactor.doubleValue(), yFactor.doubleValue());
        return transformation.transform(geom);
    }

    public static Geometry ST_Translate(Geometry geom, BigDecimal x, BigDecimal y) {
        AffineTransformation transformation = new AffineTransformation();
        transformation.translate(x.doubleValue(), y.doubleValue());
        Geometry translated = transformation.transform(geom);
        return translated;
    }

    public static Geometry ST_AddPoint(Geometry linestring, Geometry point) {
        if (!(linestring instanceof LineString)) {
            throw new RuntimeException("Only supports LINESTRING.");
        }
        if (!(point instanceof Point)) {
            throw new RuntimeException("Only supports POINT.");
        }
        LineString lineString = (LineString)linestring;
        int numPoints = lineString.getNumPoints();
        return new GeometryEditor().edit(linestring, (GeometryEditor.GeometryEditorOperation)new AddPointOperation(point, numPoints));
    }

    public static Geometry ST_AddPoint(Geometry linestring, Geometry point, int index) {
        if (!(linestring instanceof LineString)) {
            throw new RuntimeException("Only supports LINESTRING.");
        }
        if (!(point instanceof Point)) {
            throw new RuntimeException("Only supports POINT.");
        }
        return new GeometryEditor().edit(linestring, (GeometryEditor.GeometryEditorOperation)new AddPointOperation(point, index));
    }

    public static Geometry ST_Densify(Geometry geom, BigDecimal tolerance) {
        return Densifier.densify((Geometry)geom, (double)tolerance.doubleValue());
    }

    public static Geometry ST_FlipCoordinates(Geometry geom) {
        FlipCoordinatesTransformer transformer = new FlipCoordinatesTransformer();
        return transformer.transform(geom);
    }

    public static Geometry ST_Holes(Geometry geom) {
        ArrayList<Geometry> acc = new ArrayList<Geometry>();
        SpatialTypeFunctions.extractGeometryHoles(geom, acc);
        Geometry[] array = acc.toArray(new Geometry[acc.size()]);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createGeometryCollection(array);
    }

    private static void extractGeometryHoles(Geometry geom, List<Geometry> acc) {
        if (geom instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geom;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry child = geometryCollection.getGeometryN(i);
                SpatialTypeFunctions.extractGeometryHoles(child, acc);
            }
        } else if (geom instanceof Polygon) {
            Polygon polygon = (Polygon)geom;
            SpatialTypeFunctions.extractPolygonHoles(polygon, acc);
        }
    }

    private static void extractPolygonHoles(Polygon polygon, List<Geometry> acc) {
        int size = polygon.getNumInteriorRing();
        for (int i = 0; i < size; ++i) {
            acc.add((Geometry)polygon.getInteriorRingN(i));
        }
    }

    public static Geometry ST_Normalize(Geometry geom) {
        return geom.norm();
    }

    public static Geometry ST_RemoveRepeatedPoints(Geometry geom) {
        return new RemoveRepeatedPointsTransformer().transform(geom);
    }

    public static Geometry ST_RemoveRepeatedPoints(Geometry geom, BigDecimal tolerance) {
        return new RemoveRepeatedPointsTransformer(tolerance.doubleValue()).transform(geom);
    }

    public static Geometry ST_RemoveHoles(Geometry geom) {
        RemoveHoleTransformer transformer = new RemoveHoleTransformer();
        return transformer.transform(geom);
    }

    public static Geometry ST_RemovePoint(Geometry linestring, int index) {
        if (!(linestring instanceof LineString)) {
            throw new RuntimeException("Only supports LINESTRING.");
        }
        return new GeometryEditor().edit(linestring, (GeometryEditor.GeometryEditorOperation)new RemovePointOperation(index));
    }

    public static Geometry ST_Reverse(Geometry geom) {
        return geom.reverse();
    }

    public static Geometry ST_AddZ(Geometry geom, BigDecimal zToAdd) {
        return new AddZTransformer(zToAdd.doubleValue()).transform(geom);
    }

    public static @Nullable Double ST_Area(Geometry geom) {
        return geom.getArea();
    }

    public static @Nullable Geometry ST_ClosestCoordinate(Geometry point, Geometry geom) {
        ArrayList<Coordinate> closestCoordinates = new ArrayList<Coordinate>();
        double minDistance = Double.MAX_VALUE;
        for (Coordinate coordinate : geom.getCoordinates()) {
            double distance = point.getCoordinate().distance(coordinate);
            if (distance < minDistance) {
                minDistance = distance;
                closestCoordinates.clear();
                closestCoordinates.add(coordinate);
                continue;
            }
            if (distance != minDistance || closestCoordinates.contains(coordinate)) continue;
            closestCoordinates.add(coordinate);
        }
        if (closestCoordinates.size() == 1) {
            return SpatialTypeUtils.GEOMETRY_FACTORY.createPoint((Coordinate)closestCoordinates.get(0));
        }
        Coordinate[] coordinates = closestCoordinates.toArray(new Coordinate[0]);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createMultiPointFromCoords(coordinates);
    }

    public static @Nullable Geometry ST_ClosestPoint(Geometry geom1, Geometry geom2) {
        return SpatialTypeUtils.GEOMETRY_FACTORY.createPoint(DistanceOp.nearestPoints((Geometry)geom1, (Geometry)geom2)[0]);
    }

    public static @Nullable Geometry ST_FurthestCoordinate(Geometry point, Geometry geom) {
        ArrayList<Coordinate> closestCoordinates = new ArrayList<Coordinate>();
        double maxDistance = Double.MIN_VALUE;
        for (Coordinate coordinate : geom.getCoordinates()) {
            double distance = point.getCoordinate().distance(coordinate);
            if (distance > maxDistance) {
                maxDistance = distance;
                closestCoordinates.clear();
                closestCoordinates.add(coordinate);
                continue;
            }
            if (distance != maxDistance || closestCoordinates.contains(coordinate)) continue;
            closestCoordinates.add(coordinate);
        }
        if (closestCoordinates.size() == 1) {
            return SpatialTypeUtils.GEOMETRY_FACTORY.createPoint((Coordinate)closestCoordinates.get(0));
        }
        Coordinate[] coordinates = closestCoordinates.toArray(new Coordinate[0]);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createMultiPointFromCoords(coordinates);
    }

    public static @Nullable Double ST_Length(Geometry geom) {
        return geom.getLength();
    }

    public static @Nullable Geometry ST_LocateAlong(Geometry geom, BigDecimal segmentLengthFraction, BigDecimal offsetDistance) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry geometry = geom.getGeometryN(i);
            Coordinate[] geometryCoordinates = geometry.getCoordinates();
            for (int j = 0; j < geometryCoordinates.length - 1; ++j) {
                Coordinate c1 = geometryCoordinates[j];
                Coordinate c2 = geometryCoordinates[j + 1];
                LineSegment lineSegment = new LineSegment(c1, c2);
                coordinates.add(lineSegment.pointAlongOffset(segmentLengthFraction.doubleValue(), offsetDistance.doubleValue()));
            }
        }
        Coordinate[] coordinateArray = coordinates.toArray(new Coordinate[0]);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createMultiPointFromCoords(coordinateArray);
    }

    public static @Nullable Geometry ST_LongestLine(Geometry geom1, Geometry geom2) {
        double maxDistance = Double.MIN_VALUE;
        Coordinate c1 = null;
        Coordinate c2 = null;
        for (Coordinate coordinate1 : geom1.getCoordinates()) {
            for (Coordinate coordinate2 : geom2.getCoordinates()) {
                double distance = coordinate1.distance(coordinate2);
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                c1 = coordinate1;
                c2 = coordinate2;
            }
        }
        if (c1 == null || c2 == null) {
            return null;
        }
        return SpatialTypeUtils.GEOMETRY_FACTORY.createLineString(new Coordinate[]{c1, c2});
    }

    public static @Nullable Double ST_MaxDistance(Geometry geom1, Geometry geom2) {
        double maxDistance = Double.MIN_VALUE;
        for (Coordinate coordinate1 : geom1.getCoordinates()) {
            for (Coordinate coordinate2 : geom2.getCoordinates()) {
                double distance = coordinate1.distance(coordinate2);
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
            }
        }
        return maxDistance;
    }

    public static @Nullable Double ST_Perimeter(Geometry geom) {
        double perimeter = 0.0;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry geometry = geom.getGeometryN(i);
            if (!(geometry instanceof Polygon)) continue;
            perimeter += geometry.getLength();
        }
        return perimeter;
    }

    public static @Nullable Geometry ST_ProjectPoint(Geometry point, Geometry lineString) {
        if (lineString.getDimension() > 1) {
            return null;
        }
        LengthIndexedLine lengthIndexedLine = new LengthIndexedLine(lineString);
        double index = lengthIndexedLine.project(point.getCoordinate());
        Coordinate projectedCoordinate = lengthIndexedLine.extractPoint(index);
        return SpatialTypeUtils.GEOMETRY_FACTORY.createPoint(projectedCoordinate);
    }

    public static Geometry ST_ConstrainedDelaunay(Geometry geom) {
        return SpatialTypeFunctions.ST_ConstrainedDelaunay(geom, 0);
    }

    public static Geometry ST_ConstrainedDelaunay(Geometry geom, int flag) {
        GeometryFactory factory = geom.getFactory();
        ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(geom);
        List tris = cdt.getTriangles();
        Polygon[] polygons = new Polygon[tris.size()];
        int i = 0;
        for (Tri tri : tris) {
            polygons[i++] = tri.toPolygon(factory);
        }
        MultiPolygon multiPolygon = factory.createMultiPolygon(polygons);
        if (flag == 0) {
            return multiPolygon;
        }
        return SpatialTypeFunctions.asTriangleEdges(multiPolygon);
    }

    public static Geometry ST_Delaunay(Geometry geom) {
        return SpatialTypeFunctions.ST_Delaunay(geom, 0);
    }

    public static Geometry ST_Delaunay(Geometry geom, int flag) {
        GeometryFactory factory = geom.getFactory();
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites(geom);
        QuadEdgeSubdivision subdivision = builder.getSubdivision();
        List triPtsList = subdivision.getTriangleCoordinates(false);
        Polygon[] tris = new Polygon[triPtsList.size()];
        int i = 0;
        for (Coordinate[] triPt : triPtsList) {
            tris[i++] = factory.createPolygon(factory.createLinearRing(triPt));
        }
        MultiPolygon multiPolygon = factory.createMultiPolygon(tris);
        if (flag == 0) {
            return multiPolygon;
        }
        return SpatialTypeFunctions.asTriangleEdges(multiPolygon);
    }

    private static Geometry asTriangleEdges(MultiPolygon multiPolygon) {
        GeometryFactory factory = multiPolygon.getFactory();
        ArrayList<LineString> edges = new ArrayList<LineString>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
            Coordinate[] coordinates = polygon.getCoordinates();
            for (int j = 1; j < coordinates.length; ++j) {
                Coordinate c1 = coordinates[j - 1].copy();
                Coordinate c2 = coordinates[j].copy();
                LineString line = factory.createLineString(new Coordinate[]{c1, c2});
                edges.add(line);
            }
        }
        MultiLineString geometry = factory.createMultiLineString(edges.toArray(new LineString[0]));
        return geometry.union().norm();
    }

    @Hints(value={"SqlKind:HILBERT"})
    public static @Nullable Long hilbert(Geometry geom) {
        if (geom instanceof Point) {
            double x = ((Point)geom).getX();
            double y = ((Point)geom).getY();
            return new HilbertCurve2D(8).toIndex(x, y);
        }
        return null;
    }

    @Hints(value={"SqlKind:HILBERT"})
    public static long hilbert(BigDecimal x, BigDecimal y) {
        return new HilbertCurve2D(8).toIndex(x.doubleValue(), y.doubleValue());
    }

    public static class GridEnumerable
    extends AbstractEnumerable<Object[]> {
        private final Envelope envelope;
        private final boolean point;
        private final double deltaX;
        private final double deltaY;
        private final double minX;
        private final double minY;
        private final int baseX;
        private final int baseY;
        private final int spanX;
        private final int spanY;
        private final int area;

        public GridEnumerable(Envelope envelope, BigDecimal deltaX, BigDecimal deltaY, boolean point) {
            this.envelope = envelope;
            this.deltaX = deltaX.doubleValue();
            this.deltaY = deltaY.doubleValue();
            this.point = point;
            this.spanX = (int)Math.floor((envelope.getMaxX() - envelope.getMinX()) / this.deltaX) + 1;
            this.baseX = (int)Math.floor(envelope.getMinX() / this.deltaX);
            this.minX = this.deltaX * (double)this.baseX;
            this.spanY = (int)Math.floor((envelope.getMaxY() - envelope.getMinY()) / this.deltaY) + 1;
            this.baseY = (int)Math.floor(envelope.getMinY() / this.deltaY);
            this.minY = this.deltaY * (double)this.baseY;
            this.area = this.spanX * this.spanY;
        }

        public Enumerator<Object[]> enumerator() {
            return new Enumerator<Object[]>(){
                int id = -1;

                public Object[] current() {
                    Geometry geom;
                    int x = this.id % spanX;
                    int y = this.id / spanX;
                    if (point) {
                        double xCurrent = minX + ((double)x + 0.5) * deltaX;
                        double yCurrent = minY + ((double)y + 0.5) * deltaY;
                        geom = SpatialTypeFunctions.ST_MakePoint(BigDecimal.valueOf(xCurrent), BigDecimal.valueOf(yCurrent));
                    } else {
                        double left = minX + (double)x * deltaX;
                        double right = left + deltaX;
                        double bottom = minY + (double)y * deltaY;
                        double top = bottom + deltaY;
                        Coordinate[] coordinates = new Coordinate[]{new Coordinate(left, bottom), new Coordinate(left, top), new Coordinate(right, top), new Coordinate(right, bottom), new Coordinate(left, bottom)};
                        LinearRing linearRing = SpatialTypeUtils.GEOMETRY_FACTORY.createLinearRing(coordinates);
                        Polygon polygon = SpatialTypeUtils.GEOMETRY_FACTORY.createPolygon(linearRing);
                        geom = polygon;
                    }
                    return new Object[]{geom, this.id, x + 1, y + 1, baseX + x, baseY + y};
                }

                public boolean moveNext() {
                    return ++this.id < area;
                }

                public void reset() {
                    this.id = -1;
                }

                public void close() {
                }
            };
        }
    }
}

