/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.AddResponse;

public class AddResponseDecorator
extends ResponseDecorator<AddResponse>
implements AddResponse {
    private int addResponseLength;

    public AddResponseDecorator(LdapApiService codec, AddResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public AddResponse getAddResponse() {
        return (AddResponse)this.getDecorated();
    }

    public void setAddResponseLength(int addResponseLength) {
        this.addResponseLength = addResponseLength;
    }

    public int getAddResponseLength() {
        return this.addResponseLength;
    }

    @Override
    public int computeLength() {
        AddResponse addResponse = this.getAddResponse();
        this.setLdapResult(new LdapResultDecorator(addResponse.getLdapResult()));
        int addResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setAddResponseLength(addResponseLength);
        return 1 + TLV.getNbBytes(addResponseLength) + addResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)105);
            buffer.put(TLV.getBytes(this.getAddResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            return buffer;
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
    }
}

