/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAclsEndToEnd {
    private static final Log LOG = LogFactory.getLog((String)TestAclsEndToEnd.class.getName());
    private static final String TEXT = "The blue zone is for loading and unloading only. Please park in the red zone.";
    private static final Path ZONE1 = new Path("/tmp/BLUEZONE");
    private static final Path ZONE2 = new Path("/tmp/REDZONE");
    private static final Path ZONE3 = new Path("/tmp/LOADINGZONE");
    private static final Path ZONE4 = new Path("/tmp/UNLOADINGZONE");
    private static final Path FILE1 = new Path(ZONE1, "file1");
    private static final Path FILE1A = new Path(ZONE1, "file1a");
    private static final Path FILE2 = new Path(ZONE2, "file2");
    private static final Path FILE3 = new Path(ZONE3, "file3");
    private static final Path FILE4 = new Path(ZONE4, "file4");
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private static final String KEY3 = "key3";
    private static UserGroupInformation realUgi;
    private static String realUser;
    private MiniKMS miniKMS;
    private File kmsDir;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;

    @BeforeClass
    public static void captureUser() throws IOException {
        realUgi = UserGroupInformation.getCurrentUser();
        realUser = System.getProperty("user.name");
    }

    private String getKeyProviderURI() {
        return "kms://" + this.miniKMS.getKMSUrl().toExternalForm().replace("://", "@");
    }

    private void writeConf(File confDir, Configuration conf) throws IOException {
        URI keystore = new Path(this.kmsDir.getAbsolutePath(), "kms.keystore").toUri();
        conf.set("hadoop.kms.key.provider.uri", "jceks://file@" + keystore);
        conf.set("hadoop.kms.authentication.type", "simple");
        FileWriter writer = new FileWriter(new File(confDir, "kms-site.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "kms-acls.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "core-site.xml"));
        new Configuration(false).writeXml((Writer)writer);
        ((Writer)writer).close();
    }

    private void setup(Configuration conf) throws Exception {
        this.setup(conf, true, true);
    }

    private void setup(Configuration conf, boolean resetKms) throws Exception {
        this.setup(conf, resetKms, true);
    }

    private void setup(Configuration conf, boolean resetKms, boolean resetDfs) throws Exception {
        if (resetKms) {
            FileSystemTestHelper fsHelper = new FileSystemTestHelper();
            this.kmsDir = new File(fsHelper.getTestRootDir()).getAbsoluteFile();
            Assert.assertTrue((boolean)this.kmsDir.mkdirs());
        }
        this.writeConf(this.kmsDir, conf);
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder();
        this.miniKMS = miniKMSBuilder.setKmsConfDir(this.kmsDir).build();
        this.miniKMS.start();
        conf = new HdfsConfiguration();
        conf.set("hadoop.proxyuser." + realUser + ".users", "keyadmin,hdfs,user");
        conf.set("hadoop.proxyuser." + realUser + ".hosts", "*");
        conf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        MiniDFSCluster.Builder clusterBuilder = new MiniDFSCluster.Builder(conf);
        this.cluster = clusterBuilder.numDataNodes(1).format(resetDfs).build();
        this.fs = this.cluster.getFileSystem();
    }

    private void teardown() {
        UserGroupInformation.setLoginUser((UserGroupInformation)realUgi);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.miniKMS.stop();
    }

    private static Configuration getBaseConf(UserGroupInformation hdfsUgi, UserGroupInformation keyadminUgi) {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", keyadminUgi.getUserName());
        conf.set("hadoop.kms.acl.DELETE", keyadminUgi.getUserName());
        conf.set("hadoop.kms.acl.ROLLOVER", keyadminUgi.getUserName());
        conf.set("hadoop.kms.acl.GET", " ");
        conf.set("hadoop.kms.acl.GET_KEYS", keyadminUgi.getUserName());
        conf.set("hadoop.kms.acl.GET_METADATA", hdfsUgi.getUserName());
        conf.set("hadoop.kms.acl.SET_KEY_MATERIAL", " ");
        conf.set("hadoop.kms.acl.GENERATE_EEK", hdfsUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", "*");
        return conf;
    }

    private static void setBlacklistAcls(Configuration conf, UserGroupInformation hdfsUgi) {
        conf.set("hadoop.kms.blacklist.CREATE", hdfsUgi.getUserName());
        conf.set("hadoop.kms.blacklist.DELETE", hdfsUgi.getUserName());
        conf.set("hadoop.kms.blacklist.ROLLOVER", hdfsUgi.getUserName());
        conf.set("hadoop.kms.blacklist.GET", "*");
        conf.set("hadoop.kms.blacklist.SET_KEY_MATERIAL", "*");
        conf.set("hadoop.kms.blacklist.DECRYPT_EEK", hdfsUgi.getUserName());
    }

    private static void setKeyAcls(Configuration conf, String prefix, UserGroupInformation hdfsUgi, UserGroupInformation keyadminUgi, UserGroupInformation userUgi) {
        conf.set(prefix + "MANAGEMENT", keyadminUgi.getUserName());
        conf.set(prefix + "READ", hdfsUgi.getUserName());
        conf.set(prefix + "GENERATE_EEK", hdfsUgi.getUserName());
        conf.set("key.acl.key1.DECRYPT_EEK", userUgi.getUserName());
    }

    @Test
    public void testGoodWithWhitelist() throws Exception {
        UserGroupInformation hdfsUgi = UserGroupInformation.createProxyUserForTesting((String)"hdfs", (UserGroupInformation)realUgi, (String[])new String[]{"supergroup"});
        UserGroupInformation keyadminUgi = UserGroupInformation.createProxyUserForTesting((String)"keyadmin", (UserGroupInformation)realUgi, (String[])new String[]{"keyadmin"});
        UserGroupInformation userUgi = UserGroupInformation.createProxyUserForTesting((String)"user", (UserGroupInformation)realUgi, (String[])new String[]{"staff"});
        Configuration conf = TestAclsEndToEnd.getBaseConf(hdfsUgi, keyadminUgi);
        TestAclsEndToEnd.setBlacklistAcls(conf, hdfsUgi);
        TestAclsEndToEnd.setKeyAcls(conf, "whitelist.key.acl.", hdfsUgi, keyadminUgi, userUgi);
        this.doFullAclTest(conf, hdfsUgi, keyadminUgi, userUgi);
    }

    @Test
    public void testGoodWithKeyAcls() throws Exception {
        UserGroupInformation hdfsUgi = UserGroupInformation.createProxyUserForTesting((String)"hdfs", (UserGroupInformation)realUgi, (String[])new String[]{"supergroup"});
        UserGroupInformation keyadminUgi = UserGroupInformation.createProxyUserForTesting((String)"keyadmin", (UserGroupInformation)realUgi, (String[])new String[]{"keyadmin"});
        UserGroupInformation userUgi = UserGroupInformation.createProxyUserForTesting((String)"user", (UserGroupInformation)realUgi, (String[])new String[]{"staff"});
        Configuration conf = TestAclsEndToEnd.getBaseConf(hdfsUgi, keyadminUgi);
        TestAclsEndToEnd.setBlacklistAcls(conf, hdfsUgi);
        TestAclsEndToEnd.setKeyAcls(conf, "key.acl.key1.", hdfsUgi, keyadminUgi, userUgi);
        this.doFullAclTest(conf, hdfsUgi, keyadminUgi, userUgi);
    }

    @Test
    public void testGoodWithWhitelistWithoutBlacklist() throws Exception {
        UserGroupInformation hdfsUgi = UserGroupInformation.createProxyUserForTesting((String)"hdfs", (UserGroupInformation)realUgi, (String[])new String[]{"supergroup"});
        UserGroupInformation keyadminUgi = UserGroupInformation.createProxyUserForTesting((String)"keyadmin", (UserGroupInformation)realUgi, (String[])new String[]{"keyadmin"});
        UserGroupInformation userUgi = UserGroupInformation.createProxyUserForTesting((String)"user", (UserGroupInformation)realUgi, (String[])new String[]{"staff"});
        Configuration conf = TestAclsEndToEnd.getBaseConf(hdfsUgi, keyadminUgi);
        TestAclsEndToEnd.setKeyAcls(conf, "whitelist.key.acl.", hdfsUgi, keyadminUgi, userUgi);
        this.doFullAclTest(conf, hdfsUgi, keyadminUgi, userUgi);
    }

    @Test
    public void testGoodWithKeyAclsWithoutBlacklist() throws Exception {
        UserGroupInformation hdfsUgi = UserGroupInformation.createProxyUserForTesting((String)"hdfs", (UserGroupInformation)realUgi, (String[])new String[]{"supergroup"});
        UserGroupInformation keyadminUgi = UserGroupInformation.createProxyUserForTesting((String)"keyadmin", (UserGroupInformation)realUgi, (String[])new String[]{"keyadmin"});
        UserGroupInformation userUgi = UserGroupInformation.createProxyUserForTesting((String)"user", (UserGroupInformation)realUgi, (String[])new String[]{"staff"});
        Configuration conf = TestAclsEndToEnd.getBaseConf(hdfsUgi, keyadminUgi);
        TestAclsEndToEnd.setKeyAcls(conf, "key.acl.key1.", hdfsUgi, keyadminUgi, userUgi);
        this.doFullAclTest(conf, hdfsUgi, keyadminUgi, userUgi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFullAclTest(Configuration conf, UserGroupInformation hdfsUgi, UserGroupInformation keyadminUgi, UserGroupInformation userUgi) throws Exception {
        try {
            this.setup(conf);
            Assert.assertTrue((String)("Exception during creation of key key1 by " + keyadminUgi.getUserName()), (boolean)this.createKey(keyadminUgi, KEY1, conf));
            Assert.assertFalse((String)("Allowed creation of key key2 by " + hdfsUgi.getUserName()), (boolean)this.createKey(hdfsUgi, KEY2, conf));
            Assert.assertFalse((String)("Allowed creation of key key2 by " + userUgi.getUserName()), (boolean)this.createKey(userUgi, KEY2, conf));
            this.fs.mkdirs(ZONE1);
            this.fs.setOwner(ZONE1, userUgi.getUserName(), userUgi.getPrimaryGroupName());
            Assert.assertTrue((String)("Exception during creation of EZ " + ZONE1 + " by " + hdfsUgi.getUserName() + " using key " + KEY1), (boolean)this.createEncryptionZone(hdfsUgi, KEY1, ZONE1));
            Assert.assertFalse((String)("Allowed creation of EZ " + ZONE2 + " by " + keyadminUgi.getUserName() + " using key " + KEY1), (boolean)this.createEncryptionZone(keyadminUgi, KEY1, ZONE2));
            Assert.assertFalse((String)("Allowed creation of EZ " + ZONE2 + " by " + userUgi.getUserName() + " using key " + KEY1), (boolean)this.createEncryptionZone(userUgi, KEY1, ZONE2));
            Assert.assertTrue((String)("Exception during creation of file " + FILE1 + " by " + userUgi.getUserName()), (boolean)this.createFile(userUgi, FILE1, TEXT));
            Assert.assertFalse((String)("Allowed creation of file " + FILE1A + " by " + hdfsUgi.getUserName()), (boolean)this.createFile(hdfsUgi, FILE1A, TEXT));
            Assert.assertFalse((String)("Allowed creation of file " + FILE1A + " by " + keyadminUgi.getUserName()), (boolean)this.createFile(keyadminUgi, FILE1A, TEXT));
            Assert.assertTrue((String)("Exception while reading file " + FILE1 + " by " + userUgi.getUserName()), (boolean)this.compareFile(userUgi, FILE1, TEXT));
            Assert.assertFalse((String)("Allowed reading of file " + FILE1 + " by " + hdfsUgi.getUserName()), (boolean)this.compareFile(hdfsUgi, FILE1, TEXT));
            Assert.assertFalse((String)("Allowed reading of file " + FILE1 + " by " + keyadminUgi.getUserName()), (boolean)this.compareFile(keyadminUgi, FILE1, TEXT));
            this.fs.delete(ZONE1, true);
            Assert.assertFalse((String)("Allowed deletion of file " + FILE1 + " by " + hdfsUgi.getUserName()), (boolean)this.deleteKey(hdfsUgi, KEY1));
            Assert.assertFalse((String)("Allowed deletion of file " + FILE1 + " by " + userUgi.getUserName()), (boolean)this.deleteKey(userUgi, KEY1));
            Assert.assertTrue((String)("Exception during deletion of file " + FILE1 + " by " + keyadminUgi.getUserName()), (boolean)this.deleteKey(keyadminUgi, KEY1));
        }
        finally {
            this.fs.delete(ZONE1, true);
            this.fs.delete(ZONE2, true);
            this.teardown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateKey() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation with correct config using whitelist key ACLs", (boolean)this.createKey(realUgi, KEY1, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("default.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation with correct config using default key ACLs", (boolean)this.createKey(realUgi, KEY2, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.CREATE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertFalse((String)"Allowed key creation with blacklist for CREATE", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", " ");
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertFalse((String)"Allowed key creation without CREATE KMS ACL", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertFalse((String)"Allowed key creation without MANAGMENT key ACL", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("default.key.acl.MANAGEMENT", realUgi.getUserName());
        conf.set("key.acl.key3.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertFalse((String)"Allowed key creation when default key ACL should have been overridden by key ACL", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation with default KMS ACLs", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEncryptionZone() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY1, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE1);
            Assert.assertTrue((String)"Exception during zone creation with correct config using whitelist key ACLs", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE1));
        }
        finally {
            this.fs.delete(ZONE1, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("default.key.acl.READ", realUgi.getUserName());
        conf.set("default.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE2);
            Assert.assertTrue((String)"Exception during zone creation with correct config using default key ACLs", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE2));
        }
        finally {
            this.fs.delete(ZONE2, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("default.key.acl.READ", realUgi.getUserName());
        conf.set("default.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("key.acl.key1.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE3);
            Assert.assertFalse((String)"Allowed creation of zone when default key ACLs should have been overridden by key ACL", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE3));
        }
        finally {
            this.fs.delete(ZONE3, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.GET_METADATA", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE3);
            Assert.assertFalse((String)"Allowed zone creation of zone with blacklisted GET_METADATA", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE3));
        }
        finally {
            this.fs.delete(ZONE3, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE3);
            Assert.assertFalse((String)"Allowed zone creation of zone with blacklisted GENERATE_EEK", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE3));
        }
        finally {
            this.fs.delete(ZONE3, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE3);
            Assert.assertTrue((String)"Exception during zone creation with default KMS ACLs", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE3));
        }
        finally {
            this.fs.delete(ZONE3, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", " ");
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE4);
            Assert.assertFalse((String)"Allowed zone creation without GET_METADATA KMS ACL", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE4));
        }
        finally {
            this.fs.delete(ZONE4, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", " ");
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE4);
            Assert.assertFalse((String)"Allowed zone creation without GENERATE_EEK KMS ACL", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE4));
        }
        finally {
            this.fs.delete(ZONE4, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE4);
            Assert.assertFalse((String)"Allowed zone creation without READ ACL", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE4));
        }
        finally {
            this.fs.delete(ZONE4, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        try {
            this.setup(conf, false);
            this.fs.mkdirs(ZONE4);
            Assert.assertFalse((String)"Allowed zone creation without GENERATE_EEK ACL", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE4));
        }
        finally {
            this.fs.delete(ZONE4, true);
            this.teardown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFileInEncryptionZone() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        Assert.assertTrue((new File(this.kmsDir, "kms.keystore").length() == 0L ? 1 : 0) != 0);
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY1, conf));
            this.fs.mkdirs(ZONE1);
            Assert.assertTrue((String)"Exception during zone creation", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE1));
            this.fs.mkdirs(ZONE2);
            Assert.assertTrue((String)"Exception during zone creation", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE2));
            this.fs.mkdirs(ZONE3);
            Assert.assertTrue((String)"Exception during zone creation", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE3));
            this.fs.mkdirs(ZONE4);
            Assert.assertTrue((String)"Exception during zone creation", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE4));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            this.fs.delete(ZONE2, true);
            this.fs.delete(ZONE3, true);
            this.fs.delete(ZONE4, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception during file creation with correct config using whitelist ACL", (boolean)this.createFile(realUgi, FILE1, TEXT));
        }
        finally {
            this.fs.delete(ZONE1, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("default.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("default.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception during file creation with correct config using whitelist ACL", (boolean)this.createFile(realUgi, FILE2, TEXT));
        }
        finally {
            this.fs.delete(ZONE2, true);
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("default.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("default.key.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("key.acl.key1.READ", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation when default key ACLs should have been overridden by key ACL", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation with blacklist for GENERATE_EEK", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation with blacklist for DECRYPT_EEK", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception during file creation with default KMS ACLs", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", " ");
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation without GENERATE_EEK KMS ACL", (boolean)this.createFile(realUgi, FILE4, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", " ");
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation without DECRYPT_EEK KMS ACL", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation without GENERATE_EEK key ACL", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file creation without DECRYPT_EEK key ACL", (boolean)this.createFile(realUgi, FILE3, TEXT));
        }
        catch (Exception ex) {
            this.fs.delete(ZONE3, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testReadFileInEncryptionZone() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GET_METADATA", realUgi.getUserName());
        conf.set("hadoop.kms.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        conf.set("whitelist.key.acl.READ", realUgi.getUserName());
        conf.set("whitelist.key.acl.GENERATE_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        Assert.assertTrue((new File(this.kmsDir, "kms.keystore").length() == 0L ? 1 : 0) != 0);
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY1, conf));
            this.fs.mkdirs(ZONE1);
            Assert.assertTrue((String)"Exception during zone creation", (boolean)this.createEncryptionZone(realUgi, KEY1, ZONE1));
            Assert.assertTrue((String)"Exception during file creation", (boolean)this.createFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception while reading file with correct config with whitelist ACLs", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("default.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception while reading file with correct config with default ACLs", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("default.key.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("key.acl.key1.READ", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file read when default key ACLs should have been overridden by key ACL", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DECRYPT_EEK", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.DECRYPT_EEK", realUgi.getUserName());
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file read with blacklist for DECRYPT_EEK", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertTrue((String)"Exception while reading file with default KMS ACLs", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DECRYPT_EEK", " ");
        conf.set("whitelist.key.acl.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file read without DECRYPT_EEK KMS ACL", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        try {
            this.setup(conf, false, false);
            Assert.assertFalse((String)"Allowed file read without DECRYPT_EEK key ACL", (boolean)this.compareFile(realUgi, FILE1, TEXT));
        }
        catch (Throwable ex) {
            this.fs.delete(ZONE1, true);
            throw ex;
        }
        finally {
            this.teardown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteKey() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.acl.CREATE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf);
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY1, conf));
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY2, conf));
            Assert.assertTrue((String)"Exception during key creation", (boolean)this.createKey(realUgi, KEY3, conf));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertTrue((String)"Exception during key deletion with correct config using whitelist key ACLs", (boolean)this.deleteKey(realUgi, KEY1));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", realUgi.getUserName());
        conf.set("default.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertTrue((String)"Exception during key deletion with correct config using default key ACLs", (boolean)this.deleteKey(realUgi, KEY2));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", realUgi.getUserName());
        conf.set("hadoop.kms.blacklist.DELETE", realUgi.getUserName());
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertFalse((String)"Allowed key deletion with blacklist for DELETE", (boolean)this.deleteKey(realUgi, KEY3));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", " ");
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertFalse((String)"Allowed key deletion without DELETE KMS ACL", (boolean)this.deleteKey(realUgi, KEY3));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertFalse((String)"Allowed key deletion without MANAGMENT key ACL", (boolean)this.deleteKey(realUgi, KEY3));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("hadoop.kms.acl.DELETE", realUgi.getUserName());
        conf.set("default.key.acl.MANAGEMENT", realUgi.getUserName());
        conf.set("key.acl.key3.DECRYPT_EEK", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertFalse((String)"Allowed key deletion when default key ACL should have been overridden by key ACL", (boolean)this.deleteKey(realUgi, KEY3));
        }
        finally {
            this.teardown();
        }
        conf = new Configuration();
        conf.set("whitelist.key.acl.MANAGEMENT", realUgi.getUserName());
        try {
            this.setup(conf, false);
            Assert.assertTrue((String)"Exception during key deletion with default KMS ACLs", (boolean)this.deleteKey(realUgi, KEY3));
        }
        finally {
            this.teardown();
        }
    }

    private boolean createKey(UserGroupInformation ugi, final String key, final Configuration conf) {
        return this.doUserOp(ugi, new UserOp(){

            @Override
            public void execute() throws IOException {
                try {
                    DFSTestUtil.createKey(key, TestAclsEndToEnd.this.cluster, conf);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IOException(ex);
                }
            }
        });
    }

    private boolean createEncryptionZone(UserGroupInformation ugi, final String key, final Path zone) {
        return this.doUserOp(ugi, new UserOp(){

            @Override
            public void execute() throws IOException {
                TestAclsEndToEnd.this.cluster.getFileSystem().createEncryptionZone(zone, key);
            }
        });
    }

    private boolean createFile(UserGroupInformation ugi, final Path file, final String text) {
        return this.doUserOp(ugi, new UserOp(){

            @Override
            public void execute() throws IOException {
                FSDataOutputStream dout = TestAclsEndToEnd.this.cluster.getFileSystem().create(file);
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)dout));
                out.println(text);
                out.close();
            }
        });
    }

    private boolean compareFile(UserGroupInformation ugi, final Path file, final String text) {
        return this.doUserOp(ugi, new UserOp(){

            @Override
            public void execute() throws IOException {
                FSDataInputStream din = TestAclsEndToEnd.this.cluster.getFileSystem().open(file);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)din));
                Assert.assertEquals((String)"The text read does not match the text written", (Object)text, (Object)in.readLine());
            }
        });
    }

    private boolean deleteKey(UserGroupInformation ugi, final String key) throws IOException, InterruptedException {
        return this.doUserOp(ugi, new UserOp(){

            @Override
            public void execute() throws IOException {
                TestAclsEndToEnd.this.cluster.getNameNode().getNamesystem().getProvider().deleteKey(key);
            }
        });
    }

    private boolean doUserOp(UserGroupInformation ugi, final UserOp op) {
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        return (Boolean)ugi.doAs((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    op.execute();
                    return true;
                }
                catch (IOException ex) {
                    LOG.error((Object)"IOException thrown during doAs() operation", (Throwable)ex);
                    return false;
                }
            }
        });
    }

    private static interface UserOp {
        public void execute() throws IOException;
    }
}

