/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class JdbcColumnDefaultValueConverter {
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    protected static final String NULL = "NULL";
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]");
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    protected static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]");

    public String fromGravitino(Expression defaultValue) {
        FunctionExpression functionExpression;
        if (Column.DEFAULT_VALUE_NOT_SET.equals(defaultValue)) {
            return null;
        }
        if (defaultValue instanceof FunctionExpression && (functionExpression = (FunctionExpression)defaultValue).functionName().equalsIgnoreCase(CURRENT_TIMESTAMP)) {
            return CURRENT_TIMESTAMP;
        }
        if (defaultValue instanceof Literal) {
            Literal literal = (Literal)defaultValue;
            Type type = literal.dataType();
            if (defaultValue.equals(Literals.NULL)) {
                return null;
            }
            if (type instanceof Types.TimestampType) {
                if (literal.value() instanceof String || literal.value() instanceof LocalDateTime) {
                    return literal.value().toString().replace("T", " ");
                }
                return literal.value().toString();
            }
            return literal.value().toString();
        }
        return null;
    }

    public Expression toGravitino(Type columnType, String columnDefaultValue, boolean nullable) {
        return Column.DEFAULT_VALUE_NOT_SET;
    }
}

