/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.IcebergMetadataCommitter;
import org.apache.paimon.iceberg.IcebergMetadataCommitterFactory;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.manifest.IcebergConversions;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestEntry;
import org.apache.paimon.iceberg.manifest.IcebergManifestFile;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestList;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummary;
import org.apache.paimon.iceberg.metadata.IcebergDataField;
import org.apache.paimon.iceberg.metadata.IcebergMetadata;
import org.apache.paimon.iceberg.metadata.IcebergPartitionField;
import org.apache.paimon.iceberg.metadata.IcebergPartitionSpec;
import org.apache.paimon.iceberg.metadata.IcebergRef;
import org.apache.paimon.iceberg.metadata.IcebergSchema;
import org.apache.paimon.iceberg.metadata.IcebergSnapshot;
import org.apache.paimon.iceberg.metadata.IcebergSnapshotSummary;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.RawFile;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DataFilePathFactories;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ManifestReadThreadPool;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCommitCallback
implements CommitCallback,
TagCallback {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergCommitCallback.class);
    private static final String VERSION_HINT_FILENAME = "version-hint.text";
    private static final String PUFFIN_FORMAT = "puffin";
    private final FileStoreTable table;
    private final String commitUser;
    private final IcebergPathFactory pathFactory;
    @Nullable
    private final IcebergMetadataCommitter metadataCommitter;
    private final FileStorePathFactory fileStorePathFactory;
    private final IcebergManifestFile manifestFile;
    private final IcebergManifestList manifestList;
    private final int formatVersion;
    private final IndexFileHandler indexFileHandler;
    private final boolean needAddDvToIceberg;

    public IcebergCommitCallback(FileStoreTable table, String commitUser) {
        IcebergMetadataCommitterFactory metadataCommitterFactory;
        this.table = table;
        this.commitUser = commitUser;
        IcebergOptions.StorageType storageType = (IcebergOptions.StorageType)((Object)table.coreOptions().toConfiguration().get(IcebergOptions.METADATA_ICEBERG_STORAGE));
        this.pathFactory = new IcebergPathFactory(IcebergCommitCallback.catalogTableMetadataPath(table));
        try {
            metadataCommitterFactory = (IcebergMetadataCommitterFactory)FactoryUtil.discoverFactory((ClassLoader)IcebergCommitCallback.class.getClassLoader(), IcebergMetadataCommitterFactory.class, (String)storageType.toString());
        }
        catch (FactoryException ignore) {
            metadataCommitterFactory = null;
        }
        this.metadataCommitter = metadataCommitterFactory == null ? null : metadataCommitterFactory.create(table);
        this.fileStorePathFactory = table.store().pathFactory();
        this.manifestFile = IcebergManifestFile.create(table, this.pathFactory);
        this.manifestList = IcebergManifestList.create(table, this.pathFactory);
        this.formatVersion = (Integer)table.coreOptions().toConfiguration().get(IcebergOptions.FORMAT_VERSION);
        Preconditions.checkArgument((this.formatVersion == 2 || this.formatVersion == 3 ? 1 : 0) != 0, (String)"Unsupported iceberg format version! Only version 2 or version 3 is valid, but current version is ", (Object[])new Object[]{this.formatVersion});
        this.indexFileHandler = table.store().newIndexFileHandler();
        this.needAddDvToIceberg = this.needAddDvToIceberg();
    }

    public static Path catalogTableMetadataPath(FileStoreTable table) {
        Path icebergDBPath = IcebergCommitCallback.catalogDatabasePath(table);
        return new Path(icebergDBPath, String.format("%s/metadata", table.location().getName()));
    }

    public static Path catalogDatabasePath(FileStoreTable table) {
        Path dbPath = table.location().getParent();
        String dbSuffix = ".db";
        IcebergOptions.StorageType storageType = (IcebergOptions.StorageType)((Object)table.coreOptions().toConfiguration().get(IcebergOptions.METADATA_ICEBERG_STORAGE));
        if (!dbPath.getName().endsWith(".db")) {
            throw new UnsupportedOperationException(String.format("Storage type %s can only be used on Paimon tables in a Paimon warehouse.", storageType.name()));
        }
        IcebergOptions.StorageLocation storageLocation = table.coreOptions().toConfiguration().getOptional(IcebergOptions.METADATA_ICEBERG_STORAGE_LOCATION).orElse(IcebergCommitCallback.inferDefaultMetadataLocation(storageType));
        switch (storageLocation) {
            case TABLE_LOCATION: {
                return dbPath;
            }
            case CATALOG_STORAGE: {
                String dbName = dbPath.getName().substring(0, dbPath.getName().length() - ".db".length());
                return new Path(dbPath.getParent(), String.format("iceberg/%s/", dbName));
            }
        }
        throw new UnsupportedOperationException("Unknown storage location " + storageLocation.name());
    }

    private static IcebergOptions.StorageLocation inferDefaultMetadataLocation(IcebergOptions.StorageType storageType) {
        switch (storageType) {
            case TABLE_LOCATION: {
                return IcebergOptions.StorageLocation.TABLE_LOCATION;
            }
            case HIVE_CATALOG: 
            case HADOOP_CATALOG: {
                return IcebergOptions.StorageLocation.CATALOG_STORAGE;
            }
        }
        throw new UnsupportedOperationException("Unknown storage type: " + storageType.name());
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void call(List<ManifestEntry> committedEntries, List<IndexManifestEntry> indexFiles, Snapshot snapshot) {
        this.createMetadata(snapshot, (removedFiles, addedFiles) -> this.collectFileChanges(committedEntries, (Map<String, BinaryRow>)removedFiles, (Map<String, Pair<BinaryRow, DataFileMeta>>)addedFiles), indexFiles);
    }

    @Override
    public void retry(ManifestCommittable committable) {
        SnapshotManager snapshotManager = this.table.snapshotManager();
        Snapshot snapshot = snapshotManager.findSnapshotsForIdentifiers(this.commitUser, Collections.singletonList(committable.identifier())).stream().max(Comparator.comparingLong(Snapshot::id)).orElseThrow(() -> new RuntimeException("There is no snapshot for commit user " + this.commitUser + " and identifier " + committable.identifier() + ". This is unexpected."));
        long snapshotId = snapshot.id();
        this.createMetadata(snapshot, (removedFiles, addedFiles) -> this.collectFileChanges(snapshotId, (Map<String, BinaryRow>)removedFiles, (Map<String, Pair<BinaryRow, DataFileMeta>>)addedFiles), this.indexFileHandler.scan(snapshot, "DELETION_VECTORS"));
    }

    private void createMetadata(Snapshot snapshot, FileChangesCollector fileChangesCollector, List<IndexManifestEntry> indexFiles) {
        long snapshotId = snapshot.id();
        try {
            if (snapshotId == 1L) {
                this.table.fileIO().delete(this.pathFactory.metadataDirectory(), true);
            }
            if (this.table.fileIO().exists(this.pathFactory.toMetadataPath(snapshotId))) {
                return;
            }
            Path baseMetadataPath = this.pathFactory.toMetadataPath(snapshotId - 1L);
            if (this.table.fileIO().exists(baseMetadataPath)) {
                this.createMetadataWithBase(fileChangesCollector, indexFiles.stream().filter(index -> index.indexFile().indexType().equals("DELETION_VECTORS")).collect(Collectors.toList()), snapshot, baseMetadataPath);
            } else {
                this.createMetadataWithoutBase(snapshotId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createMetadataWithoutBase(long snapshotId) throws IOException {
        SnapshotReader snapshotReader = this.table.newSnapshotReader().withSnapshot(snapshotId);
        SchemaCache schemaCache = new SchemaCache();
        ArrayList<IcebergManifestEntry> dataFileEntries = new ArrayList<IcebergManifestEntry>();
        ArrayList<IcebergManifestEntry> dvFileEntries = new ArrayList<IcebergManifestEntry>();
        List filteredDataSplits = snapshotReader.read().dataSplits().stream().filter(DataSplit::rawConvertible).collect(Collectors.toList());
        for (DataSplit dataSplit : filteredDataSplits) {
            this.dataSplitToManifestEntries(dataSplit, snapshotId, schemaCache, dataFileEntries, dvFileEntries);
        }
        ArrayList<IcebergManifestFileMeta> manifestFileMetas = new ArrayList<IcebergManifestFileMeta>();
        if (!dataFileEntries.isEmpty()) {
            manifestFileMetas.addAll(this.manifestFile.rollingWrite(dataFileEntries.iterator(), snapshotId));
        }
        if (!dvFileEntries.isEmpty()) {
            manifestFileMetas.addAll(this.manifestFile.rollingWrite(dvFileEntries.iterator(), snapshotId, IcebergManifestFileMeta.Content.DELETES));
        }
        String manifestListFileName = this.manifestList.writeWithoutRolling(manifestFileMetas);
        int schemaId = (int)schemaCache.getLatestSchemaId();
        IcebergSchema icebergSchema = schemaCache.get(schemaId);
        List<IcebergPartitionField> partitionFields = this.getPartitionFields(this.table.schema().partitionKeys(), icebergSchema);
        IcebergSnapshot snapshot = new IcebergSnapshot(snapshotId, snapshotId, System.currentTimeMillis(), IcebergSnapshotSummary.APPEND, this.pathFactory.toManifestListPath(manifestListFileName).toString(), schemaId);
        Map<String, IcebergRef> icebergTags = this.table.tagManager().tags().entrySet().stream().collect(Collectors.toMap(entry -> (String)((List)entry.getValue()).get(0), entry -> new IcebergRef(((Snapshot)entry.getKey()).id())));
        String tableUuid = UUID.randomUUID().toString();
        IcebergMetadata metadata = new IcebergMetadata(this.formatVersion, tableUuid, this.table.location().toString(), snapshotId, icebergSchema.highestFieldId(), Collections.singletonList(icebergSchema), schemaId, Collections.singletonList(new IcebergPartitionSpec(partitionFields)), partitionFields.stream().mapToInt(IcebergPartitionField::fieldId).max().orElse(999), Collections.singletonList(snapshot), (int)snapshotId, icebergTags);
        Path metadataPath = this.pathFactory.toMetadataPath(snapshotId);
        this.table.fileIO().tryToWriteAtomic(metadataPath, metadata.toJson());
        this.table.fileIO().overwriteFileUtf8(new Path(this.pathFactory.metadataDirectory(), VERSION_HINT_FILENAME), String.valueOf(snapshotId));
        this.expireAllBefore(snapshotId);
        if (this.metadataCommitter != null) {
            this.metadataCommitter.commitMetadata(metadataPath, null);
        }
    }

    private void dataSplitToManifestEntries(DataSplit dataSplit, long snapshotId, SchemaCache schemaCache, List<IcebergManifestEntry> dataFileEntries, List<IcebergManifestEntry> dvFileEntries) {
        List<RawFile> rawFiles = dataSplit.convertToRawFiles().get();
        for (int i = 0; i < dataSplit.dataFiles().size(); ++i) {
            DataFileMeta paimonFileMeta = dataSplit.dataFiles().get(i);
            RawFile rawFile = rawFiles.get(i);
            IcebergDataFileMeta fileMeta = IcebergDataFileMeta.create(IcebergDataFileMeta.Content.DATA, rawFile.path(), rawFile.format(), dataSplit.partition(), rawFile.rowCount(), rawFile.fileSize(), schemaCache.get(paimonFileMeta.schemaId()), paimonFileMeta.valueStats(), paimonFileMeta.valueStatsCols());
            dataFileEntries.add(new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, snapshotId, snapshotId, snapshotId, fileMeta));
            if (!this.needAddDvToIceberg || !dataSplit.deletionFiles().isPresent() || dataSplit.deletionFiles().get().get(i) == null) continue;
            DeletionFile deletionFile = dataSplit.deletionFiles().get().get(i);
            Preconditions.checkState((deletionFile.cardinality() != null ? 1 : 0) != 0, (String)"cardinality in DeletionFile is null, stop generating dv for iceberg. dataFile path is {}, deletionFile is {}", (Object[])new Object[]{rawFile.path(), deletionFile});
            IcebergDataFileMeta deleteFileMeta = IcebergDataFileMeta.createForDeleteFile(IcebergDataFileMeta.Content.POSITION_DELETES, deletionFile.path(), PUFFIN_FORMAT, dataSplit.partition(), deletionFile.cardinality(), -1L, rawFile.path(), deletionFile.offset(), deletionFile.length());
            dvFileEntries.add(new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, snapshotId, snapshotId, snapshotId, deleteFileMeta));
        }
    }

    private List<IcebergPartitionField> getPartitionFields(List<String> partitionKeys, IcebergSchema icebergSchema) {
        HashMap<String, IcebergDataField> fields = new HashMap<String, IcebergDataField>();
        for (IcebergDataField field : icebergSchema.fields()) {
            fields.put(field.name(), field);
        }
        ArrayList<IcebergPartitionField> result = new ArrayList<IcebergPartitionField>();
        int fieldId = 1000;
        for (String partitionKey : partitionKeys) {
            result.add(new IcebergPartitionField((IcebergDataField)fields.get(partitionKey), fieldId));
            ++fieldId;
        }
        return result;
    }

    private void createMetadataWithBase(FileChangesCollector fileChangesCollector, List<IndexManifestEntry> indexFiles, Snapshot snapshot, Path baseMetadataPath) throws IOException {
        IcebergSnapshotSummary snapshotSummary;
        List<Object> newDataManifestFileMetas;
        long snapshotId = snapshot.id();
        IcebergMetadata baseMetadata = IcebergMetadata.fromPath(this.table.fileIO(), baseMetadataPath);
        if (!this.isSameFormatVersion(baseMetadata.formatVersion())) {
            this.createMetadataWithoutBase(snapshot.id());
            return;
        }
        List baseManifestFileMetas = this.manifestList.read(baseMetadata.currentSnapshot().manifestList());
        List<IcebergManifestFileMeta> baseDataManifestFileMetas = baseManifestFileMetas.stream().filter(meta -> meta.content() == IcebergManifestFileMeta.Content.DATA).collect(Collectors.toList());
        List baseDVManifestFileMetas = baseManifestFileMetas.stream().filter(meta -> meta.content() == IcebergManifestFileMeta.Content.DELETES).collect(Collectors.toList());
        LinkedHashMap<String, BinaryRow> removedFiles = new LinkedHashMap<String, BinaryRow>();
        LinkedHashMap<String, Pair<BinaryRow, DataFileMeta>> addedFiles = new LinkedHashMap<String, Pair<BinaryRow, DataFileMeta>>();
        boolean isAddOnly = fileChangesCollector.collect(removedFiles, addedFiles);
        LinkedHashSet modifiedPartitionsSet = new LinkedHashSet(removedFiles.values());
        modifiedPartitionsSet.addAll(addedFiles.values().stream().map(Pair::getLeft).collect(Collectors.toList()));
        ArrayList<BinaryRow> modifiedPartitions = new ArrayList<BinaryRow>(modifiedPartitionsSet);
        if (isAddOnly) {
            newDataManifestFileMetas = new ArrayList(baseDataManifestFileMetas);
            newDataManifestFileMetas.addAll(this.createNewlyAddedManifestFileMetas(addedFiles, snapshotId));
            snapshotSummary = IcebergSnapshotSummary.APPEND;
        } else {
            Pair<List<IcebergManifestFileMeta>, IcebergSnapshotSummary> result = this.createWithDeleteManifestFileMetas(removedFiles, addedFiles, modifiedPartitions, baseDataManifestFileMetas, snapshotId);
            newDataManifestFileMetas = (List)result.getLeft();
            snapshotSummary = (IcebergSnapshotSummary)result.getRight();
        }
        ArrayList<IcebergManifestFileMeta> newDVManifestFileMetas = new ArrayList<IcebergManifestFileMeta>();
        if (this.needAddDvToIceberg) {
            if (!indexFiles.isEmpty()) {
                newDVManifestFileMetas.addAll(this.createDvManifestFileMetas(snapshot));
            } else {
                newDVManifestFileMetas.addAll(baseDVManifestFileMetas);
            }
        }
        newDataManifestFileMetas = this.compactMetadataIfNeeded(newDataManifestFileMetas, snapshotId);
        String manifestListFileName = this.manifestList.writeWithoutRolling(Stream.concat(newDataManifestFileMetas.stream(), newDVManifestFileMetas.stream()).collect(Collectors.toList()));
        SchemaCache schemaCache = new SchemaCache();
        int schemaId = (int)schemaCache.getLatestSchemaId();
        IcebergSchema icebergSchema = schemaCache.get(schemaId);
        List<IcebergSchema> schemas = baseMetadata.schemas();
        if (baseMetadata.currentSchemaId() != schemaId) {
            schemas = new ArrayList<IcebergSchema>(schemas);
            schemas.add(icebergSchema);
        }
        List<IcebergSnapshot> snapshots = new ArrayList<IcebergSnapshot>(baseMetadata.snapshots());
        snapshots.add(new IcebergSnapshot(snapshotId, snapshotId, System.currentTimeMillis(), snapshotSummary, this.pathFactory.toManifestListPath(manifestListFileName).toString(), schemaId));
        ArrayList toExpireExceptLast = new ArrayList();
        int i = 0;
        while (i + 1 < snapshots.size()) {
            toExpireExceptLast.add(snapshots.get(i));
            if (!this.shouldExpire((IcebergSnapshot)snapshots.get(i), snapshotId)) {
                snapshots = snapshots.subList(i, snapshots.size());
                break;
            }
            ++i;
        }
        IcebergMetadata metadata = new IcebergMetadata(baseMetadata.formatVersion(), baseMetadata.tableUuid(), baseMetadata.location(), snapshotId, icebergSchema.highestFieldId(), schemas, schemaId, baseMetadata.partitionSpecs(), baseMetadata.lastPartitionId(), snapshots, (int)snapshotId, baseMetadata.refs());
        Path metadataPath = this.pathFactory.toMetadataPath(snapshotId);
        this.table.fileIO().tryToWriteAtomic(metadataPath, metadata.toJson());
        this.table.fileIO().overwriteFileUtf8(new Path(this.pathFactory.metadataDirectory(), VERSION_HINT_FILENAME), String.valueOf(snapshotId));
        this.deleteApplicableMetadataFiles(snapshotId);
        int i2 = 0;
        while (i2 + 1 < toExpireExceptLast.size()) {
            this.expireManifestList(new Path(((IcebergSnapshot)toExpireExceptLast.get(i2)).manifestList()).getName(), new Path(((IcebergSnapshot)toExpireExceptLast.get(i2 + 1)).manifestList()).getName());
            ++i2;
        }
        if (this.metadataCommitter != null) {
            this.metadataCommitter.commitMetadata(metadataPath, baseMetadataPath);
        }
    }

    private boolean collectFileChanges(List<ManifestEntry> manifestEntries, Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles) {
        boolean isAddOnly = true;
        DataFilePathFactories factories = new DataFilePathFactories(this.fileStorePathFactory);
        block4: for (ManifestEntry entry : manifestEntries) {
            DataFilePathFactory dataFilePathFactory = factories.get(entry.partition(), entry.bucket());
            String path = dataFilePathFactory.toPath(entry).toString();
            switch (entry.kind()) {
                case ADD: {
                    if (!this.shouldAddFileToIceberg(entry.file())) continue block4;
                    removedFiles.remove(path);
                    addedFiles.put(path, (Pair<BinaryRow, DataFileMeta>)Pair.of((Object)entry.partition(), (Object)entry.file()));
                    continue block4;
                }
                case DELETE: {
                    isAddOnly = false;
                    addedFiles.remove(path);
                    removedFiles.put(path, entry.partition());
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown ManifestEntry FileKind " + (Object)((Object)entry.kind()));
        }
        return isAddOnly;
    }

    private boolean collectFileChanges(long snapshotId, Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles) {
        return this.collectFileChanges(this.table.store().newScan().withKind(ScanMode.DELTA).withSnapshot(snapshotId).plan().files(), removedFiles, addedFiles);
    }

    private boolean shouldAddFileToIceberg(DataFileMeta meta) {
        if (this.table.primaryKeys().isEmpty()) {
            return true;
        }
        if (this.needAddDvToIceberg) {
            return meta.level() > 0;
        }
        int maxLevel = this.table.coreOptions().numLevels() - 1;
        return meta.level() == maxLevel;
    }

    private List<IcebergManifestFileMeta> createNewlyAddedManifestFileMetas(Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles, long currentSnapshotId) throws IOException {
        if (addedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        SchemaCache schemaCache = new SchemaCache();
        return this.manifestFile.rollingWrite(addedFiles.entrySet().stream().map(e -> {
            DataFileMeta paimonFileMeta = (DataFileMeta)((Pair)e.getValue()).getRight();
            IcebergDataFileMeta icebergFileMeta = IcebergDataFileMeta.create(IcebergDataFileMeta.Content.DATA, (String)e.getKey(), paimonFileMeta.fileFormat(), (BinaryRow)((Pair)e.getValue()).getLeft(), paimonFileMeta.rowCount(), paimonFileMeta.fileSize(), schemaCache.get(paimonFileMeta.schemaId()), paimonFileMeta.valueStats(), paimonFileMeta.valueStatsCols());
            return new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, currentSnapshotId, currentSnapshotId, currentSnapshotId, icebergFileMeta);
        }).iterator(), currentSnapshotId);
    }

    private Pair<List<IcebergManifestFileMeta>, IcebergSnapshotSummary> createWithDeleteManifestFileMetas(Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles, List<BinaryRow> modifiedPartitions, List<IcebergManifestFileMeta> baseManifestFileMetas, long currentSnapshotId) throws IOException {
        IcebergSnapshotSummary snapshotSummary = IcebergSnapshotSummary.APPEND;
        ArrayList<IcebergManifestFileMeta> newManifestFileMetas = new ArrayList<IcebergManifestFileMeta>();
        RowType partitionType = this.table.schema().logicalPartitionType();
        PartitionPredicate predicate = PartitionPredicate.fromMultiple(partitionType, modifiedPartitions);
        for (IcebergManifestFileMeta fileMeta : baseManifestFileMetas) {
            int numFields = partitionType.getFieldCount();
            GenericRow minValues = new GenericRow(numFields);
            GenericRow maxValues = new GenericRow(numFields);
            long[] nullCounts = new long[numFields];
            for (int i = 0; i < numFields; ++i) {
                IcebergPartitionSummary summary = fileMeta.partitions().get(i);
                DataType fieldType = partitionType.getTypeAt(i);
                minValues.setField(i, IcebergConversions.toPaimonObject(fieldType, summary.lowerBound()));
                maxValues.setField(i, IcebergConversions.toPaimonObject(fieldType, summary.upperBound()));
                nullCounts[i] = summary.containsNull() ? 1L : 0L;
            }
            if (predicate == null || predicate.test(fileMeta.liveRowsCount(), (InternalRow)minValues, (InternalRow)maxValues, (InternalArray)new GenericArray(nullCounts))) {
                List entries = this.manifestFile.read(new Path(fileMeta.manifestPath()).getName());
                boolean canReuseFile = true;
                for (IcebergManifestEntry entry : entries) {
                    if (!entry.isLive()) continue;
                    String path = entry.file().filePath();
                    if (addedFiles.containsKey(path)) {
                        addedFiles.remove(path);
                        continue;
                    }
                    if (!removedFiles.containsKey(path)) continue;
                    canReuseFile = false;
                }
                if (canReuseFile) {
                    newManifestFileMetas.add(fileMeta);
                    continue;
                }
                snapshotSummary = IcebergSnapshotSummary.OVERWRITE;
                ArrayList<IcebergManifestEntry> newEntries = new ArrayList<IcebergManifestEntry>();
                for (IcebergManifestEntry entry : entries) {
                    if (!entry.isLive()) continue;
                    newEntries.add(new IcebergManifestEntry(removedFiles.containsKey(entry.file().filePath()) ? IcebergManifestEntry.Status.DELETED : IcebergManifestEntry.Status.EXISTING, entry.snapshotId(), entry.sequenceNumber(), entry.fileSequenceNumber(), entry.file()));
                }
                newManifestFileMetas.addAll(this.manifestFile.rollingWrite(newEntries.iterator(), currentSnapshotId));
                continue;
            }
            newManifestFileMetas.add(fileMeta);
        }
        newManifestFileMetas.addAll(this.createNewlyAddedManifestFileMetas(addedFiles, currentSnapshotId));
        return Pair.of(newManifestFileMetas, (Object)snapshotSummary);
    }

    private List<IcebergManifestFileMeta> compactMetadataIfNeeded(List<IcebergManifestFileMeta> toCompact, long currentSnapshotId) throws IOException {
        ArrayList<IcebergManifestFileMeta> result = new ArrayList<IcebergManifestFileMeta>();
        long targetSizeInBytes = this.table.coreOptions().manifestTargetSize().getBytes();
        ArrayList<IcebergManifestFileMeta> candidates = new ArrayList<IcebergManifestFileMeta>();
        long totalSizeInBytes = 0L;
        for (IcebergManifestFileMeta meta2 : toCompact) {
            if (meta2.manifestLength() < targetSizeInBytes * 2L / 3L) {
                candidates.add(meta2);
                totalSizeInBytes += meta2.manifestLength();
                continue;
            }
            result.add(meta2);
        }
        Options options = new Options(this.table.options());
        if (candidates.size() < (Integer)options.get(IcebergOptions.COMPACT_MIN_FILE_NUM)) {
            return toCompact;
        }
        if (candidates.size() < (Integer)options.get(IcebergOptions.COMPACT_MAX_FILE_NUM) && totalSizeInBytes < targetSizeInBytes) {
            return toCompact;
        }
        Function<IcebergManifestFileMeta, List> processor = meta -> {
            ArrayList<IcebergManifestEntry> entries = new ArrayList<IcebergManifestEntry>();
            for (IcebergManifestEntry entry : IcebergManifestFile.create(this.table, this.pathFactory).read(new Path(meta.manifestPath()).getName())) {
                if (entry.fileSequenceNumber() == currentSnapshotId || entry.status() == IcebergManifestEntry.Status.EXISTING) {
                    entries.add(entry);
                    continue;
                }
                if (entry.status() != IcebergManifestEntry.Status.ADDED) {
                    if (entry.status() == IcebergManifestEntry.Status.DELETED) continue;
                    throw new UnsupportedOperationException("Unknown IcebergManifestEntry.Status " + (Object)((Object)entry.status()));
                }
                IcebergManifestEntry.Status newStatus = IcebergManifestEntry.Status.EXISTING;
                entries.add(new IcebergManifestEntry(newStatus, entry.snapshotId(), entry.sequenceNumber(), entry.fileSequenceNumber(), entry.file()));
            }
            if (meta.sequenceNumber() == currentSnapshotId) {
                this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
            }
            return entries;
        };
        Iterable newEntries = ManifestReadThreadPool.sequentialBatchedExecute(processor, candidates, null);
        result.addAll(this.manifestFile.rollingWrite(newEntries.iterator(), currentSnapshotId));
        return result;
    }

    private boolean shouldExpire(IcebergSnapshot snapshot, long currentSnapshotId) {
        Options options = new Options(this.table.options());
        if (snapshot.snapshotId() > currentSnapshotId - (long)((Integer)options.get(CoreOptions.SNAPSHOT_NUM_RETAINED_MIN)).intValue()) {
            return false;
        }
        if (snapshot.snapshotId() <= currentSnapshotId - (long)((Integer)options.get(CoreOptions.SNAPSHOT_NUM_RETAINED_MAX)).intValue()) {
            return true;
        }
        return snapshot.timestampMs() < System.currentTimeMillis() - ((Duration)options.get(CoreOptions.SNAPSHOT_TIME_RETAINED)).toMillis();
    }

    private void expireManifestList(String toExpire, String next) {
        HashSet metaInUse = new HashSet(this.manifestList.read(next));
        for (IcebergManifestFileMeta meta : this.manifestList.read(toExpire)) {
            if (metaInUse.contains(meta)) continue;
            this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
        }
        this.table.fileIO().deleteQuietly(this.pathFactory.toManifestListPath(toExpire));
    }

    private void expireAllBefore(long snapshotId) throws IOException {
        HashSet<String> expiredManifestLists = new HashSet<String>();
        HashSet<String> expiredManifestFileMetas = new HashSet<String>();
        Iterator it = this.pathFactory.getAllMetadataPathBefore(this.table.fileIO(), snapshotId).iterator();
        while (it.hasNext()) {
            Path path = (Path)it.next();
            IcebergMetadata metadata = IcebergMetadata.fromPath(this.table.fileIO(), path);
            for (IcebergSnapshot snapshot : metadata.snapshots()) {
                Path listPath = new Path(snapshot.manifestList());
                String listName = listPath.getName();
                if (expiredManifestLists.contains(listName)) continue;
                expiredManifestLists.add(listName);
                for (IcebergManifestFileMeta meta : this.manifestList.read(listName)) {
                    String metaName = new Path(meta.manifestPath()).getName();
                    if (expiredManifestFileMetas.contains(metaName)) continue;
                    expiredManifestFileMetas.add(metaName);
                    this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
                }
                this.table.fileIO().deleteQuietly(listPath);
            }
            this.deleteApplicableMetadataFiles(snapshotId);
        }
    }

    private void deleteApplicableMetadataFiles(long snapshotId) throws IOException {
        long earliestMetadataId;
        Options options = new Options(this.table.options());
        if (((Boolean)options.get(IcebergOptions.METADATA_DELETE_AFTER_COMMIT)).booleanValue() && (earliestMetadataId = snapshotId - (long)((Integer)options.get(IcebergOptions.METADATA_PREVIOUS_VERSIONS_MAX)).intValue()) > 0L) {
            Iterator it = this.pathFactory.getAllMetadataPathBefore(this.table.fileIO(), earliestMetadataId).iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                this.table.fileIO().deleteQuietly(path);
            }
        }
    }

    @Override
    public void notifyCreation(String tagName) {
        throw new UnsupportedOperationException("IcebergCommitCallback notifyCreation requires a snapshot ID");
    }

    @Override
    public void notifyCreation(String tagName, long snapshotId) {
        try {
            Snapshot latestSnapshot = this.table.snapshotManager().latestSnapshot();
            if (latestSnapshot == null) {
                LOG.info("Latest Iceberg snapshot not found when creating tag {} for snapshot {}. Unable to create tag.", (Object)tagName, (Object)snapshotId);
                return;
            }
            Path baseMetadataPath = this.pathFactory.toMetadataPath(latestSnapshot.id());
            if (!this.table.fileIO().exists(baseMetadataPath)) {
                LOG.info("Iceberg metadata file {} not found when creating tag {} for snapshot {}. Unable to create tag.", new Object[]{baseMetadataPath, tagName, snapshotId});
                return;
            }
            IcebergMetadata baseMetadata = IcebergMetadata.fromPath(this.table.fileIO(), baseMetadataPath);
            baseMetadata.refs().put(tagName, new IcebergRef(snapshotId));
            IcebergMetadata metadata = new IcebergMetadata(baseMetadata.formatVersion(), baseMetadata.tableUuid(), baseMetadata.location(), baseMetadata.currentSnapshotId(), baseMetadata.lastColumnId(), baseMetadata.schemas(), baseMetadata.currentSchemaId(), baseMetadata.partitionSpecs(), baseMetadata.lastPartitionId(), baseMetadata.snapshots(), baseMetadata.currentSnapshotId(), baseMetadata.refs());
            this.table.fileIO().overwriteFileUtf8(baseMetadataPath, metadata.toJson());
            LOG.info("Iceberg metadata file {} overwritten to add tag {} for snapshot {}.", new Object[]{baseMetadataPath, tagName, snapshotId});
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create tag " + tagName, e);
        }
    }

    @Override
    public void notifyDeletion(String tagName) {
        try {
            Snapshot latestSnapshot = this.table.snapshotManager().latestSnapshot();
            if (latestSnapshot == null) {
                LOG.info("Latest Iceberg snapshot not found when deleting tag {}. Unable to delete tag.", (Object)tagName);
                return;
            }
            Path baseMetadataPath = this.pathFactory.toMetadataPath(latestSnapshot.id());
            if (!this.table.fileIO().exists(baseMetadataPath)) {
                LOG.info("Iceberg metadata file {} not found when deleting tag {}. Unable to delete tag.", (Object)baseMetadataPath, (Object)tagName);
                return;
            }
            IcebergMetadata baseMetadata = IcebergMetadata.fromPath(this.table.fileIO(), baseMetadataPath);
            baseMetadata.refs().remove(tagName);
            IcebergMetadata metadata = new IcebergMetadata(baseMetadata.formatVersion(), baseMetadata.tableUuid(), baseMetadata.location(), baseMetadata.currentSnapshotId(), baseMetadata.lastColumnId(), baseMetadata.schemas(), baseMetadata.currentSchemaId(), baseMetadata.partitionSpecs(), baseMetadata.lastPartitionId(), baseMetadata.snapshots(), baseMetadata.currentSnapshotId(), baseMetadata.refs());
            this.table.fileIO().overwriteFileUtf8(baseMetadataPath, metadata.toJson());
            LOG.info("Iceberg metadata file {} overwritten to delete tag {}.", (Object)baseMetadataPath, (Object)tagName);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create tag " + tagName, e);
        }
    }

    private boolean needAddDvToIceberg() {
        CoreOptions options = this.table.coreOptions();
        return options.deletionVectorsEnabled() && options.deletionVectorBitmap64() && this.formatVersion == 3;
    }

    private List<IcebergManifestFileMeta> createDvManifestFileMetas(Snapshot snapshot) {
        ArrayList<IcebergManifestEntry> icebergDvEntries = new ArrayList<IcebergManifestEntry>();
        long snapshotId = snapshot.id();
        List<IndexManifestEntry> newIndexes = this.indexFileHandler.scan(snapshot, "DELETION_VECTORS");
        if (newIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        for (IndexManifestEntry entry : newIndexes) {
            IndexFileMeta indexFileMeta = entry.indexFile();
            LinkedHashMap<String, DeletionVectorMeta> dvMetas = indexFileMeta.deletionVectorMetas();
            Path bucketPath = this.fileStorePathFactory.bucketPath(entry.partition(), entry.bucket());
            if (dvMetas == null) continue;
            for (DeletionVectorMeta dvMeta : dvMetas.values()) {
                Preconditions.checkState((dvMeta.cardinality() != null ? 1 : 0) != 0, (String)"cardinality in DeletionVector is null, stop generate dv for iceberg. dataFile path is {}, indexFile path is {}", (Object[])new Object[]{new Path(bucketPath, dvMeta.dataFileName()), this.indexFileHandler.filePath(indexFileMeta).toString()});
                IcebergDataFileMeta deleteFileMeta = IcebergDataFileMeta.createForDeleteFile(IcebergDataFileMeta.Content.POSITION_DELETES, this.indexFileHandler.filePath(indexFileMeta).toString(), PUFFIN_FORMAT, entry.partition(), dvMeta.cardinality(), indexFileMeta.fileSize(), new Path(bucketPath, dvMeta.dataFileName()).toString(), Long.valueOf(dvMeta.offset()), Long.valueOf(dvMeta.length()));
                icebergDvEntries.add(new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, snapshotId, snapshotId, snapshotId, deleteFileMeta));
            }
        }
        if (icebergDvEntries.isEmpty()) {
            return Collections.emptyList();
        }
        return this.manifestFile.rollingWrite(icebergDvEntries.iterator(), snapshotId, IcebergManifestFileMeta.Content.DELETES);
    }

    private boolean isSameFormatVersion(int baseFormatVersion) {
        if (baseFormatVersion != this.formatVersion) {
            Preconditions.checkArgument((this.formatVersion > baseFormatVersion ? 1 : 0) != 0, (Object)"format version in base metadata is {}, and it's bigger than the current format version {}, this is not allowed!");
            LOG.info("format version in base metadata is {}, and it's different from the current format version {}. New metadata will be recreated using format version {}.", new Object[]{baseFormatVersion, this.formatVersion, this.formatVersion});
            return false;
        }
        return true;
    }

    private class SchemaCache {
        SchemaManager schemaManager;
        Map<Long, IcebergSchema> schemas;

        private SchemaCache() {
            this.schemaManager = new SchemaManager(IcebergCommitCallback.this.table.fileIO(), IcebergCommitCallback.this.table.location());
            this.schemas = new HashMap<Long, IcebergSchema>();
        }

        private IcebergSchema get(long schemaId) {
            return this.schemas.computeIfAbsent(schemaId, id -> IcebergSchema.create(this.schemaManager.schema((long)id)));
        }

        private long getLatestSchemaId() {
            return this.schemaManager.latest().get().id();
        }
    }

    private static interface FileChangesCollector {
        public boolean collect(Map<String, BinaryRow> var1, Map<String, Pair<BinaryRow, DataFileMeta>> var2) throws IOException;
    }
}

