/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.metalake.MetalakeManager;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupManager.class);
    private static final String METALAKE_DOES_NOT_EXIST_MSG = "Metalake %s does not exist";
    private final EntityStore store;
    private final IdGenerator idGenerator;

    UserGroupManager(EntityStore store, IdGenerator idGenerator) {
        this.store = store;
        this.idGenerator = idGenerator;
    }

    User addUser(String metalake, String name) throws UserAlreadyExistsException {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            UserEntity userEntity = UserEntity.builder().withId(this.idGenerator.nextId()).withName(name).withNamespace(AuthorizationUtils.ofUserNamespace(metalake)).withRoleNames(Lists.newArrayList()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
            this.store.put(userEntity, false);
            return userEntity;
        }
        catch (EntityAlreadyExistsException e) {
            LOG.warn("User {} in the metalake {} already exists", new Object[]{name, metalake, e});
            throw new UserAlreadyExistsException("User %s in the metalake %s already exists", new Object[]{name, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Adding user {} failed in the metalake {} due to storage issues", new Object[]{name, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    boolean removeUser(String metalake, String user) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return this.store.delete(AuthorizationUtils.ofUser(metalake, user), Entity.EntityType.USER);
        }
        catch (IOException ioe) {
            LOG.error("Removing user {} in the metalake {} failed due to storage issues", new Object[]{user, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    User getUser(String metalake, String user) throws NoSuchUserException {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return this.store.get(AuthorizationUtils.ofUser(metalake, user), Entity.EntityType.USER, UserEntity.class);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("User {} does not exist in the metalake {}", new Object[]{user, metalake, e});
            throw new NoSuchUserException("User %s does not exist in the metalake %s", new Object[]{user, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Getting user {} failed due to storage issues", (Object)user, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    String[] listUserNames(String metalake) {
        return (String[])Arrays.stream(this.listUsersInternal(metalake, false)).map(User::name).toArray(String[]::new);
    }

    User[] listUsers(String metalake) {
        return this.listUsersInternal(metalake, true);
    }

    Group addGroup(String metalake, String group) throws GroupAlreadyExistsException {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            GroupEntity groupEntity = GroupEntity.builder().withId(this.idGenerator.nextId()).withName(group).withNamespace(AuthorizationUtils.ofGroupNamespace(metalake)).withRoleNames(Collections.emptyList()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
            this.store.put(groupEntity, false);
            return groupEntity;
        }
        catch (EntityAlreadyExistsException e) {
            LOG.warn("Group {} in the metalake {} already exists", new Object[]{group, metalake, e});
            throw new GroupAlreadyExistsException("Group %s in the metalake %s already exists", new Object[]{group, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Adding group {} failed in the metalake {} due to storage issues", new Object[]{group, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    boolean removeGroup(String metalake, String group) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return this.store.delete(AuthorizationUtils.ofGroup(metalake, group), Entity.EntityType.GROUP);
        }
        catch (IOException ioe) {
            LOG.error("Removing group {} in the metalake {} failed due to storage issues", new Object[]{group, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    Group getGroup(String metalake, String group) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            return this.store.get(AuthorizationUtils.ofGroup(metalake, group), Entity.EntityType.GROUP, GroupEntity.class);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Group {} does not exist in the metalake {}", new Object[]{group, metalake, e});
            throw new NoSuchGroupException("Group %s does not exist in the metalake %s", new Object[]{group, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Getting group {} failed due to storage issues", (Object)group, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    Group[] listGroups(String metalake) {
        return this.listGroupInternal(metalake, true);
    }

    String[] listGroupNames(String metalake) {
        return (String[])Arrays.stream(this.listGroupInternal(metalake, false)).map(Group::name).toArray(String[]::new);
    }

    private User[] listUsersInternal(String metalake, boolean allFields) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            Namespace namespace = AuthorizationUtils.ofUserNamespace(metalake);
            return this.store.list(namespace, UserEntity.class, Entity.EntityType.USER, allFields).toArray(new User[0]);
        }
        catch (NoSuchEntityException e) {
            LOG.error("Metalake {} does not exist", (Object)metalake, (Object)e);
            throw new NoSuchMetalakeException(METALAKE_DOES_NOT_EXIST_MSG, new Object[]{metalake});
        }
        catch (IOException ioe) {
            LOG.error("Listing user under metalake {} failed due to storage issues", (Object)metalake, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private Group[] listGroupInternal(String metalake, boolean allFields) {
        try {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.store);
            Namespace namespace = AuthorizationUtils.ofGroupNamespace(metalake);
            return this.store.list(namespace, GroupEntity.class, Entity.EntityType.GROUP, allFields).toArray(new Group[0]);
        }
        catch (NoSuchEntityException e) {
            LOG.error("Metalake {} does not exist", (Object)metalake, (Object)e);
            throw new NoSuchMetalakeException(METALAKE_DOES_NOT_EXIST_MSG, new Object[]{metalake});
        }
        catch (IOException ioe) {
            LOG.error("Listing group under metalake {} failed due to storage issues", (Object)metalake, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }
}

