/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.apache.paimon.shade.org.apache.datasketches.memory.Map;
import org.apache.paimon.shade.org.apache.datasketches.memory.MemoryCloseException;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.AccessByteBuffer;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MemoryCleaner;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NioBits;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.UnsafeUtil;
import sun.nio.ch.FileChannelImpl;

class AllocateDirectMap
implements Map {
    static final Logger LOG = Logger.getLogger(AllocateDirectMap.class.getCanonicalName());
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final Method FILE_CHANNEL_IMPL_MAP0_METHOD;
    static final Method FILE_CHANNEL_IMPL_UNMAP0_METHOD;
    private static final Method MAPPED_BYTE_BUFFER_LOAD0_METHOD;
    private static final Method MAPPED_BYTE_BUFFER_ISLOADED0_METHOD;
    static final Method MAPPED_BYTE_BUFFER_FORCE0_METHOD;
    private final Deallocator deallocator;
    private final MemoryCleaner cleaner;
    final long capacityBytes;
    final RandomAccessFile raf;
    final long nativeBaseOffset;
    final boolean resourceReadOnly;

    AllocateDirectMap(File file, long fileOffsetBytes, long capacityBytes, boolean localReadOnly) {
        this.capacityBytes = capacityBytes;
        this.resourceReadOnly = AllocateDirectMap.isFileReadOnly(file);
        long fileLength = file.length();
        if ((localReadOnly || this.resourceReadOnly) && fileOffsetBytes + capacityBytes > fileLength) {
            throw new IllegalArgumentException("Read-only mode and requested map length is greater than current file length: Requested Length = " + (fileOffsetBytes + capacityBytes) + ", Current File Length = " + fileLength);
        }
        this.raf = AllocateDirectMap.mapper(file, fileOffsetBytes, capacityBytes, this.resourceReadOnly);
        this.nativeBaseOffset = AllocateDirectMap.map(this.raf.getChannel(), this.resourceReadOnly, fileOffsetBytes, capacityBytes);
        this.deallocator = new Deallocator(this.nativeBaseOffset, capacityBytes, this.raf);
        this.cleaner = new MemoryCleaner(this, this.deallocator);
    }

    @Override
    public void load() {
        this.madvise();
        int ps = NioBits.pageSize();
        int count = NioBits.pageCount(this.capacityBytes);
        long offset = this.nativeBaseOffset;
        for (int i = 0; i < count; ++i) {
            UnsafeUtil.unsafe.getByte(offset);
            offset += (long)ps;
        }
    }

    @Override
    public boolean isLoaded() {
        try {
            int pageCount = NioBits.pageCount(this.capacityBytes);
            return (Boolean)MAPPED_BYTE_BUFFER_ISLOADED0_METHOD.invoke((Object)AccessByteBuffer.ZERO_READ_ONLY_DIRECT_BYTE_BUFFER, this.nativeBaseOffset, this.capacityBytes, pageCount);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    @Override
    public void close() {
        this.doClose("AllocateDirectMap");
    }

    boolean doClose(String resource) {
        try {
            if (this.deallocator.deallocate(false)) {
                this.cleaner.clean();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new MemoryCloseException(resource);
        }
        finally {
            BaseStateImpl.reachabilityFence(this);
        }
    }

    StepBoolean getValid() {
        return this.deallocator.getValid();
    }

    private void madvise() {
        try {
            MAPPED_BYTE_BUFFER_LOAD0_METHOD.invoke((Object)AccessByteBuffer.ZERO_READ_ONLY_DIRECT_BYTE_BUFFER, this.nativeBaseOffset, this.capacityBytes);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    private static RandomAccessFile mapper(File file, long fileOffset, long capacityBytes, boolean resourceReadOnly) {
        RandomAccessFile raf;
        String mode = resourceReadOnly ? "r" : "rw";
        try {
            raf = new RandomAccessFile(file, mode);
            if (fileOffset + capacityBytes > raf.length()) {
                raf.setLength(fileOffset + capacityBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return raf;
    }

    private static long map(FileChannel fileChannel, boolean resourceReadOnly, long position, long lengthBytes) {
        int pagePosition = (int)(position % (long)UnsafeUtil.unsafe.pageSize());
        long mapPosition = position - (long)pagePosition;
        long mapSize = lengthBytes + (long)pagePosition;
        int mapMode = resourceReadOnly ? 0 : 1;
        try {
            long nativeBaseOffset = (Long)FILE_CHANNEL_IMPL_MAP0_METHOD.invoke((Object)fileChannel, mapMode, mapPosition, mapSize);
            return nativeBaseOffset;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception while mapping", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Exception while mapping", e);
        }
    }

    public static boolean isFileReadOnly(File file) {
        return !file.canWrite();
    }

    static {
        try {
            FILE_CHANNEL_IMPL_MAP0_METHOD = FileChannelImpl.class.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            FILE_CHANNEL_IMPL_MAP0_METHOD.setAccessible(true);
            FILE_CHANNEL_IMPL_UNMAP0_METHOD = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            FILE_CHANNEL_IMPL_UNMAP0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_LOAD0_METHOD = MappedByteBuffer.class.getDeclaredMethod("load0", Long.TYPE, Long.TYPE);
            MAPPED_BYTE_BUFFER_LOAD0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_ISLOADED0_METHOD = MappedByteBuffer.class.getDeclaredMethod("isLoaded0", Long.TYPE, Long.TYPE, Integer.TYPE);
            MAPPED_BYTE_BUFFER_ISLOADED0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_FORCE0_METHOD = MappedByteBuffer.class.getDeclaredMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
            MAPPED_BYTE_BUFFER_FORCE0_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Could not reflect static methods: " + e);
        }
    }

    private static final class Deallocator
    implements Runnable {
        private final RandomAccessFile myRaf;
        private final FileChannel myFc;
        private final long actualNativeBaseOffset;
        private final long myCapacity;
        private final StepBoolean valid = new StepBoolean(true);

        Deallocator(long nativeBaseOffset, long capacityBytes, RandomAccessFile raf) {
            BaseStateImpl.currentDirectMemoryMapAllocations_.incrementAndGet();
            BaseStateImpl.currentDirectMemoryMapAllocated_.addAndGet(capacityBytes);
            this.myRaf = raf;
            assert (this.myRaf != null);
            this.myFc = this.myRaf.getChannel();
            this.actualNativeBaseOffset = nativeBaseOffset;
            assert (this.actualNativeBaseOffset != 0L);
            this.myCapacity = capacityBytes;
            assert (this.myCapacity != 0L);
        }

        StepBoolean getValid() {
            return this.valid;
        }

        @Override
        public void run() {
            this.deallocate(true);
        }

        boolean deallocate(boolean calledFromCleaner) {
            if (this.valid.change()) {
                if (calledFromCleaner) {
                    LOG.warning("A WritableMapHandleImpl was not closed manually");
                }
                try {
                    this.unmap();
                }
                finally {
                    BaseStateImpl.currentDirectMemoryMapAllocations_.decrementAndGet();
                    BaseStateImpl.currentDirectMemoryMapAllocated_.addAndGet(-this.myCapacity);
                }
                return true;
            }
            return false;
        }

        private void unmap() throws RuntimeException {
            try {
                FILE_CHANNEL_IMPL_UNMAP0_METHOD.invoke((Object)this.myFc, this.actualNativeBaseOffset, this.myCapacity);
                this.myRaf.close();
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Encountered %s exception while freeing memory", e.getClass()));
            }
        }
    }
}

