/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchStatementErrorCodeEnum;
import com.amazonaws.services.dynamodbv2.model.transform.BatchStatementErrorMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BatchStatementError
implements Serializable,
Cloneable,
StructuredPojo {
    private String code;
    private String message;
    private Map<String, AttributeValue> item;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public BatchStatementError withCode(String code) {
        this.setCode(code);
        return this;
    }

    public BatchStatementError withCode(BatchStatementErrorCodeEnum code) {
        this.code = code.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public BatchStatementError withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public BatchStatementError withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public BatchStatementError addItemEntry(String key, AttributeValue value) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.item.put(key, value);
        return this;
    }

    public BatchStatementError clearItemEntries() {
        this.item = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCode() != null) {
            sb.append("Code: ").append(this.getCode()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getItem() != null) {
            sb.append("Item: ").append(this.getItem());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStatementError)) {
            return false;
        }
        BatchStatementError other = (BatchStatementError)obj;
        if (other.getCode() == null ^ this.getCode() == null) {
            return false;
        }
        if (other.getCode() != null && !other.getCode().equals(this.getCode())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        return other.getItem() == null || other.getItem().equals(this.getItem());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCode() == null ? 0 : this.getCode().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : this.getItem().hashCode());
        return hashCode;
    }

    public BatchStatementError clone() {
        try {
            return (BatchStatementError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchStatementErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

