/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.LongHashJoinGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.TwoInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.HashJoinFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.AdaptiveJoinExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecAdaptiveJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.HashJoinOperatorUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="batch-exec-join", version=1, producedTransformations={"join"}, consumedOptions={"table.exec.resource.hash-join.memory", "table.exec.resource.external-buffer-memory", "table.exec.resource.sort.memory", "table.exec.spill-compression.enabled", "table.exec.spill-compression.block-size"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecHashJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData>,
AdaptiveJoinExecNode {
    public static final String JOIN_TRANSFORMATION = "join";
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_IS_BROADCAST = "isBroadcast";
    public static final String FIELD_NAME_LEFT_IS_BUILD = "leftIsBuild";
    public static final String FIELD_NAME_ESTIMATED_LEFT_AVG_ROW_SIZE = "estimatedLeftAvgRowSize";
    public static final String FIELD_NAME_ESTIMATED_RIGHT_AVG_ROW_SIZE = "estimatedRightAvgRowSize";
    public static final String FIELD_NAME_ESTIMATED_LEFT_ROW_COUNT = "estimatedLeftRowCount";
    public static final String FIELD_NAME_ESTIMATED_RIGHT_ROW_COUNT = "estimatedRightRowCount";
    public static final String FIELD_NAME_TRY_DISTINCT_BUILD_ROW = "tryDistinctBuildRow";
    public static final String FIELD_NAME_WITH_JOIN_STRATEGY_HINT = "withJobStrategyHint";
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="isBroadcast")
    private final boolean isBroadcast;
    @JsonProperty(value="leftIsBuild")
    private final boolean leftIsBuild;
    @JsonProperty(value="estimatedLeftAvgRowSize")
    private final int estimatedLeftAvgRowSize;
    @JsonProperty(value="estimatedRightAvgRowSize")
    private final int estimatedRightAvgRowSize;
    @JsonProperty(value="estimatedLeftRowCount")
    private final long estimatedLeftRowCount;
    @JsonProperty(value="estimatedRightRowCount")
    private final long estimatedRightRowCount;
    @JsonProperty(value="withJobStrategyHint")
    private final boolean withJobStrategyHint;
    @JsonProperty(value="tryDistinctBuildRow")
    private final boolean tryDistinctBuildRow;

    public BatchExecHashJoin(ReadableConfig tableConfig, JoinSpec joinSpec, int estimatedLeftAvgRowSize, int estimatedRightAvgRowSize, long estimatedLeftRowCount, long estimatedRightRowCount, boolean isBroadcast, boolean leftIsBuild, boolean tryDistinctBuildRow, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, boolean withJobStrategyHint, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecHashJoin.class), ExecNodeContext.newPersistedConfig(BatchExecHashJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.isBroadcast = isBroadcast;
        this.leftIsBuild = leftIsBuild;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        this.withJobStrategyHint = withJobStrategyHint;
    }

    @JsonCreator
    public BatchExecHashJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="estimatedLeftAvgRowSize") int estimatedLeftAvgRowSize, @JsonProperty(value="estimatedRightAvgRowSize") int estimatedRightAvgRowSize, @JsonProperty(value="estimatedLeftRowCount") long estimatedLeftRowCount, @JsonProperty(value="estimatedRightRowCount") long estimatedRightRowCount, @JsonProperty(value="isBroadcast") boolean isBroadcast, @JsonProperty(value="leftIsBuild") boolean leftIsBuild, @JsonProperty(value="tryDistinctBuildRow") boolean tryDistinctBuildRow, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="withJobStrategyHint") boolean withJobStrategyHint) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.isBroadcast = isBroadcast;
        this.leftIsBuild = leftIsBuild;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        this.withJobStrategyHint = withJobStrategyHint;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<?> probeTransform;
        Transformation<?> buildTransform;
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        long managedMemory = JoinUtil.getManagedMemory(this.joinSpec.getJoinType(), config);
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.joinSpec.getNonEquiCondition().orElse(null), (LogicalType)leftType, (LogicalType)rightType);
        StreamOperatorFactory<RowData> operator = HashJoinOperatorUtil.generateOperatorFactory(this.joinSpec.getLeftKeys(), this.joinSpec.getRightKeys(), this.joinSpec.getJoinType(), this.joinSpec.getFilterNulls(), leftType, rightType, condFunc, this.leftIsBuild, this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, this.tryDistinctBuildRow, managedMemory, config, planner.getFlinkContext().getClassLoader());
        if (this.leftIsBuild) {
            buildTransform = leftInputTransform;
            probeTransform = rightInputTransform;
        } else {
            buildTransform = rightInputTransform;
            probeTransform = leftInputTransform;
        }
        return ExecNodeUtil.createTwoInputTransformation(buildTransform, probeTransform, this.createTransformationMeta(JOIN_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), probeTransform.getParallelism(), managedMemory, false);
    }

    @Override
    public boolean supportFusionCodegen() {
        RowType leftType = (RowType)this.getInputEdges().get(0).getOutputType();
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(this.joinSpec.getLeftKeys()).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        HashJoinType hashJoinType = HashJoinType.of((boolean)this.leftIsBuild, (boolean)joinType.isLeftOuter(), (boolean)joinType.isRightOuter(), (joinType == FlinkJoinType.SEMI ? 1 : 0) != 0, (joinType == FlinkJoinType.ANTI ? 1 : 0) != 0);
        return LongHashJoinGenerator.support(hashJoinType, keyType, this.joinSpec.getFilterNulls());
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator leftInput = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        OpFusionCodegenSpecGenerator rightInput = this.getInputEdges().get(1).translateToFusionCodegenSpec(planner, parentCtx);
        boolean compressionEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED);
        int compressionBlockSize = (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes();
        long managedMemory = JoinUtil.getManagedMemory(this.joinSpec.getJoinType(), config);
        TwoInputOpFusionCodegenSpecGenerator hashJoinGenerator = new TwoInputOpFusionCodegenSpecGenerator(leftInput, rightInput, managedMemory, (RowType)this.getOutputType(), new HashJoinFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx), this.isBroadcast, this.leftIsBuild, this.joinSpec, this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, compressionEnabled, compressionBlockSize));
        leftInput.addOutput(1, hashJoinGenerator);
        rightInput.addOutput(2, hashJoinGenerator);
        return hashJoinGenerator;
    }

    @Override
    public boolean canBeTransformedToAdaptiveJoin() {
        return !this.withJobStrategyHint && this.joinSpec.getJoinType() != FlinkJoinType.FULL;
    }

    @Override
    public BatchExecAdaptiveJoin toAdaptiveJoinNode() {
        return new BatchExecAdaptiveJoin(this.getPersistedConfig(), this.joinSpec, this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, this.leftIsBuild, this.tryDistinctBuildRow, this.getInputProperties(), (RowType)this.getOutputType(), this.getDescription(), OperatorType.ShuffleHashJoin);
    }
}

