/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.util.Optional;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AsyncCorrelateCodeGenerator {
    public static GeneratedFunction<AsyncFunction<RowData, Object>> generateFunction(String name, RowType inputType, RowType returnType, RexCall invocation, ReadableConfig tableConfig, ClassLoader classLoader) {
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        String processCode = AsyncCorrelateCodeGenerator.generateProcessCode(ctx, inputType, invocation, CodeGenUtils.DEFAULT_INPUT1_TERM());
        return FunctionCodeGenerator.generateFunction(ctx, name, AsyncCorrelateCodeGenerator.getFunctionClass(), processCode, (LogicalType)returnType, (LogicalType)inputType, CodeGenUtils.DEFAULT_INPUT1_TERM(), JavaScalaConversionUtil.toScala(Optional.empty()), JavaScalaConversionUtil.toScala(Optional.empty()), CodeGenUtils.DEFAULT_COLLECTOR_TERM(), CodeGenUtils.DEFAULT_CONTEXT_TERM());
    }

    private static Class<AsyncFunction<RowData, Object>> getFunctionClass() {
        return AsyncFunction.class;
    }

    private static String generateProcessCode(CodeGeneratorContext ctx, RowType inputType, RexCall invocation, String inputTerm) {
        invocation.accept(new AsyncCorrelateFunctionsValidator());
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inputType, inputTerm, JavaScalaConversionUtil.toScala(Optional.empty()));
        GeneratedExpression invocationExprs = exprGenerator.generateExpression(invocation);
        return invocationExprs.code();
    }

    private static class AsyncCorrelateFunctionsValidator
    extends RexVisitorImpl<Void> {
        public AsyncCorrelateFunctionsValidator() {
            super(true);
        }

        @Override
        public Void visitCall(RexCall call) {
            super.visitCall(call);
            if (call.getOperator() instanceof BridgingSqlFunction && ((BridgingSqlFunction)call.getOperator()).getDefinition().getKind() != FunctionKind.ASYNC_TABLE) {
                throw new CodeGenException("Invalid use of function " + String.valueOf(call.getOperator()) + ".Code generation should only be done with async table calls");
            }
            return null;
        }
    }
}

