/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlToRexConverter;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class RexFactory {
    private final FlinkTypeFactory typeFactory;
    private final Supplier<FlinkPlannerImpl> plannerSupplier;
    private final Supplier<SqlDialect> sqlDialectSupplier;
    private final Function<FlinkPlannerImpl, FlinkRelBuilder> relBuilderSupplier;

    public RexFactory(FlinkTypeFactory typeFactory, Supplier<FlinkPlannerImpl> plannerSupplier, Supplier<SqlDialect> sqlDialectSupplier, Function<FlinkPlannerImpl, FlinkRelBuilder> relBuilderSupplier) {
        this.typeFactory = typeFactory;
        this.plannerSupplier = plannerSupplier;
        this.sqlDialectSupplier = sqlDialectSupplier;
        this.relBuilderSupplier = relBuilderSupplier;
    }

    public SqlToRexConverter createSqlToRexConverter(RelDataType inputRowType, @Nullable RelDataType outputType) {
        return new SqlToRexConverter(this.plannerSupplier.get(), this.sqlDialectSupplier.get(), inputRowType, outputType);
    }

    public SqlToRexConverter createSqlToRexConverter(RowType inputRowType, @Nullable LogicalType outputType) {
        RelDataType convertedInputRowType = this.typeFactory.buildRelNodeRowType(inputRowType);
        RelDataType convertedOutputType = outputType != null ? this.typeFactory.createFieldTypeFromLogicalType(outputType) : null;
        return this.createSqlToRexConverter(convertedInputRowType, convertedOutputType);
    }

    public RexNode convertExpressionToRex(List<RowType.RowField> args, Expression expression, @Nullable LogicalType outputType) {
        FlinkPlannerImpl planner = this.plannerSupplier.get();
        FlinkRelBuilder relBuilder = this.relBuilderSupplier.apply(planner);
        FlinkContext context = ShortcutUtils.unwrapContext(relBuilder);
        Parser parser = this.createParser(context, planner);
        RelDataType argRowType = this.typeFactory.buildRelNodeRowType(new RowType(args));
        ExpressionResolver.ExpressionResolverBuilder resolverBuilder = this.createExpressionResolverBuilder(context, parser);
        if (outputType != null) {
            resolverBuilder.withOutputDataType(DataTypes.of((LogicalType)outputType));
        } else {
            resolverBuilder.withOutputDataType(null);
        }
        LocalReferenceExpression[] localRefs = (LocalReferenceExpression[])args.stream().map(a -> ApiExpressionUtils.localRef((String)a.getName(), (DataType)DataTypes.of((LogicalType)a.getType()))).toArray(LocalReferenceExpression[]::new);
        ExpressionResolver resolver = resolverBuilder.withLocalReferences(localRefs).build();
        ResolvedExpression resolvedExpression = (ResolvedExpression)resolver.resolve(Collections.singletonList(expression)).get(0);
        relBuilder.values(argRowType);
        return (RexNode)resolvedExpression.accept((ExpressionVisitor)new ExpressionConverter(relBuilder));
    }

    private ExpressionResolver.ExpressionResolverBuilder createExpressionResolverBuilder(FlinkContext context, Parser parser) {
        return ExpressionResolver.resolverFor((TableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), name -> Optional.empty(), (FunctionLookup)context.getFunctionCatalog().asLookup(arg_0 -> ((Parser)parser).parseIdentifier(arg_0)), (DataTypeFactory)context.getCatalogManager().getDataTypeFactory(), (arg_0, arg_1, arg_2) -> ((Parser)parser).parseSqlExpression(arg_0, arg_1, arg_2), (QueryOperation[])new QueryOperation[0]);
    }

    private Parser createParser(FlinkContext context, FlinkPlannerImpl planner) {
        return new ParserImpl(context.getCatalogManager(), () -> planner, planner::parser, this);
    }
}

