/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rules.ImmutableCorrelateLeftEmptyRuleConfig;
import org.apache.calcite.rel.rules.ImmutableCorrelateRightEmptyRuleConfig;
import org.apache.calcite.rel.rules.ImmutableIntersectEmptyPruneRuleConfig;
import org.apache.calcite.rel.rules.ImmutableJoinLeftEmptyRuleConfig;
import org.apache.calcite.rel.rules.ImmutableJoinRightEmptyRuleConfig;
import org.apache.calcite.rel.rules.ImmutableMinusEmptyPruneRuleConfig;
import org.apache.calcite.rel.rules.ImmutableRemoveEmptySingleRuleConfig;
import org.apache.calcite.rel.rules.ImmutableSortFetchZeroRuleConfig;
import org.apache.calcite.rel.rules.ImmutableUnionEmptyPruneRuleConfig;
import org.apache.calcite.rel.rules.ImmutableZeroMaxRowsRuleConfig;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.immutables.value.Value;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = UnionEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule MINUS_INSTANCE = MinusEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule INTERSECT_INSTANCE = IntersectEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule EMPTY_TABLE_INSTANCE = ImmutableZeroMaxRowsRuleConfig.DEFAULT.toRule();
    public static final RelOptRule PROJECT_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.PROJECT.toRule();
    public static final RelOptRule FILTER_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.FILTER.toRule();
    public static final RelOptRule SORT_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.SORT.toRule();
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = SortFetchZeroRuleConfig.DEFAULT.toRule();
    public static final RelOptRule AGGREGATE_INSTANCE = RemoveEmptySingleRule.RemoveEmptySingleRuleConfig.AGGREGATE.toRule();
    public static final RelOptRule JOIN_LEFT_INSTANCE = JoinLeftEmptyRuleConfig.DEFAULT.toRule();
    public static final RelOptRule JOIN_RIGHT_INSTANCE = JoinRightEmptyRuleConfig.DEFAULT.toRule();
    public static final RelOptRule CORRELATE_RIGHT_INSTANCE = CorrelateRightEmptyRuleConfig.DEFAULT.toRule();
    public static final RelOptRule CORRELATE_LEFT_INSTANCE = CorrelateLeftEmptyRuleConfig.DEFAULT.toRule();

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return PruneEmptyRules.isEmpty(node.stripped());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!PruneEmptyRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    private static RelNode padWithNulls(RelBuilder builder, RelNode input, RelDataType resultType, boolean leftPadding) {
        int padding = resultType.getFieldCount() - input.getRowType().getFieldCount();
        List<RexLiteral> nullLiterals = Collections.nCopies(padding, builder.literal(null));
        builder.push(input);
        if (leftPadding) {
            builder.project(Iterables.concat(nullLiterals, builder.fields()));
        } else {
            builder.project(Iterables.concat(builder.fields(), nullLiterals));
        }
        return builder.convert(resultType, true).build();
    }

    @Value.Immutable
    public static interface ZeroMaxRowsRuleConfig
    extends PruneEmptyRule.Config {
        public static final ZeroMaxRowsRuleConfig DEFAULT = ImmutableZeroMaxRowsRuleConfig.of().withOperandSupplier(b0 -> b0.operand(TableScan.class).noInputs()).withDescription("PruneZeroRowsTable");

        @Override
        default public PruneEmptyRule toRule() {
            return new RemoveEmptySingleRule(this){

                @Override
                public boolean matches(RelOptRuleCall call) {
                    Object node = call.rel(0);
                    Double maxRowCount = call.getMetadataQuery().getMaxRowCount((RelNode)node);
                    return maxRowCount != null && maxRowCount == 0.0;
                }
            };
        }
    }

    @Value.Immutable
    public static interface CorrelateRightEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final CorrelateRightEmptyRuleConfig DEFAULT = ImmutableCorrelateRightEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Correlate.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("PruneEmptyCorrelate(right)");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Object newRel;
                    Correlate corr = (Correlate)call.rel(0);
                    Object left = call.rel(1);
                    RelBuilder b = call.builder();
                    switch (corr.getJoinType()) {
                        case LEFT: {
                            newRel = PruneEmptyRules.padWithNulls(b, left, corr.getRowType(), false);
                            break;
                        }
                        case INNER: 
                        case SEMI: {
                            newRel = b.push(corr).empty().build();
                            break;
                        }
                        case ANTI: {
                            newRel = left;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Correlate does not support " + (Object)((Object)corr.getJoinType()));
                        }
                    }
                    call.transformTo((RelNode)newRel);
                }
            };
        }
    }

    @Value.Immutable
    public static interface CorrelateLeftEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final CorrelateLeftEmptyRuleConfig DEFAULT = ImmutableCorrelateLeftEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Correlate.class).inputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).withDescription("PruneEmptyCorrelate(left)");

        @Override
        default public PruneEmptyRule toRule() {
            return new RemoveEmptySingleRule(this);
        }
    }

    @Value.Immutable
    public static interface JoinRightEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final JoinRightEmptyRuleConfig DEFAULT = ImmutableJoinRightEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("PruneEmptyJoin(right)");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    Object left = call.rel(1);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnRight()) {
                        call.transformTo(PruneEmptyRules.padWithNulls(relBuilder, left, join.getRowType(), false));
                        return;
                    }
                    if (join.getJoinType() == JoinRelType.ANTI) {
                        call.transformTo(join.getLeft());
                        return;
                    }
                    call.transformTo(relBuilder.push(join).empty().build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface JoinLeftEmptyRuleConfig
    extends PruneEmptyRule.Config {
        public static final JoinLeftEmptyRuleConfig DEFAULT = ImmutableJoinLeftEmptyRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).withDescription("PruneEmptyJoin(left)");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    Object right = call.rel(2);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnLeft()) {
                        call.transformTo(PruneEmptyRules.padWithNulls(relBuilder, right, join.getRowType(), true));
                        return;
                    }
                    call.transformTo(relBuilder.push(join).empty().build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface SortFetchZeroRuleConfig
    extends PruneEmptyRule.Config {
        public static final SortFetchZeroRuleConfig DEFAULT = ImmutableSortFetchZeroRuleConfig.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs()).withDescription("PruneSortLimit0");

        @Override
        default public PruneEmptyRule toRule() {
            return new RemoveEmptySingleRule(this){

                @Override
                public boolean matches(RelOptRuleCall call) {
                    Sort sort = (Sort)call.rel(0);
                    return sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue(sort.fetch) == 0;
                }
            };
        }
    }

    @Value.Immutable
    public static interface IntersectEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final IntersectEmptyPruneRuleConfig DEFAULT = ImmutableIntersectEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Intersect.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Intersect");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Intersect intersect = (Intersect)call.rel(0);
                    RelBuilder relBuilder = call.builder();
                    relBuilder.push(intersect).empty();
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface MinusEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final MinusEmptyPruneRuleConfig DEFAULT = ImmutableMinusEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Minus.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Minus");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Minus minus = (Minus)call.rel(0);
                    List<RelNode> inputs = minus.getInputs();
                    assert (inputs != null);
                    int nonEmptyInputs = 0;
                    RelBuilder relBuilder = call.builder();
                    for (RelNode input : inputs) {
                        if (!PruneEmptyRules.isEmpty(input)) {
                            relBuilder.push(input);
                            ++nonEmptyInputs;
                            continue;
                        }
                        if (nonEmptyInputs != 0) continue;
                        break;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(minus);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(minus).empty();
                    } else {
                        relBuilder.minus(minus.all, nonEmptyInputs);
                        relBuilder.convert(minus.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface UnionEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        public static final UnionEmptyPruneRuleConfig DEFAULT = ImmutableUnionEmptyPruneRuleConfig.of().withOperandSupplier(b0 -> b0.operand(Union.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Union");

        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Union union = (Union)call.rel(0);
                    List<RelNode> inputs = union.getInputs();
                    assert (inputs != null);
                    RelBuilder relBuilder = call.builder();
                    int nonEmptyInputs = 0;
                    for (RelNode input : inputs) {
                        if (PruneEmptyRules.isEmpty(input)) continue;
                        relBuilder.push(input);
                        ++nonEmptyInputs;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(union);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(union).empty();
                    } else {
                        relBuilder.union(union.all, nonEmptyInputs);
                        relBuilder.convert(union.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    public static class RemoveEmptySingleRule
    extends PruneEmptyRule {
        RemoveEmptySingleRule(PruneEmptyRule.Config config) {
            super(config);
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, singleRel -> true));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withRelBuilderFactory(relBuilderFactory).withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, predicate));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, org.apache.flink.calcite.shaded.com.google.common.base.Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(ImmutableRemoveEmptySingleRuleConfig.of().withRelBuilderFactory(relBuilderFactory).withDescription(description).as(ImmutableRemoveEmptySingleRuleConfig.class).withOperandFor(clazz, predicate::apply));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Object singleRel = call.rel(0);
            RelNode emptyValues = call.builder().push((RelNode)singleRel).empty().build();
            RelTraitSet traits = singleRel.getTraitSet();
            if (emptyValues.getConvention() != null) {
                traits = traits.replace(emptyValues.getConvention());
            }
            emptyValues = emptyValues.copy(traits, Collections.emptyList());
            call.transformTo(emptyValues);
        }

        @Value.Immutable
        public static interface RemoveEmptySingleRuleConfig
        extends PruneEmptyRule.Config {
            public static final RemoveEmptySingleRuleConfig PROJECT = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyProject").withOperandFor(Project.class, project -> true);
            public static final RemoveEmptySingleRuleConfig FILTER = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyFilter").withOperandFor(Filter.class, singleRel -> true);
            public static final RemoveEmptySingleRuleConfig SORT = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptySort").withOperandFor(Sort.class, singleRel -> true);
            public static final RemoveEmptySingleRuleConfig AGGREGATE = ImmutableRemoveEmptySingleRuleConfig.of().withDescription("PruneEmptyAggregate").withOperandFor(Aggregate.class, Aggregate::isNotGrandTotal);

            @Override
            default public RemoveEmptySingleRule toRule() {
                return new RemoveEmptySingleRule(this);
            }

            default public <R extends RelNode> RemoveEmptySingleRuleConfig withOperandFor(Class<R> relClass, Predicate<R> predicate) {
                return this.withOperandSupplier(b0 -> b0.operand(relClass).predicate(predicate).oneInput(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).as(RemoveEmptySingleRuleConfig.class);
            }
        }
    }

    protected static abstract class PruneEmptyRule
    extends RelRule<Config>
    implements SubstitutionRule {
        protected PruneEmptyRule(Config config) {
            super(config);
        }

        @Override
        public boolean autoPruneOld() {
            return true;
        }

        public static interface Config
        extends RelRule.Config {
            @Override
            public PruneEmptyRule toRule();
        }
    }
}

