/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli.parser;

import org.jline.utils.AttributedStyle;

public class SyntaxHighlightStyle {
    private final AttributedStyle commentStyle;
    private final AttributedStyle hintStyle;
    private final AttributedStyle defaultStyle;
    private final AttributedStyle keywordStyle;
    private final AttributedStyle singleQuotedStyle;
    private final AttributedStyle sqlIdentifierStyle;
    static final AttributedStyle GREEN = AttributedStyle.DEFAULT.foreground(2);
    static final AttributedStyle CYAN = AttributedStyle.DEFAULT.foreground(6);
    static final AttributedStyle WHITE = AttributedStyle.DEFAULT.foreground(7);
    static final AttributedStyle BLACK = AttributedStyle.DEFAULT.foreground(0);
    static final AttributedStyle MAGENTA = AttributedStyle.DEFAULT.foreground(5);
    static final AttributedStyle RED = AttributedStyle.DEFAULT.foreground(1);
    static final AttributedStyle BLUE = AttributedStyle.DEFAULT.foreground(4);
    static final AttributedStyle BOLD_GREEN = AttributedStyle.BOLD.foreground(2);
    static final AttributedStyle BOLD_CYAN = AttributedStyle.BOLD.foreground(6);
    static final AttributedStyle BOLD_BRIGHT = AttributedStyle.BOLD.foreground(8);
    static final AttributedStyle BOLD_YELLOW = AttributedStyle.BOLD.foreground(3);
    static final AttributedStyle BOLD_MAGENTA = AttributedStyle.BOLD.foreground(5);
    static final AttributedStyle BOLD_RED = AttributedStyle.BOLD.foreground(1);
    static final AttributedStyle BOLD_BLUE = AttributedStyle.BOLD.foreground(4);
    static final AttributedStyle ITALIC_GREEN = AttributedStyle.DEFAULT.italic().foreground(2);
    static final AttributedStyle ITALIC_CYAN = AttributedStyle.DEFAULT.italic().foreground(6);
    static final AttributedStyle ITALIC_BRIGHT = AttributedStyle.DEFAULT.italic().foreground(8);

    public SyntaxHighlightStyle(AttributedStyle commentStyle, AttributedStyle hintStyle, AttributedStyle defaultStyle, AttributedStyle keywordStyle, AttributedStyle singleQuotedStyle, AttributedStyle sqlIdentifierStyle) {
        this.commentStyle = commentStyle;
        this.hintStyle = hintStyle;
        this.defaultStyle = defaultStyle;
        this.keywordStyle = keywordStyle;
        this.singleQuotedStyle = singleQuotedStyle;
        this.sqlIdentifierStyle = sqlIdentifierStyle;
    }

    public AttributedStyle getKeywordStyle() {
        return this.keywordStyle;
    }

    public AttributedStyle getQuotedStyle() {
        return this.singleQuotedStyle;
    }

    public AttributedStyle getSqlIdentifierStyle() {
        return this.sqlIdentifierStyle;
    }

    public AttributedStyle getCommentStyle() {
        return this.commentStyle;
    }

    public AttributedStyle getHintStyle() {
        return this.hintStyle;
    }

    public AttributedStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public static enum BuiltInStyle {
        DEFAULT(AttributedStyle.DEFAULT, AttributedStyle.DEFAULT, AttributedStyle.DEFAULT, AttributedStyle.DEFAULT, AttributedStyle.DEFAULT, AttributedStyle.DEFAULT),
        DARK(BOLD_BLUE, WHITE, ITALIC_BRIGHT, BOLD_BRIGHT, GREEN, CYAN),
        LIGHT(BOLD_RED, BLACK, ITALIC_BRIGHT, BOLD_BRIGHT, GREEN, CYAN),
        CHESTER(BOLD_BLUE, WHITE, ITALIC_GREEN, BOLD_GREEN, RED, CYAN),
        DRACULA(BOLD_MAGENTA, WHITE, ITALIC_CYAN, BOLD_CYAN, GREEN, RED),
        SOLARIZED(BOLD_YELLOW, BLUE, ITALIC_BRIGHT, BOLD_BRIGHT, GREEN, RED),
        VS2010(BOLD_BLUE, WHITE, ITALIC_GREEN, BOLD_GREEN, RED, MAGENTA),
        OBSIDIAN(BOLD_GREEN, WHITE, ITALIC_BRIGHT, BOLD_BRIGHT, RED, MAGENTA),
        GESHI(AttributedStyle.BOLD.foreground(153, 51, 51), WHITE, AttributedStyle.DEFAULT.italic().foreground(128, 128, 128), AttributedStyle.DEFAULT.bold().foreground(128, 128, 128), AttributedStyle.DEFAULT.foreground(102, 204, 102), AttributedStyle.DEFAULT.foreground(0, 0, 153));

        private final SyntaxHighlightStyle style;

        private BuiltInStyle(AttributedStyle keywordStyle, AttributedStyle defaultStyle, AttributedStyle commentStyle, AttributedStyle hintStyle, AttributedStyle singleQuotedStyle, AttributedStyle sqlIdentifierStyle) {
            this.style = new SyntaxHighlightStyle(commentStyle, hintStyle, defaultStyle, keywordStyle, singleQuotedStyle, sqlIdentifierStyle);
        }

        public SyntaxHighlightStyle getHighlightStyle() {
            return this.style;
        }

        public static BuiltInStyle fromString(String styleName) {
            for (BuiltInStyle style : BuiltInStyle.values()) {
                if (!style.name().equalsIgnoreCase(styleName)) continue;
                return style;
            }
            return DEFAULT;
        }
    }
}

