/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public class FlinkAggregateProjectMergeRule
extends AggregateProjectMergeRule {
    public static final RelOptRule INSTANCE = new FlinkAggregateProjectMergeRule(AggregateProjectMergeRule.Config.DEFAULT);

    protected FlinkAggregateProjectMergeRule(AggregateProjectMergeRule.Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = FlinkAggregateProjectMergeRule.newApply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static @Nullable RelNode newApply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        Aggregate newAggregate;
        Object newWindow;
        LogicalWindowAggregate winAgg;
        Set<Integer> interestingFields = RelOptUtil.getAllFields(aggregate);
        boolean isProctimeWindowAgg = false;
        if (aggregate instanceof LogicalWindowAggregate && !(isProctimeWindowAgg = LogicalTypeChecks.isProctimeAttribute((LogicalType)(winAgg = (LogicalWindowAggregate)aggregate).getWindow().timeAttribute().getOutputDataType().getLogicalType()))) {
            interestingFields.add(((LogicalWindowAggregate)aggregate).getWindow().timeAttribute().getFieldIndex());
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int source : interestingFields) {
            RexNode rex = project.getProjects().get(source);
            if (!(rex instanceof RexInputRef)) {
                return null;
            }
            map.put(source, ((RexInputRef)rex).getIndex());
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        int sourceCount = aggregate.getInput().getRowType().getFieldCount();
        int targetCount = project.getInput().getRowType().getFieldCount();
        Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, targetCount);
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            aggCalls.add(aggregateCall.transform(targetMapping));
        }
        if (aggregate instanceof LogicalWindowAggregate && !isProctimeWindowAgg) {
            LogicalWindowAggregate winAgg2 = (LogicalWindowAggregate)aggregate;
            LogicalWindow window = winAgg2.getWindow();
            int newTimeIndex = (Integer)map.get(window.timeAttribute().getFieldIndex());
            newWindow = window.copy(new FieldReferenceExpression(window.timeAttribute().getName(), window.timeAttribute().getOutputDataType(), window.timeAttribute().getInputIndex(), newTimeIndex));
            newAggregate = winAgg2.copy(aggregate.getTraitSet(), project.getInput(), newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()), (LogicalWindow)newWindow);
        } else {
            newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()));
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newAggregate);
        List<Integer> newKeys = Util.transform(aggregate.getGroupSet().asList(), key -> Objects.requireNonNull((Integer)map.get(key), () -> "no value found for key " + key + " in " + map));
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = new ArrayList<Integer>();
            newWindow = newKeys.iterator();
            while (newWindow.hasNext()) {
                int newKey = (Integer)newWindow.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            for (int i = newAggregate.getGroupCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project(relBuilder.fields((List<? extends Number>)posList));
        }
        return relBuilder.build();
    }
}

