/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.files.SuccessData;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitOperations
extends AbstractStoreOperation
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(CommitOperations.class);
    private final S3AFileSystem fs;
    private final CommitterStatistics statistics;
    private final WriteOperations writeOperations;
    public static final PathFilter PENDINGSET_FILTER = path -> path.toString().endsWith(".pendingset");
    public static final PathFilter PENDING_FILTER = path -> path.toString().endsWith(".pending");

    public CommitOperations(S3AFileSystem fs) throws IOException {
        this(Objects.requireNonNull(fs), fs.newCommitterStatistics());
    }

    public CommitOperations(S3AFileSystem fs, CommitterStatistics committerStatistics) throws IOException {
        super(Objects.requireNonNull(fs).createStoreContext());
        this.fs = fs;
        this.statistics = Objects.requireNonNull(committerStatistics);
        this.writeOperations = fs.createWriteOperationHelper((AuditSpan)fs.getAuditSpanSource().createSpan(Statistic.COMMITTER_COMMIT_JOB.getSymbol(), "/", null));
    }

    public static List<PartETag> toPartEtags(List<String> tagIds) {
        return IntStream.range(0, tagIds.size()).mapToObj(i -> new PartETag(i + 1, (String)tagIds.get(i))).collect(Collectors.toList());
    }

    public String toString() {
        return "CommitOperations{" + this.fs.getUri() + '}';
    }

    protected CommitterStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.statistics.getIOStatistics();
    }

    private void commitOrFail(SinglePendingCommit commit, BulkOperationState operationState) throws IOException {
        this.commit(commit, commit.getFilename(), operationState).maybeRethrow();
    }

    private MaybeIOE commit(SinglePendingCommit commit, String origin, BulkOperationState operationState) {
        MaybeIOE outcome;
        LOG.debug("Committing single commit {}", (Object)commit);
        String destKey = "unknown destination";
        try (DurationInfo d = new DurationInfo(LOG, "Committing file %s size %s", commit.getDestinationKey(), commit.getLength());){
            commit.validate();
            destKey = commit.getDestinationKey();
            long l = IOStatisticsBinding.trackDuration(this.statistics, Statistic.COMMITTER_MATERIALIZE_FILE.getSymbol(), () -> this.innerCommit(commit, operationState));
            LOG.debug("Successful commit of file length {}", (Object)l);
            outcome = MaybeIOE.NONE;
            this.statistics.commitCompleted(commit.getLength());
        }
        catch (IOException e) {
            String msg = String.format("Failed to commit upload against %s: %s", destKey, e);
            LOG.warn(msg, (Throwable)e);
            outcome = new MaybeIOE(e);
            this.statistics.commitFailed();
        }
        catch (Exception e) {
            String msg = String.format("Failed to commit upload against %s, described in %s: %s", destKey, origin, e);
            LOG.warn(msg, (Throwable)e);
            outcome = new MaybeIOE(new PathCommitException(origin, msg, e));
            this.statistics.commitFailed();
        }
        return outcome;
    }

    private long innerCommit(SinglePendingCommit commit, BulkOperationState operationState) throws IOException {
        this.writeOperations.commitUpload(commit.getDestinationKey(), commit.getUploadId(), CommitOperations.toPartEtags(commit.getEtags()), commit.getLength(), operationState);
        return commit.getLength();
    }

    public List<LocatedFileStatus> locateAllSinglePendingCommits(Path pendingDir, boolean recursive) throws IOException {
        return S3AUtils.listAndFilter(this.fs, pendingDir, recursive, PENDING_FILTER);
    }

    public Pair<PendingSet, List<Pair<LocatedFileStatus, IOException>>> loadSinglePendingCommits(Path pendingDir, boolean recursive) throws IOException {
        List<LocatedFileStatus> statusList = this.locateAllSinglePendingCommits(pendingDir, recursive);
        PendingSet commits = new PendingSet(statusList.size());
        ArrayList<Pair<LocatedFileStatus, IOException>> failures = new ArrayList<Pair<LocatedFileStatus, IOException>>(1);
        for (LocatedFileStatus status : statusList) {
            try {
                commits.add(SinglePendingCommit.load(this.fs, status.getPath()));
            }
            catch (IOException e) {
                LOG.warn("Failed to load commit file {}", (Object)status.getPath(), (Object)e);
                failures.add(Pair.of(status, e));
            }
        }
        return Pair.of(commits, failures);
    }

    public IOException makeIOE(String key, Exception ex) {
        return ex instanceof IOException ? (IOException)ex : new PathCommitException(key, ex.toString(), ex);
    }

    private void abortSingleCommit(SinglePendingCommit commit) throws IOException {
        String destKey = commit.getDestinationKey();
        String origin = commit.getFilename() != null ? " defined in " + commit.getFilename() : "";
        String uploadId = commit.getUploadId();
        LOG.info("Aborting commit ID {} to object {}{}", new Object[]{uploadId, destKey, origin});
        this.abortMultipartCommit(destKey, uploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Aborting commit ID %s to path %s", uploadId, destKey);){
            this.writeOperations.abortMultipartCommit(destKey, uploadId);
        }
        finally {
            this.statistics.commitAborted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaybeIOE abortAllSinglePendingCommits(Path pendingDir, boolean recursive) throws IOException {
        RemoteIterator<LocatedFileStatus> pendingFiles;
        Preconditions.checkArgument(pendingDir != null, "null pendingDir");
        LOG.debug("Aborting all pending commit filess under {} (recursive={}", (Object)pendingDir, (Object)recursive);
        try {
            pendingFiles = this.ls(pendingDir, recursive);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info("No directory to abort {}", (Object)pendingDir);
            return MaybeIOE.NONE;
        }
        MaybeIOE outcome = MaybeIOE.NONE;
        if (!pendingFiles.hasNext()) {
            LOG.debug("No files to abort under {}", (Object)pendingDir);
        }
        while (pendingFiles.hasNext()) {
            Path pendingFile = pendingFiles.next().getPath();
            if (!pendingFile.getName().endsWith(".pending")) continue;
            try {
                this.abortSingleCommit(SinglePendingCommit.load(this.fs, pendingFile));
            }
            catch (FileNotFoundException e) {
                LOG.debug("listed file already deleted: {}", (Object)pendingFile);
            }
            catch (IOException | IllegalArgumentException e) {
                if (!MaybeIOE.NONE.equals(outcome)) continue;
                outcome = new MaybeIOE(this.makeIOE(pendingFile.toString(), e));
            }
            finally {
                S3AUtils.deleteQuietly(this.fs, pendingFile, false);
            }
        }
        RemoteIterators.cleanupRemoteIterator(pendingFiles);
        return outcome;
    }

    protected RemoteIterator<LocatedFileStatus> ls(Path path, boolean recursive) throws IOException {
        return this.fs.listFiles(path, recursive);
    }

    public List<MultipartUpload> listPendingUploadsUnderPath(Path dest) throws IOException {
        return this.writeOperations.listMultipartUploads(this.fs.pathToKey(dest));
    }

    public int abortPendingUploadsUnderPath(Path dest) throws IOException {
        return this.writeOperations.abortMultipartUploadsUnderPath(this.fs.pathToKey(dest));
    }

    public void deleteSuccessMarker(Path outputPath) throws IOException {
        this.fs.delete(new Path(outputPath, "_SUCCESS"), false);
    }

    public void createSuccessMarker(Path outputPath, SuccessData successData, boolean addMetrics) throws IOException {
        Preconditions.checkArgument(outputPath != null, "null outputPath");
        if (addMetrics) {
            this.addFileSystemStatistics(successData.getMetrics());
        }
        Configuration conf = this.fs.getConf();
        successData.addDiagnostic("fs.s3a.metadatastore.impl", conf.getTrimmed("fs.s3a.metadatastore.impl", ""));
        successData.addDiagnostic("fs.s3a.metadatastore.authoritative", conf.getTrimmed("fs.s3a.metadatastore.authoritative", "false"));
        successData.addDiagnostic("fs.s3a.authoritative.path", conf.getTrimmed("fs.s3a.authoritative.path", ""));
        Path markerPath = new Path(outputPath, "_SUCCESS");
        LOG.debug("Touching success marker for job {}: {}", (Object)markerPath, (Object)successData);
        try (DurationInfo ignored = new DurationInfo(LOG, "Writing success file %s", markerPath);){
            successData.save(this.fs, markerPath, true);
        }
    }

    public void revertCommit(SinglePendingCommit commit, BulkOperationState operationState) throws IOException {
        LOG.info("Revert {}", (Object)commit);
        try {
            this.writeOperations.revertCommit(commit.getDestinationKey(), operationState);
        }
        finally {
            this.statistics.commitReverted();
        }
    }

    /*
     * Loose catch block
     */
    public SinglePendingCommit uploadFileToPendingCommit(File localFile, Path destPath, String partition, long uploadPartSize, Progressable progress) throws IOException {
        SinglePendingCommit singlePendingCommit;
        Throwable throwable;
        DurationInfo d;
        DurationTracker tracker;
        boolean threw;
        String uploadId;
        String destKey;
        block26: {
            LOG.debug("Initiating multipart upload from {} to {}", (Object)localFile, (Object)destPath);
            Preconditions.checkArgument(destPath != null);
            if (!localFile.isFile()) {
                throw new FileNotFoundException("Not a file: " + localFile);
            }
            String destURI = destPath.toUri().toString();
            destKey = this.fs.pathToKey(destPath);
            uploadId = null;
            threw = true;
            tracker = this.statistics.trackDuration(Statistic.COMMITTER_STAGE_FILE_UPLOAD.getSymbol());
            d = new DurationInfo(LOG, "Upload staged file from %s to %s", localFile.getAbsolutePath(), destPath);
            throwable = null;
            this.statistics.commitCreated();
            uploadId = this.writeOperations.initiateMultiPartUpload(destKey);
            long length = localFile.length();
            SinglePendingCommit commitData = new SinglePendingCommit();
            commitData.setDestinationKey(destKey);
            commitData.setBucket(this.fs.getBucket());
            commitData.touch(System.currentTimeMillis());
            commitData.setUploadId(uploadId);
            commitData.setUri(destURI);
            commitData.setText(partition != null ? "partition: " + partition : "");
            commitData.setLength(length);
            long offset = 0L;
            long numParts = length / uploadPartSize + (long)(length % uploadPartSize > 0L ? 1 : 0);
            if (numParts == 0L) {
                numParts = 1L;
            }
            if (numParts > 10000L) {
                throw new PathIOException(destPath.toString(), String.format("File to upload (size %d) is too big to be uploaded in parts of size %d", numParts, length));
            }
            ArrayList<PartETag> parts = new ArrayList<PartETag>((int)numParts);
            LOG.debug("File size is {}, number of parts to upload = {}", (Object)length, (Object)numParts);
            int partNumber = 1;
            while ((long)partNumber <= numParts) {
                progress.progress();
                long size = Math.min(length - offset, uploadPartSize);
                UploadPartRequest part = this.writeOperations.newUploadPartRequest(destKey, uploadId, partNumber, (int)size, null, localFile, offset);
                part.setLastPart((long)partNumber == numParts);
                UploadPartResult partResult = this.writeOperations.uploadPart(part);
                offset += uploadPartSize;
                parts.add(partResult.getPartETag());
                ++partNumber;
            }
            commitData.bindCommitData(parts);
            this.statistics.commitUploaded(length);
            threw = false;
            singlePendingCommit = commitData;
            if (!threw || uploadId == null) break block26;
            try {
                this.abortMultipartCommit(destKey, uploadId);
            }
            catch (IOException e) {
                LOG.error("Failed to abort upload {} to {}", new Object[]{uploadId, destKey, e});
            }
        }
        if (threw) {
            tracker.failed();
        }
        tracker.close();
        return singlePendingCommit;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (d != null) {
                    if (throwable != null) {
                        try {
                            d.close();
                        }
                        catch (Throwable size) {
                            throwable.addSuppressed(size);
                        }
                    } else {
                        d.close();
                    }
                }
            }
            {
                catch (Throwable throwable3) {
                    if (threw && uploadId != null) {
                        try {
                            this.abortMultipartCommit(destKey, uploadId);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to abort upload {} to {}", new Object[]{uploadId, destKey, e});
                        }
                    }
                    if (threw) {
                        tracker.failed();
                    }
                    tracker.close();
                    throw throwable3;
                }
            }
        }
    }

    public void addFileSystemStatistics(Map<String, Long> dest) {
        dest.putAll(this.fs.getInstrumentation().toMap());
    }

    public void taskCompleted(boolean success) {
        this.statistics.taskCompleted(success);
    }

    public void jobCompleted(boolean success) {
        this.statistics.jobCompleted(success);
    }

    public CommitContext initiateCommitOperation(Path path) throws IOException {
        return new CommitContext(this.writeOperations.initiateCommitOperation(path));
    }

    public static Optional<Long> extractMagicFileLength(FileSystem fs, Path path) throws IOException {
        byte[] bytes;
        try {
            bytes = fs.getXAttr(path, "header.x-hadoop-s3a-magic-data-length");
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("Filesystem {} doesn't support XAttr API", (Object)fs);
            return Optional.empty();
        }
        return HeaderProcessing.extractXAttrLongValue(bytes);
    }

    public static class MaybeIOE {
        private final IOException exception;
        public static final MaybeIOE NONE = new MaybeIOE(null);

        public MaybeIOE(IOException exception) {
            this.exception = exception;
        }

        public IOException getException() {
            return this.exception;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void maybeRethrow() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MaybeIOE{");
            sb.append(this.hasException() ? this.exception : "");
            sb.append('}');
            return sb.toString();
        }

        public static MaybeIOE of(IOException ex) {
            return ex != null ? new MaybeIOE(ex) : NONE;
        }
    }

    public final class CommitContext
    implements Closeable {
        private final BulkOperationState operationState;

        private CommitContext(BulkOperationState operationState) {
            this.operationState = operationState;
        }

        public void commitOrFail(SinglePendingCommit commit) throws IOException {
            CommitOperations.this.commitOrFail(commit, this.operationState);
        }

        public MaybeIOE commit(SinglePendingCommit commit, String origin) {
            return CommitOperations.this.commit(commit, origin, this.operationState);
        }

        public void abortSingleCommit(SinglePendingCommit commit) throws IOException {
            CommitOperations.this.abortSingleCommit(commit);
        }

        public void revertCommit(SinglePendingCommit commit) throws IOException {
            CommitOperations.this.revertCommit(commit, this.operationState);
        }

        public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
            CommitOperations.this.abortMultipartCommit(destKey, uploadId);
        }

        @Override
        public void close() throws IOException {
            IOUtils.cleanupWithLogger(LOG, this.operationState);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CommitContext{");
            sb.append("operationState=").append(this.operationState);
            sb.append('}');
            return sb.toString();
        }
    }
}

