package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.MixTaxonomyMappingData;
import org.apache.fineract.client.models.MixTaxonomyRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MixMappingApi {
    /**
    * 
    * 
    * @return Call&lt;MixTaxonomyMappingData&gt;
    */
    @GET("v1/mixmapping")
    Call<MixTaxonomyMappingData> retrieveTaxonomyMapping();

    /**
    * 
    * 
        * @param mixTaxonomyRequest  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/mixmapping")
    Call<String> updateTaxonomyMapping(@retrofit2.http.Body MixTaxonomyRequest mixTaxonomyRequest);


        /**
        * 
        * 
            * @param mixTaxonomyRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/mixmapping")
    Call<String> updateTaxonomyMapping();

        /**
        * 
        * 
        * @return Call&lt;MixTaxonomyMappingData&gt;
        */
    @GET("v1/mixmapping")
    Call<MixTaxonomyMappingData> retrieveTaxonomyMapping(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param mixTaxonomyRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/mixmapping")
    Call<String> updateTaxonomyMapping(@retrofit2.http.Body MixTaxonomyRequest mixTaxonomyRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param mixTaxonomyRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/mixmapping")
    Call<String> updateTaxonomyMapping(@HeaderMap Map<String, String> headers);
}
