package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.DeleteLoansLoanIdResponse;
import java.io.File;
import org.apache.fineract.client.models.GetDelinquencyActionsResponse;
import org.apache.fineract.client.models.GetDelinquencyTagHistoryResponse;
import org.apache.fineract.client.models.GetLoansApprovalTemplateResponse;
import org.apache.fineract.client.models.GetLoansLoanIdResponse;
import org.apache.fineract.client.models.GetLoansResponse;
import org.apache.fineract.client.models.GetLoansTemplateResponse;
import org.apache.fineract.client.models.LoanApprovedAmountHistoryData;
import org.apache.fineract.client.models.PostLoansDelinquencyActionRequest;
import org.apache.fineract.client.models.PostLoansDelinquencyActionResponse;
import org.apache.fineract.client.models.PostLoansLoanIdRequest;
import org.apache.fineract.client.models.PostLoansLoanIdResponse;
import org.apache.fineract.client.models.PostLoansRequest;
import org.apache.fineract.client.models.PostLoansResponse;
import org.apache.fineract.client.models.PutLoansApprovedAmountRequest;
import org.apache.fineract.client.models.PutLoansApprovedAmountResponse;
import org.apache.fineract.client.models.PutLoansAvailableDisbursementAmountRequest;
import org.apache.fineract.client.models.PutLoansAvailableDisbursementAmountResponse;
import org.apache.fineract.client.models.PutLoansLoanIdRequest;
import org.apache.fineract.client.models.PutLoansLoanIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoansApi {
    /**
    * Calculate loan repayment schedule | Submit a new Loan Application
    * It calculates the loan repayment Schedule Submits a new loan application Mandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType Optional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true) Additional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate Additional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate Additional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables
        * @param postLoansRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans")
    Call<PostLoansResponse> calculateLoanScheduleOrSubmitLoanApplication(@retrofit2.http.Body PostLoansRequest postLoansRequest, @retrofit2.http.Query("command") String command);

    /**
    * Adds a new delinquency action for a loan
    * 
        * @param loanId loanId (required)
        * @param postLoansDelinquencyActionRequest  (required)
    * @return Call&lt;PostLoansDelinquencyActionResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}/delinquency-actions")
    Call<PostLoansDelinquencyActionResponse> createLoanDelinquencyAction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansDelinquencyActionRequest postLoansDelinquencyActionRequest);

    /**
    * Adds a new delinquency action for a loan
    * 
        * @param loanExternalId loanExternalId (required)
        * @param postLoansDelinquencyActionRequest  (required)
    * @return Call&lt;PostLoansDelinquencyActionResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}/delinquency-actions")
    Call<PostLoansDelinquencyActionResponse> createLoanDelinquencyAction1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansDelinquencyActionRequest postLoansDelinquencyActionRequest);

    /**
    * Delete a Loan Application
    * Note: Only loans in \&quot;Submitted and awaiting approval\&quot; status can be deleted.
        * @param loanId loanId (required)
    * @return Call&lt;DeleteLoansLoanIdResponse&gt;
    */
    @DELETE("v1/loans/{loanId}")
    Call<DeleteLoansLoanIdResponse> deleteLoanApplication(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Delete a Loan Application
    * Note: Only loans in \&quot;Submitted and awaiting approval\&quot; status can be deleted.
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;DeleteLoansLoanIdResponse&gt;
    */
    @DELETE("v1/loans/external-id/{loanExternalId}")
    Call<DeleteLoansLoanIdResponse> deleteLoanApplication1(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Retrieve the Loan Delinquency Tag history using the Loan Id
    * 
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;GetDelinquencyTagHistoryResponse&gt;&gt;
    */
    @GET("v1/loans/{loanId}/delinquencytags")
    Call<List<GetDelinquencyTagHistoryResponse>> getDelinquencyTagHistory(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve the Loan Delinquency Tag history using the Loan Id
    * 
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;GetDelinquencyTagHistoryResponse&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/delinquencytags")
    Call<List<GetDelinquencyTagHistoryResponse>> getDelinquencyTagHistory1(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * 
    * 
        * @param glimId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/loans/glimAccount/{glimId}")
    Call<String> getGlimRepaymentTemplate(@retrofit2.http.Path("glimId") Long glimId);

    /**
    * Collects and returns the approved amount modification history for a given loan
    * 
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;LoanApprovedAmountHistoryData&gt;&gt;
    */
    @GET("v1/loans/{loanId}/approved-amount")
    Call<List<LoanApprovedAmountHistoryData>> getLoanApprovedAmountHistory(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Collects and returns the approved amount modification history for a given loan
    * 
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;LoanApprovedAmountHistoryData&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/approved-amount")
    Call<List<LoanApprovedAmountHistoryData>> getLoanApprovedAmountHistory1(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Retrieve delinquency actions related to the loan
    * 
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;GetDelinquencyActionsResponse&gt;&gt;
    */
    @GET("v1/loans/{loanId}/delinquency-actions")
    Call<List<GetDelinquencyActionsResponse>> getLoanDelinquencyActions(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve delinquency actions related to the loan
    * 
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;GetDelinquencyActionsResponse&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/delinquency-actions")
    Call<List<GetDelinquencyActionsResponse>> getLoanDelinquencyActions1(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * 
    * 
        * @param officeId  (optional)
        * @param dateFormat  (optional)
    * @return Call&lt;Void&gt;
    */
    @GET("v1/loans/repayments/downloadtemplate")
    Call<Void> getLoanRepaymentTemplate(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("dateFormat") String dateFormat);

    /**
    * 
    * 
        * @param officeId  (optional)
        * @param staffId  (optional)
        * @param dateFormat  (optional)
    * @return Call&lt;Void&gt;
    */
    @GET("v1/loans/downloadtemplate")
    Call<Void> getLoansTemplate(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("staffId") Long staffId, @retrofit2.http.Query("dateFormat") String dateFormat);

    /**
    * Approve GLIM Application | Undo GLIM Application Approval | Reject GLIM Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
    * Approve GLIM Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the GLIM application  Undo GLIM Application Approval: Undoes the GLIM Application Approval  Reject GLIM Application: Mandatory Fields: rejectedOnDate Allows you to reject the GLIM application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal 
        * @param glimId  (required)
        * @param postLoansLoanIdRequest  (required)
        * @param command  (optional)
    * @return Call&lt;PostLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/glimAccount/{glimId}")
    Call<PostLoansLoanIdResponse> glimStateTransitions(@retrofit2.http.Path("glimId") Long glimId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Modify a loan application
    * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
        * @param loanId loanId (required)
        * @param putLoansLoanIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PutLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}")
    Call<PutLoansLoanIdResponse> modifyLoanApplication(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansLoanIdRequest putLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Modify a loan application
    * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
        * @param loanExternalId loanExternalId (required)
        * @param putLoansLoanIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PutLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}")
    Call<PutLoansLoanIdResponse> modifyLoanApplication1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansLoanIdRequest putLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Modifies the approved amount of the loan
    * 
        * @param loanId loanId (required)
        * @param putLoansApprovedAmountRequest  (required)
    * @return Call&lt;PutLoansApprovedAmountResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/approved-amount")
    Call<PutLoansApprovedAmountResponse> modifyLoanApprovedAmount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansApprovedAmountRequest putLoansApprovedAmountRequest);

    /**
    * Modifies the approved amount of the loan
    * 
        * @param loanExternalId loanExternalId (required)
        * @param putLoansApprovedAmountRequest  (required)
    * @return Call&lt;PutLoansApprovedAmountResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/approved-amount")
    Call<PutLoansApprovedAmountResponse> modifyLoanApprovedAmount1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansApprovedAmountRequest putLoansApprovedAmountRequest);

    /**
    * Modifies the available disbursement amount of the loan
    * Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan
        * @param loanId loanId (required)
        * @param putLoansAvailableDisbursementAmountRequest  (required)
    * @return Call&lt;PutLoansAvailableDisbursementAmountResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/{loanId}/available-disbursement-amount")
    Call<PutLoansAvailableDisbursementAmountResponse> modifyLoanAvailableDisbursementAmount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansAvailableDisbursementAmountRequest putLoansAvailableDisbursementAmountRequest);

    /**
    * Modifies the available disbursement amount of the loan
    * Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan
        * @param loanExternalId loanExternalId (required)
        * @param putLoansAvailableDisbursementAmountRequest  (required)
    * @return Call&lt;PutLoansAvailableDisbursementAmountResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/loans/external-id/{loanExternalId}/available-disbursement-amount")
    Call<PutLoansAvailableDisbursementAmountResponse> modifyLoanAvailableDisbursementAmount1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansAvailableDisbursementAmountRequest putLoansAvailableDisbursementAmountRequest);

    /**
    * 
    * 
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @POST("v1/loans/repayments/uploadtemplate")
    Call<String> postLoanRepaymentTemplate(@retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * 
    * 
        * @param dateFormat  (optional)
        * @param locale  (optional)
        * @param uploadedInputStream  (optional)
    * @return Call&lt;String&gt;
    */
            @retrofit2.http.Multipart
    @POST("v1/loans/uploadtemplate")
    Call<String> postLoanTemplate(@retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream);

    /**
    * List Loans
    * The list capability of loans can support pagination and sorting. Example Requests:  loans  loans?fields&#x3D;accountNo  loans?offset&#x3D;10&amp;limit&#x3D;50  loans?orderBy&#x3D;accountNo&amp;sortOrder&#x3D;DESC
        * @param externalId externalId (optional)
        * @param offset offset (optional)
        * @param limit limit (optional)
        * @param orderBy orderBy (optional)
        * @param sortOrder sortOrder (optional)
        * @param accountNo accountNo (optional)
        * @param associations associations (optional)
        * @param clientId clientId (optional)
        * @param status status (optional)
    * @return Call&lt;GetLoansResponse&gt;
    */
    @GET("v1/loans")
    Call<GetLoansResponse> retrieveAll27(@retrofit2.http.Query("externalId") String externalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("accountNo") String accountNo, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("status") String status);

    /**
    * 
    * 
        * @param loanId loanId (required)
        * @param templateType templateType (optional)
    * @return Call&lt;GetLoansApprovalTemplateResponse&gt;
    */
    @GET("v1/loans/{loanId}/template")
    Call<GetLoansApprovalTemplateResponse> retrieveApprovalTemplate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("templateType") String templateType);

    /**
    * 
    * 
        * @param loanExternalId loanExternalId (required)
        * @param templateType templateType (optional)
    * @return Call&lt;GetLoansApprovalTemplateResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/template")
    Call<GetLoansApprovalTemplateResponse> retrieveApprovalTemplate1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("templateType") String templateType);

    /**
    * Retrieve a Loan
    * Note: template&#x3D;true parameter doesn&#39;t apply to this resource.Example Requests:  loans/1   loans/1?fields&#x3D;id,principal,annualInterestRate   loans/1?associations&#x3D;all  loans/1?associations&#x3D;all&amp;exclude&#x3D;guarantors   loans/1?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
        * @param loanId loanId (required)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @param associations Loan object relations to be included in the response (optional, default to all)
        * @param exclude Optional Loan object relation list to be filtered in the response (optional)
        * @param fields Optional Loan attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdResponse&gt;
    */
    @GET("v1/loans/{loanId}")
    Call<GetLoansLoanIdResponse> retrieveLoan(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("exclude") String exclude, @retrofit2.http.Query("fields") String fields);

    /**
    * Retrieve a Loan
    * Note: template&#x3D;true parameter doesn&#39;t apply to this resource.Example Requests:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,principal,annualInterestRate   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations&#x3D;all  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations&#x3D;all&amp;exclude&#x3D;guarantors   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
        * @param loanExternalId loanExternalId (required)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @param associations Loan object relations to be included in the response (optional, default to all)
        * @param exclude Optional Loan object relation list to be filtered in the response (optional)
        * @param fields Optional Loan attribute list to be in the response (optional)
    * @return Call&lt;GetLoansLoanIdResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}")
    Call<GetLoansLoanIdResponse> retrieveLoan1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("exclude") String exclude, @retrofit2.http.Query("fields") String fields);

    /**
    * Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
    * Approve Loan Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the loan application  Recover Loan Guarantee: Recovers the loan guarantee  Undo Loan Application Approval: Undoes the Loan Application Approval  Assign a Loan Officer: Allows you to assign Loan Officer for existing Loan.  Unassign a Loan Officer: Allows you to unassign the Loan Officer.  Reject Loan Application: Mandatory Fields: rejectedOnDate Allows you to reject the loan application  Applicant Withdraws from Loan Application: Mandatory Fields: withdrawnOnDate Allows the applicant to withdraw the loan application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal Showing request and response for Assign a Loan Officer
        * @param loanId loanId (required)
        * @param postLoansLoanIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/{loanId}")
    Call<PostLoansLoanIdResponse> stateTransitions(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
    * Approve Loan Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the loan application  Recover Loan Guarantee: Recovers the loan guarantee  Undo Loan Application Approval: Undoes the Loan Application Approval  Assign a Loan Officer: Allows you to assign Loan Officer for existing Loan.  Unassign a Loan Officer: Allows you to unassign the Loan Officer.  Reject Loan Application: Mandatory Fields: rejectedOnDate Allows you to reject the loan application  Applicant Withdraws from Loan Application: Mandatory Fields: withdrawnOnDate Allows the applicant to withdraw the loan application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal Showing request and response for Assign a Loan Officer
        * @param loanExternalId loanExternalId (required)
        * @param postLoansLoanIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/loans/external-id/{loanExternalId}")
    Call<PostLoansLoanIdResponse> stateTransitions1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Retrieve Loan Details Template
    * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Requests:  loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1   loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1&amp;productId&#x3D;1
        * @param clientId clientId (optional)
        * @param groupId groupId (optional)
        * @param productId productId (optional)
        * @param templateType templateType (optional)
        * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
        * @param activeOnly activeOnly (optional, default to false)
    * @return Call&lt;GetLoansTemplateResponse&gt;
    */
    @GET("v1/loans/template")
    Call<GetLoansTemplateResponse> template10(@retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("groupId") Long groupId, @retrofit2.http.Query("productId") Long productId, @retrofit2.http.Query("templateType") String templateType, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("activeOnly") Boolean activeOnly);



        /**
        * Calculate loan repayment schedule | Submit a new Loan Application
        * It calculates the loan repayment Schedule Submits a new loan application Mandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType Optional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true) Additional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate Additional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate Additional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables
            * @param postLoansRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans")
    Call<PostLoansResponse> calculateLoanScheduleOrSubmitLoanApplication(@retrofit2.http.Body PostLoansRequest postLoansRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Adds a new delinquency action for a loan
        * 
            * @param loanId loanId (required)
            * @param postLoansDelinquencyActionRequest  (required)
        * @return Call&lt;PostLoansDelinquencyActionResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}/delinquency-actions")
    Call<PostLoansDelinquencyActionResponse> createLoanDelinquencyAction(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansDelinquencyActionRequest postLoansDelinquencyActionRequest, @HeaderMap Map<String, String> headers);

        /**
        * Adds a new delinquency action for a loan
        * 
            * @param loanExternalId loanExternalId (required)
            * @param postLoansDelinquencyActionRequest  (required)
        * @return Call&lt;PostLoansDelinquencyActionResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}/delinquency-actions")
    Call<PostLoansDelinquencyActionResponse> createLoanDelinquencyAction1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansDelinquencyActionRequest postLoansDelinquencyActionRequest, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Loan Application
        * Note: Only loans in \&quot;Submitted and awaiting approval\&quot; status can be deleted.
            * @param loanId loanId (required)
        * @return Call&lt;DeleteLoansLoanIdResponse&gt;
        */
    @DELETE("v1/loans/{loanId}")
    Call<DeleteLoansLoanIdResponse> deleteLoanApplication(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Loan Application
        * Note: Only loans in \&quot;Submitted and awaiting approval\&quot; status can be deleted.
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;DeleteLoansLoanIdResponse&gt;
        */
    @DELETE("v1/loans/external-id/{loanExternalId}")
    Call<DeleteLoansLoanIdResponse> deleteLoanApplication1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve the Loan Delinquency Tag history using the Loan Id
        * 
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;GetDelinquencyTagHistoryResponse&gt;&gt;
        */
    @GET("v1/loans/{loanId}/delinquencytags")
    Call<List<GetDelinquencyTagHistoryResponse>> getDelinquencyTagHistory(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve the Loan Delinquency Tag history using the Loan Id
        * 
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;GetDelinquencyTagHistoryResponse&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/delinquencytags")
    Call<List<GetDelinquencyTagHistoryResponse>> getDelinquencyTagHistory1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param glimId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/loans/glimAccount/{glimId}")
    Call<String> getGlimRepaymentTemplate(@retrofit2.http.Path("glimId") Long glimId, @HeaderMap Map<String, String> headers);

        /**
        * Collects and returns the approved amount modification history for a given loan
        * 
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;LoanApprovedAmountHistoryData&gt;&gt;
        */
    @GET("v1/loans/{loanId}/approved-amount")
    Call<List<LoanApprovedAmountHistoryData>> getLoanApprovedAmountHistory(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Collects and returns the approved amount modification history for a given loan
        * 
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;LoanApprovedAmountHistoryData&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/approved-amount")
    Call<List<LoanApprovedAmountHistoryData>> getLoanApprovedAmountHistory1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve delinquency actions related to the loan
        * 
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;GetDelinquencyActionsResponse&gt;&gt;
        */
    @GET("v1/loans/{loanId}/delinquency-actions")
    Call<List<GetDelinquencyActionsResponse>> getLoanDelinquencyActions(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve delinquency actions related to the loan
        * 
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;GetDelinquencyActionsResponse&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/delinquency-actions")
    Call<List<GetDelinquencyActionsResponse>> getLoanDelinquencyActions1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param officeId  (optional)
            * @param dateFormat  (optional)
        * @return Call&lt;Void&gt;
        */
    @GET("v1/loans/repayments/downloadtemplate")
    Call<Void> getLoanRepaymentTemplate(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("dateFormat") String dateFormat, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param officeId  (optional)
            * @param staffId  (optional)
            * @param dateFormat  (optional)
        * @return Call&lt;Void&gt;
        */
    @GET("v1/loans/downloadtemplate")
    Call<Void> getLoansTemplate(@retrofit2.http.Query("officeId") Long officeId, @retrofit2.http.Query("staffId") Long staffId, @retrofit2.http.Query("dateFormat") String dateFormat, @HeaderMap Map<String, String> headers);

        /**
        * Approve GLIM Application | Undo GLIM Application Approval | Reject GLIM Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
        * Approve GLIM Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the GLIM application  Undo GLIM Application Approval: Undoes the GLIM Application Approval  Reject GLIM Application: Mandatory Fields: rejectedOnDate Allows you to reject the GLIM application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal 
            * @param glimId  (required)
            * @param postLoansLoanIdRequest  (required)
            * @param command  (optional)
        * @return Call&lt;PostLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/glimAccount/{glimId}")
    Call<PostLoansLoanIdResponse> glimStateTransitions(@retrofit2.http.Path("glimId") Long glimId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Modify a loan application
        * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
            * @param loanId loanId (required)
            * @param putLoansLoanIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PutLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}")
    Call<PutLoansLoanIdResponse> modifyLoanApplication(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansLoanIdRequest putLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Modify a loan application
        * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
            * @param loanExternalId loanExternalId (required)
            * @param putLoansLoanIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PutLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}")
    Call<PutLoansLoanIdResponse> modifyLoanApplication1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansLoanIdRequest putLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Modifies the approved amount of the loan
        * 
            * @param loanId loanId (required)
            * @param putLoansApprovedAmountRequest  (required)
        * @return Call&lt;PutLoansApprovedAmountResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/approved-amount")
    Call<PutLoansApprovedAmountResponse> modifyLoanApprovedAmount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansApprovedAmountRequest putLoansApprovedAmountRequest, @HeaderMap Map<String, String> headers);

        /**
        * Modifies the approved amount of the loan
        * 
            * @param loanExternalId loanExternalId (required)
            * @param putLoansApprovedAmountRequest  (required)
        * @return Call&lt;PutLoansApprovedAmountResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/approved-amount")
    Call<PutLoansApprovedAmountResponse> modifyLoanApprovedAmount1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansApprovedAmountRequest putLoansApprovedAmountRequest, @HeaderMap Map<String, String> headers);

        /**
        * Modifies the available disbursement amount of the loan
        * Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan
            * @param loanId loanId (required)
            * @param putLoansAvailableDisbursementAmountRequest  (required)
        * @return Call&lt;PutLoansAvailableDisbursementAmountResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/{loanId}/available-disbursement-amount")
    Call<PutLoansAvailableDisbursementAmountResponse> modifyLoanAvailableDisbursementAmount(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutLoansAvailableDisbursementAmountRequest putLoansAvailableDisbursementAmountRequest, @HeaderMap Map<String, String> headers);

        /**
        * Modifies the available disbursement amount of the loan
        * Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan
            * @param loanExternalId loanExternalId (required)
            * @param putLoansAvailableDisbursementAmountRequest  (required)
        * @return Call&lt;PutLoansAvailableDisbursementAmountResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/loans/external-id/{loanExternalId}/available-disbursement-amount")
    Call<PutLoansAvailableDisbursementAmountResponse> modifyLoanAvailableDisbursementAmount1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PutLoansAvailableDisbursementAmountRequest putLoansAvailableDisbursementAmountRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @POST("v1/loans/repayments/uploadtemplate")
    Call<String> postLoanRepaymentTemplate(@retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param dateFormat  (optional)
            * @param locale  (optional)
            * @param uploadedInputStream  (optional)
        * @return Call&lt;String&gt;
        */
            @retrofit2.http.Multipart
    @POST("v1/loans/uploadtemplate")
    Call<String> postLoanTemplate(@retrofit2.http.Part("dateFormat") String dateFormat, @retrofit2.http.Part("locale") String locale, @retrofit2.http.Part MultipartBody.Part uploadedInputStream, @HeaderMap Map<String, String> headers);

        /**
        * List Loans
        * The list capability of loans can support pagination and sorting. Example Requests:  loans  loans?fields&#x3D;accountNo  loans?offset&#x3D;10&amp;limit&#x3D;50  loans?orderBy&#x3D;accountNo&amp;sortOrder&#x3D;DESC
            * @param externalId externalId (optional)
            * @param offset offset (optional)
            * @param limit limit (optional)
            * @param orderBy orderBy (optional)
            * @param sortOrder sortOrder (optional)
            * @param accountNo accountNo (optional)
            * @param associations associations (optional)
            * @param clientId clientId (optional)
            * @param status status (optional)
        * @return Call&lt;GetLoansResponse&gt;
        */
    @GET("v1/loans")
    Call<GetLoansResponse> retrieveAll27(@retrofit2.http.Query("externalId") String externalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("accountNo") String accountNo, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("status") String status, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId loanId (required)
            * @param templateType templateType (optional)
        * @return Call&lt;GetLoansApprovalTemplateResponse&gt;
        */
    @GET("v1/loans/{loanId}/template")
    Call<GetLoansApprovalTemplateResponse> retrieveApprovalTemplate(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("templateType") String templateType, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanExternalId loanExternalId (required)
            * @param templateType templateType (optional)
        * @return Call&lt;GetLoansApprovalTemplateResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/template")
    Call<GetLoansApprovalTemplateResponse> retrieveApprovalTemplate1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("templateType") String templateType, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan
        * Note: template&#x3D;true parameter doesn&#39;t apply to this resource.Example Requests:  loans/1   loans/1?fields&#x3D;id,principal,annualInterestRate   loans/1?associations&#x3D;all  loans/1?associations&#x3D;all&amp;exclude&#x3D;guarantors   loans/1?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
            * @param loanId loanId (required)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
            * @param associations Loan object relations to be included in the response (optional, default to all)
            * @param exclude Optional Loan object relation list to be filtered in the response (optional)
            * @param fields Optional Loan attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdResponse&gt;
        */
    @GET("v1/loans/{loanId}")
    Call<GetLoansLoanIdResponse> retrieveLoan(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("exclude") String exclude, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan
        * Note: template&#x3D;true parameter doesn&#39;t apply to this resource.Example Requests:  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,principal,annualInterestRate   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations&#x3D;all  loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations&#x3D;all&amp;exclude&#x3D;guarantors   loans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
            * @param loanExternalId loanExternalId (required)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
            * @param associations Loan object relations to be included in the response (optional, default to all)
            * @param exclude Optional Loan object relation list to be filtered in the response (optional)
            * @param fields Optional Loan attribute list to be in the response (optional)
        * @return Call&lt;GetLoansLoanIdResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}")
    Call<GetLoansLoanIdResponse> retrieveLoan1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("associations") String associations, @retrofit2.http.Query("exclude") String exclude, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
        * Approve Loan Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the loan application  Recover Loan Guarantee: Recovers the loan guarantee  Undo Loan Application Approval: Undoes the Loan Application Approval  Assign a Loan Officer: Allows you to assign Loan Officer for existing Loan.  Unassign a Loan Officer: Allows you to unassign the Loan Officer.  Reject Loan Application: Mandatory Fields: rejectedOnDate Allows you to reject the loan application  Applicant Withdraws from Loan Application: Mandatory Fields: withdrawnOnDate Allows the applicant to withdraw the loan application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal Showing request and response for Assign a Loan Officer
            * @param loanId loanId (required)
            * @param postLoansLoanIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/{loanId}")
    Call<PostLoansLoanIdResponse> stateTransitions(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal
        * Approve Loan Application: Mandatory Fields: approvedOnDate Optional Fields: approvedLoanAmount and expectedDisbursementDate Approves the loan application  Recover Loan Guarantee: Recovers the loan guarantee  Undo Loan Application Approval: Undoes the Loan Application Approval  Assign a Loan Officer: Allows you to assign Loan Officer for existing Loan.  Unassign a Loan Officer: Allows you to unassign the Loan Officer.  Reject Loan Application: Mandatory Fields: rejectedOnDate Allows you to reject the loan application  Applicant Withdraws from Loan Application: Mandatory Fields: withdrawnOnDate Allows the applicant to withdraw the loan application  Disburse Loan: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the Loan  Disburse Loan To Savings Account: Mandatory Fields: actualDisbursementDate Optional Fields: transactionAmount and fixedEmiAmount Disburses the loan to Saving Account  Undo Loan Disbursal: Undoes the Loan Disbursal Showing request and response for Assign a Loan Officer
            * @param loanExternalId loanExternalId (required)
            * @param postLoansLoanIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/loans/external-id/{loanExternalId}")
    Call<PostLoansLoanIdResponse> stateTransitions1(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostLoansLoanIdRequest postLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Details Template
        * This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists Example Requests:  loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1   loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1&amp;productId&#x3D;1
            * @param clientId clientId (optional)
            * @param groupId groupId (optional)
            * @param productId productId (optional)
            * @param templateType templateType (optional)
            * @param staffInSelectedOfficeOnly staffInSelectedOfficeOnly (optional, default to false)
            * @param activeOnly activeOnly (optional, default to false)
        * @return Call&lt;GetLoansTemplateResponse&gt;
        */
    @GET("v1/loans/template")
    Call<GetLoansTemplateResponse> template10(@retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("groupId") Long groupId, @retrofit2.http.Query("productId") Long productId, @retrofit2.http.Query("templateType") String templateType, @retrofit2.http.Query("staffInSelectedOfficeOnly") Boolean staffInSelectedOfficeOnly, @retrofit2.http.Query("activeOnly") Boolean activeOnly, @HeaderMap Map<String, String> headers);


}
