/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * SavingsAccountTransactionEnumData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class SavingsAccountTransactionEnumData {
  public static final String SERIALIZED_NAME_ACCRUAL = "accrual";
  @SerializedName(SERIALIZED_NAME_ACCRUAL)
  private Boolean accrual;

  public static final String SERIALIZED_NAME_AMOUNT_HOLD = "amountHold";
  @SerializedName(SERIALIZED_NAME_AMOUNT_HOLD)
  private Boolean amountHold;

  public static final String SERIALIZED_NAME_AMOUNT_RELEASE = "amountRelease";
  @SerializedName(SERIALIZED_NAME_AMOUNT_RELEASE)
  private Boolean amountRelease;

  public static final String SERIALIZED_NAME_ANNUAL_FEE = "annualFee";
  @SerializedName(SERIALIZED_NAME_ANNUAL_FEE)
  private Boolean annualFee;

  public static final String SERIALIZED_NAME_APPROVE_TRANSFER = "approveTransfer";
  @SerializedName(SERIALIZED_NAME_APPROVE_TRANSFER)
  private Boolean approveTransfer;

  public static final String SERIALIZED_NAME_CHARGE_TRANSACTION = "chargeTransaction";
  @SerializedName(SERIALIZED_NAME_CHARGE_TRANSACTION)
  private Boolean chargeTransaction;

  public static final String SERIALIZED_NAME_CODE = "code";
  @SerializedName(SERIALIZED_NAME_CODE)
  private String code;

  public static final String SERIALIZED_NAME_CREDIT = "credit";
  @SerializedName(SERIALIZED_NAME_CREDIT)
  private Boolean credit;

  public static final String SERIALIZED_NAME_DEBIT = "debit";
  @SerializedName(SERIALIZED_NAME_DEBIT)
  private Boolean debit;

  public static final String SERIALIZED_NAME_DEPOSIT = "deposit";
  @SerializedName(SERIALIZED_NAME_DEPOSIT)
  private Boolean deposit;

  public static final String SERIALIZED_NAME_DEPOSIT_OR_WITHDRAWAL = "depositOrWithdrawal";
  @SerializedName(SERIALIZED_NAME_DEPOSIT_OR_WITHDRAWAL)
  private Boolean depositOrWithdrawal;

  public static final String SERIALIZED_NAME_DIVIDEND_PAYOUT = "dividendPayout";
  @SerializedName(SERIALIZED_NAME_DIVIDEND_PAYOUT)
  private Boolean dividendPayout;

  /**
   * Gets or Sets entryType
   */
  @JsonAdapter(EntryTypeEnum.Adapter.class)
  public enum EntryTypeEnum {
    CREDIT("CREDIT"),
    
    DEBIT("DEBIT");

    private String value;

    EntryTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EntryTypeEnum fromValue(String value) {
      for (EntryTypeEnum b : EntryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EntryTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntryTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EntryTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EntryTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entryType";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private EntryTypeEnum entryType;

  public static final String SERIALIZED_NAME_ESCHEAT = "escheat";
  @SerializedName(SERIALIZED_NAME_ESCHEAT)
  private Boolean escheat;

  public static final String SERIALIZED_NAME_FEE_DEDUCTION = "feeDeduction";
  @SerializedName(SERIALIZED_NAME_FEE_DEDUCTION)
  private Boolean feeDeduction;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INCOME_FROM_INTEREST = "incomeFromInterest";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_INTEREST)
  private Boolean incomeFromInterest;

  public static final String SERIALIZED_NAME_INITIATE_TRANSFER = "initiateTransfer";
  @SerializedName(SERIALIZED_NAME_INITIATE_TRANSFER)
  private Boolean initiateTransfer;

  public static final String SERIALIZED_NAME_INTEREST_POSTING = "interestPosting";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING)
  private Boolean interestPosting;

  public static final String SERIALIZED_NAME_OVER_DRAFT_INTEREST_POSTING = "overDraftInterestPosting";
  @SerializedName(SERIALIZED_NAME_OVER_DRAFT_INTEREST_POSTING)
  private Boolean overDraftInterestPosting;

  public static final String SERIALIZED_NAME_OVERDRAFT_FEE = "overdraftFee";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_FEE)
  private Boolean overdraftFee;

  public static final String SERIALIZED_NAME_OVERDRAFT_INTEREST = "overdraftInterest";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_INTEREST)
  private Boolean overdraftInterest;

  public static final String SERIALIZED_NAME_PAY_CHARGE = "payCharge";
  @SerializedName(SERIALIZED_NAME_PAY_CHARGE)
  private Boolean payCharge;

  public static final String SERIALIZED_NAME_REJECT_TRANSFER = "rejectTransfer";
  @SerializedName(SERIALIZED_NAME_REJECT_TRANSFER)
  private Boolean rejectTransfer;

  /**
   * Gets or Sets transactionTypeEnum
   */
  @JsonAdapter(TransactionTypeEnumEnum.Adapter.class)
  public enum TransactionTypeEnumEnum {
    INVALID("INVALID"),
    
    DEPOSIT("DEPOSIT"),
    
    WITHDRAWAL("WITHDRAWAL"),
    
    INTEREST_POSTING("INTEREST_POSTING"),
    
    WITHDRAWAL_FEE("WITHDRAWAL_FEE"),
    
    ANNUAL_FEE("ANNUAL_FEE"),
    
    WAIVE_CHARGES("WAIVE_CHARGES"),
    
    PAY_CHARGE("PAY_CHARGE"),
    
    DIVIDEND_PAYOUT("DIVIDEND_PAYOUT"),
    
    ACCRUAL("ACCRUAL"),
    
    INITIATE_TRANSFER("INITIATE_TRANSFER"),
    
    APPROVE_TRANSFER("APPROVE_TRANSFER"),
    
    WITHDRAW_TRANSFER("WITHDRAW_TRANSFER"),
    
    REJECT_TRANSFER("REJECT_TRANSFER"),
    
    WRITTEN_OFF("WRITTEN_OFF"),
    
    OVERDRAFT_INTEREST("OVERDRAFT_INTEREST"),
    
    WITHHOLD_TAX("WITHHOLD_TAX"),
    
    ESCHEAT("ESCHEAT"),
    
    AMOUNT_HOLD("AMOUNT_HOLD"),
    
    AMOUNT_RELEASE("AMOUNT_RELEASE");

    private String value;

    TransactionTypeEnumEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransactionTypeEnumEnum fromValue(String value) {
      for (TransactionTypeEnumEnum b : TransactionTypeEnumEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransactionTypeEnumEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransactionTypeEnumEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransactionTypeEnumEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransactionTypeEnumEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE_ENUM = "transactionTypeEnum";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE_ENUM)
  private TransactionTypeEnumEnum transactionTypeEnum;

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private String value;

  public static final String SERIALIZED_NAME_WITHDRAW_TRANSFER = "withdrawTransfer";
  @SerializedName(SERIALIZED_NAME_WITHDRAW_TRANSFER)
  private Boolean withdrawTransfer;

  public static final String SERIALIZED_NAME_WITHDRAWAL = "withdrawal";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL)
  private Boolean withdrawal;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE = "withdrawalFee";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE)
  private Boolean withdrawalFee;

  public static final String SERIALIZED_NAME_WITHHOLD_TAX = "withholdTax";
  @SerializedName(SERIALIZED_NAME_WITHHOLD_TAX)
  private Boolean withholdTax;

  public static final String SERIALIZED_NAME_WRITTENOFF = "writtenoff";
  @SerializedName(SERIALIZED_NAME_WRITTENOFF)
  private Boolean writtenoff;

  public SavingsAccountTransactionEnumData() {
  }

  public SavingsAccountTransactionEnumData accrual(Boolean accrual) {
    
    this.accrual = accrual;
    return this;
  }

  /**
   * Get accrual
   * @return accrual
   */
  @javax.annotation.Nullable

  public Boolean getAccrual() {
    return accrual;
  }


  public void setAccrual(Boolean accrual) {
    this.accrual = accrual;
  }

  public SavingsAccountTransactionEnumData amountHold(Boolean amountHold) {
    
    this.amountHold = amountHold;
    return this;
  }

  /**
   * Get amountHold
   * @return amountHold
   */
  @javax.annotation.Nullable

  public Boolean getAmountHold() {
    return amountHold;
  }


  public void setAmountHold(Boolean amountHold) {
    this.amountHold = amountHold;
  }

  public SavingsAccountTransactionEnumData amountRelease(Boolean amountRelease) {
    
    this.amountRelease = amountRelease;
    return this;
  }

  /**
   * Get amountRelease
   * @return amountRelease
   */
  @javax.annotation.Nullable

  public Boolean getAmountRelease() {
    return amountRelease;
  }


  public void setAmountRelease(Boolean amountRelease) {
    this.amountRelease = amountRelease;
  }

  public SavingsAccountTransactionEnumData annualFee(Boolean annualFee) {
    
    this.annualFee = annualFee;
    return this;
  }

  /**
   * Get annualFee
   * @return annualFee
   */
  @javax.annotation.Nullable

  public Boolean getAnnualFee() {
    return annualFee;
  }


  public void setAnnualFee(Boolean annualFee) {
    this.annualFee = annualFee;
  }

  public SavingsAccountTransactionEnumData approveTransfer(Boolean approveTransfer) {
    
    this.approveTransfer = approveTransfer;
    return this;
  }

  /**
   * Get approveTransfer
   * @return approveTransfer
   */
  @javax.annotation.Nullable

  public Boolean getApproveTransfer() {
    return approveTransfer;
  }


  public void setApproveTransfer(Boolean approveTransfer) {
    this.approveTransfer = approveTransfer;
  }

  public SavingsAccountTransactionEnumData chargeTransaction(Boolean chargeTransaction) {
    
    this.chargeTransaction = chargeTransaction;
    return this;
  }

  /**
   * Get chargeTransaction
   * @return chargeTransaction
   */
  @javax.annotation.Nullable

  public Boolean getChargeTransaction() {
    return chargeTransaction;
  }


  public void setChargeTransaction(Boolean chargeTransaction) {
    this.chargeTransaction = chargeTransaction;
  }

  public SavingsAccountTransactionEnumData code(String code) {
    
    this.code = code;
    return this;
  }

  /**
   * Get code
   * @return code
   */
  @javax.annotation.Nullable

  public String getCode() {
    return code;
  }


  public void setCode(String code) {
    this.code = code;
  }

  public SavingsAccountTransactionEnumData credit(Boolean credit) {
    
    this.credit = credit;
    return this;
  }

  /**
   * Get credit
   * @return credit
   */
  @javax.annotation.Nullable

  public Boolean getCredit() {
    return credit;
  }


  public void setCredit(Boolean credit) {
    this.credit = credit;
  }

  public SavingsAccountTransactionEnumData debit(Boolean debit) {
    
    this.debit = debit;
    return this;
  }

  /**
   * Get debit
   * @return debit
   */
  @javax.annotation.Nullable

  public Boolean getDebit() {
    return debit;
  }


  public void setDebit(Boolean debit) {
    this.debit = debit;
  }

  public SavingsAccountTransactionEnumData deposit(Boolean deposit) {
    
    this.deposit = deposit;
    return this;
  }

  /**
   * Get deposit
   * @return deposit
   */
  @javax.annotation.Nullable

  public Boolean getDeposit() {
    return deposit;
  }


  public void setDeposit(Boolean deposit) {
    this.deposit = deposit;
  }

  public SavingsAccountTransactionEnumData depositOrWithdrawal(Boolean depositOrWithdrawal) {
    
    this.depositOrWithdrawal = depositOrWithdrawal;
    return this;
  }

  /**
   * Get depositOrWithdrawal
   * @return depositOrWithdrawal
   */
  @javax.annotation.Nullable

  public Boolean getDepositOrWithdrawal() {
    return depositOrWithdrawal;
  }


  public void setDepositOrWithdrawal(Boolean depositOrWithdrawal) {
    this.depositOrWithdrawal = depositOrWithdrawal;
  }

  public SavingsAccountTransactionEnumData dividendPayout(Boolean dividendPayout) {
    
    this.dividendPayout = dividendPayout;
    return this;
  }

  /**
   * Get dividendPayout
   * @return dividendPayout
   */
  @javax.annotation.Nullable

  public Boolean getDividendPayout() {
    return dividendPayout;
  }


  public void setDividendPayout(Boolean dividendPayout) {
    this.dividendPayout = dividendPayout;
  }

  public SavingsAccountTransactionEnumData entryType(EntryTypeEnum entryType) {
    
    this.entryType = entryType;
    return this;
  }

  /**
   * Get entryType
   * @return entryType
   */
  @javax.annotation.Nullable

  public EntryTypeEnum getEntryType() {
    return entryType;
  }


  public void setEntryType(EntryTypeEnum entryType) {
    this.entryType = entryType;
  }

  public SavingsAccountTransactionEnumData escheat(Boolean escheat) {
    
    this.escheat = escheat;
    return this;
  }

  /**
   * Get escheat
   * @return escheat
   */
  @javax.annotation.Nullable

  public Boolean getEscheat() {
    return escheat;
  }


  public void setEscheat(Boolean escheat) {
    this.escheat = escheat;
  }

  public SavingsAccountTransactionEnumData feeDeduction(Boolean feeDeduction) {
    
    this.feeDeduction = feeDeduction;
    return this;
  }

  /**
   * Get feeDeduction
   * @return feeDeduction
   */
  @javax.annotation.Nullable

  public Boolean getFeeDeduction() {
    return feeDeduction;
  }


  public void setFeeDeduction(Boolean feeDeduction) {
    this.feeDeduction = feeDeduction;
  }

  public SavingsAccountTransactionEnumData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public SavingsAccountTransactionEnumData incomeFromInterest(Boolean incomeFromInterest) {
    
    this.incomeFromInterest = incomeFromInterest;
    return this;
  }

  /**
   * Get incomeFromInterest
   * @return incomeFromInterest
   */
  @javax.annotation.Nullable

  public Boolean getIncomeFromInterest() {
    return incomeFromInterest;
  }


  public void setIncomeFromInterest(Boolean incomeFromInterest) {
    this.incomeFromInterest = incomeFromInterest;
  }

  public SavingsAccountTransactionEnumData initiateTransfer(Boolean initiateTransfer) {
    
    this.initiateTransfer = initiateTransfer;
    return this;
  }

  /**
   * Get initiateTransfer
   * @return initiateTransfer
   */
  @javax.annotation.Nullable

  public Boolean getInitiateTransfer() {
    return initiateTransfer;
  }


  public void setInitiateTransfer(Boolean initiateTransfer) {
    this.initiateTransfer = initiateTransfer;
  }

  public SavingsAccountTransactionEnumData interestPosting(Boolean interestPosting) {
    
    this.interestPosting = interestPosting;
    return this;
  }

  /**
   * Get interestPosting
   * @return interestPosting
   */
  @javax.annotation.Nullable

  public Boolean getInterestPosting() {
    return interestPosting;
  }


  public void setInterestPosting(Boolean interestPosting) {
    this.interestPosting = interestPosting;
  }

  public SavingsAccountTransactionEnumData overDraftInterestPosting(Boolean overDraftInterestPosting) {
    
    this.overDraftInterestPosting = overDraftInterestPosting;
    return this;
  }

  /**
   * Get overDraftInterestPosting
   * @return overDraftInterestPosting
   */
  @javax.annotation.Nullable

  public Boolean getOverDraftInterestPosting() {
    return overDraftInterestPosting;
  }


  public void setOverDraftInterestPosting(Boolean overDraftInterestPosting) {
    this.overDraftInterestPosting = overDraftInterestPosting;
  }

  public SavingsAccountTransactionEnumData overdraftFee(Boolean overdraftFee) {
    
    this.overdraftFee = overdraftFee;
    return this;
  }

  /**
   * Get overdraftFee
   * @return overdraftFee
   */
  @javax.annotation.Nullable

  public Boolean getOverdraftFee() {
    return overdraftFee;
  }


  public void setOverdraftFee(Boolean overdraftFee) {
    this.overdraftFee = overdraftFee;
  }

  public SavingsAccountTransactionEnumData overdraftInterest(Boolean overdraftInterest) {
    
    this.overdraftInterest = overdraftInterest;
    return this;
  }

  /**
   * Get overdraftInterest
   * @return overdraftInterest
   */
  @javax.annotation.Nullable

  public Boolean getOverdraftInterest() {
    return overdraftInterest;
  }


  public void setOverdraftInterest(Boolean overdraftInterest) {
    this.overdraftInterest = overdraftInterest;
  }

  public SavingsAccountTransactionEnumData payCharge(Boolean payCharge) {
    
    this.payCharge = payCharge;
    return this;
  }

  /**
   * Get payCharge
   * @return payCharge
   */
  @javax.annotation.Nullable

  public Boolean getPayCharge() {
    return payCharge;
  }


  public void setPayCharge(Boolean payCharge) {
    this.payCharge = payCharge;
  }

  public SavingsAccountTransactionEnumData rejectTransfer(Boolean rejectTransfer) {
    
    this.rejectTransfer = rejectTransfer;
    return this;
  }

  /**
   * Get rejectTransfer
   * @return rejectTransfer
   */
  @javax.annotation.Nullable

  public Boolean getRejectTransfer() {
    return rejectTransfer;
  }


  public void setRejectTransfer(Boolean rejectTransfer) {
    this.rejectTransfer = rejectTransfer;
  }

  public SavingsAccountTransactionEnumData transactionTypeEnum(TransactionTypeEnumEnum transactionTypeEnum) {
    
    this.transactionTypeEnum = transactionTypeEnum;
    return this;
  }

  /**
   * Get transactionTypeEnum
   * @return transactionTypeEnum
   */
  @javax.annotation.Nullable

  public TransactionTypeEnumEnum getTransactionTypeEnum() {
    return transactionTypeEnum;
  }


  public void setTransactionTypeEnum(TransactionTypeEnumEnum transactionTypeEnum) {
    this.transactionTypeEnum = transactionTypeEnum;
  }

  public SavingsAccountTransactionEnumData value(String value) {
    
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   */
  @javax.annotation.Nullable

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }

  public SavingsAccountTransactionEnumData withdrawTransfer(Boolean withdrawTransfer) {
    
    this.withdrawTransfer = withdrawTransfer;
    return this;
  }

  /**
   * Get withdrawTransfer
   * @return withdrawTransfer
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawTransfer() {
    return withdrawTransfer;
  }


  public void setWithdrawTransfer(Boolean withdrawTransfer) {
    this.withdrawTransfer = withdrawTransfer;
  }

  public SavingsAccountTransactionEnumData withdrawal(Boolean withdrawal) {
    
    this.withdrawal = withdrawal;
    return this;
  }

  /**
   * Get withdrawal
   * @return withdrawal
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawal() {
    return withdrawal;
  }


  public void setWithdrawal(Boolean withdrawal) {
    this.withdrawal = withdrawal;
  }

  public SavingsAccountTransactionEnumData withdrawalFee(Boolean withdrawalFee) {
    
    this.withdrawalFee = withdrawalFee;
    return this;
  }

  /**
   * Get withdrawalFee
   * @return withdrawalFee
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawalFee() {
    return withdrawalFee;
  }


  public void setWithdrawalFee(Boolean withdrawalFee) {
    this.withdrawalFee = withdrawalFee;
  }

  public SavingsAccountTransactionEnumData withholdTax(Boolean withholdTax) {
    
    this.withholdTax = withholdTax;
    return this;
  }

  /**
   * Get withholdTax
   * @return withholdTax
   */
  @javax.annotation.Nullable

  public Boolean getWithholdTax() {
    return withholdTax;
  }


  public void setWithholdTax(Boolean withholdTax) {
    this.withholdTax = withholdTax;
  }

  public SavingsAccountTransactionEnumData writtenoff(Boolean writtenoff) {
    
    this.writtenoff = writtenoff;
    return this;
  }

  /**
   * Get writtenoff
   * @return writtenoff
   */
  @javax.annotation.Nullable

  public Boolean getWrittenoff() {
    return writtenoff;
  }


  public void setWrittenoff(Boolean writtenoff) {
    this.writtenoff = writtenoff;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SavingsAccountTransactionEnumData savingsAccountTransactionEnumData = (SavingsAccountTransactionEnumData) o;
    return Objects.equals(this.accrual, savingsAccountTransactionEnumData.accrual) &&
        Objects.equals(this.amountHold, savingsAccountTransactionEnumData.amountHold) &&
        Objects.equals(this.amountRelease, savingsAccountTransactionEnumData.amountRelease) &&
        Objects.equals(this.annualFee, savingsAccountTransactionEnumData.annualFee) &&
        Objects.equals(this.approveTransfer, savingsAccountTransactionEnumData.approveTransfer) &&
        Objects.equals(this.chargeTransaction, savingsAccountTransactionEnumData.chargeTransaction) &&
        Objects.equals(this.code, savingsAccountTransactionEnumData.code) &&
        Objects.equals(this.credit, savingsAccountTransactionEnumData.credit) &&
        Objects.equals(this.debit, savingsAccountTransactionEnumData.debit) &&
        Objects.equals(this.deposit, savingsAccountTransactionEnumData.deposit) &&
        Objects.equals(this.depositOrWithdrawal, savingsAccountTransactionEnumData.depositOrWithdrawal) &&
        Objects.equals(this.dividendPayout, savingsAccountTransactionEnumData.dividendPayout) &&
        Objects.equals(this.entryType, savingsAccountTransactionEnumData.entryType) &&
        Objects.equals(this.escheat, savingsAccountTransactionEnumData.escheat) &&
        Objects.equals(this.feeDeduction, savingsAccountTransactionEnumData.feeDeduction) &&
        Objects.equals(this.id, savingsAccountTransactionEnumData.id) &&
        Objects.equals(this.incomeFromInterest, savingsAccountTransactionEnumData.incomeFromInterest) &&
        Objects.equals(this.initiateTransfer, savingsAccountTransactionEnumData.initiateTransfer) &&
        Objects.equals(this.interestPosting, savingsAccountTransactionEnumData.interestPosting) &&
        Objects.equals(this.overDraftInterestPosting, savingsAccountTransactionEnumData.overDraftInterestPosting) &&
        Objects.equals(this.overdraftFee, savingsAccountTransactionEnumData.overdraftFee) &&
        Objects.equals(this.overdraftInterest, savingsAccountTransactionEnumData.overdraftInterest) &&
        Objects.equals(this.payCharge, savingsAccountTransactionEnumData.payCharge) &&
        Objects.equals(this.rejectTransfer, savingsAccountTransactionEnumData.rejectTransfer) &&
        Objects.equals(this.transactionTypeEnum, savingsAccountTransactionEnumData.transactionTypeEnum) &&
        Objects.equals(this.value, savingsAccountTransactionEnumData.value) &&
        Objects.equals(this.withdrawTransfer, savingsAccountTransactionEnumData.withdrawTransfer) &&
        Objects.equals(this.withdrawal, savingsAccountTransactionEnumData.withdrawal) &&
        Objects.equals(this.withdrawalFee, savingsAccountTransactionEnumData.withdrawalFee) &&
        Objects.equals(this.withholdTax, savingsAccountTransactionEnumData.withholdTax) &&
        Objects.equals(this.writtenoff, savingsAccountTransactionEnumData.writtenoff);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accrual, amountHold, amountRelease, annualFee, approveTransfer, chargeTransaction, code, credit, debit, deposit, depositOrWithdrawal, dividendPayout, entryType, escheat, feeDeduction, id, incomeFromInterest, initiateTransfer, interestPosting, overDraftInterestPosting, overdraftFee, overdraftInterest, payCharge, rejectTransfer, transactionTypeEnum, value, withdrawTransfer, withdrawal, withdrawalFee, withholdTax, writtenoff);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SavingsAccountTransactionEnumData {\n");
    sb.append("    accrual: ").append(toIndentedString(accrual)).append("\n");
    sb.append("    amountHold: ").append(toIndentedString(amountHold)).append("\n");
    sb.append("    amountRelease: ").append(toIndentedString(amountRelease)).append("\n");
    sb.append("    annualFee: ").append(toIndentedString(annualFee)).append("\n");
    sb.append("    approveTransfer: ").append(toIndentedString(approveTransfer)).append("\n");
    sb.append("    chargeTransaction: ").append(toIndentedString(chargeTransaction)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    credit: ").append(toIndentedString(credit)).append("\n");
    sb.append("    debit: ").append(toIndentedString(debit)).append("\n");
    sb.append("    deposit: ").append(toIndentedString(deposit)).append("\n");
    sb.append("    depositOrWithdrawal: ").append(toIndentedString(depositOrWithdrawal)).append("\n");
    sb.append("    dividendPayout: ").append(toIndentedString(dividendPayout)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    escheat: ").append(toIndentedString(escheat)).append("\n");
    sb.append("    feeDeduction: ").append(toIndentedString(feeDeduction)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    incomeFromInterest: ").append(toIndentedString(incomeFromInterest)).append("\n");
    sb.append("    initiateTransfer: ").append(toIndentedString(initiateTransfer)).append("\n");
    sb.append("    interestPosting: ").append(toIndentedString(interestPosting)).append("\n");
    sb.append("    overDraftInterestPosting: ").append(toIndentedString(overDraftInterestPosting)).append("\n");
    sb.append("    overdraftFee: ").append(toIndentedString(overdraftFee)).append("\n");
    sb.append("    overdraftInterest: ").append(toIndentedString(overdraftInterest)).append("\n");
    sb.append("    payCharge: ").append(toIndentedString(payCharge)).append("\n");
    sb.append("    rejectTransfer: ").append(toIndentedString(rejectTransfer)).append("\n");
    sb.append("    transactionTypeEnum: ").append(toIndentedString(transactionTypeEnum)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    withdrawTransfer: ").append(toIndentedString(withdrawTransfer)).append("\n");
    sb.append("    withdrawal: ").append(toIndentedString(withdrawal)).append("\n");
    sb.append("    withdrawalFee: ").append(toIndentedString(withdrawalFee)).append("\n");
    sb.append("    withholdTax: ").append(toIndentedString(withholdTax)).append("\n");
    sb.append("    writtenoff: ").append(toIndentedString(writtenoff)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

