/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * LoanSchedulePeriodData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanSchedulePeriodData {
  public static final String SERIALIZED_NAME_COMPLETE = "complete";
  @SerializedName(SERIALIZED_NAME_COMPLETE)
  private Boolean complete;

  public static final String SERIALIZED_NAME_DAYS_IN_PERIOD = "daysInPeriod";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_PERIOD)
  private Integer daysInPeriod;

  public static final String SERIALIZED_NAME_DOWN_PAYMENT_PERIOD = "downPaymentPeriod";
  @SerializedName(SERIALIZED_NAME_DOWN_PAYMENT_PERIOD)
  private Boolean downPaymentPeriod;

  public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
  @SerializedName(SERIALIZED_NAME_DUE_DATE)
  private LocalDate dueDate;

  public static final String SERIALIZED_NAME_FEE_CHARGES_DUE = "feeChargesDue";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_DUE)
  private BigDecimal feeChargesDue;

  public static final String SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING = "feeChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING)
  private BigDecimal feeChargesOutstanding;

  public static final String SERIALIZED_NAME_FEE_CHARGES_PAID = "feeChargesPaid";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_PAID)
  private BigDecimal feeChargesPaid;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WAIVED = "feeChargesWaived";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WAIVED)
  private BigDecimal feeChargesWaived;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF = "feeChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF)
  private BigDecimal feeChargesWrittenOff;

  public static final String SERIALIZED_NAME_FROM_DATE = "fromDate";
  @SerializedName(SERIALIZED_NAME_FROM_DATE)
  private LocalDate fromDate;

  public static final String SERIALIZED_NAME_INTEREST_DUE = "interestDue";
  @SerializedName(SERIALIZED_NAME_INTEREST_DUE)
  private BigDecimal interestDue;

  public static final String SERIALIZED_NAME_INTEREST_ORIGINAL_DUE = "interestOriginalDue";
  @SerializedName(SERIALIZED_NAME_INTEREST_ORIGINAL_DUE)
  private BigDecimal interestOriginalDue;

  public static final String SERIALIZED_NAME_INTEREST_OUTSTANDING = "interestOutstanding";
  @SerializedName(SERIALIZED_NAME_INTEREST_OUTSTANDING)
  private BigDecimal interestOutstanding;

  public static final String SERIALIZED_NAME_INTEREST_PAID = "interestPaid";
  @SerializedName(SERIALIZED_NAME_INTEREST_PAID)
  private BigDecimal interestPaid;

  public static final String SERIALIZED_NAME_INTEREST_WAIVED = "interestWaived";
  @SerializedName(SERIALIZED_NAME_INTEREST_WAIVED)
  private BigDecimal interestWaived;

  public static final String SERIALIZED_NAME_INTEREST_WRITTEN_OFF = "interestWrittenOff";
  @SerializedName(SERIALIZED_NAME_INTEREST_WRITTEN_OFF)
  private BigDecimal interestWrittenOff;

  public static final String SERIALIZED_NAME_OBLIGATIONS_MET_ON_DATE = "obligationsMetOnDate";
  @SerializedName(SERIALIZED_NAME_OBLIGATIONS_MET_ON_DATE)
  private LocalDate obligationsMetOnDate;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_DUE = "penaltyChargesDue";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_DUE)
  private BigDecimal penaltyChargesDue;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING = "penaltyChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING)
  private BigDecimal penaltyChargesOutstanding;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_PAID = "penaltyChargesPaid";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_PAID)
  private BigDecimal penaltyChargesPaid;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WAIVED = "penaltyChargesWaived";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WAIVED)
  private BigDecimal penaltyChargesWaived;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF = "penaltyChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF)
  private BigDecimal penaltyChargesWrittenOff;

  public static final String SERIALIZED_NAME_PERIOD = "period";
  @SerializedName(SERIALIZED_NAME_PERIOD)
  private Integer period;

  public static final String SERIALIZED_NAME_PRINCIPAL_DISBURSED = "principalDisbursed";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_DISBURSED)
  private BigDecimal principalDisbursed;

  public static final String SERIALIZED_NAME_PRINCIPAL_DUE = "principalDue";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_DUE)
  private BigDecimal principalDue;

  public static final String SERIALIZED_NAME_PRINCIPAL_LOAN_BALANCE_OUTSTANDING = "principalLoanBalanceOutstanding";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_LOAN_BALANCE_OUTSTANDING)
  private BigDecimal principalLoanBalanceOutstanding;

  public static final String SERIALIZED_NAME_PRINCIPAL_ORIGINAL_DUE = "principalOriginalDue";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_ORIGINAL_DUE)
  private BigDecimal principalOriginalDue;

  public static final String SERIALIZED_NAME_PRINCIPAL_OUTSTANDING = "principalOutstanding";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_OUTSTANDING)
  private BigDecimal principalOutstanding;

  public static final String SERIALIZED_NAME_PRINCIPAL_PAID = "principalPaid";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_PAID)
  private BigDecimal principalPaid;

  public static final String SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF = "principalWrittenOff";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF)
  private BigDecimal principalWrittenOff;

  public static final String SERIALIZED_NAME_TOTAL_ACCRUED_INTEREST = "totalAccruedInterest";
  @SerializedName(SERIALIZED_NAME_TOTAL_ACCRUED_INTEREST)
  private BigDecimal totalAccruedInterest;

  public static final String SERIALIZED_NAME_TOTAL_ACTUAL_COST_OF_LOAN_FOR_PERIOD = "totalActualCostOfLoanForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_ACTUAL_COST_OF_LOAN_FOR_PERIOD)
  private BigDecimal totalActualCostOfLoanForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_CREDITS = "totalCredits";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDITS)
  private BigDecimal totalCredits;

  public static final String SERIALIZED_NAME_TOTAL_DUE_FOR_PERIOD = "totalDueForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_DUE_FOR_PERIOD)
  private BigDecimal totalDueForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_INSTALLMENT_AMOUNT_FOR_PERIOD = "totalInstallmentAmountForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_INSTALLMENT_AMOUNT_FOR_PERIOD)
  private BigDecimal totalInstallmentAmountForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_ORIGINAL_DUE_FOR_PERIOD = "totalOriginalDueForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_ORIGINAL_DUE_FOR_PERIOD)
  private BigDecimal totalOriginalDueForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_OUTSTANDING_FOR_PERIOD = "totalOutstandingForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_OUTSTANDING_FOR_PERIOD)
  private BigDecimal totalOutstandingForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_OVERDUE = "totalOverdue";
  @SerializedName(SERIALIZED_NAME_TOTAL_OVERDUE)
  private BigDecimal totalOverdue;

  public static final String SERIALIZED_NAME_TOTAL_PAID_FOR_PERIOD = "totalPaidForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_FOR_PERIOD)
  private BigDecimal totalPaidForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_PAID_IN_ADVANCE_FOR_PERIOD = "totalPaidInAdvanceForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_IN_ADVANCE_FOR_PERIOD)
  private BigDecimal totalPaidInAdvanceForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_PAID_LATE_FOR_PERIOD = "totalPaidLateForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_LATE_FOR_PERIOD)
  private BigDecimal totalPaidLateForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_WAIVED_FOR_PERIOD = "totalWaivedForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_WAIVED_FOR_PERIOD)
  private BigDecimal totalWaivedForPeriod;

  public static final String SERIALIZED_NAME_TOTAL_WRITTEN_OFF_FOR_PERIOD = "totalWrittenOffForPeriod";
  @SerializedName(SERIALIZED_NAME_TOTAL_WRITTEN_OFF_FOR_PERIOD)
  private BigDecimal totalWrittenOffForPeriod;

  public LoanSchedulePeriodData() {
  }

  public LoanSchedulePeriodData complete(Boolean complete) {
    
    this.complete = complete;
    return this;
  }

  /**
   * Get complete
   * @return complete
   */
  @javax.annotation.Nullable

  public Boolean getComplete() {
    return complete;
  }


  public void setComplete(Boolean complete) {
    this.complete = complete;
  }

  public LoanSchedulePeriodData daysInPeriod(Integer daysInPeriod) {
    
    this.daysInPeriod = daysInPeriod;
    return this;
  }

  /**
   * Get daysInPeriod
   * @return daysInPeriod
   */
  @javax.annotation.Nullable

  public Integer getDaysInPeriod() {
    return daysInPeriod;
  }


  public void setDaysInPeriod(Integer daysInPeriod) {
    this.daysInPeriod = daysInPeriod;
  }

  public LoanSchedulePeriodData downPaymentPeriod(Boolean downPaymentPeriod) {
    
    this.downPaymentPeriod = downPaymentPeriod;
    return this;
  }

  /**
   * Get downPaymentPeriod
   * @return downPaymentPeriod
   */
  @javax.annotation.Nullable

  public Boolean getDownPaymentPeriod() {
    return downPaymentPeriod;
  }


  public void setDownPaymentPeriod(Boolean downPaymentPeriod) {
    this.downPaymentPeriod = downPaymentPeriod;
  }

  public LoanSchedulePeriodData dueDate(LocalDate dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Get dueDate
   * @return dueDate
   */
  @javax.annotation.Nullable

  public LocalDate getDueDate() {
    return dueDate;
  }


  public void setDueDate(LocalDate dueDate) {
    this.dueDate = dueDate;
  }

  public LoanSchedulePeriodData feeChargesDue(BigDecimal feeChargesDue) {
    
    this.feeChargesDue = feeChargesDue;
    return this;
  }

  /**
   * Get feeChargesDue
   * @return feeChargesDue
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesDue() {
    return feeChargesDue;
  }


  public void setFeeChargesDue(BigDecimal feeChargesDue) {
    this.feeChargesDue = feeChargesDue;
  }

  public LoanSchedulePeriodData feeChargesOutstanding(BigDecimal feeChargesOutstanding) {
    
    this.feeChargesOutstanding = feeChargesOutstanding;
    return this;
  }

  /**
   * Get feeChargesOutstanding
   * @return feeChargesOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesOutstanding() {
    return feeChargesOutstanding;
  }


  public void setFeeChargesOutstanding(BigDecimal feeChargesOutstanding) {
    this.feeChargesOutstanding = feeChargesOutstanding;
  }

  public LoanSchedulePeriodData feeChargesPaid(BigDecimal feeChargesPaid) {
    
    this.feeChargesPaid = feeChargesPaid;
    return this;
  }

  /**
   * Get feeChargesPaid
   * @return feeChargesPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesPaid() {
    return feeChargesPaid;
  }


  public void setFeeChargesPaid(BigDecimal feeChargesPaid) {
    this.feeChargesPaid = feeChargesPaid;
  }

  public LoanSchedulePeriodData feeChargesWaived(BigDecimal feeChargesWaived) {
    
    this.feeChargesWaived = feeChargesWaived;
    return this;
  }

  /**
   * Get feeChargesWaived
   * @return feeChargesWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesWaived() {
    return feeChargesWaived;
  }


  public void setFeeChargesWaived(BigDecimal feeChargesWaived) {
    this.feeChargesWaived = feeChargesWaived;
  }

  public LoanSchedulePeriodData feeChargesWrittenOff(BigDecimal feeChargesWrittenOff) {
    
    this.feeChargesWrittenOff = feeChargesWrittenOff;
    return this;
  }

  /**
   * Get feeChargesWrittenOff
   * @return feeChargesWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesWrittenOff() {
    return feeChargesWrittenOff;
  }


  public void setFeeChargesWrittenOff(BigDecimal feeChargesWrittenOff) {
    this.feeChargesWrittenOff = feeChargesWrittenOff;
  }

  public LoanSchedulePeriodData fromDate(LocalDate fromDate) {
    
    this.fromDate = fromDate;
    return this;
  }

  /**
   * Get fromDate
   * @return fromDate
   */
  @javax.annotation.Nullable

  public LocalDate getFromDate() {
    return fromDate;
  }


  public void setFromDate(LocalDate fromDate) {
    this.fromDate = fromDate;
  }

  public LoanSchedulePeriodData interestDue(BigDecimal interestDue) {
    
    this.interestDue = interestDue;
    return this;
  }

  /**
   * Get interestDue
   * @return interestDue
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestDue() {
    return interestDue;
  }


  public void setInterestDue(BigDecimal interestDue) {
    this.interestDue = interestDue;
  }

  public LoanSchedulePeriodData interestOriginalDue(BigDecimal interestOriginalDue) {
    
    this.interestOriginalDue = interestOriginalDue;
    return this;
  }

  /**
   * Get interestOriginalDue
   * @return interestOriginalDue
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestOriginalDue() {
    return interestOriginalDue;
  }


  public void setInterestOriginalDue(BigDecimal interestOriginalDue) {
    this.interestOriginalDue = interestOriginalDue;
  }

  public LoanSchedulePeriodData interestOutstanding(BigDecimal interestOutstanding) {
    
    this.interestOutstanding = interestOutstanding;
    return this;
  }

  /**
   * Get interestOutstanding
   * @return interestOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestOutstanding() {
    return interestOutstanding;
  }


  public void setInterestOutstanding(BigDecimal interestOutstanding) {
    this.interestOutstanding = interestOutstanding;
  }

  public LoanSchedulePeriodData interestPaid(BigDecimal interestPaid) {
    
    this.interestPaid = interestPaid;
    return this;
  }

  /**
   * Get interestPaid
   * @return interestPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestPaid() {
    return interestPaid;
  }


  public void setInterestPaid(BigDecimal interestPaid) {
    this.interestPaid = interestPaid;
  }

  public LoanSchedulePeriodData interestWaived(BigDecimal interestWaived) {
    
    this.interestWaived = interestWaived;
    return this;
  }

  /**
   * Get interestWaived
   * @return interestWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestWaived() {
    return interestWaived;
  }


  public void setInterestWaived(BigDecimal interestWaived) {
    this.interestWaived = interestWaived;
  }

  public LoanSchedulePeriodData interestWrittenOff(BigDecimal interestWrittenOff) {
    
    this.interestWrittenOff = interestWrittenOff;
    return this;
  }

  /**
   * Get interestWrittenOff
   * @return interestWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestWrittenOff() {
    return interestWrittenOff;
  }


  public void setInterestWrittenOff(BigDecimal interestWrittenOff) {
    this.interestWrittenOff = interestWrittenOff;
  }

  public LoanSchedulePeriodData obligationsMetOnDate(LocalDate obligationsMetOnDate) {
    
    this.obligationsMetOnDate = obligationsMetOnDate;
    return this;
  }

  /**
   * Get obligationsMetOnDate
   * @return obligationsMetOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getObligationsMetOnDate() {
    return obligationsMetOnDate;
  }


  public void setObligationsMetOnDate(LocalDate obligationsMetOnDate) {
    this.obligationsMetOnDate = obligationsMetOnDate;
  }

  public LoanSchedulePeriodData penaltyChargesDue(BigDecimal penaltyChargesDue) {
    
    this.penaltyChargesDue = penaltyChargesDue;
    return this;
  }

  /**
   * Get penaltyChargesDue
   * @return penaltyChargesDue
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesDue() {
    return penaltyChargesDue;
  }


  public void setPenaltyChargesDue(BigDecimal penaltyChargesDue) {
    this.penaltyChargesDue = penaltyChargesDue;
  }

  public LoanSchedulePeriodData penaltyChargesOutstanding(BigDecimal penaltyChargesOutstanding) {
    
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
    return this;
  }

  /**
   * Get penaltyChargesOutstanding
   * @return penaltyChargesOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesOutstanding() {
    return penaltyChargesOutstanding;
  }


  public void setPenaltyChargesOutstanding(BigDecimal penaltyChargesOutstanding) {
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
  }

  public LoanSchedulePeriodData penaltyChargesPaid(BigDecimal penaltyChargesPaid) {
    
    this.penaltyChargesPaid = penaltyChargesPaid;
    return this;
  }

  /**
   * Get penaltyChargesPaid
   * @return penaltyChargesPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesPaid() {
    return penaltyChargesPaid;
  }


  public void setPenaltyChargesPaid(BigDecimal penaltyChargesPaid) {
    this.penaltyChargesPaid = penaltyChargesPaid;
  }

  public LoanSchedulePeriodData penaltyChargesWaived(BigDecimal penaltyChargesWaived) {
    
    this.penaltyChargesWaived = penaltyChargesWaived;
    return this;
  }

  /**
   * Get penaltyChargesWaived
   * @return penaltyChargesWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesWaived() {
    return penaltyChargesWaived;
  }


  public void setPenaltyChargesWaived(BigDecimal penaltyChargesWaived) {
    this.penaltyChargesWaived = penaltyChargesWaived;
  }

  public LoanSchedulePeriodData penaltyChargesWrittenOff(BigDecimal penaltyChargesWrittenOff) {
    
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
    return this;
  }

  /**
   * Get penaltyChargesWrittenOff
   * @return penaltyChargesWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesWrittenOff() {
    return penaltyChargesWrittenOff;
  }


  public void setPenaltyChargesWrittenOff(BigDecimal penaltyChargesWrittenOff) {
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
  }

  public LoanSchedulePeriodData period(Integer period) {
    
    this.period = period;
    return this;
  }

  /**
   * Get period
   * @return period
   */
  @javax.annotation.Nullable

  public Integer getPeriod() {
    return period;
  }


  public void setPeriod(Integer period) {
    this.period = period;
  }

  public LoanSchedulePeriodData principalDisbursed(BigDecimal principalDisbursed) {
    
    this.principalDisbursed = principalDisbursed;
    return this;
  }

  /**
   * Get principalDisbursed
   * @return principalDisbursed
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalDisbursed() {
    return principalDisbursed;
  }


  public void setPrincipalDisbursed(BigDecimal principalDisbursed) {
    this.principalDisbursed = principalDisbursed;
  }

  public LoanSchedulePeriodData principalDue(BigDecimal principalDue) {
    
    this.principalDue = principalDue;
    return this;
  }

  /**
   * Get principalDue
   * @return principalDue
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalDue() {
    return principalDue;
  }


  public void setPrincipalDue(BigDecimal principalDue) {
    this.principalDue = principalDue;
  }

  public LoanSchedulePeriodData principalLoanBalanceOutstanding(BigDecimal principalLoanBalanceOutstanding) {
    
    this.principalLoanBalanceOutstanding = principalLoanBalanceOutstanding;
    return this;
  }

  /**
   * Get principalLoanBalanceOutstanding
   * @return principalLoanBalanceOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalLoanBalanceOutstanding() {
    return principalLoanBalanceOutstanding;
  }


  public void setPrincipalLoanBalanceOutstanding(BigDecimal principalLoanBalanceOutstanding) {
    this.principalLoanBalanceOutstanding = principalLoanBalanceOutstanding;
  }

  public LoanSchedulePeriodData principalOriginalDue(BigDecimal principalOriginalDue) {
    
    this.principalOriginalDue = principalOriginalDue;
    return this;
  }

  /**
   * Get principalOriginalDue
   * @return principalOriginalDue
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalOriginalDue() {
    return principalOriginalDue;
  }


  public void setPrincipalOriginalDue(BigDecimal principalOriginalDue) {
    this.principalOriginalDue = principalOriginalDue;
  }

  public LoanSchedulePeriodData principalOutstanding(BigDecimal principalOutstanding) {
    
    this.principalOutstanding = principalOutstanding;
    return this;
  }

  /**
   * Get principalOutstanding
   * @return principalOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalOutstanding() {
    return principalOutstanding;
  }


  public void setPrincipalOutstanding(BigDecimal principalOutstanding) {
    this.principalOutstanding = principalOutstanding;
  }

  public LoanSchedulePeriodData principalPaid(BigDecimal principalPaid) {
    
    this.principalPaid = principalPaid;
    return this;
  }

  /**
   * Get principalPaid
   * @return principalPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalPaid() {
    return principalPaid;
  }


  public void setPrincipalPaid(BigDecimal principalPaid) {
    this.principalPaid = principalPaid;
  }

  public LoanSchedulePeriodData principalWrittenOff(BigDecimal principalWrittenOff) {
    
    this.principalWrittenOff = principalWrittenOff;
    return this;
  }

  /**
   * Get principalWrittenOff
   * @return principalWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalWrittenOff() {
    return principalWrittenOff;
  }


  public void setPrincipalWrittenOff(BigDecimal principalWrittenOff) {
    this.principalWrittenOff = principalWrittenOff;
  }

  public LoanSchedulePeriodData totalAccruedInterest(BigDecimal totalAccruedInterest) {
    
    this.totalAccruedInterest = totalAccruedInterest;
    return this;
  }

  /**
   * Get totalAccruedInterest
   * @return totalAccruedInterest
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalAccruedInterest() {
    return totalAccruedInterest;
  }


  public void setTotalAccruedInterest(BigDecimal totalAccruedInterest) {
    this.totalAccruedInterest = totalAccruedInterest;
  }

  public LoanSchedulePeriodData totalActualCostOfLoanForPeriod(BigDecimal totalActualCostOfLoanForPeriod) {
    
    this.totalActualCostOfLoanForPeriod = totalActualCostOfLoanForPeriod;
    return this;
  }

  /**
   * Get totalActualCostOfLoanForPeriod
   * @return totalActualCostOfLoanForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalActualCostOfLoanForPeriod() {
    return totalActualCostOfLoanForPeriod;
  }


  public void setTotalActualCostOfLoanForPeriod(BigDecimal totalActualCostOfLoanForPeriod) {
    this.totalActualCostOfLoanForPeriod = totalActualCostOfLoanForPeriod;
  }

  public LoanSchedulePeriodData totalCredits(BigDecimal totalCredits) {
    
    this.totalCredits = totalCredits;
    return this;
  }

  /**
   * Get totalCredits
   * @return totalCredits
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCredits() {
    return totalCredits;
  }


  public void setTotalCredits(BigDecimal totalCredits) {
    this.totalCredits = totalCredits;
  }

  public LoanSchedulePeriodData totalDueForPeriod(BigDecimal totalDueForPeriod) {
    
    this.totalDueForPeriod = totalDueForPeriod;
    return this;
  }

  /**
   * Get totalDueForPeriod
   * @return totalDueForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalDueForPeriod() {
    return totalDueForPeriod;
  }


  public void setTotalDueForPeriod(BigDecimal totalDueForPeriod) {
    this.totalDueForPeriod = totalDueForPeriod;
  }

  public LoanSchedulePeriodData totalInstallmentAmountForPeriod(BigDecimal totalInstallmentAmountForPeriod) {
    
    this.totalInstallmentAmountForPeriod = totalInstallmentAmountForPeriod;
    return this;
  }

  /**
   * Get totalInstallmentAmountForPeriod
   * @return totalInstallmentAmountForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalInstallmentAmountForPeriod() {
    return totalInstallmentAmountForPeriod;
  }


  public void setTotalInstallmentAmountForPeriod(BigDecimal totalInstallmentAmountForPeriod) {
    this.totalInstallmentAmountForPeriod = totalInstallmentAmountForPeriod;
  }

  public LoanSchedulePeriodData totalOriginalDueForPeriod(BigDecimal totalOriginalDueForPeriod) {
    
    this.totalOriginalDueForPeriod = totalOriginalDueForPeriod;
    return this;
  }

  /**
   * Get totalOriginalDueForPeriod
   * @return totalOriginalDueForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOriginalDueForPeriod() {
    return totalOriginalDueForPeriod;
  }


  public void setTotalOriginalDueForPeriod(BigDecimal totalOriginalDueForPeriod) {
    this.totalOriginalDueForPeriod = totalOriginalDueForPeriod;
  }

  public LoanSchedulePeriodData totalOutstandingForPeriod(BigDecimal totalOutstandingForPeriod) {
    
    this.totalOutstandingForPeriod = totalOutstandingForPeriod;
    return this;
  }

  /**
   * Get totalOutstandingForPeriod
   * @return totalOutstandingForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOutstandingForPeriod() {
    return totalOutstandingForPeriod;
  }


  public void setTotalOutstandingForPeriod(BigDecimal totalOutstandingForPeriod) {
    this.totalOutstandingForPeriod = totalOutstandingForPeriod;
  }

  public LoanSchedulePeriodData totalOverdue(BigDecimal totalOverdue) {
    
    this.totalOverdue = totalOverdue;
    return this;
  }

  /**
   * Get totalOverdue
   * @return totalOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOverdue() {
    return totalOverdue;
  }


  public void setTotalOverdue(BigDecimal totalOverdue) {
    this.totalOverdue = totalOverdue;
  }

  public LoanSchedulePeriodData totalPaidForPeriod(BigDecimal totalPaidForPeriod) {
    
    this.totalPaidForPeriod = totalPaidForPeriod;
    return this;
  }

  /**
   * Get totalPaidForPeriod
   * @return totalPaidForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPaidForPeriod() {
    return totalPaidForPeriod;
  }


  public void setTotalPaidForPeriod(BigDecimal totalPaidForPeriod) {
    this.totalPaidForPeriod = totalPaidForPeriod;
  }

  public LoanSchedulePeriodData totalPaidInAdvanceForPeriod(BigDecimal totalPaidInAdvanceForPeriod) {
    
    this.totalPaidInAdvanceForPeriod = totalPaidInAdvanceForPeriod;
    return this;
  }

  /**
   * Get totalPaidInAdvanceForPeriod
   * @return totalPaidInAdvanceForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPaidInAdvanceForPeriod() {
    return totalPaidInAdvanceForPeriod;
  }


  public void setTotalPaidInAdvanceForPeriod(BigDecimal totalPaidInAdvanceForPeriod) {
    this.totalPaidInAdvanceForPeriod = totalPaidInAdvanceForPeriod;
  }

  public LoanSchedulePeriodData totalPaidLateForPeriod(BigDecimal totalPaidLateForPeriod) {
    
    this.totalPaidLateForPeriod = totalPaidLateForPeriod;
    return this;
  }

  /**
   * Get totalPaidLateForPeriod
   * @return totalPaidLateForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPaidLateForPeriod() {
    return totalPaidLateForPeriod;
  }


  public void setTotalPaidLateForPeriod(BigDecimal totalPaidLateForPeriod) {
    this.totalPaidLateForPeriod = totalPaidLateForPeriod;
  }

  public LoanSchedulePeriodData totalWaivedForPeriod(BigDecimal totalWaivedForPeriod) {
    
    this.totalWaivedForPeriod = totalWaivedForPeriod;
    return this;
  }

  /**
   * Get totalWaivedForPeriod
   * @return totalWaivedForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWaivedForPeriod() {
    return totalWaivedForPeriod;
  }


  public void setTotalWaivedForPeriod(BigDecimal totalWaivedForPeriod) {
    this.totalWaivedForPeriod = totalWaivedForPeriod;
  }

  public LoanSchedulePeriodData totalWrittenOffForPeriod(BigDecimal totalWrittenOffForPeriod) {
    
    this.totalWrittenOffForPeriod = totalWrittenOffForPeriod;
    return this;
  }

  /**
   * Get totalWrittenOffForPeriod
   * @return totalWrittenOffForPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWrittenOffForPeriod() {
    return totalWrittenOffForPeriod;
  }


  public void setTotalWrittenOffForPeriod(BigDecimal totalWrittenOffForPeriod) {
    this.totalWrittenOffForPeriod = totalWrittenOffForPeriod;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanSchedulePeriodData loanSchedulePeriodData = (LoanSchedulePeriodData) o;
    return Objects.equals(this.complete, loanSchedulePeriodData.complete) &&
        Objects.equals(this.daysInPeriod, loanSchedulePeriodData.daysInPeriod) &&
        Objects.equals(this.downPaymentPeriod, loanSchedulePeriodData.downPaymentPeriod) &&
        Objects.equals(this.dueDate, loanSchedulePeriodData.dueDate) &&
        Objects.equals(this.feeChargesDue, loanSchedulePeriodData.feeChargesDue) &&
        Objects.equals(this.feeChargesOutstanding, loanSchedulePeriodData.feeChargesOutstanding) &&
        Objects.equals(this.feeChargesPaid, loanSchedulePeriodData.feeChargesPaid) &&
        Objects.equals(this.feeChargesWaived, loanSchedulePeriodData.feeChargesWaived) &&
        Objects.equals(this.feeChargesWrittenOff, loanSchedulePeriodData.feeChargesWrittenOff) &&
        Objects.equals(this.fromDate, loanSchedulePeriodData.fromDate) &&
        Objects.equals(this.interestDue, loanSchedulePeriodData.interestDue) &&
        Objects.equals(this.interestOriginalDue, loanSchedulePeriodData.interestOriginalDue) &&
        Objects.equals(this.interestOutstanding, loanSchedulePeriodData.interestOutstanding) &&
        Objects.equals(this.interestPaid, loanSchedulePeriodData.interestPaid) &&
        Objects.equals(this.interestWaived, loanSchedulePeriodData.interestWaived) &&
        Objects.equals(this.interestWrittenOff, loanSchedulePeriodData.interestWrittenOff) &&
        Objects.equals(this.obligationsMetOnDate, loanSchedulePeriodData.obligationsMetOnDate) &&
        Objects.equals(this.penaltyChargesDue, loanSchedulePeriodData.penaltyChargesDue) &&
        Objects.equals(this.penaltyChargesOutstanding, loanSchedulePeriodData.penaltyChargesOutstanding) &&
        Objects.equals(this.penaltyChargesPaid, loanSchedulePeriodData.penaltyChargesPaid) &&
        Objects.equals(this.penaltyChargesWaived, loanSchedulePeriodData.penaltyChargesWaived) &&
        Objects.equals(this.penaltyChargesWrittenOff, loanSchedulePeriodData.penaltyChargesWrittenOff) &&
        Objects.equals(this.period, loanSchedulePeriodData.period) &&
        Objects.equals(this.principalDisbursed, loanSchedulePeriodData.principalDisbursed) &&
        Objects.equals(this.principalDue, loanSchedulePeriodData.principalDue) &&
        Objects.equals(this.principalLoanBalanceOutstanding, loanSchedulePeriodData.principalLoanBalanceOutstanding) &&
        Objects.equals(this.principalOriginalDue, loanSchedulePeriodData.principalOriginalDue) &&
        Objects.equals(this.principalOutstanding, loanSchedulePeriodData.principalOutstanding) &&
        Objects.equals(this.principalPaid, loanSchedulePeriodData.principalPaid) &&
        Objects.equals(this.principalWrittenOff, loanSchedulePeriodData.principalWrittenOff) &&
        Objects.equals(this.totalAccruedInterest, loanSchedulePeriodData.totalAccruedInterest) &&
        Objects.equals(this.totalActualCostOfLoanForPeriod, loanSchedulePeriodData.totalActualCostOfLoanForPeriod) &&
        Objects.equals(this.totalCredits, loanSchedulePeriodData.totalCredits) &&
        Objects.equals(this.totalDueForPeriod, loanSchedulePeriodData.totalDueForPeriod) &&
        Objects.equals(this.totalInstallmentAmountForPeriod, loanSchedulePeriodData.totalInstallmentAmountForPeriod) &&
        Objects.equals(this.totalOriginalDueForPeriod, loanSchedulePeriodData.totalOriginalDueForPeriod) &&
        Objects.equals(this.totalOutstandingForPeriod, loanSchedulePeriodData.totalOutstandingForPeriod) &&
        Objects.equals(this.totalOverdue, loanSchedulePeriodData.totalOverdue) &&
        Objects.equals(this.totalPaidForPeriod, loanSchedulePeriodData.totalPaidForPeriod) &&
        Objects.equals(this.totalPaidInAdvanceForPeriod, loanSchedulePeriodData.totalPaidInAdvanceForPeriod) &&
        Objects.equals(this.totalPaidLateForPeriod, loanSchedulePeriodData.totalPaidLateForPeriod) &&
        Objects.equals(this.totalWaivedForPeriod, loanSchedulePeriodData.totalWaivedForPeriod) &&
        Objects.equals(this.totalWrittenOffForPeriod, loanSchedulePeriodData.totalWrittenOffForPeriod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(complete, daysInPeriod, downPaymentPeriod, dueDate, feeChargesDue, feeChargesOutstanding, feeChargesPaid, feeChargesWaived, feeChargesWrittenOff, fromDate, interestDue, interestOriginalDue, interestOutstanding, interestPaid, interestWaived, interestWrittenOff, obligationsMetOnDate, penaltyChargesDue, penaltyChargesOutstanding, penaltyChargesPaid, penaltyChargesWaived, penaltyChargesWrittenOff, period, principalDisbursed, principalDue, principalLoanBalanceOutstanding, principalOriginalDue, principalOutstanding, principalPaid, principalWrittenOff, totalAccruedInterest, totalActualCostOfLoanForPeriod, totalCredits, totalDueForPeriod, totalInstallmentAmountForPeriod, totalOriginalDueForPeriod, totalOutstandingForPeriod, totalOverdue, totalPaidForPeriod, totalPaidInAdvanceForPeriod, totalPaidLateForPeriod, totalWaivedForPeriod, totalWrittenOffForPeriod);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanSchedulePeriodData {\n");
    sb.append("    complete: ").append(toIndentedString(complete)).append("\n");
    sb.append("    daysInPeriod: ").append(toIndentedString(daysInPeriod)).append("\n");
    sb.append("    downPaymentPeriod: ").append(toIndentedString(downPaymentPeriod)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    feeChargesDue: ").append(toIndentedString(feeChargesDue)).append("\n");
    sb.append("    feeChargesOutstanding: ").append(toIndentedString(feeChargesOutstanding)).append("\n");
    sb.append("    feeChargesPaid: ").append(toIndentedString(feeChargesPaid)).append("\n");
    sb.append("    feeChargesWaived: ").append(toIndentedString(feeChargesWaived)).append("\n");
    sb.append("    feeChargesWrittenOff: ").append(toIndentedString(feeChargesWrittenOff)).append("\n");
    sb.append("    fromDate: ").append(toIndentedString(fromDate)).append("\n");
    sb.append("    interestDue: ").append(toIndentedString(interestDue)).append("\n");
    sb.append("    interestOriginalDue: ").append(toIndentedString(interestOriginalDue)).append("\n");
    sb.append("    interestOutstanding: ").append(toIndentedString(interestOutstanding)).append("\n");
    sb.append("    interestPaid: ").append(toIndentedString(interestPaid)).append("\n");
    sb.append("    interestWaived: ").append(toIndentedString(interestWaived)).append("\n");
    sb.append("    interestWrittenOff: ").append(toIndentedString(interestWrittenOff)).append("\n");
    sb.append("    obligationsMetOnDate: ").append(toIndentedString(obligationsMetOnDate)).append("\n");
    sb.append("    penaltyChargesDue: ").append(toIndentedString(penaltyChargesDue)).append("\n");
    sb.append("    penaltyChargesOutstanding: ").append(toIndentedString(penaltyChargesOutstanding)).append("\n");
    sb.append("    penaltyChargesPaid: ").append(toIndentedString(penaltyChargesPaid)).append("\n");
    sb.append("    penaltyChargesWaived: ").append(toIndentedString(penaltyChargesWaived)).append("\n");
    sb.append("    penaltyChargesWrittenOff: ").append(toIndentedString(penaltyChargesWrittenOff)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    principalDisbursed: ").append(toIndentedString(principalDisbursed)).append("\n");
    sb.append("    principalDue: ").append(toIndentedString(principalDue)).append("\n");
    sb.append("    principalLoanBalanceOutstanding: ").append(toIndentedString(principalLoanBalanceOutstanding)).append("\n");
    sb.append("    principalOriginalDue: ").append(toIndentedString(principalOriginalDue)).append("\n");
    sb.append("    principalOutstanding: ").append(toIndentedString(principalOutstanding)).append("\n");
    sb.append("    principalPaid: ").append(toIndentedString(principalPaid)).append("\n");
    sb.append("    principalWrittenOff: ").append(toIndentedString(principalWrittenOff)).append("\n");
    sb.append("    totalAccruedInterest: ").append(toIndentedString(totalAccruedInterest)).append("\n");
    sb.append("    totalActualCostOfLoanForPeriod: ").append(toIndentedString(totalActualCostOfLoanForPeriod)).append("\n");
    sb.append("    totalCredits: ").append(toIndentedString(totalCredits)).append("\n");
    sb.append("    totalDueForPeriod: ").append(toIndentedString(totalDueForPeriod)).append("\n");
    sb.append("    totalInstallmentAmountForPeriod: ").append(toIndentedString(totalInstallmentAmountForPeriod)).append("\n");
    sb.append("    totalOriginalDueForPeriod: ").append(toIndentedString(totalOriginalDueForPeriod)).append("\n");
    sb.append("    totalOutstandingForPeriod: ").append(toIndentedString(totalOutstandingForPeriod)).append("\n");
    sb.append("    totalOverdue: ").append(toIndentedString(totalOverdue)).append("\n");
    sb.append("    totalPaidForPeriod: ").append(toIndentedString(totalPaidForPeriod)).append("\n");
    sb.append("    totalPaidInAdvanceForPeriod: ").append(toIndentedString(totalPaidInAdvanceForPeriod)).append("\n");
    sb.append("    totalPaidLateForPeriod: ").append(toIndentedString(totalPaidLateForPeriod)).append("\n");
    sb.append("    totalWaivedForPeriod: ").append(toIndentedString(totalWaivedForPeriod)).append("\n");
    sb.append("    totalWrittenOffForPeriod: ").append(toIndentedString(totalWrittenOffForPeriod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

