/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

public enum ShareAccountStatusType {
    INVALID(Integer.valueOf(0), "shareAccountStatusType.invalid"),
    SUBMITTED_AND_PENDING_APPROVAL(Integer.valueOf(100), "shareAccountStatusType.submitted.and.pending.approval"),
    APPROVED(Integer.valueOf(200), "shareAccountStatusType.approved"),
    ACTIVE(Integer.valueOf(300), "shareAccountStatusType.active"),
    REJECTED(Integer.valueOf(500), "shareAccountStatusType.rejected"),
    CLOSED(Integer.valueOf(600), "shareAccountStatusType.closed");

    private final Integer value;
    private final String code;

    public static ShareAccountStatusType fromInt(Integer type) {
        ShareAccountStatusType enumeration = INVALID;
        switch (type) {
            case 100: {
                enumeration = SUBMITTED_AND_PENDING_APPROVAL;
                break;
            }
            case 200: {
                enumeration = APPROVED;
                break;
            }
            case 300: {
                enumeration = ACTIVE;
                break;
            }
            case 500: {
                enumeration = REJECTED;
                break;
            }
            case 600: {
                enumeration = CLOSED;
            }
        }
        return enumeration;
    }

    private ShareAccountStatusType(Integer value, String code) {
        this.value = value;
        this.code = code;
    }

    public boolean hasStateOf(ShareAccountStatusType state) {
        return this.value.equals(state.getValue());
    }

    public Integer getValue() {
        return this.value;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isSubmittedAndPendingApproval() {
        return this.value.equals(SUBMITTED_AND_PENDING_APPROVAL.getValue());
    }

    public boolean isApproved() {
        return this.value.equals(APPROVED.getValue());
    }

    public boolean isRejected() {
        return this.value.equals(REJECTED.getValue());
    }

    public boolean isActive() {
        return this.value.equals(ACTIVE.getValue());
    }

    public boolean isActiveOrAwaitingApprovalOrDisbursal() {
        return this.isApproved() || this.isSubmittedAndPendingApproval() || this.isActive();
    }

    public boolean isClosed() {
        return this.value.equals(CLOSED.getValue()) || this.isRejected();
    }
}

