/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

public enum PurchasedSharesStatusType {
    INVALID(Integer.valueOf(0), "purchasedSharesStatusType.invalid"),
    APPLIED(Integer.valueOf(100), "purchasedSharesStatusType.applied"),
    APPROVED(Integer.valueOf(300), "purchasedSharesStatusType.approved"),
    REJECTED(Integer.valueOf(400), "purchasedSharesStatusType.rejected"),
    PURCHASED(Integer.valueOf(500), "purchasedSharesType.purchased"),
    REDEEMED(Integer.valueOf(600), "purchasedSharesType.redeemed"),
    CHARGE_PAYMENT(Integer.valueOf(700), "charge.payment");

    private final Integer value;
    private final String code;

    private PurchasedSharesStatusType(Integer value, String code) {
        this.value = value;
        this.code = code;
    }

    public static PurchasedSharesStatusType fromInt(Integer type) {
        PurchasedSharesStatusType enumeration = INVALID;
        switch (type) {
            case 100: {
                enumeration = APPLIED;
                break;
            }
            case 300: {
                enumeration = APPROVED;
                break;
            }
            case 400: {
                enumeration = REJECTED;
                break;
            }
            case 500: {
                enumeration = PURCHASED;
                break;
            }
            case 600: {
                enumeration = REDEEMED;
                break;
            }
            case 700: {
                enumeration = CHARGE_PAYMENT;
            }
        }
        return enumeration;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isApproved() {
        return this.value.equals(APPROVED.getValue());
    }

    public boolean isRejected() {
        return this.value.equals(REJECTED.getValue());
    }

    public boolean isPurchased() {
        return this.value.equals(PURCHASED.getValue());
    }

    public boolean isChargePayment() {
        return this.value.equals(CHARGE_PAYMENT.getValue());
    }
}

