/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfBeneficiariesTPTDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "name", "officeName", "accountNumber", "accountType", "transferLimit"));
    private static final Set<String> UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("name", "transferLimit"));

    @Autowired
    public SelfBeneficiariesTPTDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public HashMap<String, Object> validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CREATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("beneficiary");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String officeName = this.fromApiJsonHelper.extractStringNamed("officeName", element);
        baseDataValidator.reset().parameter("officeName").value((Object)officeName).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNumber", element);
        baseDataValidator.reset().parameter("accountNumber").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
        Integer accountType = this.fromApiJsonHelper.extractIntegerNamed("accountType", element, this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject()));
        baseDataValidator.reset().parameter("accountType").value((Object)accountType).notNull().isOneOfTheseValues(new Object[]{PortfolioAccountType.LOAN.getValue(), PortfolioAccountType.SAVINGS.getValue()});
        Long transferLimit = this.fromApiJsonHelper.extractLongNamed("transferLimit", element);
        baseDataValidator.reset().parameter("transferLimit").value((Object)transferLimit).ignoreIfNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("name", name);
        ret.put("officeName", officeName);
        ret.put("accountNumber", accountNo);
        ret.put("accountType", accountType);
        ret.put("transferLimit", transferLimit);
        return ret;
    }

    public HashMap<String, Object> validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)UPDATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("beneficiary");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(50));
            ret.put("name", name);
        }
        if (this.fromApiJsonHelper.parameterExists("transferLimit", element)) {
            Long transferLimit = this.fromApiJsonHelper.extractLongNamed("transferLimit", element);
            baseDataValidator.reset().parameter("transferLimit").value((Object)transferLimit).ignoreIfNull().longGreaterThanZero();
            ret.put("transferLimit", transferLimit);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        return ret;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

