/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.account.api.AccountTransfersApiResource;
import org.apache.fineract.portfolio.account.data.request.AccountTransferRequest;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.self.account.api.SelfAccountTransferApiResourceSwagger;
import org.apache.fineract.portfolio.self.account.data.SelfAccountTemplateData;
import org.apache.fineract.portfolio.self.account.data.SelfAccountTransferData;
import org.apache.fineract.portfolio.self.account.data.SelfAccountTransferDataValidator;
import org.apache.fineract.portfolio.self.account.exception.BeneficiaryTransferLimitExceededException;
import org.apache.fineract.portfolio.self.account.exception.DailyTPTTransactionAmountLimitExceededException;
import org.apache.fineract.portfolio.self.account.service.SelfAccountTransferReadService;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTReadPlatformService;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/accounttransfers")
@Component
@Tag(name="Self Account transfer", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfAccountTransferApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SelfAccountTransferData> toApiJsonSerializer;
    private final AccountTransfersApiResource accountTransfersApiResource;
    private final SelfAccountTransferReadService selfAccountTransferReadService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SelfAccountTransferDataValidator dataValidator;
    private final SelfBeneficiariesTPTReadPlatformService tptBeneficiaryReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Account Transfer Template", description="Returns list of loan/savings accounts that can be used for account transfer\n\n\nExample Requests:\n\nself/accounttransfers/template\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfAccountTransferApiResourceSwagger.GetAccountTransferTemplateResponse.class)))})})
    public String template(@DefaultValue(value="") @QueryParam(value="type") @Parameter(name="type") String type, @Context UriInfo uriInfo) {
        AppUser user = this.context.authenticatedUser();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        Collection selfTemplateData = this.selfAccountTransferReadService.retrieveSelfAccountTemplateData(user);
        if (type.equals("tpt")) {
            Collection tptTemplateData = this.tptBeneficiaryReadPlatformService.retrieveTPTSelfAccountTemplateData(user);
            return this.toApiJsonSerializer.serialize(settings, (Object)new SelfAccountTransferData(selfTemplateData, tptTemplateData));
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)new SelfAccountTransferData(selfTemplateData, selfTemplateData));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create new Transfer", description="Ability to create new transfer of monetary funds from one account to another.\n\n\nExample Requests:\n\n self/accounttransfers/\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfAccountTransferApiResourceSwagger.PostNewTransferResponse.class)))})})
    public CommandProcessingResult create(@DefaultValue(value="") @QueryParam(value="type") @Parameter(name="type") String type, AccountTransferRequest accountTransferRequest) {
        String apiRequestBodyAsJson = this.toApiJsonSerializer.serialize((Object)accountTransferRequest);
        Map params = this.dataValidator.validateCreate(type, apiRequestBodyAsJson);
        if (type.equals("tpt")) {
            this.checkForLimits(params);
        }
        return this.accountTransfersApiResource.create(accountTransferRequest);
    }

    private void checkForLimits(Map<String, Object> params) {
        Long dailyTPTLimit;
        SelfAccountTemplateData fromAccount = (SelfAccountTemplateData)params.get("fromAccount");
        SelfAccountTemplateData toAccount = (SelfAccountTemplateData)params.get("toAccount");
        LocalDate transactionDate = (LocalDate)params.get("transactionDate");
        BigDecimal transactionAmount = (BigDecimal)params.get("transactionAmount");
        AppUser user = this.context.authenticatedUser();
        Long transferLimit = this.tptBeneficiaryReadPlatformService.getTransferLimit((Long)user.getId(), toAccount.getAccountId(), toAccount.getAccountType());
        if (transferLimit != null && transferLimit > 0L && transactionAmount.compareTo(new BigDecimal(transferLimit)) > 0) {
            throw new BeneficiaryTransferLimitExceededException();
        }
        if (this.configurationDomainService.isDailyTPTLimitEnabled() && (dailyTPTLimit = this.configurationDomainService.getDailyTPTLimit()) != null && dailyTPTLimit > 0L) {
            BigDecimal dailyTPTLimitBD = new BigDecimal(dailyTPTLimit);
            BigDecimal totTransactionAmount = this.accountTransfersReadPlatformService.getTotalTransactionAmount(fromAccount.getAccountId(), fromAccount.getAccountType(), transactionDate);
            if (totTransactionAmount != null && totTransactionAmount.compareTo(BigDecimal.ZERO) > 0 && (dailyTPTLimitBD.compareTo(totTransactionAmount) <= 0 || dailyTPTLimitBD.compareTo(totTransactionAmount.add(transactionAmount)) < 0)) {
                throw new DailyTPTTransactionAmountLimitExceededException(fromAccount.getAccountId(), fromAccount.getAccountType());
            }
        }
    }

    @Generated
    public SelfAccountTransferApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<SelfAccountTransferData> toApiJsonSerializer, AccountTransfersApiResource accountTransfersApiResource, SelfAccountTransferReadService selfAccountTransferReadService, ApiRequestParameterHelper apiRequestParameterHelper, SelfAccountTransferDataValidator dataValidator, SelfBeneficiariesTPTReadPlatformService tptBeneficiaryReadPlatformService, ConfigurationDomainService configurationDomainService, AccountTransfersReadPlatformService accountTransfersReadPlatformService) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.accountTransfersApiResource = accountTransfersApiResource;
        this.selfAccountTransferReadService = selfAccountTransferReadService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.dataValidator = dataValidator;
        this.tptBeneficiaryReadPlatformService = tptBeneficiaryReadPlatformService;
        this.configurationDomainService = configurationDomainService;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
    }
}

