/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.rate.api.RateRequest;
import org.apache.fineract.portfolio.rate.data.RateData;
import org.apache.fineract.portfolio.rate.service.RateReadService;
import org.springframework.stereotype.Component;

@Path(value="/v1/rates")
@Component
@Tag(name="Rate", description="")
public class RateApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "percentage", "productApply", "active"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "RATE";
    private final PlatformSecurityContext context;
    private final RateReadService readPlatformService;
    private final DefaultToApiJsonSerializer<RateData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="{rateId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RateData retrieveRate(@PathParam(value="rateId") Long rateId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveOne(rateId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult createRate(RateRequest rateRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createRate().withJson(this.toApiJsonSerializer.serialize((Object)rateRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<RateData> getAllRates() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveAllRates();
    }

    @PUT
    @Path(value="{rateId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult updateRate(@PathParam(value="rateId") Long rateId, RateRequest rateRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateRate(rateId).withJson(this.toApiJsonSerializer.serialize((Object)rateRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public RateApiResource(PlatformSecurityContext context, RateReadService readPlatformService, DefaultToApiJsonSerializer<RateData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

