/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.resilience4j.retry.annotation.Retry;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.cob.exceptions.AccountLockCannotBeOverruledException;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.configuration.service.TemporaryConfigurationServiceContainer;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAcceptTransferBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanChargebackTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCloseAsRescheduleBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCloseBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanDisbursalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanInitiateTransferBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanInterestRecalculationBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanReassignOfficerBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRejectTransferBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRemoveOfficerBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRescheduledDueCalendarChangeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUndoDisbursalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUndoLastDisbursalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUpdateDisbursementDataBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanWithdrawTransferBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeOffPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeOffPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanDisbursalTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestPaymentWaiverPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestPaymentWaiverPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanUndoChargeOffBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanUndoWrittenOffBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanWaiveInterestBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanWrittenOffPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanWrittenOffPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.holiday.service.HolidayUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.teller.data.CashierTransactionDataValidator;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.account.domain.AccountAssociations;
import org.apache.fineract.portfolio.account.domain.AccountAssociationsRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionPriority;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.exception.CalendarParameterUpdateNotSupportedException;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkDisbursalCommand;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkRepaymentCommand;
import org.apache.fineract.portfolio.collectionsheet.command.SingleDisbursalCommand;
import org.apache.fineract.portfolio.collectionsheet.command.SingleRepaymentCommand;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.command.LoanUpdateCommand;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.GLIMAccountInfoRepository;
import org.apache.fineract.portfolio.loanaccount.domain.GroupLoanIndividualMonitoringAccount;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallmentRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleProcessingWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanSubStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariations;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.exception.DateMismatchException;
import org.apache.fineract.portfolio.loanaccount.exception.ExceedingTrancheCountException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanStateTransitionException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTransactionTypeException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidPaidInAdvanceAmountException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanForeclosureException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanMultiDisbursementException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanOfficerAssignmentException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanOfficerUnassignmentException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataNotAllowedException;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataRequiredException;
import org.apache.fineract.portfolio.loanaccount.exception.UndoLastTrancheDisbursementException;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorDomainService;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModel;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModelPeriod;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanMapper;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanRescheduleRequest;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDownPaymentTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanOfficerValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanUpdateCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualTransactionBusinessEventService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDisbursementService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDownPaymentHandlerService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanOfficerService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentParameter;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentService;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.loanproduct.exception.LinkedAccountRequiredException;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecks;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecksRepository;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service.RepaymentWithPostDatedChecksAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class LoanWritePlatformServiceJpaRepositoryImpl
implements LoanWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final LoanTransactionValidator loanTransactionValidator;
    private final LoanUpdateCommandFromApiJsonDeserializer loanUpdateCommandFromApiJsonDeserializer;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanAccountDomainService loanAccountDomainService;
    private final NoteRepository noteRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanTransactionRelationRepository loanTransactionRelationRepository;
    private final LoanAssembler loanAssembler;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final HolidayRepositoryWrapper holidayRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final FromJsonHelper fromApiJsonHelper;
    private final CalendarRepository calendarRepository;
    private final LoanScheduleHistoryWritePlatformService loanScheduleHistoryWritePlatformService;
    private final LoanApplicationValidator loanApplicationValidator;
    private final AccountAssociationsRepository accountAssociationRepository;
    private final AccountTransferDetailRepository accountTransferDetailRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final GuarantorDomainService guarantorDomainService;
    private final LoanUtilService loanUtilService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final CashierTransactionDataValidator cashierTransactionDataValidator;
    private final GLIMAccountInfoRepository glimRepository;
    private final LoanRepository loanRepository;
    private final RepaymentWithPostDatedChecksAssembler repaymentWithPostDatedChecksAssembler;
    private final PostDatedChecksRepository postDatedChecksRepository;
    private final LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final LoanAccountLockService loanAccountLockService;
    private final ExternalIdFactory externalIdFactory;
    private final LoanAccrualTransactionBusinessEventService loanAccrualTransactionBusinessEventService;
    private final ErrorHandler errorHandler;
    private final LoanDownPaymentHandlerService loanDownPaymentHandlerService;
    private final LoanTransactionAssembler loanTransactionAssembler;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanOfficerValidator loanOfficerValidator;
    private final LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator;
    private final LoanDisbursementService loanDisbursementService;
    private final LoanScheduleService loanScheduleService;
    private final LoanChargeValidator loanChargeValidator;
    private final LoanOfficerService loanOfficerService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanAccountService loanAccountService;
    private final LoanJournalEntryPoster journalEntryPoster;
    private final LoanAdjustmentService loanAdjustmentService;
    private final LoanMapper loanMapper;
    private final LoanTransactionProcessingService loanTransactionProcessingService;
    private final LoanBalanceService loanBalanceService;
    private final LoanTransactionService loanTransactionService;

    @Transactional
    public CommandProcessingResult disburseGLIMLoan(Long loanId, JsonCommand command) {
        Long parentLoanId = loanId;
        GroupLoanIndividualMonitoringAccount parentLoan = (GroupLoanIndividualMonitoringAccount)this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        List childLoans = this.loanRepository.findByGlimId(loanId);
        CommandProcessingResult result = null;
        int count = 0;
        for (Loan loan : childLoans) {
            result = this.disburseLoan((Long)loan.getId(), command, Boolean.valueOf(false));
            if (result.getLoanId() == null || (long)(++count) != parentLoan.getChildAccountsCount()) continue;
            parentLoan.setLoanStatus(LoanStatus.ACTIVE.getValue());
            this.glimRepository.save((Object)parentLoan);
        }
        return result;
    }

    public CommandProcessingResult disburseLoan(Long loanId, JsonCommand command, Boolean isAccountTransfer) {
        return this.disburseLoan(loanId, command, isAccountTransfer, Boolean.valueOf(false));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public CommandProcessingResult disburseLoan(Long loanId, JsonCommand command, Boolean isAccountTransfer, Boolean isWithoutAutoPayment) {
        void var20_27;
        List<LoanDisbursementDetails> filteredList;
        this.loanTransactionValidator.validateDisbursement(command, isAccountTransfer.booleanValue(), loanId);
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (loan.loanProduct().isDisallowExpectedDisbursements() && (filteredList = loan.getDisbursementDetails().stream().filter(disbursementDetails -> disbursementDetails.actualDisbursementDate() == null).toList()).isEmpty()) {
            LocalDate artificialExpectedDate = loan.getExpectedDisbursedOnLocalDate();
            LoanDisbursementDetails disbursementDetail = new LoanDisbursementDetails(artificialExpectedDate, null, loan.getDisbursedAmount(), null, false);
            disbursementDetail.updateLoan(loan);
            loan.getAllDisbursementDetails().add(disbursementDetail);
        }
        LocalDate nextPossibleRepaymentDate = loan.getNextPossibleRepaymentDateForRescheduling();
        LocalDate rescheduledRepaymentDate = command.localDateValueOfParameterNamed("adjustRepaymentDate");
        LocalDate actualDisbursementDate = command.localDateValueOfParameterNamed("actualDisbursementDate");
        if (!loan.isMultiDisburmentLoan()) {
            loan.setActualDisbursementDate(actualDisbursementDate);
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanDisbursalBusinessEvent(loan));
        AppUser currentUser = this.getAppUserIfPresent();
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        if (paymentDetail != null && paymentDetail.getPaymentType() != null && paymentDetail.getPaymentType().getIsCashPayment().booleanValue()) {
            BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
            this.cashierTransactionDataValidator.validateOnLoanDisbursal(currentUser, loan.getCurrencyCode(), transactionAmount);
        }
        boolean isPaymentTypeApplicableForDisbursementCharge = this.configurationDomainService.isPaymentTypeApplicableForDisbursementCharge();
        this.updateLoanCounters(loan, actualDisbursementDate);
        Money amountBeforeAdjust = loan.getPrincipal();
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        if (this.canDisburse(loan)) {
            boolean bl;
            BigDecimal netDisbursalAmount = command.bigDecimalValueOfParameterNamed("netDisbursalAmount");
            if (netDisbursalAmount != null) {
                loan.setNetDisbursalAmount(netDisbursalAmount);
            }
            Money disburseAmount = this.loanDisbursementService.adjustDisburseAmount(loan, command, actualDisbursementDate);
            Object amountToDisburse = disburseAmount.copy();
            boolean bl2 = amountBeforeAdjust.isNotEqualTo(loan.getPrincipal());
            ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
            if (loan.isTopup() && loan.getClientId() != null) {
                BigDecimal loanOutstanding = this.loanApplicationValidator.validateTopupLoan(loan, actualDisbursementDate);
                amountToDisburse = disburseAmount.minus(loanOutstanding);
                this.disburseLoanToLoan(loan, command, loanOutstanding);
            }
            LoanTransaction disbursementTransaction = null;
            if (isAccountTransfer.booleanValue()) {
                this.disburseLoanToSavings(loan, command, (Money)amountToDisburse, paymentDetail);
            } else {
                disbursementTransaction = LoanTransaction.disbursement((Loan)loan, (Money)amountToDisburse, (PaymentDetail)paymentDetail, (LocalDate)actualDisbursementDate, (ExternalId)txnExternalId, (Money)loan.getTotalOverpaidAsMoney());
                disbursementTransaction.updateLoan(loan);
                loan.addLoanTransaction(disbursementTransaction);
                this.loanTransactionRepository.saveAndFlush((Object)disbursementTransaction);
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(disbursementTransaction, false, false);
            }
            if (loan.getRepaymentScheduleInstallments().isEmpty()) {
                bl = true;
            }
            this.regenerateScheduleOnDisbursement(command, loan, bl, scheduleGeneratorDTO, nextPossibleRepaymentDate, rescheduledRepaymentDate);
            boolean downPaymentEnabled = loan.getLoanProductRelatedDetail().isEnableDownPayment();
            if (loan.isInterestBearingAndInterestRecalculationEnabled() || downPaymentEnabled) {
                this.createAndSaveLoanScheduleArchive(loan, scheduleGeneratorDTO);
            }
            this.disburseLoan(command, isPaymentTypeApplicableForDisbursementCharge, paymentDetail, loan, currentUser, changes, scheduleGeneratorDTO);
            loan.adjustNetDisbursalAmount(amountToDisburse.getAmount());
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            LocalDate firstInstallmentDueDate = loan.fetchRepaymentScheduleInstallment(Integer.valueOf(1)).getDueDate();
            if (loan.isInterestBearingAndInterestRecalculationEnabled() && (DateUtils.isBeforeBusinessDate((LocalDate)firstInstallmentDueDate) || loan.isDisbursementMissed())) {
                this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
            }
            if (loan.isAutoRepaymentForDownPaymentEnabled() && !isWithoutAutoPayment.booleanValue()) {
                if (isAccountTransfer.booleanValue() && loan.shouldCreateStandingInstructionAtDisbursement().booleanValue()) {
                    PortfolioAccountData linkedSavingsAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(loanId);
                    SavingsAccount fromSavingsAccount = null;
                    boolean isRegularTransaction = true;
                    boolean isExceptionForBalanceCheck = false;
                    BigDecimal disbursedAmountPercentageForDownPayment = loan.getLoanRepaymentScheduleDetail().getDisbursedAmountPercentageForDownPayment();
                    Money downPaymentMoney = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.percentageOf((BigDecimal)amountToDisburse.getAmount(), (BigDecimal)disbursedAmountPercentageForDownPayment, (int)19));
                    if (loan.getLoanProductRelatedDetail().getInstallmentAmountInMultiplesOf() != null) {
                        downPaymentMoney = Money.roundToMultiplesOf((Money)downPaymentMoney, (Integer)loan.getLoanProductRelatedDetail().getInstallmentAmountInMultiplesOf());
                    }
                    AccountTransferDTO accountTransferDTO = new AccountTransferDTO(actualDisbursementDate, downPaymentMoney.getAmount(), PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, linkedSavingsAccountData.getId(), (Long)loan.getId(), "To loan " + loan.getAccountNumber() + " from savings " + linkedSavingsAccountData.getAccountNo() + " Standing instruction transfer ", locale, fmt, null, null, LoanTransactionType.DOWN_PAYMENT.getValue(), null, null, AccountTransferType.LOAN_DOWN_PAYMENT.getValue(), null, null, ExternalId.empty(), null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
                    this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
                } else {
                    this.loanDownPaymentHandlerService.handleDownPayment(scheduleGeneratorDTO, command, disbursementTransaction, loan);
                    this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
                    if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                        this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
                    }
                }
            }
        }
        if (!changes.isEmpty()) {
            loan.updateLoanScheduleDependentDerivedFields();
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.createNote(loan, command, changes);
            this.createStandingInstruction(loan);
        }
        Set loanCharges = loan.getActiveCharges();
        HashMap<Long, BigDecimal> disBuLoanCharges = new HashMap<Long, BigDecimal>();
        for (LoanCharge loanCharge : loanCharges) {
            if (!loanCharge.isDueAtDisbursement() || !loanCharge.getChargePaymentMode().isPaymentModeAccountTransfer() || !loanCharge.isChargePending()) continue;
            disBuLoanCharges.put((Long)loanCharge.getId(), loanCharge.amountOutstanding());
        }
        for (Map.Entry entry : disBuLoanCharges.entrySet()) {
            PortfolioAccountData savingAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(loanId);
            SavingsAccount fromSavingsAccount = null;
            boolean isRegularTransaction = true;
            boolean isExceptionForBalanceCheck = false;
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(actualDisbursementDate, (BigDecimal)entry.getValue(), PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, savingAccountData.getId(), loanId, "Loan Charge Payment", locale, fmt, null, null, LoanTransactionType.REPAYMENT_AT_DISBURSEMENT.getValue(), (Long)entry.getKey(), null, AccountTransferType.CHARGE_PAYMENT.getValue(), null, null, ExternalId.empty(), null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
        }
        this.updateRecurringCalendarDatesForInterestRecalculation(loan);
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        if (command.parameterExists("postDatedChecks")) {
            Set postDatedChecks = this.repaymentWithPostDatedChecksAssembler.fromParsedJson(command.json(), loan);
            this.updatePostDatedChecks(postDatedChecks);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDisbursalBusinessEvent(loan));
        Long disbursalTransactionId = null;
        Object var20_25 = null;
        if (!isAccountTransfer.booleanValue()) {
            LoanTransaction disbursalTransaction = Lists.reverse((List)loan.getLoanTransactions()).stream().filter(e -> LoanTransactionType.DISBURSEMENT.equals((Object)e.getTypeOf())).findFirst().orElseThrow();
            disbursalTransactionId = (Long)disbursalTransaction.getId();
            ExternalId externalId = disbursalTransaction.getExternalId();
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDisbursalTransactionBusinessEvent(disbursalTransaction));
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withSubEntityId(disbursalTransactionId).withSubEntityExternalId((ExternalId)var20_27).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    private void createNote(Loan loan, JsonCommand command, Map<String, Object> changes) {
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanNote((Loan)loan, (String)noteText);
            this.noteRepository.save((Object)note);
        }
    }

    private void disburseLoan(JsonCommand command, boolean isPaymentTypeApplicableForDisbursementCharge, PaymentDetail paymentDetail, Loan loan, AppUser currentUser, Map<String, Object> changes, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        PaymentDetail paymentDetail1 = isPaymentTypeApplicableForDisbursementCharge ? paymentDetail : null;
        LocalDate actualDisbursementDate1 = command.localDateValueOfParameterNamed("actualDisbursementDate");
        loan.setDisbursedBy(currentUser);
        loan.updateLoanScheduleDependentDerivedFields();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("actualDisbursementDate", command.stringValueOfParameterNamed("actualDisbursementDate"));
        boolean disbursementMissedParam = loan.isDisbursementMissed();
        LocalDate firstInstallmentDueDate = loan.fetchRepaymentScheduleInstallment(Integer.valueOf(1)).getDueDate();
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled() && (DateUtils.isBeforeBusinessDate((LocalDate)firstInstallmentDueDate) || disbursementMissedParam)) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        loan.updateSummaryWithTotalFeeChargesDueAtDisbursement(loan.deriveSumTotalOfChargesDueAtDisbursement());
        loan.updateLoanRepaymentPeriodsDerivedFields(actualDisbursementDate1);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_DISBURSED, actualDisbursementDate1);
        this.loanDisbursementService.handleDisbursementTransaction(loan, actualDisbursementDate1, paymentDetail1);
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        Money interestApplied = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)loan.getSummary().getTotalInterestCharged());
        if ((loan.isMultiDisburmentLoan() && loan.getDisbursedLoanDisbursementDetails().size() == 1 || !loan.isMultiDisburmentLoan()) && loan.isNoneOrCashOrUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue() && interestApplied.isGreaterThanZero()) {
            ExternalId externalId = ExternalId.empty();
            if (TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
                externalId = ExternalId.generate();
            }
            LoanTransaction interestAppliedTransaction = LoanTransaction.accrueInterest((Office)loan.getOffice(), (Loan)loan, (Money)interestApplied, (LocalDate)actualDisbursementDate1, (ExternalId)externalId);
            loan.addLoanTransaction(interestAppliedTransaction);
            this.loanTransactionRepository.saveAndFlush((Object)interestAppliedTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(interestAppliedTransaction, false, false);
        }
        if (loan.getLoanProduct().isMultiDisburseLoan() || loan.isProgressiveSchedule()) {
            List allNonContraTransactionsPostDisbursement = this.loanTransactionRepository.findNonReversedTransactionsForReprocessingByLoan(loan);
            if (!allNonContraTransactionsPostDisbursement.isEmpty()) {
                this.reprocessLoanTransactionsService.reprocessTransactions(loan);
            }
            this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        }
        this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_DISBURSED, loan);
        changes.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
    }

    private void updatePostDatedChecks(Set<PostDatedChecks> postDatedChecks) {
        this.postDatedChecksRepository.saveAll(postDatedChecks);
    }

    private void createAndSaveLoanScheduleArchive(Loan loan, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        LoanRescheduleRequest loanRescheduleRequest = null;
        LoanScheduleModel loanScheduleModel = this.loanMapper.regenerateScheduleModel(scheduleGeneratorDTO, loan);
        List installments = this.retrieveRepaymentScheduleFromModel(loanScheduleModel);
        this.loanScheduleHistoryWritePlatformService.createAndSaveLoanScheduleArchive(installments, loan, loanRescheduleRequest);
    }

    private void createStandingInstruction(Loan loan) {
        AccountAssociations accountAssociations;
        if (loan.shouldCreateStandingInstructionAtDisbursement().booleanValue() && (accountAssociations = this.accountAssociationRepository.findByLoanIdAndType((Long)loan.getId(), AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue())) != null) {
            SavingsAccount linkedSavingsAccount = accountAssociations.linkedSavingsAccount();
            String name = "To loan " + loan.getAccountNumber() + " from savings " + linkedSavingsAccount.getAccountNumber();
            Office fromOffice = loan.getOffice();
            Client fromClient = loan.getClient();
            Office toOffice = loan.getOffice();
            Client toClient = loan.getClient();
            Integer priority = StandingInstructionPriority.MEDIUM.getValue();
            Integer transferType = AccountTransferType.LOAN_REPAYMENT.getValue();
            Integer instructionType = StandingInstructionType.DUES.getValue();
            Integer status = StandingInstructionStatus.ACTIVE.getValue();
            Integer recurrenceType = AccountTransferRecurrenceType.AS_PER_DUES.getValue();
            LocalDate validFrom = DateUtils.getBusinessLocalDate();
            AccountTransferDetails accountTransferDetails = AccountTransferDetails.savingsToLoanTransfer((Office)fromOffice, (Client)fromClient, (SavingsAccount)linkedSavingsAccount, (Office)toOffice, (Client)toClient, (Loan)loan, (Integer)transferType);
            AccountTransferStandingInstruction accountTransferStandingInstruction = AccountTransferStandingInstruction.create((AccountTransferDetails)accountTransferDetails, (String)name, (Integer)priority, (Integer)instructionType, (Integer)status, null, (LocalDate)validFrom, null, (Integer)recurrenceType, null, null, null);
            accountTransferDetails.updateAccountTransferStandingInstruction(accountTransferStandingInstruction);
            this.accountTransferDetailRepository.save((Object)accountTransferDetails);
        }
    }

    private void updateRecurringCalendarDatesForInterestRecalculation(Loan loan) {
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && loan.loanInterestRecalculationDetails().getRestFrequencyType().isSameAsRepayment()) {
            CalendarInstance calendarInstanceForInterestRecalculation = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(loan.loanInterestRecalculationDetailId(), CalendarEntityType.LOAN_RECALCULATION_REST_DETAIL.getValue(), CalendarType.COLLECTION.getValue());
            Calendar calendarForInterestRecalculation = calendarInstanceForInterestRecalculation.getCalendar();
            calendarForInterestRecalculation.updateStartAndEndDate(loan.getDisbursementDate(), loan.getMaturityDate());
            this.calendarRepository.save((Object)calendarForInterestRecalculation);
        }
    }

    private Loan saveAndFlushLoanWithDataIntegrityViolationChecks(Loan loan) {
        try {
            this.loanRepaymentScheduleInstallmentRepository.saveAll((Iterable)loan.getRepaymentScheduleInstallments());
            return this.loanRepositoryWrapper.saveAndFlush(loan);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            Throwable realCause = e.getCause();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
            if (realCause.getMessage().toLowerCase().contains("external_id_unique")) {
                baseDataValidator.reset().parameter("externalId").failWithCode("value.must.be.unique", new Object[0]);
            }
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, e);
            }
            throw e;
        }
    }

    private void saveLoanWithDataIntegrityViolationChecks(Loan loan) {
        block3: {
            try {
                this.loanRepositoryWrapper.save(loan);
            }
            catch (DataIntegrityViolationException | JpaSystemException e) {
                Throwable realCause = e.getCause();
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
                if (realCause.getMessage().toLowerCase().contains("external_id_unique")) {
                    baseDataValidator.reset().parameter("externalId").failWithCode("value.must.be.unique", new Object[0]);
                }
                if (dataValidationErrors.isEmpty()) break block3;
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, e);
            }
        }
    }

    @Transactional
    public Map<String, Object> bulkLoanDisbursal(JsonCommand command, CollectionSheetBulkDisbursalCommand bulkDisbursalCommand, Boolean isAccountTransfer) {
        AppUser currentUser = this.getAppUserIfPresent();
        SingleDisbursalCommand[] disbursalCommand = bulkDisbursalCommand.getDisburseTransactions();
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        if (disbursalCommand == null) {
            return changes;
        }
        LocalDate nextPossibleRepaymentDate = null;
        LocalDate rescheduledRepaymentDate = null;
        for (SingleDisbursalCommand singleLoanDisbursalCommand : disbursalCommand) {
            Loan loan = this.loanAssembler.assembleFrom(singleLoanDisbursalCommand.getLoanId());
            LocalDate actualDisbursementDate = command.localDateValueOfParameterNamed("actualDisbursementDate");
            LoanProduct loanProduct = loan.loanProduct();
            if (loanProduct.isSyncExpectedWithDisbursementDate()) {
                this.syncExpectedDateWithActualDisbursementDate(loan, actualDisbursementDate);
            }
            this.checkClientOrGroupActive(loan);
            this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanDisbursalBusinessEvent(loan));
            PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
            this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_DISBURSED);
            this.updateLoanCounters(loan, actualDisbursementDate);
            if (this.canDisburse(loan)) {
                Money amountBeforeAdjust = loan.getPrincipal();
                Money disburseAmount = this.loanDisbursementService.adjustDisburseAmount(loan, command, actualDisbursementDate);
                boolean recalculateSchedule = amountBeforeAdjust.isNotEqualTo(loan.getPrincipal());
                ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
                if (isAccountTransfer.booleanValue()) {
                    this.disburseLoanToSavings(loan, command, disburseAmount, paymentDetail);
                } else {
                    LoanTransaction disbursementTransaction = LoanTransaction.disbursement((Loan)loan, (Money)disburseAmount, (PaymentDetail)paymentDetail, (LocalDate)actualDisbursementDate, (ExternalId)txnExternalId, (Money)loan.getTotalOverpaidAsMoney());
                    disbursementTransaction.updateLoan(loan);
                    loan.addLoanTransaction(disbursementTransaction);
                    this.loanTransactionRepository.saveAndFlush((Object)disbursementTransaction);
                    this.journalEntryPoster.postJournalEntriesForLoanTransaction(disbursementTransaction, false, false);
                    this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDisbursalTransactionBusinessEvent(disbursementTransaction));
                }
                LocalDate recalculateFrom = null;
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
                this.regenerateScheduleOnDisbursement(command, loan, recalculateSchedule, scheduleGeneratorDTO, nextPossibleRepaymentDate, rescheduledRepaymentDate);
                boolean downPaymentEnabled = loan.getLoanProductRelatedDetail().isEnableDownPayment();
                if (loan.isInterestBearingAndInterestRecalculationEnabled() || downPaymentEnabled) {
                    this.createAndSaveLoanScheduleArchive(loan, scheduleGeneratorDTO);
                }
                this.disburseLoan(command, this.configurationDomainService.isPaymentTypeApplicableForDisbursementCharge(), paymentDetail, loan, currentUser, changes, scheduleGeneratorDTO);
                this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
                LocalDate firstInstallmentDueDate = loan.fetchRepaymentScheduleInstallment(Integer.valueOf(1)).getDueDate();
                if (loan.isInterestBearingAndInterestRecalculationEnabled() && (DateUtils.isBeforeBusinessDate((LocalDate)firstInstallmentDueDate) || loan.isDisbursementMissed())) {
                    this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
                }
            }
            if (!changes.isEmpty()) {
                this.createNote(loan, command, changes);
                loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            }
            Set loanCharges = loan.getActiveCharges();
            HashMap<Long, BigDecimal> disBuLoanCharges = new HashMap<Long, BigDecimal>();
            for (LoanCharge loanCharge : loanCharges) {
                if (!loanCharge.isDueAtDisbursement() || !loanCharge.getChargePaymentMode().isPaymentModeAccountTransfer() || !loanCharge.isChargePending()) continue;
                disBuLoanCharges.put((Long)loanCharge.getId(), loanCharge.amountOutstanding());
            }
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            for (Map.Entry entrySet : disBuLoanCharges.entrySet()) {
                PortfolioAccountData savingAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation((Long)loan.getId());
                SavingsAccount fromSavingsAccount = null;
                boolean isRegularTransaction = true;
                boolean isExceptionForBalanceCheck = false;
                AccountTransferDTO accountTransferDTO = new AccountTransferDTO(actualDisbursementDate, (BigDecimal)entrySet.getValue(), PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, savingAccountData.getId(), (Long)loan.getId(), "Loan Charge Payment", locale, fmt, null, null, LoanTransactionType.REPAYMENT_AT_DISBURSEMENT.getValue(), (Long)entrySet.getKey(), null, AccountTransferType.CHARGE_PAYMENT.getValue(), null, null, ExternalId.empty(), null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
                this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            }
            this.updateRecurringCalendarDatesForInterestRecalculation(loan);
            this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
            this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDisbursalBusinessEvent(loan));
        }
        return changes;
    }

    @Transactional
    public CommandProcessingResult undoGLIMLoanDisbursal(Long loanId, JsonCommand command) {
        Long parentLoanId = loanId;
        GroupLoanIndividualMonitoringAccount parentLoan = (GroupLoanIndividualMonitoringAccount)this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        List childLoans = this.loanRepository.findByGlimId(loanId);
        CommandProcessingResult result = null;
        int count = 0;
        for (Loan loan : childLoans) {
            result = this.undoLoanDisbursal((Long)loan.getId(), command);
            if (result.getLoanId() == null || (long)(++count) != parentLoan.getChildAccountsCount()) continue;
            parentLoan.setLoanStatus(LoanStatus.APPROVED.getValue());
            this.glimRepository.save((Object)parentLoan);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult undoLoanDisbursal(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Undo Loan: " + loanId + " disbursement is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUndoDisbursalBusinessEvent(loan));
        this.removeLoanCycle(loan);
        LocalDate recalculateFrom = null;
        loan.setActualDisbursementDate(null);
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        loan.removePostDatedChecks();
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_DISBURSAL_UNDO);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_DISBURSAL_UNDO, loan.getDisbursementDate());
        Map changes = this.undoDisbursal(loan, scheduleGeneratorDTO);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (!changes.isEmpty()) {
            if (loan.isTopup() && loan.getClientId() != null) {
                Long loanIdToClose = loan.getTopupLoanDetails().getLoanIdToClose();
                LocalDate expectedDisbursementDate = command.localDateValueOfParameterNamed("expectedDisbursementDate");
                BigDecimal loanOutstanding = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.REPAYMENT, loanIdToClose, expectedDisbursementDate).getAmount();
                BigDecimal netDisbursalAmount = loan.getApprovedPrincipal().subtract(loanOutstanding);
                loan.adjustNetDisbursalAmount(netDisbursalAmount);
            }
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.accountTransfersWritePlatformService.reverseAllTransactions(loanId, PortfolioAccountType.LOAN);
            this.createNote(loan, command, changes);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoDisbursalBusinessEvent(loan));
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public CommandProcessingResult makeGLIMLoanRepayment(Long loanId, JsonCommand command) {
        Long parentLoanId = loanId;
        this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        JsonArray repayments = command.arrayOfParameterNamed("formDataArray");
        CommandProcessingResult result = null;
        Long[] childLoanId = new Long[repayments.size()];
        for (int i = 0; i < repayments.size(); ++i) {
            JsonObject jsonObject = repayments.get(i).getAsJsonObject();
            log.debug("{}", (Object)jsonObject.toString());
            childLoanId[i] = jsonObject.get("loanId").getAsLong();
        }
        int j = 0;
        for (JsonElement element : repayments) {
            JsonCommand childCommand = JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)element);
            result = this.makeLoanRepayment(LoanTransactionType.REPAYMENT, childLoanId[j++], childCommand, false);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult makeLoanRepayment(LoanTransactionType repaymentTransactionType, Long loanId, JsonCommand command, boolean isRecoveryRepayment) {
        String chargeRefundChargeType = null;
        return this.makeLoanRepaymentWithChargeRefundChargeType(repaymentTransactionType, loanId, command, isRecoveryRepayment, chargeRefundChargeType);
    }

    private void recalculateLoanWithInterestPaymentWaiverTxn(Loan loan, LoanTransaction newInterestPaymentWaiverTransaction) {
        LocalDate recalculateFrom = null;
        LocalDate transactionDate = newInterestPaymentWaiverTransaction.getTransactionDate();
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = transactionDate;
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom, null);
        newInterestPaymentWaiverTransaction.updateLoan(loan);
        boolean isTransactionChronologicallyLatest = this.loanTransactionService.isChronologicallyLatestRepaymentOrWaiver(loan, newInterestPaymentWaiverTransaction);
        LoanRepaymentScheduleInstallment currentInstallment = loan.fetchLoanRepaymentScheduleInstallmentByDueDate(transactionDate);
        boolean reprocess = true;
        if (!loan.isForeclosure() && isTransactionChronologicallyLatest && DateUtils.isEqualBusinessDate((LocalDate)transactionDate) && currentInstallment != null && currentInstallment.getTotalOutstanding(loan.getCurrency()).isEqualTo(newInterestPaymentWaiverTransaction.getAmount(loan.getCurrency()))) {
            reprocess = false;
        }
        if (!(!isTransactionChronologicallyLatest || reprocess && loan.isInterestBearingAndInterestRecalculationEnabled() || loan.isForeclosure())) {
            this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), newInterestPaymentWaiverTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
            reprocess = false;
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                if (currentInstallment == null || currentInstallment.isNotFullyPaidOff()) {
                    reprocess = true;
                } else {
                    LoanRepaymentScheduleInstallment nextInstallment = loan.fetchRepaymentScheduleInstallment(Integer.valueOf(currentInstallment.getInstallmentNumber() + 1));
                    if (nextInstallment != null && nextInstallment.getTotalPaidInAdvance(loan.getCurrency()).isGreaterThanZero()) {
                        reprocess = true;
                    }
                }
            }
            if (!reprocess) {
                loan.addLoanTransaction(newInterestPaymentWaiverTransaction);
            }
        }
        if (reprocess) {
            this.reprocessChangedLoanTransactions(loan, newInterestPaymentWaiverTransaction, scheduleGeneratorDTO);
        }
        this.loanLifecycleStateMachine.determineAndTransition(loan, newInterestPaymentWaiverTransaction.getTransactionDate());
    }

    private void reprocessChangedLoanTransactions(Loan loan, LoanTransaction newInterestPaymentWaiverTransaction, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else if (loan.isProgressiveSchedule()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        loan.addLoanTransaction(newInterestPaymentWaiverTransaction);
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
    }

    @Transactional
    public CommandProcessingResult makeInterestPaymentWaiver(JsonCommand command) {
        this.loanTransactionValidator.validateLoanTransactionInterestPaymentWaiver(command);
        Long loanId = command.getLoanId();
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionInterestPaymentWaiverPreBusinessEvent(loan));
        String noteText = command.stringValueOfParameterNamed("note");
        LinkedHashMap changes = new LinkedHashMap();
        LoanTransaction newInterestPaymentWaiverTransaction = this.loanTransactionAssembler.assembleTransactionAndCalculateChanges(loan, command, changes);
        this.recalculateLoanWithInterestPaymentWaiverTxn(loan, newInterestPaymentWaiverTransaction);
        this.loanTransactionValidator.validateLoanTransactionInterestPaymentWaiverAfterRecalculation(loan);
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newInterestPaymentWaiverTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newInterestPaymentWaiverTransaction, false, false);
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        this.saveNote(noteText, loan, newInterestPaymentWaiverTransaction);
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, newInterestPaymentWaiverTransaction.getTransactionDate());
        this.loanAccountDomainService.disableStandingInstructionsLinkedToClosedLoan(loan);
        this.loanAccountDomainService.updateAndSavePostDatedChecksForIndividualAccount(loan, newInterestPaymentWaiverTransaction);
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, newInterestPaymentWaiverTransaction);
        LoanTransactionInterestPaymentWaiverPostBusinessEvent transactionRepaymentEvent = new LoanTransactionInterestPaymentWaiverPostBusinessEvent(newInterestPaymentWaiverTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)transactionRepaymentEvent);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId((Long)loan.getId()).withEntityId((Long)newInterestPaymentWaiverTransaction.getId()).withEntityExternalId(newInterestPaymentWaiverTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).with(changes).build();
    }

    private void saveNote(String noteText, Loan loan, LoanTransaction loanTransaction) {
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)loanTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
    }

    @Transactional
    public CommandProcessingResult makeLoanRepaymentWithChargeRefundChargeType(LoanTransactionType repaymentTransactionType, Long loanId, JsonCommand command, boolean isRecoveryRepayment, String chargeRefundChargeType) {
        this.loanUtilService.validateRepaymentTransactionType(repaymentTransactionType);
        this.loanTransactionValidator.validateNewRepaymentTransaction(command.json());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("paymentTypeId", command.longValueOfParameterNamed("paymentTypeId"));
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        if (!txnExternalId.isEmpty()) {
            changes.put("externalId", txnExternalId);
        }
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        Boolean isHolidayValidationDone = false;
        HolidayDetailDTO holidayDetailDto = null;
        boolean isAccountTransfer = false;
        LoanTransaction loanTransaction = this.loanAccountDomainService.makeRepayment(repaymentTransactionType, loan, transactionDate, transactionAmount, paymentDetail, noteText, txnExternalId, isRecoveryRepayment, chargeRefundChargeType, isAccountTransfer, holidayDetailDto, isHolidayValidationDone);
        loan = loanTransaction.getLoan();
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, loanTransaction);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId((Long)loan.getId()).withEntityId((Long)loanTransaction.getId()).withEntityExternalId(loanTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).with(changes).build();
    }

    @Transactional
    public Map<String, Object> makeLoanBulkRepayment(CollectionSheetBulkRepaymentCommand bulkRepaymentCommand) {
        Loan loan;
        SingleRepaymentCommand[] repaymentCommand = bulkRepaymentCommand.getLoanTransactions();
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        boolean isRecoveryRepayment = false;
        if (repaymentCommand == null) {
            return changes;
        }
        ArrayList<Long> transactionIds = new ArrayList<Long>();
        boolean isAccountTransfer = false;
        HolidayDetailDTO holidayDetailDTO = null;
        boolean isHolidayValidationDone = false;
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        for (SingleRepaymentCommand singleLoanRepaymentCommand : repaymentCommand) {
            if (singleLoanRepaymentCommand == null) continue;
            loan = this.loanAssembler.assembleFrom(singleLoanRepaymentCommand.getLoanId());
            List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), singleLoanRepaymentCommand.getTransactionDate());
            WorkingDays workingDays = this.workingDaysRepository.findOne();
            boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
            boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
            holidayDetailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays, allowTransactionsOnHoliday, allowTransactionsOnNonWorkingDay);
            this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(singleLoanRepaymentCommand.getTransactionDate(), holidayDetailDTO.isAllowTransactionsOnHoliday(), holidayDetailDTO.getHolidays());
            this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(singleLoanRepaymentCommand.getTransactionDate(), holidayDetailDTO.getWorkingDays(), holidayDetailDTO.isAllowTransactionsOnNonWorkingDay());
            isHolidayValidationDone = true;
            break;
        }
        for (SingleRepaymentCommand singleLoanRepaymentCommand : repaymentCommand) {
            if (singleLoanRepaymentCommand == null) continue;
            loan = this.loanAssembler.assembleFrom(singleLoanRepaymentCommand.getLoanId());
            PaymentDetail paymentDetail = singleLoanRepaymentCommand.getPaymentDetail();
            ExternalId externalId = singleLoanRepaymentCommand.getExternalId();
            if (externalId.isEmpty() && this.configurationDomainService.isExternalIdAutoGenerationEnabled()) {
                externalId = ExternalId.generate();
            }
            if (paymentDetail != null && paymentDetail.getId() == null) {
                this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
            }
            String chargeRefundChargeType = null;
            LoanTransaction loanTransaction = this.loanAccountDomainService.makeRepayment(LoanTransactionType.REPAYMENT, loan, bulkRepaymentCommand.getTransactionDate(), singleLoanRepaymentCommand.getTransactionAmount(), paymentDetail, bulkRepaymentCommand.getNote(), externalId, false, chargeRefundChargeType, isAccountTransfer, holidayDetailDTO, Boolean.valueOf(isHolidayValidationDone));
            transactionIds.add((Long)loanTransaction.getId());
        }
        changes.put("loanTransactions", transactionIds);
        return changes;
    }

    @Transactional
    public CommandProcessingResult adjustLoanTransaction(Long loanId, Long transactionId, JsonCommand command) {
        boolean isAdjustCommand;
        this.loanTransactionValidator.validateTransaction(command.json());
        LoanTransaction transactionToAdjust = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(command.entityId(), command.getLoanId()).orElseThrow(() -> new LoanTransactionNotFoundException(command.entityId(), command.getLoanId()));
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (loan.getStatus().isClosed() && loan.getLoanSubStatus() != null && loan.getLoanSubStatus().equals((Object)LoanSubStatus.FORECLOSED)) {
            String defaultUserMessage = "The loan cannot reopened as it is foreclosed.";
            throw new LoanForeclosureException("loan.cannot.be.reopened.as.it.is.foreclosured", "The loan cannot reopened as it is foreclosed.", new Object[]{loanId});
        }
        this.checkClientOrGroupActive(loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(new LoanAdjustTransactionBusinessEvent.Data(transactionToAdjust)));
        if (this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.LOAN)) {
            throw new PlatformServiceUnavailableException("error.msg.loan.transfer.transaction.update.not.allowed", "Loan transaction: " + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        if (loan.isClosedWrittenOff()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.written.off.update.not.allowed", "Loan transaction: " + transactionId + " update not allowed as loan status is written off", new Object[]{transactionId});
        }
        if (transactionToAdjust.hasChargebackLoanTransactionRelations()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.transaction.update.not.allowed", "Loan transaction: " + transactionId + " update not allowed as loan transaction is linked to other transactions", new Object[]{transactionId});
        }
        if (transactionToAdjust.isInterestRefund()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.update.not.allowed", "Interest refund transaction: " + transactionId + " cannot be reversed or adjusted directly", new Object[]{transactionId});
        }
        Long commandId = command.commandId();
        String noteText = command.stringValueOfParameterNamed("note");
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        boolean bl = isAdjustCommand = transactionAmount.compareTo(BigDecimal.ZERO) > 0;
        if (isAdjustCommand && !transactionToAdjust.isEditable()) {
            String errorMessage = "Loan transaction: " + transactionId + " update not allowed as loan transaction is a " + transactionToAdjust.getTypeOf().getCode();
            throw new InvalidLoanTransactionTypeException("transaction", "error.msg.loan.transaction.update.not.allowed", errorMessage, new Object[0]);
        }
        String reversalExternalId = command.stringValueOfParameterNamedAllowingNull("reversalExternalId");
        ExternalId reversalTxnExternalId = ExternalIdFactory.produce((String)reversalExternalId);
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("paymentTypeId", command.longValueOfParameterNamed("paymentTypeId"));
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createPaymentDetail(command, changes);
        LoanAdjustmentParameter parameter = LoanAdjustmentParameter.builder().transactionAmount(transactionAmount).paymentDetail(paymentDetail).transactionDate(transactionDate).txnExternalId(txnExternalId).reversalTxnExternalId(reversalTxnExternalId).noteText(noteText).build();
        return this.loanAdjustmentService.adjustLoanTransaction(loan, transactionToAdjust, parameter, commandId, changes);
    }

    @Transactional
    public CommandProcessingResult chargebackLoanTransaction(Long loanId, Long transactionId, JsonCommand command) {
        this.loanTransactionValidator.validateChargebackTransaction(command.json());
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(command.entityId(), command.getLoanId()).orElseThrow(() -> new LoanTransactionNotFoundException(command.entityId(), command.getLoanId()));
        if (loanTransaction.isReversed()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.chargeback.operation.not.allowed", "Loan transaction:" + transactionId + " chargeback not allowed as loan transaction repayment is reversed", new Object[]{transactionId});
        }
        if (!loanTransaction.isTypeAllowedForChargeback()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.chargeback.operation.not.allowed", "Loan transaction:" + transactionId + " chargeback not allowed for loan transaction type, its type is " + loanTransaction.getTypeOf().getCode(), new Object[]{transactionId});
        }
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.LOAN)) {
            throw new PlatformServiceUnavailableException("error.msg.loan.transfer.transaction.update.not.allowed", "Loan transaction:" + transactionId + " chargeback not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        if (loan.isClosedWrittenOff()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.chargeback.operation.not.allowed", "Loan transaction:" + transactionId + " chargeback not allowed as loan status is written off", new Object[]{transactionId});
        }
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && !loan.isProgressiveSchedule()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.chargeback.operation.not.allowed", "Loan transaction:" + transactionId + " chargeback not allowed as loan product is interest recalculation enabled", new Object[]{transactionId});
        }
        this.checkClientOrGroupActive(loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanChargebackTransactionBusinessEvent(loanTransaction));
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("paymentTypeId", command.longValueOfParameterNamed("paymentTypeId"));
        Money transactionAmountAsMoney = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createPaymentDetail(command, changes);
        if (paymentDetail != null) {
            paymentDetail = this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
        }
        LoanTransaction newTransaction = LoanTransaction.chargeback((Loan)loan, (Money)transactionAmountAsMoney, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId);
        this.validateLoanTransactionAmountChargeBack(loanTransaction, newTransaction);
        if (loan.isInterestBearing() && loan.isInterestRecalculationEnabled() && loan.isProgressiveSchedule()) {
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        LoanTransactionRelation loanTransactionRelation = LoanTransactionRelation.linkToTransaction((LoanTransaction)loanTransaction, (LoanTransaction)newTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.CHARGEBACK);
        this.loanTransactionRelationRepository.save((Object)loanTransactionRelation);
        this.handleChargebackTransaction(loan, newTransaction);
        newTransaction = (LoanTransaction)this.loanTransactionRepository.saveAndFlush((Object)newTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransaction, false, false);
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, transactionDate);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanChargebackTransactionBusinessEvent(newTransaction));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newTransaction.getId()).withEntityExternalId(newTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    private void validateLoanTransactionAmountChargeBack(LoanTransaction loanTransaction, LoanTransaction chargebackTransaction) {
        BigDecimal actualAmount = BigDecimal.ZERO;
        for (LoanTransactionRelation loanTransactionRelation : loanTransaction.getLoanTransactionRelations()) {
            if (!loanTransactionRelation.getRelationType().equals((Object)LoanTransactionRelationTypeEnum.CHARGEBACK) || !loanTransactionRelation.getToTransaction().isNotReversed()) continue;
            actualAmount = actualAmount.add(loanTransactionRelation.getToTransaction().getAmount());
        }
        actualAmount = actualAmount.add(chargebackTransaction.getAmount());
        if (loanTransaction.getAmount() != null && actualAmount.compareTo(loanTransaction.getAmount()) > 0) {
            throw new PlatformServiceUnavailableException("error.msg.loan.chargeback.operation.not.allowed", "Loan transaction:" + String.valueOf(loanTransaction.getId()) + " chargeback not allowed as loan transaction amount is not enough", new Object[]{loanTransaction.getId()});
        }
    }

    @Transactional
    public CommandProcessingResult waiveInterestOnLoan(Long loanId, JsonCommand command) {
        Money receivableInterest;
        this.loanTransactionValidator.validateTransaction(command.json());
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        Money transactionAmountAsMoney = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        Money unrecognizedIncome = transactionAmountAsMoney.zero();
        Money interestComponent = transactionAmountAsMoney;
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue() && transactionAmountAsMoney.isGreaterThan(receivableInterest = this.loanBalanceService.getReceivableInterest(loan, transactionDate))) {
            interestComponent = receivableInterest;
            unrecognizedIncome = transactionAmountAsMoney.minus(receivableInterest);
        }
        LoanTransaction waiveInterestTransaction = LoanTransaction.waiver((Office)loan.getOffice(), (Loan)loan, (Money)transactionAmountAsMoney, (LocalDate)transactionDate, (Money)interestComponent, (Money)unrecognizedIncome, (ExternalId)externalId);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanWaiveInterestBusinessEvent(waiveInterestTransaction));
        LocalDate recalculateFrom = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = transactionDate;
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_REPAYMENT_OR_WAIVER);
        this.loanTransactionValidator.validateActivityNotBeforeLastTransactionDate(loan, waiveInterestTransaction.getTransactionDate(), LoanEvent.LOAN_REPAYMENT_OR_WAIVER);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_REPAYMENT_OR_WAIVER, waiveInterestTransaction.getTransactionDate());
        this.waiveInterest(loan, waiveInterestTransaction, scheduleGeneratorDTO);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        this.loanTransactionRepository.saveAndFlush((Object)waiveInterestTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(waiveInterestTransaction, false, false);
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)waiveInterestTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanWaiveInterestBusinessEvent(waiveInterestTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)waiveInterestTransaction.getId()).withEntityExternalId(waiveInterestTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult writeOff(Long loanId, JsonCommand command) {
        AppUser currentUser = this.getAppUserIfPresent();
        this.loanTransactionValidator.validateTransactionWithNoAmount(command.json());
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (command.hasParameter("writeoffReasonId")) {
            Long writeoffReasonId = command.longValueOfParameterNamed("writeoffReasonId");
            CodeValue writeoffReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("WriteOffReasons", writeoffReasonId);
            changes.put("writeoffReasonId", writeoffReasonId);
            loan.updateWriteOffReason(writeoffReason);
        }
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + loanId + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanWrittenOffPreBusinessEvent(loan));
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(loanId, EntityTables.LOAN.getName(), StatusEnum.WRITE_OFF.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
        this.removeLoanCycle(loan);
        this.updateLoanCounters(loan, loan.getDisbursementDate());
        LocalDate recalculateFrom = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = command.localDateValueOfParameterNamed("transactionDate");
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        LocalDate writtenOffOnLocalDate = command.localDateValueOfParameterNamed("transactionDate");
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.WRITE_OFF_OUTSTANDING);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.WRITE_OFF_OUTSTANDING, writtenOffOnLocalDate);
        CommandProcessingResultBuilder builder = new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes);
        Optional loanTransactionOptional = this.closeAsWrittenOff(loan, command, changes, currentUser, scheduleGeneratorDTO);
        if (loanTransactionOptional.isPresent()) {
            LoanTransaction loanTransaction = (LoanTransaction)loanTransactionOptional.get();
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
            }
            this.loanTransactionRepository.saveAndFlush((Object)loanTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
            this.saveLoanWithDataIntegrityViolationChecks(loan);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                changes.put("note", noteText);
                Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)loanTransaction, (String)noteText);
                this.noteRepository.save((Object)note);
            }
            this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
            this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanWrittenOffPostBusinessEvent(loanTransaction));
            builder.withEntityId((Long)loanTransaction.getId()).withEntityExternalId(loanTransaction.getExternalId());
        }
        return builder.build();
    }

    @Transactional
    public CommandProcessingResult closeLoan(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateTransactionWithNoAmount(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + loanId + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanCloseBusinessEvent(loan));
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        this.updateLoanCounters(loan, loan.getDisbursementDate());
        LocalDate recalculateFrom = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = command.localDateValueOfParameterNamed("transactionDate");
        }
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        LocalDate closureDate = command.localDateValueOfParameterNamed("transactionDate");
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_CLOSED);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.REPAID_IN_FULL, closureDate);
        Optional loanTransactionOptional = this.close(loan, command, changes, scheduleGeneratorDTO);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        loanTransactionOptional.ifPresent(loanTransaction -> {
            this.loanTransactionRepository.saveAndFlush(loanTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
        });
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanNote((Loan)loan, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCloseBusinessEvent(loan));
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, null);
        this.loanAccountDomainService.disableStandingInstructionsLinkedToClosedLoan(loan);
        CommandProcessingResult result = loanTransactionOptional.isPresent() ? new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)((LoanTransaction)loanTransactionOptional.get()).getId()).withEntityExternalId(((LoanTransaction)loanTransactionOptional.get()).getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build() : new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
        return result;
    }

    @Transactional
    public CommandProcessingResult closeAsRescheduled(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateTransactionWithNoAmount(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Loan: " + loanId + " Close as rescheduled is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        this.removeLoanCycle(loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanCloseAsRescheduleBusinessEvent(loan));
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        this.closeAsMarkedForReschedule(loan, command, changes);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanNote((Loan)loan, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCloseAsRescheduleBusinessEvent(loan));
        this.loanAccountDomainService.disableStandingInstructionsLinkedToClosedLoan(loan);
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, null);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    private void disburseLoanToLoan(Loan loan, JsonCommand command, BigDecimal amount) {
        LocalDate transactionDate = command.localDateValueOfParameterNamed("actualDisbursementDate");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        AccountTransferDTO accountTransferDTO = new AccountTransferDTO(transactionDate, amount, PortfolioAccountType.LOAN, PortfolioAccountType.LOAN, (Long)loan.getId(), loan.getTopupLoanDetails().getLoanIdToClose(), "Loan Topup", locale, fmt, LoanTransactionType.DISBURSEMENT.getValue(), LoanTransactionType.REPAYMENT.getValue(), txnExternalId, loan, null);
        AccountTransferDetails accountTransferDetails = this.accountTransfersWritePlatformService.repayLoanWithTopup(accountTransferDTO);
        loan.getTopupLoanDetails().setAccountTransferDetails((Long)accountTransferDetails.getId());
        loan.getTopupLoanDetails().setTopupAmount(amount);
    }

    protected Long disburseLoanToSavings(Loan loan, JsonCommand command, Money amount, PaymentDetail paymentDetail) {
        LocalDate transactionDate = command.localDateValueOfParameterNamed("actualDisbursementDate");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        PortfolioAccountData portfolioAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation((Long)loan.getId());
        if (portfolioAccountData == null) {
            String errorMessage = "Disburse Loan with id:" + String.valueOf(loan.getId()) + " requires linked savings account for payment";
            throw new LinkedAccountRequiredException("loan.disburse.to.savings", errorMessage, new Object[]{loan.getId()});
        }
        SavingsAccount fromSavingsAccount = null;
        boolean isExceptionForBalanceCheck = false;
        boolean isRegularTransaction = true;
        AccountTransferDTO accountTransferDTO = new AccountTransferDTO(transactionDate, amount.getAmount(), PortfolioAccountType.LOAN, PortfolioAccountType.SAVINGS, (Long)loan.getId(), portfolioAccountData.getId(), "Loan Disbursement", locale, fmt, paymentDetail, LoanTransactionType.DISBURSEMENT.getValue(), null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, txnExternalId, loan, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
        return this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
    }

    @Transactional
    public LoanTransaction initiateLoanTransfer(Loan loan, LocalDate transferDate) {
        this.checkClientOrGroupActive(loan);
        this.validateTransactionsForTransfer(loan, transferDate);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanInitiateTransferBusinessEvent(loan));
        ExternalId externalId = this.externalIdFactory.create();
        LoanTransaction newTransferTransaction = LoanTransaction.initiateTransfer((Office)loan.getOffice(), (Loan)loan, (LocalDate)transferDate, (ExternalId)externalId);
        loan.addLoanTransaction(newTransferTransaction);
        this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_INITIATE_TRANSFER, loan);
        this.loanTransactionRepository.saveAndFlush((Object)newTransferTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransferTransaction, false, false);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanInitiateTransferBusinessEvent(loan));
        return newTransferTransaction;
    }

    @Transactional
    public LoanTransaction acceptLoanTransfer(Loan loan, LocalDate transferDate, Office acceptedInOffice, Staff loanOfficer) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanAcceptTransferBusinessEvent(loan));
        ExternalId externalId = this.externalIdFactory.create();
        LoanTransaction newTransferAcceptanceTransaction = LoanTransaction.approveTransfer((Office)acceptedInOffice, (Loan)loan, (LocalDate)transferDate, (ExternalId)externalId);
        loan.addLoanTransaction(newTransferAcceptanceTransaction);
        if (loan.getTotalOverpaid() != null) {
            this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_OVERPAYMENT, loan);
        } else {
            this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_REPAYMENT_OR_WAIVER, loan);
        }
        if (loanOfficer != null) {
            this.loanOfficerService.reassignLoanOfficer(loan, loanOfficer, transferDate);
        }
        this.loanTransactionRepository.saveAndFlush((Object)newTransferAcceptanceTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransferAcceptanceTransaction, false, false);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAcceptTransferBusinessEvent(loan));
        return newTransferAcceptanceTransaction;
    }

    @Transactional
    public LoanTransaction withdrawLoanTransfer(Loan loan, LocalDate transferDate) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanWithdrawTransferBusinessEvent(loan));
        ExternalId externalId = this.externalIdFactory.create();
        LoanTransaction newTransferAcceptanceTransaction = LoanTransaction.withdrawTransfer((Office)loan.getOffice(), (Loan)loan, (LocalDate)transferDate, (ExternalId)externalId);
        loan.addLoanTransaction(newTransferAcceptanceTransaction);
        this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_WITHDRAW_TRANSFER, loan);
        this.loanTransactionRepository.saveAndFlush((Object)newTransferAcceptanceTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransferAcceptanceTransaction, false, false);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanWithdrawTransferBusinessEvent(loan));
        return newTransferAcceptanceTransaction;
    }

    @Transactional
    public void rejectLoanTransfer(Loan loan) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanRejectTransferBusinessEvent(loan));
        this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_REJECT_TRANSFER, loan);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRejectTransferBusinessEvent(loan));
    }

    @Transactional
    public CommandProcessingResult loanReassignment(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateUpdateOfLoanOfficer(command.json());
        Long fromLoanOfficerId = command.longValueOfParameterNamed("fromLoanOfficerId");
        Long toLoanOfficerId = command.longValueOfParameterNamed("toLoanOfficerId");
        Staff fromLoanOfficer = this.loanAssembler.findLoanOfficerByIdIfProvided(fromLoanOfficerId);
        Staff toLoanOfficer = this.loanAssembler.findLoanOfficerByIdIfProvided(toLoanOfficerId);
        LocalDate dateOfLoanOfficerAssignment = command.localDateValueOfParameterNamed("assignmentDate");
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanReassignOfficerBusinessEvent(loan));
        if (!loan.hasLoanOfficer(fromLoanOfficer)) {
            throw new LoanOfficerAssignmentException(loanId, fromLoanOfficerId);
        }
        this.loanOfficerService.reassignLoanOfficer(loan, toLoanOfficer, dateOfLoanOfficerAssignment);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReassignOfficerBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).build();
    }

    @Transactional
    public CommandProcessingResult bulkLoanReassignment(JsonCommand command) {
        this.loanTransactionValidator.validateForBulkLoanReassignment(command.json());
        Long fromLoanOfficerId = command.longValueOfParameterNamed("fromLoanOfficerId");
        Long toLoanOfficerId = command.longValueOfParameterNamed("toLoanOfficerId");
        String[] loanIds = command.arrayValueOfParameterNamed("loans");
        LocalDate dateOfLoanOfficerAssignment = command.localDateValueOfParameterNamed("assignmentDate");
        Staff fromLoanOfficer = this.loanAssembler.findLoanOfficerByIdIfProvided(fromLoanOfficerId);
        Staff toLoanOfficer = this.loanAssembler.findLoanOfficerByIdIfProvided(toLoanOfficerId);
        ArrayList<Long> lockedLoanIds = new ArrayList<Long>();
        for (String loanIdString : loanIds) {
            Long loanId = Long.valueOf(loanIdString);
            Loan loan = this.loanAssembler.assembleFrom(loanId);
            if (this.loanAccountLockService.isLoanHardLocked(loanId)) {
                lockedLoanIds.add(loanId);
                continue;
            }
            this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanReassignOfficerBusinessEvent(loan));
            this.checkClientOrGroupActive(loan);
            if (!loan.hasLoanOfficer(fromLoanOfficer)) {
                throw new LoanOfficerAssignmentException(loanId, fromLoanOfficerId);
            }
            this.loanOfficerService.reassignLoanOfficer(loan, toLoanOfficer, dateOfLoanOfficerAssignment);
            this.saveLoanWithDataIntegrityViolationChecks(loan);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReassignOfficerBusinessEvent(loan));
        }
        if (!lockedLoanIds.isEmpty()) {
            throw new AccountLockCannotBeOverruledException("There are hard-lcoked loan accounts: " + String.valueOf(lockedLoanIds));
        }
        this.loanRepositoryWrapper.flush();
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
    }

    @Transactional
    public CommandProcessingResult removeLoanOfficer(Long loanId, JsonCommand command) {
        LoanUpdateCommand loanUpdateCommand = this.loanUpdateCommandFromApiJsonDeserializer.commandFromApiJson(command.json());
        loanUpdateCommand.validate();
        LocalDate dateOfLoanOfficerUnassigned = command.localDateValueOfParameterNamed("unassignedDate");
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.getLoanOfficer() == null) {
            throw new LoanOfficerUnassignmentException(loanId);
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanRemoveOfficerBusinessEvent(loan));
        this.loanOfficerValidator.validateUnassignDate(loan, dateOfLoanOfficerUnassigned);
        loan.removeLoanOfficer(dateOfLoanOfficerUnassigned);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRemoveOfficerBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).build();
    }

    @Transactional
    public void applyMeetingDateChanges(Calendar calendar, Collection<CalendarInstance> loanCalendarInstances) {
        Boolean rescheduleBasedOnMeetingDates = null;
        LocalDate presentMeetingDate = null;
        LocalDate newMeetingDate = null;
        this.applyMeetingDateChanges(calendar, loanCalendarInstances, rescheduleBasedOnMeetingDates, presentMeetingDate, newMeetingDate);
    }

    @Transactional
    public void applyMeetingDateChanges(Calendar calendar, Collection<CalendarInstance> loanCalendarInstances, Boolean rescheduleBasedOnMeetingDates, LocalDate presentMeetingDate, LocalDate newMeetingDate) {
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        ArrayList existingTransactionIds = new ArrayList();
        ArrayList existingReversedTransactionIds = new ArrayList();
        ArrayList<LoanStatus> loanStatuses = new ArrayList<LoanStatus>(Arrays.asList(LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED, LoanStatus.ACTIVE));
        ArrayList<AccountType> loanTypes = new ArrayList<AccountType>(Arrays.asList(AccountType.GROUP, AccountType.JLG));
        ArrayList<Long> loanIds = new ArrayList<Long>(loanCalendarInstances.size());
        for (CalendarInstance calendarInstance : loanCalendarInstances) {
            loanIds.add(calendarInstance.getEntityId());
        }
        List loans = this.loanRepositoryWrapper.findByIdsAndLoanStatusAndLoanType(loanIds, loanStatuses, loanTypes);
        LocalDate recalculateFrom = null;
        for (Loan loan : loans) {
            if (loan == null) continue;
            if (loan.getExpectedFirstRepaymentOnDate() != null && loan.getExpectedFirstRepaymentOnDate().equals(presentMeetingDate)) {
                String defaultUserMessage = "Meeting calendar date update is not supported since its a first repayment date";
                throw new CalendarParameterUpdateNotSupportedException("meeting.for.first.repayment.date", "Meeting calendar date update is not supported since its a first repayment date", new Object[]{loan.getExpectedFirstRepaymentOnDate(), presentMeetingDate});
            }
            if (loan.isChargedOff()) {
                throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Loan: " + String.valueOf(loan.getId()) + " reschedule is not allowed. Loan Account is Charged-off", new Object[]{loan.getId()});
            }
            Boolean isSkipRepaymentOnFirstMonth = false;
            int numberOfDays = 0;
            boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
            if (isSkipRepaymentOnFirstMonthEnabled && (isSkipRepaymentOnFirstMonth = this.loanUtilService.isLoanRepaymentsSyncWithMeeting(loan.group(), calendar)).booleanValue()) {
                numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
            }
            List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), loan.getDisbursementDate());
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
                this.loanScheduleService.recalculateScheduleFromLastTransaction(loan, scheduleGeneratorDTO, existingTransactionIds, existingReversedTransactionIds);
                this.createAndSaveLoanScheduleArchive(loan, scheduleGeneratorDTO);
            } else if (rescheduleBasedOnMeetingDates != null && rescheduleBasedOnMeetingDates.booleanValue()) {
                this.updateLoanRepaymentScheduleDates(loan, calendar.getRecurrence(), isHolidayEnabled, holidays, workingDays, presentMeetingDate, newMeetingDate, isSkipRepaymentOnFirstMonth.booleanValue(), Integer.valueOf(numberOfDays));
            } else {
                this.updateLoanRepaymentScheduleDates(loan, calendar.getStartDateLocalDate(), calendar.getRecurrence(), isHolidayEnabled, holidays, workingDays, isSkipRepaymentOnFirstMonth.booleanValue(), Integer.valueOf(numberOfDays));
            }
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, false);
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, false);
            }
            this.saveLoanWithDataIntegrityViolationChecks(loan);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRescheduledDueCalendarChangeBusinessEvent(loan));
            this.loanAccrualTransactionBusinessEventService.raiseBusinessEventForAccrualTransactions(loan, existingTransactionIds);
        }
    }

    private void removeLoanCycle(Loan loan) {
        List loansToUpdate = loan.isGroupLoan() ? (loan.loanProduct().isIncludeInBorrowerCycle() ? this.loanRepositoryWrapper.getGroupLoansToUpdateLoanCounter(loan.getCurrentLoanCounter(), loan.getGroupId(), AccountType.GROUP) : this.loanRepositoryWrapper.getGroupLoansToUpdateLoanProductCounter(loan.getLoanProductLoanCounter(), loan.getGroupId(), AccountType.GROUP)) : (loan.loanProduct().isIncludeInBorrowerCycle() ? this.loanRepositoryWrapper.getClientOrJLGLoansToUpdateLoanCounter(loan.getCurrentLoanCounter(), loan.getClientId()) : this.loanRepositoryWrapper.getClientLoansToUpdateLoanProductCounter(loan.getLoanProductLoanCounter(), loan.getClientId()));
        if (loansToUpdate != null) {
            this.updateLoanCycleCounter(loansToUpdate, loan);
        }
        loan.updateClientLoanCounter(null);
        loan.updateLoanProductLoanCounter(null);
    }

    private void updateLoanCounters(Loan loan, LocalDate actualDisbursementDate) {
        if (loan.isGroupLoan()) {
            List loansToUpdateForLoanCounter = this.loanRepositoryWrapper.getGroupLoansDisbursedAfter(actualDisbursementDate, loan.getGroupId(), AccountType.GROUP);
            Integer newLoanCounter = this.getNewGroupLoanCounter(loan);
            Integer newLoanProductCounter = this.getNewGroupLoanProductCounter(loan);
            this.updateLoanCounter(loan, loansToUpdateForLoanCounter, newLoanCounter, newLoanProductCounter);
        } else {
            List loansToUpdateForLoanCounter = this.loanRepositoryWrapper.getClientOrJLGLoansDisbursedAfter(actualDisbursementDate, loan.getClientId());
            Integer newLoanCounter = this.getNewClientOrJLGLoanCounter(loan);
            Integer newLoanProductCounter = this.getNewClientOrJLGLoanProductCounter(loan);
            this.updateLoanCounter(loan, loansToUpdateForLoanCounter, newLoanCounter, newLoanProductCounter);
        }
    }

    private Integer getNewGroupLoanCounter(Loan loan) {
        Integer maxClientLoanCounter = this.loanRepositoryWrapper.getMaxGroupLoanCounter(loan.getGroupId(), AccountType.GROUP);
        maxClientLoanCounter = maxClientLoanCounter == null ? Integer.valueOf(1) : Integer.valueOf(maxClientLoanCounter + 1);
        return maxClientLoanCounter;
    }

    private Integer getNewGroupLoanProductCounter(Loan loan) {
        Integer maxLoanProductLoanCounter = this.loanRepositoryWrapper.getMaxGroupLoanProductCounter((Long)loan.loanProduct().getId(), loan.getGroupId(), AccountType.GROUP);
        maxLoanProductLoanCounter = maxLoanProductLoanCounter == null ? Integer.valueOf(1) : Integer.valueOf(maxLoanProductLoanCounter + 1);
        return maxLoanProductLoanCounter;
    }

    private void updateLoanCounter(Loan loan, List<Loan> loansToUpdateForLoanCounter, Integer newLoanCounter, Integer newLoanProductCounter) {
        boolean includeInBorrowerCycle = loan.loanProduct().isIncludeInBorrowerCycle();
        for (Loan loanToUpdate : loansToUpdateForLoanCounter) {
            if (loanToUpdate.loanProduct().isIncludeInBorrowerCycle()) {
                Integer currentLoanCounter = loanToUpdate.getCurrentLoanCounter() == null ? 1 : loanToUpdate.getCurrentLoanCounter();
                if (newLoanCounter > currentLoanCounter) {
                    newLoanCounter = currentLoanCounter;
                }
                currentLoanCounter = currentLoanCounter + 1;
                loanToUpdate.updateClientLoanCounter(currentLoanCounter);
            }
            if (!Objects.equals(loan.loanProduct().getId(), loanToUpdate.loanProduct().getId())) continue;
            Integer loanProductLoanCounter = loanToUpdate.getLoanProductLoanCounter();
            if (newLoanProductCounter > loanProductLoanCounter) {
                newLoanProductCounter = loanProductLoanCounter;
            }
            loanProductLoanCounter = loanProductLoanCounter + 1;
            loanToUpdate.updateLoanProductLoanCounter(loanProductLoanCounter);
        }
        if (includeInBorrowerCycle) {
            loan.updateClientLoanCounter(newLoanCounter);
        } else {
            loan.updateClientLoanCounter(null);
        }
        loan.updateLoanProductLoanCounter(newLoanProductCounter);
        this.loanRepositoryWrapper.save(loansToUpdateForLoanCounter);
    }

    private Integer getNewClientOrJLGLoanCounter(Loan loan) {
        Integer maxClientLoanCounter = this.loanRepositoryWrapper.getMaxClientOrJLGLoanCounter(loan.getClientId());
        maxClientLoanCounter = maxClientLoanCounter == null ? Integer.valueOf(1) : Integer.valueOf(maxClientLoanCounter + 1);
        return maxClientLoanCounter;
    }

    private Integer getNewClientOrJLGLoanProductCounter(Loan loan) {
        Integer maxLoanProductLoanCounter = this.loanRepositoryWrapper.getMaxClientOrJLGLoanProductCounter((Long)loan.loanProduct().getId(), loan.getClientId());
        maxLoanProductLoanCounter = maxLoanProductLoanCounter == null ? Integer.valueOf(1) : Integer.valueOf(maxLoanProductLoanCounter + 1);
        return maxLoanProductLoanCounter;
    }

    private void updateLoanCycleCounter(List<Loan> loansToUpdate, Loan loan) {
        Integer currentLoanCounter = loan.getCurrentLoanCounter();
        Integer currentLoanProductCounter = loan.getLoanProductLoanCounter();
        for (Loan loanToUpdate : loansToUpdate) {
            Integer runningLoanProductCounter;
            Integer runningLoanCounter;
            if (loan.loanProduct().isIncludeInBorrowerCycle() && (runningLoanCounter = loanToUpdate.getCurrentLoanCounter()) > currentLoanCounter) {
                runningLoanCounter = runningLoanCounter - 1;
                loanToUpdate.updateClientLoanCounter(runningLoanCounter);
            }
            if (!Objects.equals(loan.loanProduct().getId(), loanToUpdate.loanProduct().getId()) || (runningLoanProductCounter = loanToUpdate.getLoanProductLoanCounter()) <= currentLoanProductCounter) continue;
            runningLoanProductCounter = runningLoanProductCounter - 1;
            loanToUpdate.updateLoanProductLoanCounter(runningLoanProductCounter);
        }
        this.loanRepositoryWrapper.save(loansToUpdate);
    }

    private void checkClientOrGroupActive(Loan loan) {
        Client client = loan.client();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = loan.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public CommandProcessingResult undoWriteOff(Long loanId) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (!loan.isClosedWrittenOff()) {
            throw new PlatformServiceUnavailableException("error.msg.loan.status.not.written.off.update.not.allowed", "Loan :" + loanId + " update not allowed as loan status is not written off", new Object[]{loanId});
        }
        LoanTransaction writeOffTransaction = loan.findWriteOffTransaction();
        if (writeOffTransaction == null) {
            throw new PlatformServiceUnavailableException("error.msg.loan.write.off.transaction.not.found", "Loan :" + loanId + " write off transaction not found", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUndoWrittenOffBusinessEvent(writeOffTransaction));
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.WRITE_OFF_OUTSTANDING_UNDO);
        this.undoWrittenOff(loan);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(writeOffTransaction, false, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoWrittenOffBusinessEvent(writeOffTransaction));
        return new CommandProcessingResultBuilder().withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).withEntityId((Long)writeOffTransaction.getId()).withEntityExternalId(writeOffTransaction.getExternalId()).build();
    }

    private void validateMultiDisbursementData(JsonCommand command, LocalDate expectedDisbursementDate, boolean isDisallowExpectedDisbursements, Loan loan) {
        String json = command.json();
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        JsonArray disbursementDataArray = command.arrayOfParameterNamed("disbursementData");
        if (isDisallowExpectedDisbursements) {
            if (!disbursementDataArray.isEmpty()) {
                String errorMessage = "For this loan product, disbursement details are not allowed";
                throw new MultiDisbursementDataNotAllowedException("disbursementData", "For this loan product, disbursement details are not allowed", new Object[0]);
            }
        } else if (disbursementDataArray == null || disbursementDataArray.isEmpty()) {
            String errorMessage = "For this loan product, disbursement details must be provided";
            throw new MultiDisbursementDataRequiredException("disbursementData", "For this loan product, disbursement details must be provided", new Object[0]);
        }
        BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("approvedLoanAmount", element);
        this.loanApplicationValidator.validateLoanMultiDisbursementDate(element, baseDataValidator, expectedDisbursementDate, principal, loan);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateForAddAndDeleteTranche(Loan loan) {
        BigDecimal totalDisbursedAmount = BigDecimal.ZERO;
        List loanDisburseDetails = loan.getDisbursementDetails();
        for (LoanDisbursementDetails disbursementDetails : loanDisburseDetails) {
            if (disbursementDetails.actualDisbursementDate() == null) continue;
            totalDisbursedAmount = totalDisbursedAmount.add(disbursementDetails.principal());
        }
        if (totalDisbursedAmount.compareTo(loan.getApprovedPrincipal()) == 0) {
            String errorMessage = "loan.disbursement.cannot.be.a.edited";
            throw new LoanMultiDisbursementException("loan.disbursement.cannot.be.a.edited", new Object[0]);
        }
    }

    @Transactional
    public CommandProcessingResult addAndDeleteLoanDisburseDetails(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Update Loan: " + loanId + " disbursement details is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        LinkedHashMap actualChanges = new LinkedHashMap();
        LocalDate expectedDisbursementDate = loan.getExpectedDisbursedOnLocalDate();
        if (!loan.loanProduct().isMultiDisburseLoan()) {
            String errorMessage = "loan.product.does.not.support.multiple.disbursals";
            throw new LoanMultiDisbursementException("loan.product.does.not.support.multiple.disbursals", new Object[0]);
        }
        if (loan.isSubmittedAndPendingApproval() || loan.isClosed() || loan.isClosedWrittenOff() || loan.getStatus().isClosedObligationsMet() || loan.getStatus().isOverpaid()) {
            String errorMessage = "cannot.modify.tranches.if.loan.is.pendingapproval.closed.overpaid.writtenoff";
            throw new LoanMultiDisbursementException("cannot.modify.tranches.if.loan.is.pendingapproval.closed.overpaid.writtenoff", new Object[0]);
        }
        this.validateMultiDisbursementData(command, expectedDisbursementDate, loan.loanProduct().isDisallowExpectedDisbursements(), loan);
        this.validateForAddAndDeleteTranche(loan);
        this.loanDisbursementService.updateDisbursementDetails(loan, command, actualChanges);
        if (loan.loanProduct().isDisallowExpectedDisbursements()) {
            if (!loan.getDisbursementDetails().isEmpty()) {
                String errorMessage = "For this loan product, disbursement details are not allowed";
                throw new MultiDisbursementDataNotAllowedException("disbursementData", "For this loan product, disbursement details are not allowed", new Object[0]);
            }
        } else if (loan.getDisbursementDetails().isEmpty()) {
            String errorMessage = "For this loan product, disbursement details must be provided";
            throw new MultiDisbursementDataRequiredException("disbursementData", "For this loan product, disbursement details must be provided", new Object[0]);
        }
        if (loan.getDisbursementDetails().size() > loan.loanProduct().maxTrancheCount()) {
            String errorMessage = "Number of tranche shouldn't be greater than " + loan.loanProduct().maxTrancheCount();
            throw new ExceedingTrancheCountException("disbursementData", errorMessage, new Object[]{loan.loanProduct().maxTrancheCount(), loan.getDisbursementDetails().size()});
        }
        LoanDisbursementDetails updateDetails = null;
        CommandProcessingResult result = this.processLoanDisbursementDetail(loan, loanId, command, updateDetails);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUpdateDisbursementDataBusinessEvent(loan));
        return result;
    }

    private CommandProcessingResult processLoanDisbursementDetail(Loan loan, Long loanId, JsonCommand command, LoanDisbursementDetails loanDisbursementDetails) {
        LinkedHashMap changes = new LinkedHashMap();
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        if (command.entityId() != null) {
            this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_EDIT_MULTI_DISBURSE_DATE);
            this.updateDisbursementDateAndAmountForTranche(loan, loanDisbursementDetails, command, changes, scheduleGeneratorDTO);
        } else {
            loan.getLoanProductRelatedDetail().setPrincipal(loan.getPrincipalAmountForRepaymentSchedule());
            if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
            } else if (loan.isProgressiveSchedule()) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
                this.reprocessLoanTransactionsService.reprocessTransactions(loan);
            }
        }
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        if ((loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan)).isInterestBearingAndInterestRecalculationEnabled()) {
            this.createLoanScheduleArchive(loan, scheduleGeneratorDTO);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        return new CommandProcessingResultBuilder().withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult updateDisbursementDateAndAmountForTranche(Long loanId, Long disbursementId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Update Loan: " + loanId + " disbursement details is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        LoanDisbursementDetails loanDisbursementDetails = loan.fetchLoanDisbursementsById(disbursementId);
        this.loanTransactionValidator.validateUpdateDisbursementDateAndAmount(command.json(), loanDisbursementDetails);
        CommandProcessingResult result = this.processLoanDisbursementDetail(loan, loanId, command, loanDisbursementDetails);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUpdateDisbursementDataBusinessEvent(loan));
        return result;
    }

    @Transactional
    @Retry(name="recalculateInterest", fallbackMethod="fallbackRecalculateInterest")
    public void recalculateInterest(long loanId) {
        Loan loan = this.loanAssembler.assembleFrom(Long.valueOf(loanId));
        this.recalculateInterest(loan);
    }

    @Transactional
    public Loan recalculateInterest(Loan loan) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanInterestRecalculationBusinessEvent(loan));
        ArrayList existingTransactionIds = new ArrayList();
        ArrayList existingReversedTransactionIds = new ArrayList();
        if (loan.isCumulativeSchedule()) {
            LocalDate recalculateFrom = loan.fetchInterestRecalculateFromDate();
            ScheduleGeneratorDTO generatorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
            this.loanScheduleService.recalculateScheduleFromLastTransaction(loan, generatorDTO, existingTransactionIds, existingReversedTransactionIds);
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
            }
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanInterestRecalculationBusinessEvent(loan));
        } else {
            this.loanScheduleService.recalculateScheduleFromLastTransaction(loan, null, existingTransactionIds, existingReversedTransactionIds, true);
            this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanInterestRecalculationBusinessEvent(loan));
        }
        return loan;
    }

    public CommandProcessingResult recoverFromGuarantor(Long loanId) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.guarantorDomainService.transferFundsFromGuarantor(loan);
        return new CommandProcessingResultBuilder().withLoanId(loanId).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).build();
    }

    public void fallbackRecalculateInterest(Throwable t) {
        throw ErrorHandler.getMappable((Throwable)t, null, null, (String)"loan.recalculateinterest", (Object[])new Object[0]);
    }

    public void updateOriginalSchedule(Loan loan) {
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            LocalDate recalculateFrom = null;
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
            this.createLoanScheduleArchive(loan, scheduleGeneratorDTO);
        }
    }

    private void createLoanScheduleArchive(Loan loan, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        this.createAndSaveLoanScheduleArchive(loan, scheduleGeneratorDTO);
    }

    private void regenerateScheduleOnDisbursement(JsonCommand command, Loan loan, boolean recalculateSchedule, ScheduleGeneratorDTO scheduleGeneratorDTO, LocalDate nextPossibleRepaymentDate, LocalDate rescheduledRepaymentDate) {
        LocalDate actualDisbursementDate = command.localDateValueOfParameterNamed("actualDisbursementDate");
        BigDecimal emiAmount = command.bigDecimalValueOfParameterNamed("fixedEmiAmount");
        boolean isEmiAmountChanged = false;
        LoanProduct loanProduct = loan.getLoanProduct();
        if ((loanProduct.isMultiDisburseLoan() || loanProduct.isCanDefineInstallmentAmount()) && emiAmount != null && emiAmount.compareTo(loan.retriveLastEmiAmount()) != 0) {
            if (loanProduct.isMultiDisburseLoan()) {
                LocalDate dateValue = null;
                boolean isSpecificToInstallment = false;
                Boolean isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled = scheduleGeneratorDTO.isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled();
                LocalDate effectiveDateFrom = actualDisbursementDate;
                if (!isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled.booleanValue() && actualDisbursementDate.equals(nextPossibleRepaymentDate)) {
                    effectiveDateFrom = nextPossibleRepaymentDate.plusDays(1L);
                }
                LoanTermVariations loanVariationTerms = new LoanTermVariations(LoanTermVariationType.EMI_AMOUNT.getValue(), effectiveDateFrom, emiAmount, dateValue, false, loan, LoanStatus.ACTIVE.getValue());
                loan.getLoanTermVariations().add(loanVariationTerms);
            } else {
                loan.setFixedEmiAmount(emiAmount);
            }
            isEmiAmountChanged = true;
        }
        if (rescheduledRepaymentDate != null && loanProduct.isMultiDisburseLoan()) {
            boolean isSpecificToInstallment = false;
            LoanTermVariations loanVariationTerms = new LoanTermVariations(LoanTermVariationType.DUE_DATE.getValue(), nextPossibleRepaymentDate, emiAmount, rescheduledRepaymentDate, false, loan, LoanStatus.ACTIVE.getValue());
            loan.getLoanTermVariations().add(loanVariationTerms);
        }
        if (loan.isActualDisbursedOnDateEarlierOrLaterThanExpected(actualDisbursementDate) || recalculateSchedule || isEmiAmountChanged || rescheduledRepaymentDate != null) {
            if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
            } else if (loan.isProgressiveSchedule()) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
        }
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
    }

    private List<LoanRepaymentScheduleInstallment> retrieveRepaymentScheduleFromModel(LoanScheduleModel model) {
        ArrayList<LoanRepaymentScheduleInstallment> installments = new ArrayList<LoanRepaymentScheduleInstallment>();
        for (LoanScheduleModelPeriod scheduledLoanInstallment : model.getPeriods()) {
            if (!scheduledLoanInstallment.isRepaymentPeriod() && !scheduledLoanInstallment.isDownPaymentPeriod()) continue;
            LoanRepaymentScheduleInstallment installment = new LoanRepaymentScheduleInstallment(null, scheduledLoanInstallment.periodNumber(), scheduledLoanInstallment.periodFromDate(), scheduledLoanInstallment.periodDueDate(), scheduledLoanInstallment.principalDue(), scheduledLoanInstallment.interestDue(), scheduledLoanInstallment.feeChargesDue(), scheduledLoanInstallment.penaltyChargesDue(), scheduledLoanInstallment.isRecalculatedInterestComponent(), scheduledLoanInstallment.getLoanCompoundingDetails());
            installments.add(installment);
        }
        return installments;
    }

    public CommandProcessingResult creditBalanceRefund(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateNewRefundTransaction(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        String noteText = command.stringValueOfParameterNamedAllowingNull("note");
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        if (!externalId.isEmpty()) {
            changes.put("externalId", externalId);
        }
        changes.put("paymentTypeId", command.longValueOfParameterNamed("paymentTypeId"));
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createPaymentDetail(command, changes);
        if (paymentDetail != null) {
            paymentDetail = this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
        }
        LoanTransaction loanTransaction = this.loanAccountDomainService.creditBalanceRefund(loan, transactionDate, transactionAmount, noteText, externalId, paymentDetail);
        return new CommandProcessingResultBuilder().withEntityId((Long)loanTransaction.getId()).withEntityExternalId(loanTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withCommandId(command.commandId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult markLoanAsFraud(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateMarkAsFraudLoan(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LinkedHashMap<String, Boolean> changes = new LinkedHashMap<String, Boolean>();
        boolean fraud = command.booleanPrimitiveValueOfParameterNamed("fraud");
        if (loan.isFraud() != fraud) {
            loan.markAsFraud(fraud);
            this.loanRepository.save((Object)loan);
            changes.put("fraud", fraud);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult makeLoanRefund(Long loanId, JsonCommand command) {
        this.loanTransactionValidator.validateNewRefundTransaction(command.json());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        this.checkIfLoanIsPaidInAdvance(loanId, transactionAmount);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("externalId", (String)externalId);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        PaymentDetail paymentDetail = null;
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder();
        LoanTransaction loanTransaction = this.loanAccountDomainService.makeRefundForActiveLoan(loanId, commandProcessingResultBuilder, transactionDate, transactionAmount, paymentDetail, noteText, externalId);
        return commandProcessingResultBuilder.withCommandId(command.commandId()).withLoanId(loanId).withEntityId((Long)loanTransaction.getId()).withEntityExternalId(loanTransaction.getExternalId()).with(changes).build();
    }

    private void checkIfLoanIsPaidInAdvance(Long loanId, BigDecimal transactionAmount) {
        BigDecimal overpaid = this.loanReadPlatformService.retrieveTotalPaidInAdvance(loanId).getPaidInAdvance();
        if (overpaid == null || overpaid.compareTo(BigDecimal.ZERO) == 0 || transactionAmount.floatValue() > overpaid.floatValue()) {
            if (overpaid == null) {
                overpaid = BigDecimal.ZERO;
            }
            throw new InvalidPaidInAdvanceAmountException(overpaid.toPlainString());
        }
    }

    private AppUser getAppUserIfPresent() {
        AppUser user = null;
        if (this.context != null) {
            user = this.context.getAuthenticatedUserIfPresent();
        }
        return user;
    }

    @Transactional
    public CommandProcessingResult undoLastLoanDisbursal(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LocalDate recalculateFromDate = loan.getLastRepaymentDate();
        this.validateIsMultiDisbursalLoanAndDisbursedMoreThanOneTranche(loan);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Undo Loan: " + loanId + " last disbursement is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUndoLastDisbursalBusinessEvent(loan));
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFromDate);
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_DISBURSAL_UNDO_LAST);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_DISBURSAL_UNDO_LAST, loan.getDisbursementDate());
        Map changes = this.undoLastDisbursal(scheduleGeneratorDTO, loan);
        if (!changes.isEmpty()) {
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
            }
            this.createNote(loan, command, changes);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoLastDisbursalBusinessEvent(loan));
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult forecloseLoan(Long loanId, JsonCommand command) {
        String json = command.json();
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        this.loanTransactionValidator.validateLoanForeclosure(command.json());
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("dateFormat", command.dateFormat());
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("externalId", (String)externalId);
        String noteText = this.fromApiJsonHelper.extractStringNamed("note", element);
        LoanRescheduleRequest loanRescheduleRequest = null;
        for (LoanDisbursementDetails loanDisbursementDetails : loan.getDisbursementDetails()) {
            if (DateUtils.isAfter((LocalDate)loanDisbursementDetails.expectedDisbursementDateAsLocalDate(), (LocalDate)transactionDate) || loanDisbursementDetails.actualDisbursementDate() != null) continue;
            String defaultUserMessage = "The loan with undisbursed tranche before foreclosure cannot be foreclosed.";
            throw new LoanForeclosureException("loan.with.undisbursed.tranche.before.foreclosure.cannot.be.foreclosured", "The loan with undisbursed tranche before foreclosure cannot be foreclosed.", new Object[]{transactionDate});
        }
        this.loanScheduleHistoryWritePlatformService.createAndSaveLoanScheduleArchive(loan.getRepaymentScheduleInstallments(), loan, loanRescheduleRequest);
        LoanTransaction foreclosureTransaction = this.loanAccountDomainService.foreCloseLoan(loan, transactionDate, noteText, externalId, changes);
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder();
        return commandProcessingResultBuilder.withLoanId(loanId).withEntityId((Long)foreclosureTransaction.getId()).withEntityExternalId(foreclosureTransaction.getExternalId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult chargeOff(JsonCommand command) {
        this.loanTransactionValidator.validateChargeOffTransaction(command.json());
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        AppUser currentUser = this.getAppUserIfPresent();
        Loan loan = this.loanAssembler.assembleFrom(command.getLoanId());
        Long loanId = (Long)loan.getId();
        if (!loan.isOpen()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.not.active", "Loan: " + loanId + " Charge-off is not allowed. Loan Account is not Active", new Object[]{loanId});
        }
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.already.charged.off", "Loan: " + loanId + " is already charged-off", new Object[]{loanId});
        }
        if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getLastUserTransactionDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.charge.off.is.before.than.the.last.user.transaction", "Loan: " + loanId + " charge-off cannot be executed. User transaction was found after the charge-off transaction date!", new Object[]{loanId});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
            String errorMessage = "The transaction date cannot be in the future.";
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.cannot.be.a.future.date", "The transaction date cannot be in the future.", new Object[]{transactionDate});
        }
        if (loan.hasMonetaryActivityAfter(transactionDate)) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.monetary.transactions.after.charge.off", "Loan: " + loanId + " charge-off cannot be executed. Loan has monetary activity after the charge-off transaction date!", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanChargeOffPreBusinessEvent(loan));
        if (command.hasParameter("chargeOffReasonId")) {
            Long chargeOffReasonId = command.longValueOfParameterNamed("chargeOffReasonId");
            CodeValue chargeOffReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ChargeOffReasons", chargeOffReasonId);
            changes.put("chargeOffReasonId", chargeOffReasonId);
            loan.markAsChargedOff(transactionDate, currentUser, chargeOffReason);
        } else {
            loan.markAsChargedOff(transactionDate, currentUser, null);
        }
        loan.getLoanTransactions().stream().filter(lt -> lt.isAccrual() || lt.isAccrualAdjustment()).filter(transaction -> loan.getLoanProductRelatedDetail().isInterestRecognitionOnDisbursementDate() ? !DateUtils.isBefore((LocalDate)transaction.getTransactionDate(), (LocalDate)transactionDate) : DateUtils.isAfter((LocalDate)transaction.getTransactionDate(), (LocalDate)transactionDate)).forEach(transaction -> {
            transaction.reverse();
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
        });
        LoanTransaction chargeOffTransaction = LoanTransaction.chargeOff((Loan)loan, (LocalDate)transactionDate, (ExternalId)txnExternalId);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            if (loan.isCumulativeSchedule()) {
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null, null);
                this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
            }
            this.reprocessLoanTransactionsService.reprocessTransactions(loan, List.of(chargeOffTransaction));
            loan.addLoanTransaction(chargeOffTransaction);
        } else {
            this.reprocessLoanTransactionsService.processLatestTransaction(chargeOffTransaction, loan);
            loan.addLoanTransaction(chargeOffTransaction);
        }
        this.loanTransactionRepository.saveAndFlush((Object)chargeOffTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(chargeOffTransaction, false, false);
        this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)chargeOffTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanChargeOffPostBusinessEvent(chargeOffTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)chargeOffTransaction.getId()).withEntityExternalId(chargeOffTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult undoChargeOff(JsonCommand command) {
        this.loanTransactionValidator.validateUndoChargeOff(command.json());
        Long loanId = command.getLoanId();
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (!loan.isOpen()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.not.active", "Loan: " + loanId + " Undo Charge-off is not allowed. Loan Account is not Active", new Object[]{loanId});
        }
        if (!loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.not.charged.off", "Loan: " + loanId + " is not charged-off", new Object[]{loanId});
        }
        LoanTransaction chargedOffTransaction = loan.findChargedOffTransaction();
        if (chargedOffTransaction == null) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.charge.off.transaction.not.found", "Loan: " + loanId + " charge-off transaction was not found", new Object[]{loanId});
        }
        if (!chargedOffTransaction.equals(loan.getLastUserTransaction())) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.charge.off.is.not.the.last.user.transaction", "Loan: " + loanId + " charge-off cannot be undone. User transaction was found after charge-off!", new Object[]{loanId});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUndoChargeOffBusinessEvent(chargedOffTransaction));
        String reversalExternalId = command.stringValueOfParameterNamedAllowingNull("reversalExternalId");
        ExternalId reversalTxnExternalId = ExternalIdFactory.produce((String)reversalExternalId);
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(chargedOffTransaction.getLoan(), chargedOffTransaction, "reversed");
        chargedOffTransaction.reverse(reversalTxnExternalId);
        chargedOffTransaction.manuallyAdjustedOrReversed();
        loan.liftChargeOff();
        this.loanTransactionRepository.saveAndFlush((Object)chargedOffTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(chargedOffTransaction, false, false);
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null, null);
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else if (loan.isProgressiveSchedule()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        this.saveLoanWithDataIntegrityViolationChecks(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoChargeOffBusinessEvent(chargedOffTransaction));
        return new CommandProcessingResultBuilder().withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).withEntityId((Long)chargedOffTransaction.getId()).withEntityExternalId(chargedOffTransaction.getExternalId()).build();
    }

    public CommandProcessingResult makeRefund(Long loanId, LoanTransactionType loanTransactionType, JsonCommand command) {
        this.loanTransactionValidator.validateRefund(command.json());
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("externalId", (String)txnExternalId);
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        LocalDate recalculateFrom = loan.isInterestBearingAndInterestRecalculationEnabled() ? transactionDate : null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom, null);
        this.loanTransactionValidator.validateRefund(loan, loanTransactionType, transactionDate, scheduleGeneratorDTO);
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        this.createNote(loan, command, changes);
        Boolean interestRefundCalculation = command.booleanObjectValueOfParameterNamed("interestRefundCalculation");
        Pair refundTransactions = this.loanAccountDomainService.makeRefund(loan, scheduleGeneratorDTO, loanTransactionType, transactionDate, transactionAmount, paymentDetail, txnExternalId, interestRefundCalculation);
        LoanTransaction refundTransaction = (LoanTransaction)refundTransactions.getLeft();
        LoanTransaction interestRefundTransaction = (LoanTransaction)refundTransactions.getRight();
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, transactionDate);
        this.loanAccountDomainService.disableStandingInstructionsLinkedToClosedLoan(loan);
        this.loanAccountDomainService.updateAndSavePostDatedChecksForIndividualAccount(loan, refundTransaction);
        if (interestRefundTransaction != null) {
            this.loanAccountDomainService.updateAndSavePostDatedChecksForIndividualAccount(loan, interestRefundTransaction);
        }
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, refundTransaction);
        if (interestRefundTransaction != null) {
            this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, interestRefundTransaction);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(refundTransaction, false, false);
        if (interestRefundTransaction != null) {
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(interestRefundTransaction, false, false);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        Long entityId = (Long)refundTransaction.getId();
        ExternalId entityExternalId = refundTransaction.getExternalId();
        Long subEntityId = interestRefundTransaction != null ? (Long)interestRefundTransaction.getId() : null;
        ExternalId subEntityExternalId = interestRefundTransaction != null ? interestRefundTransaction.getExternalId() : null;
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId((Long)loan.getId()).withEntityId(entityId).withEntityExternalId(entityExternalId).withSubEntityId(subEntityId).withSubEntityExternalId(subEntityExternalId).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult makeManualInterestRefund(Long loanId, Long transactionId, JsonCommand command) {
        boolean processLatest;
        this.loanTransactionValidator.validateManualInterestRefundTransaction(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (loan == null) {
            throw new LoanNotFoundException(loanId);
        }
        LoanTransaction targetTransaction = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(transactionId, loanId).orElseThrow(() -> new LoanTransactionNotFoundException(transactionId, loanId));
        LocalDate transactionDate = targetTransaction.getDateOf();
        if (!targetTransaction.isMerchantIssuedRefund() && !targetTransaction.isPayoutRefund()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.not.refund.type", "Target transaction must be Merchant Issued Refund or Payout Refund", new Object[0]);
        }
        if (targetTransaction.isReversed()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.reversed", "Target transaction is already reversed", new Object[0]);
        }
        boolean alreadyHasInterestRefund = loan.getLoanTransactions().stream().anyMatch(txn -> txn.isInterestRefund() && !txn.getLoanTransactionRelations(rel -> rel.getToTransaction().equals(targetTransaction)).isEmpty() && !txn.isReversed());
        if (alreadyHasInterestRefund) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.interest.refund.already.exists", "Interest Refund already exists for this transaction", new Object[0]);
        }
        BigDecimal amount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.interest.refund.amount.invalid", "Amount must be provided and positive", new Object[0]);
        }
        boolean shouldCreateInterestRefundTransaction = loan.getLoanProductRelatedDetail().getSupportedInterestRefundTypes().stream().map(LoanSupportedInterestRefundTypes::getTransactionType).anyMatch(transactionType -> transactionType.equals((Object)targetTransaction.getTypeOf()));
        if (!shouldCreateInterestRefundTransaction) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.transaction.interest.refund.not.supported", "Interest Refund calculation is not supported for this loan", new Object[0]);
        }
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("externalId", (String)txnExternalId);
        LocalDate recalculateFrom = loan.isInterestBearingAndInterestRecalculationEnabled() ? transactionDate : null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom, null);
        this.loanTransactionValidator.validateRefund(loan, LoanTransactionType.INTEREST_REFUND, transactionDate, scheduleGeneratorDTO);
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        this.createNote(loan, command, changes);
        LoanTransaction interestRefundTxn = this.loanAccountDomainService.createManualInterestRefundWithAmount(loan, targetTransaction, amount, paymentDetail, txnExternalId);
        interestRefundTxn.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)interestRefundTxn, (LoanTransaction)targetTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.RELATED));
        boolean isTransactionChronologicallyLatest = this.loanTransactionService.isChronologicallyLatestRepaymentOrWaiver(loan, interestRefundTxn);
        LoanRepaymentScheduleInstallment currentInstallment = loan.fetchLoanRepaymentScheduleInstallmentByDueDate(transactionDate);
        boolean bl = processLatest = isTransactionChronologicallyLatest && !loan.isForeclosure() && !loan.hasChargesAffectedByBackdatedRepaymentLikeTransaction(interestRefundTxn) && this.loanTransactionProcessingService.canProcessLatestTransactionOnly(loan, interestRefundTxn, currentInstallment);
        if (processLatest) {
            this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), interestRefundTxn, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
            loan.addLoanTransaction(interestRefundTxn);
        } else {
            if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
            } else if (loan.isProgressiveSchedule()) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
            loan.addLoanTransaction(interestRefundTxn);
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        }
        this.loanBalanceService.updateLoanOutstandingBalances(loan);
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(interestRefundTxn);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionInterestRefundPostBusinessEvent(interestRefundTxn));
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, transactionDate);
        this.loanAccountDomainService.disableStandingInstructionsLinkedToClosedLoan(loan);
        this.loanAccountDomainService.updateAndSavePostDatedChecksForIndividualAccount(loan, interestRefundTxn);
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, interestRefundTxn);
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(interestRefundTxn, false, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId((Long)loan.getId()).withEntityId((Long)interestRefundTxn.getId()).withEntityExternalId(interestRefundTxn.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).with(changes).build();
    }

    public void handleChargebackTransaction(Loan loan, LoanTransaction chargebackTransaction) {
        this.loanTransactionValidator.validateIfTransactionIsChargeback(chargebackTransaction);
        if (loan.isInterestBearing() && loan.isInterestRecalculationEnabled()) {
            loan.addLoanTransaction(chargebackTransaction);
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        } else {
            loan.addLoanTransaction(chargebackTransaction);
            this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), chargebackTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
        }
        this.loanLifecycleStateMachine.determineAndTransition(loan, chargebackTransaction.getTransactionDate());
    }

    private void validateIsMultiDisbursalLoanAndDisbursedMoreThanOneTranche(Loan loan) {
        if (!loan.isMultiDisburmentLoan()) {
            String errorMessage = "loan.product.does.not.support.multiple.disbursals.cannot.undo.last.disbursal";
            throw new LoanMultiDisbursementException("loan.product.does.not.support.multiple.disbursals.cannot.undo.last.disbursal", new Object[0]);
        }
        int trancheDisbursedCount = 0;
        for (LoanDisbursementDetails disbursementDetails : loan.getDisbursementDetails()) {
            if (disbursementDetails.actualDisbursementDate() == null) continue;
            ++trancheDisbursedCount;
        }
        if (trancheDisbursedCount <= 1) {
            String errorMessage = "tranches.should.be.disbursed.more.than.one.to.undo.last.disbursal";
            throw new LoanMultiDisbursementException("tranches.should.be.disbursed.more.than.one.to.undo.last.disbursal", new Object[0]);
        }
    }

    private void syncExpectedDateWithActualDisbursementDate(Loan loan, LocalDate actualDisbursementDate) {
        if (!loan.getExpectedDisbursedOnLocalDate().equals(actualDisbursementDate)) {
            throw new DateMismatchException(actualDisbursementDate, loan.getExpectedDisbursedOnLocalDate());
        }
    }

    private void validateTransactionsForTransfer(Loan loan, LocalDate transferDate) {
        for (LoanTransaction transaction : loan.getLoanTransactions()) {
            if ((!DateUtils.isEqual((LocalDate)transferDate, (LocalDate)transaction.getTransactionDate()) || !DateUtils.isEqual((LocalDate)transferDate, (LocalDate)transaction.getSubmittedOnDate())) && !DateUtils.isBefore((LocalDate)transferDate, (LocalDate)transaction.getTransactionDate())) continue;
            throw new GeneralPlatformDomainRuleException("error.msg.cannot.transfer.client.as.loan.transaction.present.on.or.after.transfer.date", "error msg cannot transfer client as loan transaction present on or after transfer date", new Object[]{transaction.getTransactionDate(), transferDate});
        }
    }

    private Map<String, Object> undoDisbursal(Loan loan, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        LoanStatus currentStatus = loan.getStatus();
        LoanStatus statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.LOAN_DISBURSAL_UNDO, loan);
        if (!statusEnum.hasStateOf(currentStatus)) {
            this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_DISBURSAL_UNDO, loan);
            actualChanges.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
            LocalDate actualDisbursementDate = loan.getDisbursementDate();
            boolean isScheduleRegenerateRequired = loan.isActualDisbursedOnDateEarlierOrLaterThanExpected(actualDisbursementDate);
            loan.setActualDisbursementDate(null);
            loan.setDisbursedBy(null);
            loan.setLastClosedBusinessDate(null);
            boolean isDisbursedAmountChanged = !MathUtil.isEqualTo((BigDecimal)loan.getApprovedPrincipal(), (BigDecimal)loan.getLoanRepaymentScheduleDetail().getPrincipal().getAmount());
            loan.getLoanRepaymentScheduleDetail().setPrincipal(loan.getApprovedPrincipal());
            if (loan.loanProduct().isDisallowExpectedDisbursements() && !loan.getDisbursementDetails().isEmpty()) {
                for (LoanDisbursementDetails disbursementDetail : loan.getAllDisbursementDetails()) {
                    disbursementDetail.reverse();
                }
            } else {
                for (LoanDisbursementDetails details : loan.getDisbursementDetails()) {
                    details.updateActualDisbursementDate(null);
                }
            }
            boolean isEmiAmountChanged = !loan.getLoanTermVariations().isEmpty();
            this.updateLoanToPreDisbursalState(loan);
            if (isScheduleRegenerateRequired || isDisbursedAmountChanged || isEmiAmountChanged || loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
                if (isDisbursedAmountChanged) {
                    loan.updateSummaryWithTotalFeeChargesDueAtDisbursement(loan.deriveSumTotalOfChargesDueAtDisbursement());
                }
            } else if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
                for (LoanRepaymentScheduleInstallment period : loan.getRepaymentScheduleInstallments()) {
                    period.resetAccrualComponents();
                }
            }
            if (loan.isTopup()) {
                loan.getLoanTopupDetails().setAccountTransferDetails(null);
                loan.getLoanTopupDetails().setTopupAmount(null);
            }
            loan.adjustNetDisbursalAmount(loan.getApprovedPrincipal());
            actualChanges.put("actualDisbursementDate", "");
            this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        }
        return actualChanges;
    }

    public void updateLoanToPreDisbursalState(Loan loan) {
        loan.setActualDisbursementDate(null);
        loan.setDisbursedBy(null);
        loan.setAccruedTill(null);
        this.reverseExistingTransactions(loan);
        BigDecimal principalForScheduleRegeneration = loan.getApprovedPrincipal();
        for (Object charge : loan.getActiveCharges()) {
            if (charge.isOverdueInstallmentCharge()) {
                charge.setActive(false);
                continue;
            }
            charge.resetToOriginal(loan.loanCurrency());
        }
        loan.getLoanRepaymentScheduleDetail().setPrincipal(principalForScheduleRegeneration);
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment currentInstallment : installments) {
            currentInstallment.resetDerivedComponents();
        }
        for (LoanTermVariations variations : loan.getLoanTermVariations()) {
            if (!variations.getOnLoanStatus().equals(LoanStatus.ACTIVE.getValue())) continue;
            variations.markAsInactive();
        }
        LoanRepaymentScheduleProcessingWrapper wrapper = new LoanRepaymentScheduleProcessingWrapper();
        wrapper.reprocess(loan.getCurrency(), loan.getDisbursementDate(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        this.loanBalanceService.refreshSummaryAndBalancesForDisbursedLoan(loan);
    }

    private void reverseExistingTransactions(Loan loan) {
        ArrayList<LoanTransaction> retainTransactions = new ArrayList<LoanTransaction>();
        for (LoanTransaction transaction : loan.getLoanTransactions()) {
            this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(transaction.getLoan(), transaction, "reversed");
            transaction.reverse();
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            if (transaction.getId() == null) continue;
            retainTransactions.add(transaction);
        }
        loan.getLoanTransactions().retainAll(retainTransactions);
    }

    private Optional<LoanTransaction> closeAsWrittenOff(Loan loan, JsonCommand command, Map<String, Object> changes, AppUser currentUser, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        this.closeDisbursements(loan, scheduleGeneratorDTO);
        LocalDate writtenOffOnLocalDate = command.localDateValueOfParameterNamed("transactionDate");
        loan.setClosedOnDate(writtenOffOnLocalDate);
        loan.setWrittenOffOnDate(writtenOffOnLocalDate);
        loan.setClosedBy(currentUser);
        LoanStatus statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.WRITE_OFF_OUTSTANDING, loan);
        if (statusEnum.hasStateOf(loan.getStatus())) {
            return Optional.empty();
        }
        String txnExternalId = command.stringValueOfParameterNamedAllowingNull("externalId");
        ExternalId externalId = ExternalIdFactory.produce((String)txnExternalId);
        if (externalId.isEmpty() && TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
            externalId = ExternalId.generate();
        }
        changes.put("closedOnDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("writtenOffOnDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("externalId", externalId);
        if (DateUtils.isBefore((LocalDate)writtenOffOnLocalDate, (LocalDate)loan.getDisbursementDate())) {
            String errorMessage = "The date on which a loan is written off cannot be before the loan disbursement date: " + loan.getDisbursementDate().toString();
            throw new InvalidLoanStateTransitionException("writeoff", "cannot.be.before.submittal.date", errorMessage, new Object[]{writtenOffOnLocalDate, loan.getDisbursementDate()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)writtenOffOnLocalDate)) {
            String errorMessage = "The date on which a loan is written off cannot be in the future.";
            throw new InvalidLoanStateTransitionException("writeoff", "cannot.be.a.future.date", "The date on which a loan is written off cannot be in the future.", new Object[]{writtenOffOnLocalDate});
        }
        LoanTransaction loanTransaction = LoanTransaction.writeoff((Loan)loan, (Office)loan.getOffice(), (LocalDate)writtenOffOnLocalDate, (ExternalId)externalId);
        LocalDate lastTransactionDate = loan.getLastUserTransactionDate();
        if (DateUtils.isAfter((LocalDate)lastTransactionDate, (LocalDate)writtenOffOnLocalDate)) {
            String errorMessage = "The date of the writeoff transaction must occur on or after previous transactions.";
            throw new InvalidLoanStateTransitionException("writeoff", "must.occur.on.or.after.other.transaction.dates", "The date of the writeoff transaction must occur on or after previous transactions.", new Object[]{writtenOffOnLocalDate});
        }
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && DateUtils.isBeforeBusinessDate((LocalDate)loanTransaction.getTransactionDate())) {
            if (loan.isProgressiveSchedule()) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
            loan.addLoanTransaction(loanTransaction);
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        } else {
            loan.addLoanTransaction(loanTransaction);
            this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), loanTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
        }
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        this.loanLifecycleStateMachine.transition(LoanEvent.WRITE_OFF_OUTSTANDING, loan);
        changes.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
        return Optional.of(loanTransaction);
    }

    private void closeDisbursements(Loan loan, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        if (loan.isDisbursementAllowed() && loan.atLeastOnceDisbursed()) {
            loan.getLoanRepaymentScheduleDetail().setPrincipal(loan.getDisbursedAmount());
            loan.removeDisbursementDetail();
            if (loan.isCumulativeSchedule()) {
                if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                    this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
                } else {
                    this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
                }
            }
        }
    }

    private Optional<LoanTransaction> close(Loan loan, JsonCommand command, Map<String, Object> changes, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        LoanStatus statusEnum;
        LocalDate closureDate = command.localDateValueOfParameterNamed("transactionDate");
        String txnExternalId = command.stringValueOfParameterNamedAllowingNull("externalId");
        ExternalId externalId = ExternalIdFactory.produce((String)txnExternalId);
        if (externalId.isEmpty() && TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
            externalId = ExternalId.generate();
        }
        loan.setClosedOnDate(closureDate);
        changes.put("closedOnDate", command.stringValueOfParameterNamed("transactionDate"));
        if (DateUtils.isBefore((LocalDate)closureDate, (LocalDate)loan.getDisbursementDate())) {
            String errorMessage = "The date on which a loan is closed cannot be before the loan disbursement date: " + loan.getDisbursementDate().toString();
            throw new InvalidLoanStateTransitionException("close", "cannot.be.before.submittal.date", errorMessage, new Object[]{closureDate, loan.getDisbursementDate()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)closureDate)) {
            String errorMessage = "The date on which a loan is closed cannot be in the future.";
            throw new InvalidLoanStateTransitionException("close", "cannot.be.a.future.date", "The date on which a loan is closed cannot be in the future.", new Object[]{closureDate});
        }
        this.closeDisbursements(loan, scheduleGeneratorDTO);
        LoanTransaction loanTransaction = null;
        if (loan.isOpen()) {
            Money totalOutstanding = loan.getSummary().getTotalOutstanding(loan.getCurrency());
            if (totalOutstanding.isGreaterThanZero() && loan.getInArrearsTolerance().isGreaterThanOrEqualTo(totalOutstanding)) {
                loan.setClosedOnDate(closureDate);
                statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.REPAID_IN_FULL, loan);
                if (!statusEnum.hasStateOf(loan.getStatus())) {
                    this.loanLifecycleStateMachine.transition(LoanEvent.REPAID_IN_FULL, loan);
                    changes.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
                }
                changes.put("externalId", externalId);
                loanTransaction = LoanTransaction.writeoff((Loan)loan, (Office)loan.getOffice(), (LocalDate)closureDate, (ExternalId)externalId);
                boolean isLastTransaction = this.loanTransactionRepository.isChronologicallyLatest(loanTransaction.getTransactionDate(), loan);
                if (!isLastTransaction) {
                    String errorMessage = "The closing date of the loan must be on or after latest transaction date.";
                    throw new InvalidLoanStateTransitionException("close.loan", "must.occur.on.or.after.latest.transaction.date", "The closing date of the loan must be on or after latest transaction date.", new Object[]{closureDate});
                }
                loan.addLoanTransaction(loanTransaction);
                this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), loanTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
                this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
            } else if (totalOutstanding.isGreaterThanZero()) {
                String errorMessage = "A loan with money outstanding cannot be closed";
                throw new InvalidLoanStateTransitionException("close", "loan.has.money.outstanding", "A loan with money outstanding cannot be closed", new Object[]{totalOutstanding.toString()});
            }
        }
        if (this.loanBalanceService.isOverPaid(loan)) {
            Money totalLoanOverpayment = this.loanBalanceService.calculateTotalOverpayment(loan);
            if (totalLoanOverpayment.isGreaterThanZero() && loan.getInArrearsTolerance().isGreaterThanOrEqualTo(totalLoanOverpayment)) {
                loan.setClosedOnDate(closureDate);
                statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.REPAID_IN_FULL, loan);
                if (!statusEnum.hasStateOf(loan.getStatus())) {
                    this.loanLifecycleStateMachine.transition(LoanEvent.REPAID_IN_FULL, loan);
                    changes.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
                }
            } else if (totalLoanOverpayment.isGreaterThanZero()) {
                String errorMessage = "The loan is marked as 'Overpaid' and cannot be moved to 'Closed (obligations met).";
                throw new InvalidLoanStateTransitionException("close", "loan.is.overpaid", "The loan is marked as 'Overpaid' and cannot be moved to 'Closed (obligations met).", new Object[]{totalLoanOverpayment.toString()});
            }
        }
        return Optional.ofNullable(loanTransaction);
    }

    private void updateDisbursementDateAndAmountForTranche(Loan loan, LoanDisbursementDetails disbursementDetails, JsonCommand command, Map<String, Object> actualChanges, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        Locale locale = command.extractLocale();
        BigDecimal principal = command.bigDecimalValueOfParameterNamed("updatedPrincipal", locale);
        LocalDate expectedDisbursementDate = command.localDateValueOfParameterNamed("updatedExpectedDisbursementDate");
        disbursementDetails.updateExpectedDisbursementDateAndAmount(expectedDisbursementDate, principal);
        actualChanges.put("expectedDisbursementDate", command.stringValueOfParameterNamed("expectedDisbursementDate"));
        actualChanges.put("id", command.stringValueOfParameterNamed("id"));
        actualChanges.put("principal", command.bigDecimalValueOfParameterNamed("principal", locale));
        loan.getLoanRepaymentScheduleDetail().setPrincipal(loan.getPrincipalAmountForRepaymentSchedule());
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else if (loan.isProgressiveSchedule()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
    }

    private Map<String, Object> undoLastDisbursal(ScheduleGeneratorDTO scheduleGeneratorDTO, Loan loan) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        List loanTransactions = loan.retrieveListOfTransactionsByType(LoanTransactionType.DISBURSEMENT);
        loanTransactions.sort(Comparator.comparing(AbstractPersistableCustom::getId));
        LoanTransaction lastDisbursalTransaction = (LoanTransaction)loanTransactions.getLast();
        LocalDate lastTransactionDate = lastDisbursalTransaction.getTransactionDate();
        loanTransactions = this.loanTransactionRepository.findNonReversedMonetaryTransactionsByLoan(loan);
        Collections.reverse(loanTransactions);
        for (LoanTransaction previousTransaction : loanTransactions) {
            if (DateUtils.isBefore((LocalDate)lastTransactionDate, (LocalDate)previousTransaction.getTransactionDate()) && (previousTransaction.isRepaymentLikeType() || previousTransaction.isWaiver() || previousTransaction.isChargePayment())) {
                throw new UndoLastTrancheDisbursementException(new Object[]{previousTransaction.getId()});
            }
            if (((Long)previousTransaction.getId()).compareTo((Long)lastDisbursalTransaction.getId()) >= 0) continue;
            break;
        }
        LoanDisbursementDetails disbursementDetail = loan.getDisbursementDetails(lastTransactionDate, lastDisbursalTransaction.getAmount());
        this.loanBalanceService.updateLoanToLastDisbursalState(loan, disbursementDetail);
        loan.getLoanTermVariations().removeIf(loanTermVariations -> loanTermVariations.getTermType().isDueDateVariation() && DateUtils.isAfter((LocalDate)loanTermVariations.fetchDateValue(), (LocalDate)lastTransactionDate) || loanTermVariations.getTermType().isEMIAmountVariation() && DateUtils.isEqual((LocalDate)loanTermVariations.getTermApplicableFrom(), (LocalDate)lastTransactionDate) || DateUtils.isAfter((LocalDate)loanTermVariations.getTermApplicableFrom(), (LocalDate)lastTransactionDate));
        this.reverseExistingTransactionsTillLastDisbursal(loan, lastDisbursalTransaction);
        this.loanScheduleService.regenerateScheduleWithReprocessingTransactions(loan, scheduleGeneratorDTO);
        actualChanges.put("undolastdisbursal", "true");
        actualChanges.put("disbursedAmount", loan.getDisbursedAmount());
        this.loanLifecycleStateMachine.determineAndTransition(loan, loan.getLastUserTransactionDate());
        return actualChanges;
    }

    private void waiveInterest(Loan loan, LoanTransaction waiveInterestTransaction, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        this.loanDownPaymentHandlerService.handleRepaymentOrRecoveryOrWaiverTransaction(loan, waiveInterestTransaction, null, scheduleGeneratorDTO);
    }

    private void undoWrittenOff(Loan loan) {
        LoanTransaction writeOffTransaction = loan.findWriteOffTransaction();
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(writeOffTransaction.getLoan(), writeOffTransaction, "reversed");
        writeOffTransaction.reverse();
        this.loanLifecycleStateMachine.transition(LoanEvent.WRITE_OFF_OUTSTANDING_UNDO, loan);
        if (loan.isProgressiveSchedule()) {
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
    }

    public void reverseExistingTransactionsTillLastDisbursal(Loan loan, LoanTransaction lastDisbursalTransaction) {
        LoanCharge chargeToDeactivate = null;
        for (LoanCharge charge : loan.getCharges()) {
            if (!charge.isTrancheDisbursementCharge() || charge.getTrancheDisbursementCharge() == null || charge.getTrancheDisbursementCharge().getloanDisbursementDetails() == null) continue;
            LocalDate expectedDate = charge.getTrancheDisbursementCharge().getloanDisbursementDetails().expectedDisbursementDate();
            LocalDate actualDate = charge.getTrancheDisbursementCharge().getloanDisbursementDetails().actualDisbursementDate();
            if ((actualDate == null || !actualDate.equals(lastDisbursalTransaction.getTransactionDate())) && (expectedDate == null || !expectedDate.equals(lastDisbursalTransaction.getTransactionDate()))) continue;
            chargeToDeactivate = charge;
            break;
        }
        if (chargeToDeactivate != null) {
            chargeToDeactivate.resetPaidAmount(loan.getCurrency());
            chargeToDeactivate.setActive(false);
        }
        for (LoanTransaction transaction2 : loan.getLoanTransactions()) {
            if (DateUtils.isBefore((LocalDate)transaction2.getTransactionDate(), (LocalDate)lastDisbursalTransaction.getTransactionDate()) || ((Long)transaction2.getId()).compareTo((Long)lastDisbursalTransaction.getId()) < 0 || !transaction2.isAllowTypeTransactionAtTheTimeOfLastUndo().booleanValue()) continue;
            this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(transaction2.getLoan(), transaction2, "reversed");
            transaction2.reverse();
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction2, false, false);
        }
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        if (loan.isAutoRepaymentForDownPaymentEnabled()) {
            BigDecimal disbursedAmountPercentageForDownPayment = loan.getLoanRepaymentScheduleDetail().getDisbursedAmountPercentageForDownPayment();
            Money downPaymentMoney = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.percentageOf((BigDecimal)lastDisbursalTransaction.getAmount(), (BigDecimal)disbursedAmountPercentageForDownPayment, (int)19));
            Optional<LoanTransaction> downPaymentTransaction = loan.getLoanTransactions().stream().filter(tr -> tr.getTransactionDate().equals(lastDisbursalTransaction.getTransactionDate()) && tr.getTypeOf().isDownPayment() && tr.getAmount().compareTo(downPaymentMoney.getAmount()) == 0).max(Comparator.comparing(AbstractPersistableCustom::getId));
            downPaymentTransaction.ifPresent(transaction -> {
                this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(transaction.getLoan(), transaction, "reversed");
                transaction.reverse();
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            });
        }
    }

    public void closeAsMarkedForReschedule(Loan loan, JsonCommand command, Map<String, Object> changes) {
        LocalDate rescheduledOn = command.localDateValueOfParameterNamed("transactionDate");
        loan.setClosedOnDate(rescheduledOn);
        LoanStatus statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.LOAN_RESCHEDULE, loan);
        if (!statusEnum.hasStateOf(loan.getStatus())) {
            this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_RESCHEDULE, loan);
            changes.put("status", LoanEnumerations.status((LoanStatus)loan.getLoanStatus()));
        }
        loan.setRescheduledOnDate(rescheduledOn);
        changes.put("closedOnDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("rescheduledOnDate", command.stringValueOfParameterNamed("transactionDate"));
        this.loanTransactionValidator.validateLoanRescheduleDate(loan);
    }

    private boolean canDisburse(Loan loan) {
        LoanStatus statusEnum = this.loanLifecycleStateMachine.dryTransition(LoanEvent.LOAN_DISBURSED, loan);
        boolean isMultiTrancheDisburse = false;
        LoanStatus actualLoanStatus = loan.getStatus();
        if ((actualLoanStatus.isActive() || actualLoanStatus.isClosedObligationsMet() || actualLoanStatus.isOverpaid()) && loan.isAllTranchesNotDisbursed()) {
            isMultiTrancheDisburse = true;
        }
        return !statusEnum.hasStateOf(actualLoanStatus) || isMultiTrancheDisburse;
    }

    private void updateLoanRepaymentScheduleDates(Loan loan, LocalDate meetingStartDate, String recuringRule, boolean isHolidayEnabled, List<Holiday> holidays, WorkingDays workingDays, boolean isSkipRepaymentonfirstdayofmonth, Integer numberofDays) {
        LocalDate tmpFromDate = loan.getDisbursementDate();
        PeriodFrequencyType repaymentPeriodFrequencyType = loan.getLoanRepaymentScheduleDetail().getRepaymentPeriodFrequencyType();
        Integer loanRepaymentInterval = loan.getLoanRepaymentScheduleDetail().getRepayEvery();
        String frequency = CalendarUtils.getMeetingFrequencyFromPeriodFrequencyType((PeriodFrequencyType)repaymentPeriodFrequencyType);
        LocalDate latestRepaymentDate = null;
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : installments) {
            LocalDate oldDueDate = loanRepaymentScheduleInstallment.getDueDate();
            if (DateUtils.isAfter((LocalDate)oldDueDate, (LocalDate)meetingStartDate) && DateUtils.isDateInTheFuture((LocalDate)oldDueDate)) {
                LocalDate maxDateLimitForNewRepayment;
                LocalDate newRepaymentDate = CalendarUtils.getNewRepaymentMeetingDate((String)recuringRule, (LocalDate)meetingStartDate, (LocalDate)oldDueDate, (Integer)loanRepaymentInterval, (String)frequency, (WorkingDays)workingDays, (boolean)isSkipRepaymentonfirstdayofmonth, (Integer)numberofDays);
                if (DateUtils.isAfter((LocalDate)newRepaymentDate, (LocalDate)(maxDateLimitForNewRepayment = this.getMaxDateLimitForNewRepayment(repaymentPeriodFrequencyType, loanRepaymentInterval, tmpFromDate)))) {
                    newRepaymentDate = CalendarUtils.getNextRepaymentMeetingDate((String)recuringRule, (LocalDate)meetingStartDate, (LocalDate)tmpFromDate, (Integer)loanRepaymentInterval, (String)frequency, (WorkingDays)workingDays, (boolean)isSkipRepaymentonfirstdayofmonth, (Integer)numberofDays);
                }
                if (isHolidayEnabled) {
                    newRepaymentDate = HolidayUtil.getRepaymentRescheduleDateToIfHoliday((LocalDate)newRepaymentDate, holidays);
                }
                if (DateUtils.isBefore(latestRepaymentDate, (LocalDate)newRepaymentDate)) {
                    latestRepaymentDate = newRepaymentDate;
                }
                loanRepaymentScheduleInstallment.updateDueDate(newRepaymentDate);
                loanRepaymentScheduleInstallment.updateFromDate(tmpFromDate);
                tmpFromDate = newRepaymentDate;
                continue;
            }
            tmpFromDate = oldDueDate;
        }
        if (latestRepaymentDate != null) {
            loan.setExpectedMaturityDate(latestRepaymentDate);
        }
    }

    private LocalDate getMaxDateLimitForNewRepayment(PeriodFrequencyType periodFrequencyType, Integer loanRepaymentInterval, LocalDate startDate) {
        LocalDate dueRepaymentPeriodDate = startDate;
        int repaidEvery = 2 * loanRepaymentInterval;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$common$domain$PeriodFrequencyType[periodFrequencyType.ordinal()]) {
            case 1: {
                dueRepaymentPeriodDate = startDate.plusDays(repaidEvery);
                break;
            }
            case 2: {
                dueRepaymentPeriodDate = startDate.plusWeeks(repaidEvery);
                break;
            }
            case 3: {
                dueRepaymentPeriodDate = startDate.plusMonths(repaidEvery);
                break;
            }
            case 4: {
                dueRepaymentPeriodDate = startDate.plusYears(repaidEvery);
                break;
            }
        }
        return dueRepaymentPeriodDate.minusDays(1L);
    }

    private void updateLoanRepaymentScheduleDates(Loan loan, String recurringRule, boolean isHolidayEnabled, List<Holiday> holidays, WorkingDays workingDays, LocalDate presentMeetingDate, LocalDate newMeetingDate, boolean isSkipRepaymentOnFirstDayOfMonth, Integer numberOfDays) {
        LocalDate tmpFromDate = loan.getDisbursementDate();
        PeriodFrequencyType repaymentPeriodFrequencyType = loan.getLoanRepaymentScheduleDetail().getRepaymentPeriodFrequencyType();
        Integer loanRepaymentInterval = loan.getLoanRepaymentScheduleDetail().getRepayEvery();
        String frequency = CalendarUtils.getMeetingFrequencyFromPeriodFrequencyType((PeriodFrequencyType)repaymentPeriodFrequencyType);
        boolean isFirstTime = true;
        LocalDate latestRepaymentDate = null;
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : installments) {
            LocalDate oldDueDate = loanRepaymentScheduleInstallment.getDueDate();
            if (!DateUtils.isBefore((LocalDate)oldDueDate, (LocalDate)presentMeetingDate)) {
                LocalDate newRepaymentDate;
                if (isFirstTime) {
                    isFirstTime = false;
                    newRepaymentDate = newMeetingDate;
                } else {
                    newRepaymentDate = CalendarUtils.getNewRepaymentMeetingDate((String)recurringRule, (LocalDate)tmpFromDate, (LocalDate)tmpFromDate.plusDays(1L), (Integer)loanRepaymentInterval, (String)frequency, (WorkingDays)workingDays, (boolean)isSkipRepaymentOnFirstDayOfMonth, (Integer)numberOfDays);
                }
                if (isHolidayEnabled) {
                    newRepaymentDate = HolidayUtil.getRepaymentRescheduleDateToIfHoliday((LocalDate)newRepaymentDate, holidays);
                }
                if (DateUtils.isBefore(latestRepaymentDate, (LocalDate)newRepaymentDate)) {
                    latestRepaymentDate = newRepaymentDate;
                }
                loanRepaymentScheduleInstallment.updateDueDate(newRepaymentDate);
                loanRepaymentScheduleInstallment.updateFromDate(tmpFromDate);
                tmpFromDate = newRepaymentDate;
                continue;
            }
            tmpFromDate = oldDueDate;
        }
        if (latestRepaymentDate != null) {
            loan.setExpectedMaturityDate(latestRepaymentDate);
        }
    }

    @Generated
    public LoanWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, LoanTransactionValidator loanTransactionValidator, LoanUpdateCommandFromApiJsonDeserializer loanUpdateCommandFromApiJsonDeserializer, LoanRepositoryWrapper loanRepositoryWrapper, LoanAccountDomainService loanAccountDomainService, NoteRepository noteRepository, LoanTransactionRepository loanTransactionRepository, LoanTransactionRelationRepository loanTransactionRelationRepository, LoanAssembler loanAssembler, CalendarInstanceRepository calendarInstanceRepository, PaymentDetailWritePlatformService paymentDetailWritePlatformService, HolidayRepositoryWrapper holidayRepository, ConfigurationDomainService configurationDomainService, WorkingDaysRepositoryWrapper workingDaysRepository, AccountTransfersWritePlatformService accountTransfersWritePlatformService, AccountTransfersReadPlatformService accountTransfersReadPlatformService, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, LoanReadPlatformService loanReadPlatformService, FromJsonHelper fromApiJsonHelper, CalendarRepository calendarRepository, LoanScheduleHistoryWritePlatformService loanScheduleHistoryWritePlatformService, LoanApplicationValidator loanApplicationValidator, AccountAssociationsRepository accountAssociationRepository, AccountTransferDetailRepository accountTransferDetailRepository, BusinessEventNotifierService businessEventNotifierService, GuarantorDomainService guarantorDomainService, LoanUtilService loanUtilService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, CodeValueRepositoryWrapper codeValueRepository, CashierTransactionDataValidator cashierTransactionDataValidator, GLIMAccountInfoRepository glimRepository, LoanRepository loanRepository, RepaymentWithPostDatedChecksAssembler repaymentWithPostDatedChecksAssembler, PostDatedChecksRepository postDatedChecksRepository, LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository, LoanLifecycleStateMachine loanLifecycleStateMachine, LoanAccountLockService loanAccountLockService, ExternalIdFactory externalIdFactory, LoanAccrualTransactionBusinessEventService loanAccrualTransactionBusinessEventService, ErrorHandler errorHandler, LoanDownPaymentHandlerService loanDownPaymentHandlerService, LoanTransactionAssembler loanTransactionAssembler, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanOfficerValidator loanOfficerValidator, LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator, LoanDisbursementService loanDisbursementService, LoanScheduleService loanScheduleService, LoanChargeValidator loanChargeValidator, LoanOfficerService loanOfficerService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanAccountService loanAccountService, LoanJournalEntryPoster journalEntryPoster, LoanAdjustmentService loanAdjustmentService, LoanMapper loanMapper, LoanTransactionProcessingService loanTransactionProcessingService, LoanBalanceService loanBalanceService, LoanTransactionService loanTransactionService) {
        this.context = context;
        this.loanTransactionValidator = loanTransactionValidator;
        this.loanUpdateCommandFromApiJsonDeserializer = loanUpdateCommandFromApiJsonDeserializer;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanAccountDomainService = loanAccountDomainService;
        this.noteRepository = noteRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanTransactionRelationRepository = loanTransactionRelationRepository;
        this.loanAssembler = loanAssembler;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.holidayRepository = holidayRepository;
        this.configurationDomainService = configurationDomainService;
        this.workingDaysRepository = workingDaysRepository;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.calendarRepository = calendarRepository;
        this.loanScheduleHistoryWritePlatformService = loanScheduleHistoryWritePlatformService;
        this.loanApplicationValidator = loanApplicationValidator;
        this.accountAssociationRepository = accountAssociationRepository;
        this.accountTransferDetailRepository = accountTransferDetailRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.guarantorDomainService = guarantorDomainService;
        this.loanUtilService = loanUtilService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.codeValueRepository = codeValueRepository;
        this.cashierTransactionDataValidator = cashierTransactionDataValidator;
        this.glimRepository = glimRepository;
        this.loanRepository = loanRepository;
        this.repaymentWithPostDatedChecksAssembler = repaymentWithPostDatedChecksAssembler;
        this.postDatedChecksRepository = postDatedChecksRepository;
        this.loanRepaymentScheduleInstallmentRepository = loanRepaymentScheduleInstallmentRepository;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.loanAccountLockService = loanAccountLockService;
        this.externalIdFactory = externalIdFactory;
        this.loanAccrualTransactionBusinessEventService = loanAccrualTransactionBusinessEventService;
        this.errorHandler = errorHandler;
        this.loanDownPaymentHandlerService = loanDownPaymentHandlerService;
        this.loanTransactionAssembler = loanTransactionAssembler;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanOfficerValidator = loanOfficerValidator;
        this.loanDownPaymentTransactionValidator = loanDownPaymentTransactionValidator;
        this.loanDisbursementService = loanDisbursementService;
        this.loanScheduleService = loanScheduleService;
        this.loanChargeValidator = loanChargeValidator;
        this.loanOfficerService = loanOfficerService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanAccountService = loanAccountService;
        this.journalEntryPoster = journalEntryPoster;
        this.loanAdjustmentService = loanAdjustmentService;
        this.loanMapper = loanMapper;
        this.loanTransactionProcessingService = loanTransactionProcessingService;
        this.loanBalanceService = loanBalanceService;
        this.loanTransactionService = loanTransactionService;
    }
}

