/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.addperiodicaccrualentriesforloanswithincomepostedastransactions;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class AddPeriodicAccrualEntriesForLoansTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddPeriodicAccrualEntriesForLoansTasklet.class);
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection loanIds = this.loanReadPlatformService.retrieveLoanIdsWithPendingIncomePostingTransactions();
        if (!CollectionUtils.isEmpty((Collection)loanIds)) {
            ArrayList<Exception> errors = new ArrayList<Exception>();
            for (Long loanId : loanIds) {
                try {
                    this.loanAccrualsProcessingService.addIncomePostingAndAccruals(loanId);
                }
                catch (Exception e) {
                    log.error("Failed to add income and accrual transaction for loan {}", (Object)loanId, (Object)e);
                    errors.add(e);
                }
            }
            if (!errors.isEmpty()) {
                throw new JobExecutionException(errors);
            }
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public AddPeriodicAccrualEntriesForLoansTasklet(LoanReadPlatformService loanReadPlatformService, LoanAccrualsProcessingService loanAccrualsProcessingService) {
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
    }
}

