/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.service;

import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.event.business.BusinessEventListener;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApprovedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUndoApprovalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUndoDisbursalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanUndoWrittenOffBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanWrittenOffPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.Guarantor;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingDetails;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingRepository;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingTransaction;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorRepository;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorDomainService;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorDomainServiceImpl;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductGuaranteeDetails;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.savings.domain.DepositAccountOnHoldTransaction;
import org.apache.fineract.portfolio.savings.domain.DepositAccountOnHoldTransactionRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.exception.InsufficientAccountBalanceException;
import org.springframework.stereotype.Service;

@Service
public class GuarantorDomainServiceImpl
implements GuarantorDomainService {
    private final GuarantorRepository guarantorRepository;
    private final GuarantorFundingRepository guarantorFundingRepository;
    private final GuarantorFundingTransactionRepository guarantorFundingTransactionRepository;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository;
    private final Map<Long, Long> releaseLoanIds = new HashMap(2);
    private final SavingsAccountAssembler savingsAccountAssembler;
    private final ConfigurationDomainService configurationDomainService;
    private final ExternalIdFactory externalIdFactory;
    private final LoanRepository loanRepository;
    private final LoanTransactionRepository loanTransactionRepository;

    @PostConstruct
    public void addListeners() {
        this.businessEventNotifierService.addPostBusinessEventListener(LoanApprovedBusinessEvent.class, (BusinessEventListener)new ValidateOnBusinessEvent(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanApprovedBusinessEvent.class, (BusinessEventListener)new HoldFundsOnBusinessEvent(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanUndoApprovalBusinessEvent.class, (BusinessEventListener)new UndoAllFundTransactions(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanUndoDisbursalBusinessEvent.class, (BusinessEventListener)new ReverseAllFundsOnBusinessEvent(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanAdjustTransactionBusinessEvent.class, (BusinessEventListener)new AdjustFundsOnBusinessEvent(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanTransactionMakeRepaymentPostBusinessEvent.class, (BusinessEventListener)new ReleaseFundsOnBusinessEvent(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanWrittenOffPostBusinessEvent.class, (BusinessEventListener)new ReleaseAllFunds(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanUndoWrittenOffBusinessEvent.class, (BusinessEventListener)new ReverseFundsOnBusinessEvent(this));
    }

    public void validateGuarantorBusinessRules(Loan loan) {
        LoanProduct loanProduct = loan.loanProduct();
        BigDecimal principal = loan.getPrincipal().getAmount();
        if (loanProduct.isHoldGuaranteeFunds()) {
            LoanProductGuaranteeDetails guaranteeData = loanProduct.getLoanProductGuaranteeDetails();
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            BigDecimal mandatoryAmount = principal.multiply(guaranteeData.getMandatoryGuarantee()).divide(BigDecimal.valueOf(100L));
            BigDecimal minSelfAmount = principal.multiply(guaranteeData.getMinimumGuaranteeFromOwnFunds()).divide(BigDecimal.valueOf(100L));
            BigDecimal minExtGuarantee = principal.multiply(guaranteeData.getMinimumGuaranteeFromGuarantor()).divide(BigDecimal.valueOf(100L));
            BigDecimal actualAmount = BigDecimal.ZERO;
            BigDecimal actualSelfAmount = BigDecimal.ZERO;
            BigDecimal actualExtGuarantee = BigDecimal.ZERO;
            for (Guarantor guarantor : existGuarantorList) {
                List fundingDetails = guarantor.getGuarantorFundDetails();
                for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                    if (!guarantorFundingDetails.getStatus().isActive() && !guarantorFundingDetails.getStatus().isWithdrawn() && !guarantorFundingDetails.getStatus().isCompleted()) continue;
                    if (guarantor.isSelfGuarantee()) {
                        actualSelfAmount = actualSelfAmount.add(guarantorFundingDetails.getAmount()).subtract(guarantorFundingDetails.getAmountTransfered());
                        continue;
                    }
                    actualExtGuarantee = actualExtGuarantee.add(guarantorFundingDetails.getAmount()).subtract(guarantorFundingDetails.getAmountTransfered());
                }
            }
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.guarantor");
            if (actualSelfAmount.compareTo(minSelfAmount) < 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("min.self.guarantee.required", new Object[]{minSelfAmount});
            }
            if (actualExtGuarantee.compareTo(minExtGuarantee) < 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("min.external.guarantee.required", new Object[]{minExtGuarantee});
            }
            if ((actualAmount = actualAmount.add(actualExtGuarantee).add(actualSelfAmount)).compareTo(mandatoryAmount) < 0) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("mandated.guarantee.required", new Object[]{mandatoryAmount});
            }
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
            }
        }
    }

    public void assignGuarantor(GuarantorFundingDetails guarantorFundingDetails, LocalDate transactionDate) {
        if (guarantorFundingDetails.getStatus().isActive()) {
            SavingsAccount savingsAccount = guarantorFundingDetails.getLinkedSavingsAccount();
            savingsAccount.holdFunds(guarantorFundingDetails.getAmount());
            if (savingsAccount.getWithdrawableBalance().compareTo(BigDecimal.ZERO) < 0) {
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.guarantor");
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{savingsAccount.getId()});
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
            }
            DepositAccountOnHoldTransaction onHoldTransaction = DepositAccountOnHoldTransaction.hold((SavingsAccount)savingsAccount, (BigDecimal)guarantorFundingDetails.getAmount(), (LocalDate)transactionDate);
            GuarantorFundingTransaction guarantorFundingTransaction = new GuarantorFundingTransaction(guarantorFundingDetails, null, onHoldTransaction);
            guarantorFundingDetails.addGuarantorFundingTransactions(guarantorFundingTransaction);
            this.depositAccountOnHoldTransactionRepository.saveAndFlush((Object)onHoldTransaction);
        }
    }

    public void releaseGuarantor(GuarantorFundingDetails guarantorFundingDetails, LocalDate transactionDate) {
        BigDecimal amoutForWithdraw = guarantorFundingDetails.getAmountRemaining();
        if (amoutForWithdraw.compareTo(BigDecimal.ZERO) > 0 && guarantorFundingDetails.getStatus().isActive()) {
            SavingsAccount savingsAccount = guarantorFundingDetails.getLinkedSavingsAccount();
            savingsAccount.releaseFunds(amoutForWithdraw);
            DepositAccountOnHoldTransaction onHoldTransaction = DepositAccountOnHoldTransaction.release((SavingsAccount)savingsAccount, (BigDecimal)amoutForWithdraw, (LocalDate)transactionDate);
            GuarantorFundingTransaction guarantorFundingTransaction = new GuarantorFundingTransaction(guarantorFundingDetails, null, onHoldTransaction);
            guarantorFundingDetails.addGuarantorFundingTransactions(guarantorFundingTransaction);
            guarantorFundingDetails.releaseFunds(amoutForWithdraw);
            guarantorFundingDetails.withdrawFunds(amoutForWithdraw);
            guarantorFundingDetails.getLoanAccount().updateGuaranteeAmount(amoutForWithdraw.negate());
            this.depositAccountOnHoldTransactionRepository.saveAndFlush((Object)onHoldTransaction);
            this.guarantorFundingRepository.saveAndFlush((Object)guarantorFundingDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFundsFromGuarantor(Loan loan) {
        if (loan.getGuaranteeAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        List existGuarantorList = this.guarantorRepository.findByLoan(loan);
        boolean isRegularTransaction = true;
        boolean isExceptionForBalanceCheck = true;
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        PortfolioAccountType fromAccountType = PortfolioAccountType.SAVINGS;
        PortfolioAccountType toAccountType = PortfolioAccountType.LOAN;
        Long toAccountId = (Long)loan.getId();
        String description = "Payment from guarantor savings";
        Locale locale = null;
        DateTimeFormatter fmt = null;
        PaymentDetail paymentDetail = null;
        Integer fromTransferType = null;
        Integer toTransferType = null;
        Long chargeId = null;
        Integer loanInstallmentNumber = null;
        Integer transferType = AccountTransferType.LOAN_REPAYMENT.getValue();
        AccountTransferDetails accountTransferDetails = null;
        String noteText = null;
        Long loanId = (Long)loan.getId();
        for (Guarantor guarantor : existGuarantorList) {
            List fundingDetails = guarantor.getGuarantorFundDetails();
            for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                Loan freshLoan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow();
                if (!guarantorFundingDetails.getStatus().isActive()) continue;
                SavingsAccount fromSavingsAccount = guarantorFundingDetails.getLinkedSavingsAccount();
                Long fromAccountId = (Long)fromSavingsAccount.getId();
                this.releaseLoanIds.put(loanId, (Long)guarantorFundingDetails.getId());
                try {
                    BigDecimal remainingAmount = guarantorFundingDetails.getAmountRemaining();
                    if (freshLoan.getGuaranteeAmount().compareTo(freshLoan.getPrincipal().getAmount()) > 0) {
                        remainingAmount = remainingAmount.multiply(freshLoan.getPrincipal().getAmount()).divide(freshLoan.getGuaranteeAmount(), MoneyHelper.getRoundingMode());
                    }
                    ExternalId externalId = this.externalIdFactory.create();
                    AccountTransferDTO accountTransferDTO = new AccountTransferDTO(transactionDate, remainingAmount, fromAccountType, toAccountType, fromAccountId, toAccountId, "Payment from guarantor savings", locale, fmt, paymentDetail, fromTransferType, toTransferType, chargeId, loanInstallmentNumber, transferType, accountTransferDetails, noteText, externalId, null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(true));
                    this.transferAmount(accountTransferDTO);
                }
                finally {
                    this.releaseLoanIds.remove(loanId);
                }
            }
        }
    }

    private void transferAmount(AccountTransferDTO accountTransferDTO) {
        try {
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
        }
        catch (InsufficientAccountBalanceException e) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.guarantor");
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{accountTransferDTO.getFromAccountId(), accountTransferDTO.getToAccountId()});
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, (Throwable)e);
        }
    }

    private void reverseAllFundTransaction(Loan loan) {
        if (loan.getGuaranteeAmount().compareTo(BigDecimal.ZERO) > 0) {
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            ArrayList<GuarantorFundingDetails> guarantorFundingDetailList = new ArrayList<GuarantorFundingDetails>();
            for (Guarantor guarantor : existGuarantorList) {
                List fundingDetails = guarantor.getGuarantorFundDetails();
                for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                    guarantorFundingDetails.undoAllTransactions();
                    guarantorFundingDetailList.add(guarantorFundingDetails);
                }
            }
            if (!guarantorFundingDetailList.isEmpty()) {
                loan.setGuaranteeAmount(null);
                this.guarantorFundingRepository.saveAll(guarantorFundingDetailList);
            }
        }
    }

    private void holdGuarantorFunds(Loan loan) {
        if (loan.loanProduct().isHoldGuaranteeFunds()) {
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            ArrayList<GuarantorFundingDetails> guarantorFundingDetailList = new ArrayList<GuarantorFundingDetails>();
            ArrayList<DepositAccountOnHoldTransaction> onHoldTransactions = new ArrayList<DepositAccountOnHoldTransaction>();
            BigDecimal totalGuarantee = BigDecimal.ZERO;
            ArrayList<Long> insufficientBalanceIds = new ArrayList<Long>();
            for (Guarantor guarantor : existGuarantorList) {
                List fundingDetails = guarantor.getGuarantorFundDetails();
                for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                    if (!guarantorFundingDetails.getStatus().isActive()) continue;
                    SavingsAccount savingsAccount = guarantorFundingDetails.getLinkedSavingsAccount();
                    if (loan.isApproved() && !loan.isDisbursed()) {
                        ArrayList<SavingsAccountTransaction> transactions = new ArrayList<SavingsAccountTransaction>();
                        for (SavingsAccountTransaction transaction : savingsAccount.getTransactions()) {
                            if (DateUtils.isAfter((LocalDate)transaction.getTransactionDate(), (LocalDate)loan.getApprovedOnDate())) continue;
                            transactions.add(transaction);
                        }
                        this.savingsAccountAssembler.setHelpers(savingsAccount);
                        savingsAccount.updateSavingsAccountSummary(transactions);
                    }
                    savingsAccount.holdFunds(guarantorFundingDetails.getAmount());
                    totalGuarantee = totalGuarantee.add(guarantorFundingDetails.getAmount());
                    DepositAccountOnHoldTransaction onHoldTransaction = DepositAccountOnHoldTransaction.hold((SavingsAccount)savingsAccount, (BigDecimal)guarantorFundingDetails.getAmount(), (LocalDate)loan.getApprovedOnDate());
                    onHoldTransactions.add(onHoldTransaction);
                    GuarantorFundingTransaction guarantorFundingTransaction = new GuarantorFundingTransaction(guarantorFundingDetails, null, onHoldTransaction);
                    guarantorFundingDetails.addGuarantorFundingTransactions(guarantorFundingTransaction);
                    guarantorFundingDetailList.add(guarantorFundingDetails);
                    if (savingsAccount.getWithdrawableBalance().compareTo(BigDecimal.ZERO) < 0) {
                        insufficientBalanceIds.add((Long)savingsAccount.getId());
                    }
                    savingsAccount.updateSavingsAccountSummary(savingsAccount.getTransactions());
                }
            }
            if (!insufficientBalanceIds.isEmpty()) {
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.guarantor");
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("insufficient.balance", new Object[]{insufficientBalanceIds});
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
            }
            loan.setGuaranteeAmount(totalGuarantee);
            if (!guarantorFundingDetailList.isEmpty()) {
                this.depositAccountOnHoldTransactionRepository.saveAll(onHoldTransactions);
                this.guarantorFundingRepository.saveAll(guarantorFundingDetailList);
            }
        }
    }

    private void releaseGuarantorFunds(LoanTransaction loanTransaction) {
        Loan loan = loanTransaction.getLoan();
        if (loan.getGuaranteeAmount().compareTo(BigDecimal.ZERO) > 0) {
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            ArrayList<Object> externalGuarantorList = new ArrayList<Object>();
            ArrayList<GuarantorFundingDetails> selfGuarantorList = new ArrayList<GuarantorFundingDetails>();
            BigDecimal selfGuarantee = BigDecimal.ZERO;
            BigDecimal guarantorGuarantee = BigDecimal.ZERO;
            for (Guarantor guarantor : existGuarantorList) {
                List fundingDetails = guarantor.getGuarantorFundDetails();
                for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                    if (!guarantorFundingDetails.getStatus().isActive()) continue;
                    if (guarantor.isSelfGuarantee()) {
                        selfGuarantorList.add(guarantorFundingDetails);
                        selfGuarantee = selfGuarantee.add(guarantorFundingDetails.getAmountRemaining());
                        continue;
                    }
                    if (!guarantor.isExistingCustomer()) continue;
                    externalGuarantorList.add(guarantorFundingDetails);
                    guarantorGuarantee = guarantorGuarantee.add(guarantorFundingDetails.getAmountRemaining());
                }
            }
            BigDecimal amountForRelease = loanTransaction.getPrincipalPortion();
            BigDecimal totalGuaranteeAmount = loan.getGuaranteeAmount();
            BigDecimal principal = loan.getPrincipal().getAmount();
            if (amountForRelease != null && totalGuaranteeAmount != null) {
                ArrayList accountOnHoldTransactions;
                BigDecimal amountLeft = this.calculateAndRelaseGuarantorFunds(externalGuarantorList, guarantorGuarantee, amountForRelease = amountForRelease.multiply(totalGuaranteeAmount).divide(principal, MoneyHelper.getRoundingMode()), loanTransaction, accountOnHoldTransactions = new ArrayList());
                if (amountLeft.compareTo(BigDecimal.ZERO) > 0) {
                    this.calculateAndRelaseGuarantorFunds(selfGuarantorList, selfGuarantee, amountLeft, loanTransaction, accountOnHoldTransactions);
                    externalGuarantorList.addAll(selfGuarantorList);
                }
                if (!externalGuarantorList.isEmpty()) {
                    this.depositAccountOnHoldTransactionRepository.saveAll(accountOnHoldTransactions);
                    this.guarantorFundingRepository.saveAll(externalGuarantorList);
                }
            }
        }
    }

    private void releaseAllGuarantors(LoanTransaction loanTransaction) {
        Loan loan = loanTransaction.getLoan();
        if (loan.getGuaranteeAmount().compareTo(BigDecimal.ZERO) > 0) {
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            ArrayList<GuarantorFundingDetails> saveGuarantorFundingDetails = new ArrayList<GuarantorFundingDetails>();
            ArrayList<DepositAccountOnHoldTransaction> onHoldTransactions = new ArrayList<DepositAccountOnHoldTransaction>();
            for (Guarantor guarantor : existGuarantorList) {
                List fundingDetails = guarantor.getGuarantorFundDetails();
                for (GuarantorFundingDetails guarantorFundingDetails : fundingDetails) {
                    BigDecimal amoutForRelease = guarantorFundingDetails.getAmountRemaining();
                    if (amoutForRelease.compareTo(BigDecimal.ZERO) <= 0 || !guarantorFundingDetails.getStatus().isActive()) continue;
                    SavingsAccount savingsAccount = guarantorFundingDetails.getLinkedSavingsAccount();
                    savingsAccount.releaseFunds(amoutForRelease);
                    DepositAccountOnHoldTransaction onHoldTransaction = DepositAccountOnHoldTransaction.release((SavingsAccount)savingsAccount, (BigDecimal)amoutForRelease, (LocalDate)loanTransaction.getTransactionDate());
                    onHoldTransactions.add(onHoldTransaction);
                    GuarantorFundingTransaction guarantorFundingTransaction = new GuarantorFundingTransaction(guarantorFundingDetails, loanTransaction, onHoldTransaction);
                    guarantorFundingDetails.addGuarantorFundingTransactions(guarantorFundingTransaction);
                    guarantorFundingDetails.releaseFunds(amoutForRelease);
                    saveGuarantorFundingDetails.add(guarantorFundingDetails);
                }
            }
            if (!saveGuarantorFundingDetails.isEmpty()) {
                this.depositAccountOnHoldTransactionRepository.saveAll(onHoldTransactions);
                this.guarantorFundingRepository.saveAll(saveGuarantorFundingDetails);
            }
        }
    }

    private void completeGuarantorFund(LoanTransaction loanTransaction) {
        Loan loan = loanTransaction.getLoan();
        GuarantorFundingDetails guarantorFundingDetails = this.guarantorFundingRepository.findById((Object)((Long)this.releaseLoanIds.get(loan.getId()))).orElse(null);
        if (guarantorFundingDetails != null) {
            BigDecimal amountForRelease;
            BigDecimal guarantorGuarantee = amountForRelease = loanTransaction.getAmount(loan.getCurrency()).getAmount();
            List<GuarantorFundingDetails> guarantorList = Arrays.asList(guarantorFundingDetails);
            ArrayList accountOnHoldTransactions = new ArrayList();
            this.calculateAndRelaseGuarantorFunds(guarantorList, guarantorGuarantee, amountForRelease, loanTransaction, accountOnHoldTransactions);
            this.depositAccountOnHoldTransactionRepository.saveAll(accountOnHoldTransactions);
            this.guarantorFundingRepository.saveAndFlush((Object)guarantorFundingDetails);
        }
    }

    private BigDecimal calculateAndRelaseGuarantorFunds(List<GuarantorFundingDetails> guarantorList, BigDecimal totalGuaranteeAmount, BigDecimal amountForRelease, LoanTransaction loanTransaction, List<DepositAccountOnHoldTransaction> accountOnHoldTransactions) {
        BigDecimal amountLeft = amountForRelease;
        for (GuarantorFundingDetails fundingDetails : guarantorList) {
            BigDecimal guarantorAmount = amountForRelease.multiply(fundingDetails.getAmountRemaining()).divide(totalGuaranteeAmount, MoneyHelper.getRoundingMode());
            if (fundingDetails.getAmountRemaining().compareTo(guarantorAmount) <= 0) {
                guarantorAmount = fundingDetails.getAmountRemaining();
            }
            fundingDetails.releaseFunds(guarantorAmount);
            SavingsAccount savingsAccount = fundingDetails.getLinkedSavingsAccount();
            savingsAccount.releaseFunds(guarantorAmount);
            DepositAccountOnHoldTransaction onHoldTransaction = DepositAccountOnHoldTransaction.release((SavingsAccount)savingsAccount, (BigDecimal)guarantorAmount, (LocalDate)loanTransaction.getTransactionDate());
            accountOnHoldTransactions.add(onHoldTransaction);
            GuarantorFundingTransaction guarantorFundingTransaction = new GuarantorFundingTransaction(fundingDetails, loanTransaction, onHoldTransaction);
            fundingDetails.addGuarantorFundingTransactions(guarantorFundingTransaction);
            amountLeft = amountLeft.subtract(guarantorAmount);
        }
        return amountLeft;
    }

    private void reverseTransaction(List<Long> loanTransactionIds) {
        List fundingTransactions = this.guarantorFundingTransactionRepository.fetchGuarantorFundingTransactions(loanTransactionIds);
        for (GuarantorFundingTransaction fundingTransaction : fundingTransactions) {
            fundingTransaction.reverseTransaction();
        }
        if (!fundingTransactions.isEmpty()) {
            this.guarantorFundingTransactionRepository.saveAll((Iterable)fundingTransactions);
        }
    }

    @Generated
    public GuarantorDomainServiceImpl(GuarantorRepository guarantorRepository, GuarantorFundingRepository guarantorFundingRepository, GuarantorFundingTransactionRepository guarantorFundingTransactionRepository, AccountTransfersWritePlatformService accountTransfersWritePlatformService, BusinessEventNotifierService businessEventNotifierService, DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository, SavingsAccountAssembler savingsAccountAssembler, ConfigurationDomainService configurationDomainService, ExternalIdFactory externalIdFactory, LoanRepository loanRepository, LoanTransactionRepository loanTransactionRepository) {
        this.guarantorRepository = guarantorRepository;
        this.guarantorFundingRepository = guarantorFundingRepository;
        this.guarantorFundingTransactionRepository = guarantorFundingTransactionRepository;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.depositAccountOnHoldTransactionRepository = depositAccountOnHoldTransactionRepository;
        this.savingsAccountAssembler = savingsAccountAssembler;
        this.configurationDomainService = configurationDomainService;
        this.externalIdFactory = externalIdFactory;
        this.loanRepository = loanRepository;
        this.loanTransactionRepository = loanTransactionRepository;
    }
}

