/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.account.domain.AccountAssociations;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.Guarantor;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundStatusType;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_guarantor_funding_details")
public class GuarantorFundingDetails
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne
    @JoinColumn(name="guarantor_id", nullable=false)
    private Guarantor guarantor;
    @ManyToOne
    @JoinColumn(name="account_associations_id", nullable=false)
    private AccountAssociations accountAssociations;
    @Column(name="status_enum", nullable=false)
    private Integer status;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    @Column(name="amount_released_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountReleased;
    @Column(name="amount_remaining_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountRemaining;
    @Column(name="amount_transfered_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountTransfered;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="guarantorFundingDetails", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<GuarantorFundingTransaction> guarantorFundingTransactions;
    static final long serialVersionUID = -8872193367232079886L;

    protected GuarantorFundingDetails() {
        this.guarantorFundingTransactions = new ArrayList();
    }

    public GuarantorFundingDetails(AccountAssociations accountAssociations, Integer status, BigDecimal amount) {
        this.guarantorFundingTransactions = new ArrayList();
        this.accountAssociations = accountAssociations;
        this.status = status;
        this.amount = amount;
        this.amountRemaining = amount;
    }

    public void updateGuarantor(Guarantor guarantor) {
        this._persistence_set_guarantor(guarantor);
    }

    public void updateStatus(GuarantorFundStatusType guarantorFundStatusType) {
        this._persistence_set_status(guarantorFundStatusType.getValue());
    }

    public GuarantorFundStatusType getStatus() {
        return GuarantorFundStatusType.fromInt((Integer)this._persistence_get_status());
    }

    public SavingsAccount getLinkedSavingsAccount() {
        return this._persistence_get_accountAssociations().linkedSavingsAccount();
    }

    public Loan getLoanAccount() {
        return this._persistence_get_guarantor().getLoan();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public BigDecimal getAmountReleased() {
        return this._persistence_get_amountReleased() == null ? BigDecimal.ZERO : this._persistence_get_amountReleased();
    }

    public BigDecimal getAmountRemaining() {
        return this._persistence_get_amountRemaining() == null ? BigDecimal.ZERO : this._persistence_get_amountRemaining();
    }

    public BigDecimal getAmountTransfered() {
        return this._persistence_get_amountTransfered() == null ? BigDecimal.ZERO : this._persistence_get_amountTransfered();
    }

    public void releaseFunds(BigDecimal amount) {
        this._persistence_set_amountReleased(this.getAmountReleased().add(amount));
        this._persistence_set_amountRemaining(this.getAmountRemaining().subtract(amount));
        if (this._persistence_get_amountRemaining().compareTo(BigDecimal.ZERO) == 0) {
            this.updateStatus(GuarantorFundStatusType.COMPLETED);
        }
    }

    public void undoReleaseFunds(BigDecimal amount) {
        this._persistence_set_amountReleased(this.getAmountReleased().subtract(amount));
        this._persistence_set_amountRemaining(this.getAmountRemaining().add(amount));
        if (this.getStatus().isCompleted() && this._persistence_get_amountRemaining().compareTo(BigDecimal.ZERO) > 0) {
            this.updateStatus(GuarantorFundStatusType.ACTIVE);
        }
    }

    public void withdrawFunds(BigDecimal amount) {
        this._persistence_set_amountTransfered(amount);
    }

    public void addGuarantorFundingTransactions(GuarantorFundingTransaction guarantorFundingTransaction) {
        this._persistence_get_guarantorFundingTransactions().add(guarantorFundingTransaction);
    }

    public void undoAllTransactions() {
        for (GuarantorFundingTransaction fundingTransaction : this._persistence_get_guarantorFundingTransactions()) {
            fundingTransaction.reverseTransaction();
        }
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new GuarantorFundingDetails(persistenceObject);
    }

    public GuarantorFundingDetails(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "guarantorFundingTransactions") {
            return this.guarantorFundingTransactions;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "amountTransfered") {
            return this.amountTransfered;
        }
        if (string == "accountAssociations") {
            return this.accountAssociations;
        }
        if (string == "amountRemaining") {
            return this.amountRemaining;
        }
        if (string == "guarantor") {
            return this.guarantor;
        }
        if (string == "amountReleased") {
            return this.amountReleased;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "guarantorFundingTransactions") {
            this.guarantorFundingTransactions = (List)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "amountTransfered") {
            this.amountTransfered = (BigDecimal)object;
            return;
        }
        if (string == "accountAssociations") {
            this.accountAssociations = (AccountAssociations)object;
            return;
        }
        if (string == "amountRemaining") {
            this.amountRemaining = (BigDecimal)object;
            return;
        }
        if (string == "guarantor") {
            this.guarantor = (Guarantor)object;
            return;
        }
        if (string == "amountReleased") {
            this.amountReleased = (BigDecimal)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_guarantorFundingTransactions() {
        this._persistence_checkFetched("guarantorFundingTransactions");
        return this.guarantorFundingTransactions;
    }

    public void _persistence_set_guarantorFundingTransactions(List list) {
        this._persistence_checkFetchedForSet("guarantorFundingTransactions");
        this.guarantorFundingTransactions = list;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this.amount = bigDecimal;
    }

    public BigDecimal _persistence_get_amountTransfered() {
        this._persistence_checkFetched("amountTransfered");
        return this.amountTransfered;
    }

    public void _persistence_set_amountTransfered(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountTransfered");
        this.amountTransfered = bigDecimal;
    }

    public AccountAssociations _persistence_get_accountAssociations() {
        this._persistence_checkFetched("accountAssociations");
        return this.accountAssociations;
    }

    public void _persistence_set_accountAssociations(AccountAssociations accountAssociations) {
        this._persistence_checkFetchedForSet("accountAssociations");
        this.accountAssociations = accountAssociations;
    }

    public BigDecimal _persistence_get_amountRemaining() {
        this._persistence_checkFetched("amountRemaining");
        return this.amountRemaining;
    }

    public void _persistence_set_amountRemaining(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountRemaining");
        this.amountRemaining = bigDecimal;
    }

    public Guarantor _persistence_get_guarantor() {
        this._persistence_checkFetched("guarantor");
        return this.guarantor;
    }

    public void _persistence_set_guarantor(Guarantor guarantor) {
        this._persistence_checkFetchedForSet("guarantor");
        this.guarantor = guarantor;
    }

    public BigDecimal _persistence_get_amountReleased() {
        this._persistence_checkFetched("amountReleased");
        return this.amountReleased;
    }

    public void _persistence_set_amountReleased(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountReleased");
        this.amountReleased = bigDecimal;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this.status = n;
    }
}

