/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.data;

import java.util.Collection;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.portfolio.collectionsheet.data.LoanDueData;
import org.apache.fineract.portfolio.collectionsheet.data.SavingsDueData;

public final class JLGClientData {
    private final Long clientId;
    private final String clientName;
    private Collection<LoanDueData> loans;
    private Collection<SavingsDueData> savings;
    private final EnumOptionData attendanceType;

    public static JLGClientData instance(Long clientId, String clientName, EnumOptionData attendanceType) {
        Collection loans = null;
        Collection savings = null;
        return new JLGClientData(clientId, clientName, loans, savings, attendanceType);
    }

    public static JLGClientData withSavings(JLGClientData client, Collection<SavingsDueData> savings) {
        Collection loans = null;
        EnumOptionData attendanceType = null;
        return new JLGClientData(client.clientId, client.clientName, loans, savings, attendanceType);
    }

    public static JLGClientData withAttendance(Long clientId, String clientName, EnumOptionData attendanceType) {
        Collection loans = null;
        Collection savings = null;
        return new JLGClientData(clientId, clientName, loans, savings, attendanceType);
    }

    private JLGClientData(Long clientId, String clientName, Collection<LoanDueData> loans, Collection<SavingsDueData> savings, EnumOptionData attendanceType) {
        this.clientId = clientId;
        this.clientName = clientName;
        this.loans = loans;
        this.savings = savings;
        this.attendanceType = attendanceType;
    }

    public Long getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public Collection<LoanDueData> getLoans() {
        return this.loans;
    }

    public void setLoans(Collection<LoanDueData> loans) {
        this.loans = loans;
    }

    public Collection<SavingsDueData> getSavings() {
        return this.savings;
    }

    public void setSavings(Collection<SavingsDueData> savings) {
        this.savings = savings;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JLGClientData)) {
            return false;
        }
        JLGClientData clientData = (JLGClientData)obj;
        return clientData.clientId.compareTo(this.clientId) == 0;
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }
}

