/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectionSheetTransactionDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> COLLECTIONSHEET_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "transactionDate", "actualDisbursementDate", "bulkRepaymentTransactions", "bulkDisbursementTransactions", "note", "calendarId", "clientsAttendance", "bulkSavingsDueTransactions", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber", "isTransactionDateOnNonMeetingDate"));
    private static final Set<String> INDIVIDUAL_COLLECTIONSHEET_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "transactionDate", "actualDisbursementDate", "bulkRepaymentTransactions", "bulkDisbursementTransactions", "note", "bulkSavingsDueTransactions"));
    private static final Set<String> PAYMENT_CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));

    @Autowired
    public CollectionSheetTransactionDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateTransaction(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)COLLECTIONSHEET_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("collectionsheet");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        if (StringUtils.isNotBlank((CharSequence)note)) {
            baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        }
        Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
        baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull();
        this.validateAttendanceDetails(element, baseDataValidator);
        this.validateDisbursementTransactions(element, baseDataValidator);
        this.validateRepaymentTransactions(element, baseDataValidator);
        this.validateSavingsDueTransactions(element, baseDataValidator);
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        this.validatePaymentDetails(baseDataValidator, element, locale);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateIndividualCollectionSheet(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INDIVIDUAL_COLLECTIONSHEET_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("collectionsheet");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull().validateDateBeforeOrEqual(DateUtils.getBusinessLocalDate());
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        if (StringUtils.isNotBlank((CharSequence)note)) {
            baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
        }
        this.validateDisbursementTransactions(element, baseDataValidator);
        this.validateRepaymentTransactions(element, baseDataValidator);
        this.validateSavingsDueTransactions(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateAttendanceDetails(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (element.isJsonObject() && topLevelJsonElement.has("clientsAttendance") && topLevelJsonElement.get("clientsAttendance").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("clientsAttendance").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject attendanceElement = array.get(i).getAsJsonObject();
                Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", (JsonElement)attendanceElement);
                Long attendanceType = this.fromApiJsonHelper.extractLongNamed("attendanceType", (JsonElement)attendanceElement);
                baseDataValidator.reset().parameter("clientsAttendance[" + i + "].clientId").value((Object)clientId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter("clientsAttendance[" + i + "].attendanceType").value((Object)attendanceType).notNull().integerGreaterThanZero();
            }
        }
    }

    private void validateDisbursementTransactions(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        if (element.isJsonObject() && topLevelJsonElement.has("bulkDisbursementTransactions") && topLevelJsonElement.get("bulkDisbursementTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkDisbursementTransactions").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject loanTransactionElement = array.get(i).getAsJsonObject();
                Long loanId = this.fromApiJsonHelper.extractLongNamed("loanId", (JsonElement)loanTransactionElement);
                BigDecimal disbursementAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)loanTransactionElement, locale);
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].loan.id").value((Object)loanId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].disbursement.amount").value((Object)disbursementAmount).notNull().zeroOrPositiveAmount();
            }
        }
    }

    private void validateRepaymentTransactions(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        if (element.isJsonObject() && topLevelJsonElement.has("bulkRepaymentTransactions") && topLevelJsonElement.get("bulkRepaymentTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkRepaymentTransactions").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject loanTransactionElement = array.get(i).getAsJsonObject();
                Long loanId = this.fromApiJsonHelper.extractLongNamed("loanId", (JsonElement)loanTransactionElement);
                BigDecimal disbursementAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)loanTransactionElement, locale);
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].loan.id").value((Object)loanId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].disbursement.amount").value((Object)disbursementAmount).notNull().zeroOrPositiveAmount();
                this.validatePaymentDetails(baseDataValidator, (JsonElement)loanTransactionElement, locale);
            }
        }
    }

    private void validateSavingsDueTransactions(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        if (element.isJsonObject() && topLevelJsonElement.has("bulkSavingsDueTransactions") && topLevelJsonElement.get("bulkSavingsDueTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkSavingsDueTransactions").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject savingsTransactionElement = array.get(i).getAsJsonObject();
                Long savingsId = this.fromApiJsonHelper.extractLongNamed("savingsId", (JsonElement)savingsTransactionElement);
                BigDecimal dueAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)savingsTransactionElement, locale);
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].savings.id").value((Object)savingsId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter("bulktransaction[" + i + "].due.amount").value((Object)dueAmount).notNull().zeroOrPositiveAmount();
                this.validatePaymentDetails(baseDataValidator, (JsonElement)savingsTransactionElement, locale);
            }
        }
    }

    private void validatePaymentDetails(DataValidatorBuilder baseDataValidator, JsonElement element, Locale locale) {
        Integer paymentTypeId = this.fromApiJsonHelper.extractIntegerNamed("paymentTypeId", element, locale);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).ignoreIfNull().integerGreaterThanZero();
        for (String paymentDetailParameterName : PAYMENT_CREATE_REQUEST_DATA_PARAMETERS) {
            String paymentDetailParameterValue = this.fromApiJsonHelper.extractStringNamed(paymentDetailParameterName, element);
            baseDataValidator.reset().parameter(paymentDetailParameterName).value((Object)paymentDetailParameterValue).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

