/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.starter;

import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateral.domain.LoanCollateralRepository;
import org.apache.fineract.portfolio.collateral.serialization.CollateralCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.collateral.service.CollateralAssembler;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformService;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformServiceImpl;
import org.apache.fineract.portfolio.collateral.service.CollateralWritePlatformService;
import org.apache.fineract.portfolio.collateral.service.CollateralWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class CollateralConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CollateralAssembler.class})
    public CollateralAssembler collateralAssembler(FromJsonHelper fromApiJsonHelper, CodeValueRepositoryWrapper codeValueRepository, LoanCollateralRepository loanCollateralRepository) {
        return new CollateralAssembler(fromApiJsonHelper, codeValueRepository, loanCollateralRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollateralReadPlatformService.class})
    public CollateralReadPlatformService collateralReadPlatformService(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, LoanRepositoryWrapper loanRepositoryWrapper) {
        return new CollateralReadPlatformServiceImpl(context, jdbcTemplate, loanRepositoryWrapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollateralWritePlatformService.class})
    public CollateralWritePlatformService collateralWritePlatformService(PlatformSecurityContext context, LoanRepositoryWrapper loanRepositoryWrapper, LoanCollateralRepository collateralRepository, CodeValueRepositoryWrapper codeValueRepository, CollateralCommandFromApiJsonDeserializer collateralCommandFromApiJsonDeserializer) {
        return new CollateralWritePlatformServiceJpaRepositoryImpl(context, loanRepositoryWrapper, collateralRepository, codeValueRepository, collateralCommandFromApiJsonDeserializer);
    }
}

