/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatEnumerations;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationPropertyData;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepository;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.springframework.stereotype.Component;

@Component
public class AccountNumberGenerator {
    private static final int maxLength = 9;
    private static final String ID = "id";
    private static final String ENTITY_TYPE = "entityType";
    private static final String CLIENT_TYPE = "clientType";
    private static final String OFFICE_NAME = "officeName";
    private static final String LOAN_PRODUCT_SHORT_NAME = "loanProductShortName";
    private static final String SAVINGS_PRODUCT_SHORT_NAME = "savingsProductShortName";
    private static final String SHARE_PRODUCT_SHORT_NAME = "sharesProductShortName";
    private static final String PREFIX_SHORT_NAME = "prefixShortName";
    private final ConfigurationReadPlatformService configurationReadPlatformService;
    private final ClientRepository clientRepository;
    private final LoanRepository loanRepository;
    private final SavingsAccountRepository savingsAccountRepository;

    public String generate(Client client, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)client.getId()).toString());
        propertyMap.put(OFFICE_NAME, client.getOffice().getName());
        propertyMap.put(ENTITY_TYPE, "client");
        CodeValue clientType = client.clientType();
        if (clientType != null) {
            propertyMap.put(CLIENT_TYPE, clientType.getLabel());
        }
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    public String generate(Loan loan, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)loan.getId()).toString());
        propertyMap.put(OFFICE_NAME, loan.getOffice().getName());
        propertyMap.put(LOAN_PRODUCT_SHORT_NAME, loan.loanProduct().getShortName());
        propertyMap.put(ENTITY_TYPE, "loan");
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    public String generate(SavingsAccount savingsAccount, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)savingsAccount.getId()).toString());
        propertyMap.put(OFFICE_NAME, savingsAccount.office().getName());
        propertyMap.put(SAVINGS_PRODUCT_SHORT_NAME, savingsAccount.savingsProduct().getShortName());
        propertyMap.put(ENTITY_TYPE, "savingsAccount");
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    public String generate(ShareAccount shareaccount, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)shareaccount.getId()).toString());
        propertyMap.put(SHARE_PRODUCT_SHORT_NAME, shareaccount.getShareProduct().getShortName());
        propertyMap.put(ENTITY_TYPE, "shareAccount");
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    private String generateAccountNumber(Map<String, String> propertyMap, AccountNumberFormat accountNumberFormat) {
        Boolean randomNumberConflict;
        GlobalConfigurationPropertyData randomAccountNumber;
        int accountMaxLength = 9;
        String accountNumber = StringUtils.leftPad((String)propertyMap.get(ID), (int)accountMaxLength, (char)'0');
        GlobalConfigurationPropertyData customLength = this.configurationReadPlatformService.retrieveGlobalConfiguration("custom-account-number-length");
        if (customLength.isEnabled() && customLength.getValue() != null) {
            accountMaxLength = customLength.getValue().intValue();
        }
        if ((randomAccountNumber = this.configurationReadPlatformService.retrieveGlobalConfiguration("random-account-number")).isEnabled()) {
            accountNumber = this.randomNumberGenerator(accountMaxLength, propertyMap);
        }
        accountNumber = StringUtils.leftPad((String)accountNumber, (int)accountMaxLength, (char)'0');
        if (accountNumberFormat != null && accountNumberFormat.getPrefixEnum() != null) {
            AccountNumberFormatEnumerations.AccountNumberPrefixType accountNumberPrefixType = AccountNumberFormatEnumerations.AccountNumberPrefixType.fromInt((int)accountNumberFormat.getPrefixEnum());
            String prefix = null;
            switch (1.$SwitchMap$org$apache$fineract$infrastructure$accountnumberformat$domain$AccountNumberFormatEnumerations$AccountNumberPrefixType[accountNumberPrefixType.ordinal()]) {
                case 1: {
                    prefix = propertyMap.get(CLIENT_TYPE);
                    break;
                }
                case 2: {
                    prefix = propertyMap.get(OFFICE_NAME);
                    break;
                }
                case 3: {
                    prefix = propertyMap.get(LOAN_PRODUCT_SHORT_NAME);
                    break;
                }
                case 4: {
                    prefix = propertyMap.get(SAVINGS_PRODUCT_SHORT_NAME);
                    break;
                }
                case 5: {
                    this.generatePrefix(propertyMap, propertyMap.get(ID), Integer.valueOf(accountMaxLength), accountNumberFormat);
                    prefix = propertyMap.get(PREFIX_SHORT_NAME);
                }
            }
            if (prefix != null) {
                prefix = prefix.substring(0, Math.min(prefix.length(), 10));
            }
            if (accountNumberPrefixType.getValue().equals(AccountNumberFormatEnumerations.AccountNumberPrefixType.PREFIX_SHORT_NAME.getValue())) {
                Integer prefixLength = prefix.length();
                if (randomAccountNumber.isEnabled()) {
                    accountNumber = accountNumber.substring(prefixLength);
                } else {
                    Integer numberLength = accountMaxLength - prefixLength;
                    accountNumber = StringUtils.leftPad((String)propertyMap.get(ID), (int)numberLength, (char)'0');
                }
            } else {
                accountNumber = StringUtils.leftPad((String)accountNumber, (int)propertyMap.get(ID).length(), (char)'0');
            }
            accountNumber = StringUtils.overlay((String)accountNumber, (String)prefix, (int)0, (int)0);
        }
        if (randomAccountNumber.isEnabled() && (randomNumberConflict = this.checkAccountNumberConflict(propertyMap, accountNumberFormat, accountNumber)).booleanValue()) {
            accountNumber = this.generateAccountNumber(propertyMap, accountNumberFormat);
        }
        return accountNumber;
    }

    private String randomNumberGenerator(int accountMaxLength, Map<String, String> propertyMap) {
        String randomNumber = RandomStringUtils.random((int)accountMaxLength, (boolean)false, (boolean)true);
        BigInteger accNumber = new BigInteger(randomNumber);
        if (accNumber.equals(BigInteger.ZERO)) {
            randomNumber = this.randomNumberGenerator(accountMaxLength, propertyMap);
        }
        String accountNumber = randomNumber.substring(0, accountMaxLength);
        return accountNumber;
    }

    public Boolean checkAccountNumberConflict(Map<String, String> propertyMap, AccountNumberFormat accountNumberFormat, String accountNumber) {
        String entityType = propertyMap.get(ENTITY_TYPE);
        if (entityType == null) {
            return false;
        }
        boolean randomNumberConflict = false;
        switch (entityType) {
            case "client": {
                Client client = this.clientRepository.getClientByAccountNumber(accountNumber);
                if (client == null) break;
                randomNumberConflict = true;
                break;
            }
            case "loan": {
                Loan loan = this.loanRepository.findLoanAccountByAccountNumber(accountNumber);
                if (loan == null) break;
                randomNumberConflict = true;
                break;
            }
            case "savingsAccount": {
                SavingsAccount savingsAccount = this.savingsAccountRepository.findSavingsAccountByAccountNumber(accountNumber);
                if (savingsAccount == null) break;
                randomNumberConflict = true;
                break;
            }
        }
        return randomNumberConflict;
    }

    private Map<String, String> generatePrefix(Map<String, String> propertyMap, String accountNumber, Integer accountMaxLength, AccountNumberFormat accountNumberFormat) {
        String prefix = accountNumberFormat.getPrefixCharacter();
        Integer prefixLength = prefix.length();
        Integer totalLength = prefixLength + Integer.valueOf(propertyMap.get(ID).length());
        if ((prefixLength = Integer.valueOf(totalLength - accountMaxLength)) > 0) {
            prefix = prefix.substring(0, prefix.length() - prefixLength);
        }
        propertyMap.put(PREFIX_SHORT_NAME, prefix);
        return propertyMap;
    }

    public String generateGroupAccountNumber(Group group, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)group.getId()).toString());
        propertyMap.put(OFFICE_NAME, group.getOffice().getName());
        propertyMap.put(ENTITY_TYPE, "group");
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    public String generateCenterAccountNumber(Group group, AccountNumberFormat accountNumberFormat) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ID, ((Long)group.getId()).toString());
        propertyMap.put(OFFICE_NAME, group.getOffice().getName());
        propertyMap.put(ENTITY_TYPE, "center");
        return this.generateAccountNumber(propertyMap, accountNumberFormat);
    }

    @Generated
    public AccountNumberGenerator(ConfigurationReadPlatformService configurationReadPlatformService, ClientRepository clientRepository, LoanRepository loanRepository, SavingsAccountRepository savingsAccountRepository) {
        this.configurationReadPlatformService = configurationReadPlatformService;
        this.clientRepository = clientRepository;
        this.loanRepository = loanRepository;
        this.savingsAccountRepository = savingsAccountRepository;
    }
}

