/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

public enum AccountTransferType {
    INVALID(Integer.valueOf(0), "accountTransferType.invalid"),
    ACCOUNT_TRANSFER(Integer.valueOf(1), "accountTransferType.account.transfer"),
    LOAN_REPAYMENT(Integer.valueOf(2), "accountTransferType.loan.repayment"),
    CHARGE_PAYMENT(Integer.valueOf(3), "accountTransferType.charge.payment"),
    INTEREST_TRANSFER(Integer.valueOf(4), "accountTransferType.interest.transfer"),
    LOAN_DOWN_PAYMENT(Integer.valueOf(5), "accountTransferType.loan.downpayment");

    private final Integer value;
    private final String code;

    public static AccountTransferType fromInt(Integer statusValue) {
        AccountTransferType enumeration = INVALID;
        switch (statusValue) {
            case 1: {
                enumeration = ACCOUNT_TRANSFER;
                break;
            }
            case 2: {
                enumeration = LOAN_REPAYMENT;
                break;
            }
            case 3: {
                enumeration = CHARGE_PAYMENT;
                break;
            }
            case 4: {
                enumeration = INTEREST_TRANSFER;
                break;
            }
            case 5: {
                enumeration = LOAN_DOWN_PAYMENT;
            }
        }
        return enumeration;
    }

    private AccountTransferType(Integer value, String code) {
        this.value = value;
        this.code = code;
    }

    public boolean hasStateOf(AccountTransferType state) {
        return this.value.equals(state.getValue());
    }

    public Integer getValue() {
        return this.value;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isAccountTransfer() {
        return this.value.equals(ACCOUNT_TRANSFER.getValue());
    }

    public boolean isLoanRepayment() {
        return this.value.equals(LOAN_REPAYMENT.getValue());
    }

    public boolean isChargePayment() {
        return this.value.equals(CHARGE_PAYMENT.getValue());
    }

    public boolean isInterestTransfer() {
        return this.value.equals(INTEREST_TRANSFER.getValue());
    }

    public boolean isLoanDownPayment() {
        return this.value.equals(LOAN_DOWN_PAYMENT.getValue());
    }
}

