/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.starter;

import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.StaffRepository;
import org.apache.fineract.organisation.staff.serialization.StaffCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformServiceImpl;
import org.apache.fineract.organisation.staff.service.StaffWritePlatformService;
import org.apache.fineract.organisation.staff.service.StaffWritePlatformServiceJpaRepositoryImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class OrganisationStaffConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={StaffReadPlatformService.class})
    public StaffReadPlatformService staffReadPlatformService(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        return new StaffReadPlatformServiceImpl(context, jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={StaffWritePlatformService.class})
    public StaffWritePlatformService staffWritePlatformService(StaffCommandFromApiJsonDeserializer fromApiJsonDeserializer, StaffRepository staffRepository, OfficeRepositoryWrapper officeRepositoryWrapper) {
        return new StaffWritePlatformServiceJpaRepositoryImpl(fromApiJsonDeserializer, staffRepository, officeRepositoryWrapper);
    }
}

