/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.data.OfficeTransactionData;
import org.apache.fineract.organisation.office.domain.OfficeRepository;
import org.apache.fineract.organisation.office.exception.OfficeNotFoundException;
import org.apache.fineract.organisation.office.mapper.OfficeDataMapper;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class OfficeReadPlatformServiceImpl
implements OfficeReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PlatformSecurityContext context;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final ColumnValidator columnValidator;
    private final OfficeRepository officeRepository;
    private final OfficeDataMapper officeDataMapper;
    private static final String nameDecoratedBaseOnHierarchy = "concat(substring('........................................', 1, ((LENGTH(o.hierarchy) - LENGTH(REPLACE(o.hierarchy, '.', '')) - 1) * 4)), o.name)";

    @Cacheable(value={"offices"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'of')")
    public Collection<OfficeData> retrieveAllOffices(boolean includeAllOffices, SearchParameters searchParameters) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        Object hierarchySearchString = includeAllOffices ? ".%" : hierarchy + "%";
        OfficeMapper rm = new OfficeMapper();
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select ");
        sqlBuilder.append(rm.officeSchema());
        sqlBuilder.append(" where o.hierarchy like ? ");
        if (searchParameters != null) {
            if (searchParameters.hasOrderBy()) {
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
                sqlBuilder.append("order by ").append(searchParameters.getOrderBy());
                if (searchParameters.hasSortOrder()) {
                    this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
                    sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                }
            } else {
                sqlBuilder.append("order by o.hierarchy");
            }
        }
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)rm, new Object[]{hierarchySearchString});
    }

    @Cacheable(value={"officesForDropdown"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'ofd')")
    public Collection<OfficeData> retrieveAllOfficesForDropdown() {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        OfficeDropdownMapper rm = new OfficeDropdownMapper();
        String sql = "select " + rm.schema() + "where o.hierarchy like ? order by o.hierarchy";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{hierarchySearchString});
    }

    @Cacheable(value={"officesById"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#officeId)")
    public OfficeData retrieveOffice(Long officeId) {
        try {
            this.context.authenticatedUser();
            OfficeMapper rm = new OfficeMapper();
            String sql = "select " + rm.officeSchema() + " where o.id = ?";
            OfficeData selectedOffice = (OfficeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{officeId});
            return selectedOffice;
        }
        catch (EmptyResultDataAccessException e) {
            throw new OfficeNotFoundException(officeId, e);
        }
    }

    public OfficeData retrieveOfficeWithExternalId(ExternalId externalId) {
        this.context.authenticatedUser();
        return this.officeRepository.findByExternalId(externalId).map(arg_0 -> ((OfficeDataMapper)this.officeDataMapper).toOfficeData(arg_0)).orElseThrow(() -> new OfficeNotFoundException(externalId));
    }

    public OfficeData retrieveNewOfficeTemplate() {
        this.context.authenticatedUser();
        return OfficeData.template(null, (LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()));
    }

    public Collection<OfficeData> retrieveAllowedParents(Long officeId) {
        this.context.authenticatedUser();
        ArrayList<OfficeData> filterParentLookups = new ArrayList<OfficeData>();
        if (this.isNotHeadOffice(officeId)) {
            Collection parentLookups = this.retrieveAllOfficesForDropdown();
            for (OfficeData office : parentLookups) {
                if (office.hasIdentifyOf(officeId)) continue;
                filterParentLookups.add(office);
            }
        }
        return filterParentLookups;
    }

    private boolean isNotHeadOffice(Long officeId) {
        return !Long.valueOf(1L).equals(officeId);
    }

    public Collection<OfficeTransactionData> retrieveAllOfficeTransactions() {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        OfficeTransactionMapper rm = new OfficeTransactionMapper(this.sqlGenerator);
        String sql = "select " + rm.schema() + " where (fromoff.hierarchy like ? or tooff.hierarchy like ?) order by ot.transaction_date, ot.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{hierarchySearchString, hierarchySearchString});
    }

    public OfficeTransactionData retrieveNewOfficeTransactionDetails() {
        this.context.authenticatedUser();
        Collection parentLookups = this.retrieveAllOfficesForDropdown();
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        return OfficeTransactionData.template((LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()), (Collection)parentLookups, (Collection)currencyOptions);
    }

    public PlatformSecurityContext getContext() {
        return this.context;
    }

    @Generated
    public OfficeReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context, CurrencyReadPlatformService currencyReadPlatformService, ColumnValidator columnValidator, OfficeRepository officeRepository, OfficeDataMapper officeDataMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.context = context;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.columnValidator = columnValidator;
        this.officeRepository = officeRepository;
        this.officeDataMapper = officeDataMapper;
    }
}

