/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.InteropRefundData;
import org.apache.fineract.interoperation.domain.InteropInitiatorType;
import org.apache.fineract.interoperation.domain.InteropTransactionRole;
import org.apache.fineract.interoperation.domain.InteropTransactionScenario;

public class InteropTransactionTypeData {
    public static final List<String> PARAMS = List.copyOf(Arrays.asList("scenario", "subScenario", "initiator", "initiatorType", "refundInfo", "balanceOfPayments"));
    @NotNull
    private final InteropTransactionScenario scenario;
    private final String subScenario;
    @NotNull
    private final InteropTransactionRole initiator;
    @NotNull
    private final InteropInitiatorType initiatorType;
    @Valid
    private InteropRefundData refundInfo;
    private String balanceOfPayments;

    InteropTransactionTypeData(InteropTransactionScenario scenario, String subScenario, InteropTransactionRole initiator, InteropInitiatorType initiatorType, InteropRefundData refundInfo, String balanceOfPayments) {
        this.scenario = scenario;
        this.subScenario = subScenario;
        this.initiator = initiator;
        this.initiatorType = initiatorType;
        this.refundInfo = refundInfo;
        this.balanceOfPayments = balanceOfPayments;
    }

    private InteropTransactionTypeData(InteropTransactionScenario scenario, String subScenario, InteropTransactionRole initiator, InteropInitiatorType initiatorType) {
        this(scenario, subScenario, initiator, initiatorType, null, null);
    }

    public InteropTransactionScenario getScenario() {
        return this.scenario;
    }

    public String getSubScenario() {
        return this.subScenario;
    }

    public InteropTransactionRole getInitiator() {
        return this.initiator;
    }

    public InteropInitiatorType getInitiatorType() {
        return this.initiatorType;
    }

    public static InteropTransactionTypeData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, (Collection)PARAMS);
        String scenarioString = jsonHelper.extractStringNamed("scenario", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("scenario").value((Object)scenarioString).notBlank();
        InteropTransactionScenario scenario = InteropTransactionScenario.valueOf((String)scenarioString);
        String subScenario = jsonHelper.extractStringNamed("subScenario", (JsonElement)element);
        String initiatorString = jsonHelper.extractStringNamed("initiator", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("initiator").value((Object)initiatorString).notBlank();
        InteropTransactionRole initiator = InteropTransactionRole.valueOf((String)initiatorString);
        String initiatorTypeString = jsonHelper.extractStringNamed("initiatorType", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("initiatorType").value((Object)initiatorTypeString).notBlank();
        InteropInitiatorType initiatorType = InteropInitiatorType.valueOf((String)initiatorTypeString);
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new InteropTransactionTypeData(scenario, subScenario, initiator, initiatorType);
    }
}

