/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.service;

import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.sms.data.SmsDataValidator;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageAssembler;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.service.SmsWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsWritePlatformServiceJpaRepositoryImpl
implements SmsWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(SmsWritePlatformServiceJpaRepositoryImpl.class);
    private final SmsMessageAssembler assembler;
    private final SmsMessageRepository repository;
    private final SmsDataValidator validator;

    @Autowired
    public SmsWritePlatformServiceJpaRepositoryImpl(SmsMessageAssembler assembler, SmsMessageRepository repository, SmsDataValidator validator) {
        this.assembler = assembler;
        this.repository = repository;
        this.validator = validator;
    }

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        try {
            this.validator.validateForCreate(command.json());
            SmsMessage message = this.assembler.assembleFromJson(command);
            this.repository.saveAndFlush((Object)message);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)message.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult update(Long resourceId, JsonCommand command) {
        try {
            this.validator.validateForUpdate(command.json());
            SmsMessage message = this.assembler.assembleFromResourceId(resourceId);
            Map changes = message.update(command);
            if (!changes.isEmpty()) {
                this.repository.save((Object)message);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(resourceId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long resourceId) {
        try {
            SmsMessage message = this.assembler.assembleFromResourceId(resourceId);
            this.repository.delete((Object)message);
            this.repository.flush();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(null, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
        return new CommandProcessingResultBuilder().withEntityId(resourceId).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("mobile_no")) {
            throw new PlatformDataIntegrityException("error.msg.sms.no.mobile.no.exists", "The group, client or staff provided has no mobile no.", "id", new Object[0]);
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.sms.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }
}

