/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.data;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;

public final class PlatformRequestLog {
    private long startTime;
    private long totalTime;
    private String method;
    private String url;
    private Map<String, String[]> parameters;

    public static PlatformRequestLog from(StopWatch task, HttpServletRequest request) throws IOException {
        String requestUrl = request.getRequestURL().toString();
        HashMap parameters = new HashMap(request.getParameterMap());
        parameters.remove("password");
        parameters.remove("_");
        return new PlatformRequestLog().setStartTime(task.getStartTime()).setTotalTime(task.getTime()).setMethod(request.getMethod()).setUrl(requestUrl).setParameters(parameters);
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getTotalTime() {
        return this.totalTime;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Generated
    public PlatformRequestLog setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public PlatformRequestLog setTotalTime(long totalTime) {
        this.totalTime = totalTime;
        return this;
    }

    @Generated
    public PlatformRequestLog setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public PlatformRequestLog setUrl(String url) {
        this.url = url;
        return this;
    }

    @Generated
    public PlatformRequestLog setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformRequestLog)) {
            return false;
        }
        PlatformRequestLog other = (PlatformRequestLog)o;
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getTotalTime() != other.getTotalTime()) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map this$parameters = this.getParameters();
        Map other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $totalTime = this.getTotalTime();
        result = result * 59 + (int)($totalTime >>> 32 ^ $totalTime);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlatformRequestLog(startTime=" + this.getStartTime() + ", totalTime=" + this.getTotalTime() + ", method=" + this.getMethod() + ", url=" + this.getUrl() + ", parameters=" + String.valueOf(this.getParameters()) + ")";
    }

    @Generated
    public PlatformRequestLog() {
    }
}

