/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import java.util.Date;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobRunHistory;
import org.apache.fineract.infrastructure.jobs.service.SchedularWritePlatformService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.springframework.stereotype.Component;

@Component
public class SchedulerJobListener
implements JobListener {
    private final SchedularWritePlatformService schedularService;
    private final TenantDetailsService tenantDetailsService;
    private int stackTraceLevel = 0;

    public String getName() {
        return "Global Listener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String tenantIdentifier = context.getMergedJobDataMap().getString("tenantIdentifier");
        FineractPlatformTenant existingTenant = ThreadLocalContextUtil.getTenant();
        boolean contextInitialized = false;
        try {
            if (existingTenant == null || !existingTenant.getTenantIdentifier().equals(tenantIdentifier)) {
                contextInitialized = true;
                FineractPlatformTenant tenant = this.tenantDetailsService.loadTenantById(tenantIdentifier);
                ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
            }
            Trigger trigger = context.getTrigger();
            JobKey key = context.getJobDetail().getKey();
            String jobKey = key.getName() + " _ " + key.getGroup();
            ScheduledJobDetail scheduledJobDetails = this.schedularService.findByJobKey(jobKey);
            Long version = this.schedularService.fetchMaxVersionBy(jobKey) + 1L;
            String status = "success";
            String errorMessage = null;
            String errorLog = null;
            if (jobException != null) {
                status = "failed";
                this.stackTraceLevel = 0;
                Throwable throwable = this.getCauseFromException((Throwable)jobException);
                this.stackTraceLevel = 0;
                StackTraceElement[] stackTraceElements = null;
                errorMessage = throwable.getMessage();
                stackTraceElements = throwable.getStackTrace();
                StringBuilder sb = new StringBuilder(throwable.toString());
                for (StackTraceElement element : stackTraceElements) {
                    sb.append("\n \t at ").append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getLineNumber()).append(")");
                }
                errorLog = sb.toString();
            }
            String triggerType = "cron";
            if (context.getMergedJobDataMap().containsKey((Object)"TRIGGER_TYPE_REFERENCE")) {
                triggerType = context.getMergedJobDataMap().getString("TRIGGER_TYPE_REFERENCE");
            }
            if ("cron".equals(triggerType) && trigger.getNextFireTime() != null && trigger.getNextFireTime().after(scheduledJobDetails.getNextRunTime())) {
                scheduledJobDetails.setNextRunTime(trigger.getNextFireTime());
            }
            scheduledJobDetails.setPreviousRunStartTime(context.getFireTime());
            scheduledJobDetails.setCurrentlyRunning(false);
            ScheduledJobRunHistory runHistory = new ScheduledJobRunHistory().setScheduledJobDetail(scheduledJobDetails).setVersion(version).setStartTime(context.getFireTime()).setEndTime(new Date()).setStatus(status).setErrorMessage(errorMessage).setTriggerType(triggerType).setErrorLog(errorLog);
            this.schedularService.saveOrUpdate(scheduledJobDetails, runHistory);
        }
        finally {
            if (contextInitialized) {
                ThreadLocalContextUtil.reset();
            }
        }
    }

    private Throwable getCauseFromException(Throwable exception) {
        if (this.stackTraceLevel <= 7 && exception.getCause() != null && (exception.getCause().toString().contains("SchedulerException") || exception.getCause().toString().contains("JobExecutionException") || exception.getCause().toString().contains("JobMethodInvocationFailedException"))) {
            ++this.stackTraceLevel;
            return this.getCauseFromException(exception.getCause());
        }
        if (exception.getCause() != null) {
            return exception.getCause();
        }
        return exception;
    }

    @Generated
    public SchedulerJobListener(SchedularWritePlatformService schedularService, TenantDetailsService tenantDetailsService) {
        this.schedularService = schedularService;
        this.tenantDetailsService = tenantDetailsService;
    }
}

