/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.jobs.api.SchedulerApiResourceSwagger;
import org.apache.fineract.infrastructure.jobs.api.SchedulerJobApiConstants;
import org.apache.fineract.infrastructure.jobs.data.SchedulerDetailData;
import org.apache.fineract.infrastructure.jobs.service.JobRegisterService;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/scheduler")
@Component
@Tag(name="Scheduler", description="")
public class SchedulerApiResource {
    private final PlatformSecurityContext context;
    private final JobRegisterService jobRegisterService;
    private final ToApiJsonSerializer<SchedulerDetailData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @Autowired
    public SchedulerApiResource(PlatformSecurityContext context, JobRegisterService jobRegisterService, ToApiJsonSerializer<SchedulerDetailData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.jobRegisterService = jobRegisterService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Scheduler Status", description="Returns the scheduler status.\n\nExample Requests:\n\nscheduler")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SchedulerApiResourceSwagger.GetSchedulerResponse.class))})})
    public String retrieveStatus(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("SCHEDULER");
        boolean isSchedulerRunning = this.jobRegisterService.isSchedulerRunning();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        SchedulerDetailData schedulerDetailData = new SchedulerDetailData().setActive(isSchedulerRunning);
        return this.toApiJsonSerializer.serialize(settings, (Object)schedulerDetailData, SchedulerJobApiConstants.SCHEDULER_DETAIL_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate Scheduler Jobs | Suspend Scheduler Jobs", description="Activates the scheduler job service. | Suspends the scheduler job service.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="POST :  scheduler?command=start\n\n\nPOST : scheduler?command=stop")})
    public Response changeSchedulerStatus(@QueryParam(value="command") @Parameter(description="command") String commandParam) {
        boolean hasNotPermission = this.context.authenticatedUser().hasNotPermissionForAnyOf(new String[]{"ALL_FUNCTIONS", "UPDATE_SCHEDULER"});
        if (hasNotPermission) {
            String authorizationMessage = "User has no authority to update scheduler status";
            throw new NoAuthorizationException("User has no authority to update scheduler status");
        }
        Response response = Response.status((int)400).build();
        if (this.is(commandParam, "start")) {
            this.jobRegisterService.startScheduler();
            response = Response.status((int)202).build();
        } else if (this.is(commandParam, "stop")) {
            this.jobRegisterService.pauseScheduler();
            response = Response.status((int)202).build();
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        return response;
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }
}

