/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.util.List;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanChargeDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanChargeDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.AbstractBusinessEventWithCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoanChargeBusinessEventSerializer
extends AbstractBusinessEventWithCustomDataSerializer<LoanChargeBusinessEvent> {
    private final LoanChargeReadPlatformService service;
    private final LoanChargeDataMapper mapper;
    private final List<ExternalEventCustomDataSerializer<LoanChargeBusinessEvent>> externalEventCustomDataSerializers;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanChargeBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanChargeBusinessEvent event = (LoanChargeBusinessEvent)rawEvent;
        LoanChargeData data = this.service.retrieveLoanChargeDetails((Long)((LoanCharge)event.get()).getId(), (Long)((LoanCharge)event.get()).getLoan().getId());
        LoanChargeDataV1 loanChargeDataV1 = this.mapper.map(data);
        loanChargeDataV1.setCustomData(this.collectCustomData((BusinessEvent)event));
        return loanChargeDataV1;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanChargeDataV1.class;
    }

    protected List<ExternalEventCustomDataSerializer<LoanChargeBusinessEvent>> getExternalEventCustomDataSerializers() {
        return this.externalEventCustomDataSerializers;
    }

    @Generated
    public LoanChargeBusinessEventSerializer(LoanChargeReadPlatformService service, LoanChargeDataMapper mapper, List<ExternalEventCustomDataSerializer<LoanChargeBusinessEvent>> externalEventCustomDataSerializers) {
        this.service = service;
        this.mapper = mapper;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

