/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.service.migration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.fineract.infrastructure.core.service.database.DatabasePasswordEncryptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class TenantPasswordEncryptionTask
implements CustomTaskChange,
ApplicationContextAware {
    private static DatabasePasswordEncryptor databasePasswordEncryptor;
    private Map<String, Boolean> done = new ConcurrentHashMap();

    public void execute(Database database) throws CustomChangeException {
        JdbcConnection dbConn = (JdbcConnection)database.getConnection();
        try (Statement selectStatement = dbConn.createStatement();
             Statement updateStatement = dbConn.createStatement();
             ResultSet rs = selectStatement.executeQuery("SELECT id, schema_password FROM tenant_server_connections");){
            while (rs.next()) {
                String id = rs.getString("id");
                if (Boolean.TRUE.equals(this.done.get(id))) continue;
                String schemaPassword = rs.getString("schema_password");
                String encryptedPassword = databasePasswordEncryptor.encrypt(schemaPassword);
                String updateSql = String.format("update tenant_server_connections set schema_password = '%s', master_password_hash = '%s' where id = %s", encryptedPassword, databasePasswordEncryptor.getMasterPasswordHash(), id);
                updateStatement.execute(updateSql);
                this.done.put(id, true);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        databasePasswordEncryptor = (DatabasePasswordEncryptor)applicationContext.getBean(DatabasePasswordEncryptor.class);
    }
}

