/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.constants.CampaignType;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsCampaignData;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsCampaignTimeLine;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaignStatusEnumerations;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.JdbcSupport;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class SmsCampaignMapper
implements RowMapper<SmsCampaignData> {
    private String schema;

    public SmsCampaignMapper() {
        this.setSchema(this.buildCampaignColumn());
    }

    public String schema() {
        return this.schema;
    }

    private String buildCampaignColumn() {
        StringBuilder sql = new StringBuilder(400);
        sql.append("sc.id as id, ");
        sql.append("sc.campaign_name as campaignName, ");
        sql.append("sc.campaign_type as campaignType, ");
        sql.append("sc.campaign_trigger_type as triggerType, ");
        sql.append("sc.report_id as runReportId, ");
        sql.append("sc.message as message, ");
        sql.append("sc.param_value as paramValue, ");
        sql.append("sc.status_enum as status, ");
        sql.append("sc.recurrence as recurrence, ");
        sql.append("sc.recurrence_start_date as recurrenceStartDate, ");
        sql.append("sc.next_trigger_date as nextTriggerDate, ");
        sql.append("sc.last_trigger_date as lastTriggerDate, ");
        sql.append("sc.submittedon_date as submittedOnDate, ");
        sql.append("sbu.username as submittedByUsername, ");
        sql.append("sc.closedon_date as closedOnDate, ");
        sql.append("clu.username as closedByUsername, ");
        sql.append("acu.username as activatedByUsername, ");
        sql.append("sc.approvedon_date as activatedOnDate, ");
        sql.append("sr.report_name as reportName, ");
        sql.append("provider_id as providerId, ");
        sql.append("sc.is_notification as isNotification ");
        sql.append("from sms_campaign sc ");
        sql.append("left join m_appuser sbu on sbu.id = sc.submittedon_userid ");
        sql.append("left join m_appuser acu on acu.id = sc.approvedon_userid ");
        sql.append("left join m_appuser clu on clu.id = sc.closedon_userid ");
        sql.append("left join stretchy_report sr on sr.id = sc.report_id ");
        return sql.toString();
    }

    public SmsCampaignData mapRow(ResultSet rs, int rowNum) throws SQLException {
        Long id = JdbcSupport.getLong((ResultSet)rs, (String)"id");
        String campaignName = rs.getString("campaignName");
        Integer campaignType = JdbcSupport.getInteger((ResultSet)rs, (String)"campaignType");
        EnumOptionData campaignTypeEnum = CampaignType.campaignType((Integer)campaignType);
        Long runReportId = JdbcSupport.getLong((ResultSet)rs, (String)"runReportId");
        String paramValue = rs.getString("paramValue");
        String message = rs.getString("message");
        Integer statusId = JdbcSupport.getInteger((ResultSet)rs, (String)"status");
        EnumOptionData status = SmsCampaignStatusEnumerations.status((Integer)statusId);
        Integer triggerType = JdbcSupport.getInteger((ResultSet)rs, (String)"triggerType");
        EnumOptionData triggerTypeEnum = SmsCampaignTriggerType.triggerType((Integer)triggerType);
        ZonedDateTime nextTriggerDate = JdbcSupport.getDateTime((ResultSet)rs, (String)"nextTriggerDate");
        LocalDate lastTriggerDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"lastTriggerDate");
        LocalDate closedOnDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"closedOnDate");
        String closedByUsername = rs.getString("closedByUsername");
        LocalDate submittedOnDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"submittedOnDate");
        String submittedByUsername = rs.getString("submittedByUsername");
        LocalDate activatedOnDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"activatedOnDate");
        String activatedByUsername = rs.getString("activatedByUsername");
        String recurrence = rs.getString("recurrence");
        ZonedDateTime recurrenceStartDate = JdbcSupport.getDateTime((ResultSet)rs, (String)"recurrenceStartDate");
        SmsCampaignTimeLine smsCampaignTimeLine = new SmsCampaignTimeLine(submittedOnDate, submittedByUsername, activatedOnDate, activatedByUsername, closedOnDate, closedByUsername);
        String reportName = rs.getString("reportName");
        Long providerId = rs.getLong("providerId");
        boolean isNotification = rs.getBoolean("isNotification");
        return SmsCampaignData.instance((Long)id, (String)campaignName, (EnumOptionData)campaignTypeEnum, (EnumOptionData)triggerTypeEnum, (Long)runReportId, (String)reportName, (String)paramValue, (EnumOptionData)status, (String)message, (ZonedDateTime)nextTriggerDate, (LocalDate)lastTriggerDate, (SmsCampaignTimeLine)smsCampaignTimeLine, (ZonedDateTime)recurrenceStartDate, (String)recurrence, (Long)providerId, (boolean)isNotification);
    }

    @Generated
    public void setSchema(String schema) {
        this.schema = schema;
    }
}

