/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.savings;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataIdSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsActivation;
import org.apache.fineract.portfolio.savings.data.SavingsApproval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavingsImportHandler
implements ImportHandler {
    public static final String DAILY = "Daily";
    public static final String MONTHLY = "Monthly";
    public static final String QUARTERLY = "Quarterly";
    public static final String SEMI_ANNUAL = "Semi-Annual";
    public static final String ANNUALLY = "Annually";
    public static final String BI_ANNUAL = "BiAnnual";
    private static final Logger LOG = LoggerFactory.getLogger(SavingsImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public SavingsImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList savings = new ArrayList();
        ArrayList approvalDates = new ArrayList();
        ArrayList activationDates = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, savings, approvalDates, activationDates, statuses, locale, dateFormat);
        return this.importEntity(workbook, savings, approvalDates, activationDates, statuses, dateFormat);
    }

    public void readExcelFile(Workbook workbook, List<SavingsAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<String> statuses, String locale, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("SavingsAccounts");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)savingsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = savingsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)23)) continue;
            savings.add(this.readSavings(workbook, row, statuses, locale, dateFormat));
            approvalDates.add(this.readSavingsApproval(row, locale, dateFormat));
            activationDates.add(this.readSavingsActivation(row, locale, dateFormat));
        }
    }

    private SavingsActivation readSavingsActivation(Row row, String locale, String dateFormat) {
        LocalDate activationDate = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        if (activationDate != null) {
            return SavingsActivation.importInstance((LocalDate)activationDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private SavingsApproval readSavingsApproval(Row row, String locale, String dateFormat) {
        LocalDate approvalDate = ImportHandlerUtils.readAsDate((int)6, (Row)row);
        if (approvalDate != null) {
            return SavingsApproval.importInstance((LocalDate)approvalDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private SavingsAccountData readSavings(Workbook workbook, Row row, List<String> statuses, String locale, String dateFormat) {
        String productName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long productId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Products"), (String)productName);
        String fieldOfficerName = ImportHandlerUtils.readAsString((int)4, (Row)row);
        Long fieldOfficerId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)fieldOfficerName);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)5, (Row)row);
        BigDecimal nominalAnnualInterestRate = null;
        if (ImportHandlerUtils.readAsDouble((int)11, (Row)row) != null) {
            nominalAnnualInterestRate = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)11, (Row)row));
        }
        String interestCompoundingPeriodType = ImportHandlerUtils.readAsString((int)12, (Row)row);
        Long interestCompoundingPeriodTypeId = null;
        EnumOptionData interestCompoundingPeriodTypeEnum = null;
        if (interestCompoundingPeriodType != null) {
            if (interestCompoundingPeriodType.equalsIgnoreCase(DAILY)) {
                interestCompoundingPeriodTypeId = 1L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase(MONTHLY)) {
                interestCompoundingPeriodTypeId = 4L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase(QUARTERLY)) {
                interestCompoundingPeriodTypeId = 5L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase(SEMI_ANNUAL)) {
                interestCompoundingPeriodTypeId = 6L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase(ANNUALLY)) {
                interestCompoundingPeriodTypeId = 7L;
            }
            interestCompoundingPeriodTypeEnum = new EnumOptionData(interestCompoundingPeriodTypeId, null, null);
        }
        String interestPostingPeriodType = ImportHandlerUtils.readAsString((int)13, (Row)row);
        Long interestPostingPeriodTypeId = null;
        EnumOptionData interestPostingPeriodTypeEnum = null;
        if (interestPostingPeriodType != null) {
            if (interestPostingPeriodType.equalsIgnoreCase(DAILY)) {
                interestPostingPeriodTypeId = SavingsPostingInterestPeriodType.DAILY.getValue().longValue();
            } else if (interestPostingPeriodType.equalsIgnoreCase(MONTHLY)) {
                interestPostingPeriodTypeId = 4L;
            } else if (interestPostingPeriodType.equalsIgnoreCase(QUARTERLY)) {
                interestPostingPeriodTypeId = 5L;
            } else if (interestPostingPeriodType.equalsIgnoreCase(ANNUALLY)) {
                interestPostingPeriodTypeId = 7L;
            } else if (interestPostingPeriodType.equalsIgnoreCase(BI_ANNUAL)) {
                interestPostingPeriodTypeId = 6L;
            }
            interestPostingPeriodTypeEnum = new EnumOptionData(interestPostingPeriodTypeId, null, null);
        }
        String interestCalculationType = ImportHandlerUtils.readAsString((int)14, (Row)row);
        Long interestCalculationTypeId = null;
        EnumOptionData interestCalculationTypeEnum = null;
        if (interestCalculationType != null) {
            if (interestCalculationType.equalsIgnoreCase("Daily Balance")) {
                interestCalculationTypeId = 1L;
            } else if (interestCalculationType.equalsIgnoreCase("Average Daily Balance")) {
                interestCalculationTypeId = 2L;
            }
            interestCalculationTypeEnum = new EnumOptionData(interestCalculationTypeId, null, null);
        }
        String interestCalculationDaysInYearType = ImportHandlerUtils.readAsString((int)15, (Row)row);
        EnumOptionData interestCalculationDaysInYearTypeEnum = null;
        Long interestCalculationDaysInYearTypeId = null;
        if (interestCalculationDaysInYearType != null) {
            if (interestCalculationDaysInYearType.equalsIgnoreCase("360 Days")) {
                interestCalculationDaysInYearTypeId = 360L;
            } else if (interestCalculationDaysInYearType.equalsIgnoreCase("365 Days")) {
                interestCalculationDaysInYearTypeId = 365L;
            }
            interestCalculationDaysInYearTypeEnum = new EnumOptionData(interestCalculationDaysInYearTypeId, null, null);
        }
        BigDecimal minRequiredOpeningBalance = null;
        if (ImportHandlerUtils.readAsDouble((int)16, (Row)row) != null) {
            minRequiredOpeningBalance = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)16, (Row)row));
        }
        Integer lockinPeriodFrequency = ImportHandlerUtils.readAsInt((int)17, (Row)row);
        String lockinPeriodFrequencyType = ImportHandlerUtils.readAsString((int)18, (Row)row);
        Long lockinPeriodFrequencyTypeId = null;
        EnumOptionData lockinPeriodFrequencyTypeEnum = null;
        if (lockinPeriodFrequencyType != null) {
            if (lockinPeriodFrequencyType.equalsIgnoreCase("Days")) {
                lockinPeriodFrequencyTypeId = 0L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Weeks")) {
                lockinPeriodFrequencyTypeId = 1L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Months")) {
                lockinPeriodFrequencyTypeId = 2L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase("Years")) {
                lockinPeriodFrequencyTypeId = 3L;
            }
            lockinPeriodFrequencyTypeEnum = new EnumOptionData(lockinPeriodFrequencyTypeId, null, null);
        }
        Boolean applyWithdrawalFeeForTransfers = ImportHandlerUtils.readAsBoolean((int)19, (Row)row);
        String savingsType = null;
        if (ImportHandlerUtils.readAsString((int)1, (Row)row) != null) {
            savingsType = ImportHandlerUtils.readAsString((int)1, (Row)row).toLowerCase(Locale.ENGLISH);
        }
        String clientOrGroupName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        String externalId = ImportHandlerUtils.readAsString((int)22, (Row)row);
        ArrayList<SavingsAccountChargeData> charges = new ArrayList<SavingsAccountChargeData>();
        Boolean allowOverdraft = ImportHandlerUtils.readAsBoolean((int)20, (Row)row);
        BigDecimal overdraftLimit = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)21, (Row)row));
        String charge1 = ImportHandlerUtils.readAsString((int)34, (Row)row);
        String charge2 = ImportHandlerUtils.readAsString((int)37, (Row)row);
        if (charge1 != null) {
            if (ImportHandlerUtils.readAsDouble((int)35, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)34, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)35, (Row)row)), ImportHandlerUtils.readAsDate((int)36, (Row)row)));
            } else {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)34, (Row)row), null, ImportHandlerUtils.readAsDate((int)36, (Row)row)));
            }
        }
        if (charge2 != null) {
            if (ImportHandlerUtils.readAsDouble((int)38, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)37, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)38, (Row)row)), ImportHandlerUtils.readAsDate((int)39, (Row)row)));
            } else {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)37, (Row)row), null, ImportHandlerUtils.readAsDate((int)39, (Row)row)));
            }
        }
        String status = ImportHandlerUtils.readAsString((int)23, (Row)row);
        statuses.add(status);
        if (savingsType != null) {
            if (savingsType.equals("individual")) {
                Long clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientOrGroupName);
                return SavingsAccountData.importInstanceIndividual((Long)clientId, (Long)productId, (Long)fieldOfficerId, (LocalDate)submittedOnDate, (BigDecimal)nominalAnnualInterestRate, (EnumOptionData)interestCompoundingPeriodTypeEnum, (EnumOptionData)interestPostingPeriodTypeEnum, (EnumOptionData)interestCalculationTypeEnum, (EnumOptionData)interestCalculationDaysInYearTypeEnum, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (EnumOptionData)lockinPeriodFrequencyTypeEnum, (boolean)applyWithdrawalFeeForTransfers, (Integer)row.getRowNum(), (String)externalId, charges, (boolean)allowOverdraft, (BigDecimal)overdraftLimit, (String)locale, (String)dateFormat);
            }
            Long groupId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Groups"), (String)clientOrGroupName);
            return SavingsAccountData.importInstanceGroup((Long)groupId, (Long)productId, (Long)fieldOfficerId, (LocalDate)submittedOnDate, (BigDecimal)nominalAnnualInterestRate, (EnumOptionData)interestCompoundingPeriodTypeEnum, (EnumOptionData)interestPostingPeriodTypeEnum, (EnumOptionData)interestCalculationTypeEnum, (EnumOptionData)interestCalculationDaysInYearTypeEnum, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (EnumOptionData)lockinPeriodFrequencyTypeEnum, (boolean)applyWithdrawalFeeForTransfers, (Integer)row.getRowNum(), (String)externalId, charges, (boolean)allowOverdraft, (BigDecimal)overdraftLimit, (String)locale, (String)dateFormat);
        }
        return null;
    }

    public Count importEntity(Workbook workbook, List<SavingsAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<String> statuses, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("SavingsAccounts");
        int successCount = 0;
        int errorCount = 0;
        int progressLevel = 0;
        String errorMessage = "";
        Long savingsId = null;
        for (int i = 0; i < savings.size(); ++i) {
            Row row = savingsSheet.getRow(savings.get(i).getRowIndex().intValue());
            Cell statusCell = row.createCell(23);
            Cell errorReportCell = row.createCell(25);
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0) {
                    CommandProcessingResult result = this.importSavings(savings, i, dateFormat);
                    savingsId = result.getSavingsId();
                    progressLevel = 1;
                } else {
                    savingsId = ImportHandlerUtils.readAsLong((int)24, (Row)savingsSheet.getRow(savings.get(i).getRowIndex().intValue()));
                }
                if (progressLevel <= 1) {
                    progressLevel = this.importSavingsApproval(approvalDates, savingsId, i, dateFormat);
                }
                if (progressLevel <= 2) {
                    progressLevel = this.importSavingsActivation(activationDates, savingsId, i, dateFormat);
                }
                ++successCount;
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeSavingsErrorMessage(workbook, savingsId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(savingsSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeSavingsErrorMessage(Workbook workbook, Long savingsId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = "";
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Approval failed";
        } else if (progressLevel == 2) {
            status = "Activation failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(24).setCellValue((double)savingsId.longValue());
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private void setReportHeaders(Sheet savingsSheet) {
        savingsSheet.setColumnWidth(23, 4000);
        Row rowHeader = savingsSheet.getRow(0);
        ImportHandlerUtils.writeString((int)23, (Row)rowHeader, (String)"Status");
        ImportHandlerUtils.writeString((int)24, (Row)rowHeader, (String)"Savings ID");
        ImportHandlerUtils.writeString((int)25, (Row)rowHeader, (String)"Failure Report");
    }

    private int importSavingsActivation(List<SavingsActivation> activationDates, Long savingsId, int i, String dateFormat) {
        if (activationDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, activationDates.get(i).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)activationDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().savingsAccountActivation(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 3;
    }

    private int importSavingsApproval(List<SavingsApproval> approvalDates, Long savingsId, int i, String dateFormat) {
        if (approvalDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, approvalDates.get(i).getLocale()));
            String payload = gsonBuilder.create().toJson((Object)approvalDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().approveSavingsAccountApplication(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 2;
    }

    private CommandProcessingResult importSavings(List<SavingsAccountData> savings, int i, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, savings.get(i).getLocale()));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataIdSerializer());
        JsonObject savingsJsonob = gsonBuilder.create().toJsonTree((Object)savings.get(i)).getAsJsonObject();
        savingsJsonob.remove("isDormancyTrackingActive");
        String payload = savingsJsonob.toString();
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSavingsAccount().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Approval failed")) {
            return 1;
        }
        if (status.equals("Activation failed")) {
            return 2;
        }
        return 0;
    }
}

