/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.service;

import jakarta.persistence.PersistenceException;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.accountnumberformat.data.AccountNumberFormatDataValidator;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatEnumerations;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.accountnumberformat.service.AccountNumberFormatWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountNumberFormatWritePlatformServiceJpaRepositoryImpl
implements AccountNumberFormatWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountNumberFormatWritePlatformServiceJpaRepositoryImpl.class);
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final AccountNumberFormatDataValidator accountNumberFormatDataValidator;

    @Autowired
    AccountNumberFormatWritePlatformServiceJpaRepositoryImpl(AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, AccountNumberFormatDataValidator accountNumberFormatDataValidator) {
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.accountNumberFormatDataValidator = accountNumberFormatDataValidator;
    }

    @Transactional
    public CommandProcessingResult createAccountNumberFormat(JsonCommand command) {
        try {
            this.accountNumberFormatDataValidator.validateForCreate(command.json());
            Integer accountTypeId = command.integerValueSansLocaleOfParameterNamed("accountType");
            EntityAccountType entityAccountType = EntityAccountType.fromInt((int)accountTypeId);
            Integer prefixTypeId = command.integerValueSansLocaleOfParameterNamed("prefixType");
            AccountNumberFormatEnumerations.AccountNumberPrefixType accountNumberPrefixType = null;
            if (prefixTypeId != null) {
                accountNumberPrefixType = AccountNumberFormatEnumerations.AccountNumberPrefixType.fromInt((int)prefixTypeId);
            }
            String prefixCharacter = command.stringValueOfParameterNamed("prefixCharacter");
            AccountNumberFormat accountNumberFormat = new AccountNumberFormat(entityAccountType, accountNumberPrefixType, prefixCharacter);
            this.accountNumberFormatRepository.saveAndFlush(accountNumberFormat);
            return new CommandProcessingResultBuilder().withEntityId((Long)accountNumberFormat.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)ee));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateAccountNumberFormat(Long accountNumberFormatId, JsonCommand command) {
        try {
            Object newValue;
            AccountNumberFormat accountNumberFormatForUpdate = this.accountNumberFormatRepository.findOneWithNotFoundDetection(accountNumberFormatId);
            EntityAccountType accountType = accountNumberFormatForUpdate.getAccountType();
            this.accountNumberFormatDataValidator.validateForUpdate(command.json(), accountType);
            LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
            if (command.isChangeInIntegerSansLocaleParameterNamed("prefixType", accountNumberFormatForUpdate.getPrefixEnum())) {
                newValue = command.integerValueSansLocaleOfParameterNamed("prefixType");
                AccountNumberFormatEnumerations.AccountNumberPrefixType accountNumberPrefixType = AccountNumberFormatEnumerations.AccountNumberPrefixType.fromInt((int)((Integer)newValue));
                actualChanges.put("prefixType", accountNumberPrefixType);
                accountNumberFormatForUpdate.setPrefix(accountNumberPrefixType);
            }
            if (command.isChangeInStringParameterNamed("prefixCharacter", accountNumberFormatForUpdate.getPrefixCharacter())) {
                newValue = command.stringValueOfParameterNamed("prefixCharacter");
                actualChanges.put("prefixCharacter", newValue);
                accountNumberFormatForUpdate.setPrefixCharacter((String)newValue);
            }
            if (!actualChanges.isEmpty()) {
                this.accountNumberFormatRepository.saveAndFlush(accountNumberFormatForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(accountNumberFormatId).with(actualChanges).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)ee));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteAccountNumberFormat(Long accountNumberFormatId) {
        AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findOneWithNotFoundDetection(accountNumberFormatId);
        this.accountNumberFormatRepository.delete(accountNumberFormat);
        return new CommandProcessingResultBuilder().withEntityId(accountNumberFormatId).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("account_type_enum")) {
            Integer accountTypeId = command.integerValueSansLocaleOfParameterNamed("accountType");
            EntityAccountType entityAccountType = EntityAccountType.fromInt((int)accountTypeId);
            throw new PlatformDataIntegrityException("error.msg.account.number.format.duplicate.account.type", "Account Format preferences for Account type `" + entityAccountType.getCode() + "` already exists", "externalId", new Object[]{entityAccountType.getValue(), entityAccountType.getCode()});
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.account.number.format.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }
}

