/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.commands.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.commands.data.AuditData;
import org.apache.fineract.commands.data.AuditSearchData;
import org.apache.fineract.commands.data.request.AuditRequest;
import org.apache.fineract.commands.service.AuditReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.springframework.stereotype.Component;

@Path(value="/v1/audits")
@Component
@Tag(name="Audits", description="Every non-read Mifos API request is audited. A fully processed request can not be changed or deleted. See maker checker api for situations where an audit is not fully processed.\n\nPermissions: To search and look at audit entries a user needs to be attached to a role that has one of the ALL_FUNCTIONS, ALL_FUNCTIONS_READ or READ_AUDIT permissions.\n\nData Scope: A user can only see audits that are within their data scope. However, 'head office' users can see all audits including those that aren't office/branch related e.g. Loan Product changes.\")")
public class AuditsApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "AUDIT";
    private final PlatformSecurityContext context;
    private final AuditReadPlatformService auditReadPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ToApiJsonSerializer<String> toApiJsonSerializer;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Audits", description="Get a 200 list of audits that match the criteria supplied and sorted by audit id in descending order, and are within the requestors' data scope. Also it supports pagination and sorting\n\nExample Requests:\n\naudits\n\naudits?fields=madeOnDate,maker,processingResult\n\naudits?makerDateTimeFrom=2013-03-25 08:00:00&makerDateTimeTo=2013-04-04 18:00:00\n\naudits?officeId=1\n\naudits?officeId=1&includeJson=true")
    public String retrieveAuditEntries(@Context UriInfo uriInfo, @BeanParam AuditRequest auditRequest, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        PaginationParameters parameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        SQLBuilder extraCriteria = this.getExtraCriteria(auditRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(parameters.isPaged() ? this.auditReadPlatformService.retrievePaginatedAuditEntries(extraCriteria, settings.isIncludeJson(), parameters) : this.auditReadPlatformService.retrieveAuditEntries(extraCriteria, settings.isIncludeJson()));
    }

    @GET
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve an Audit Entry", description="Example Requests:\n\naudits/20\naudits/20?fields=madeOnDate,maker,processingResult")
    public AuditData retrieveAuditEntry(@PathParam(value="auditId") @Parameter Long auditId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.auditReadPlatformService.retrieveAuditEntry(auditId);
    }

    @GET
    @Path(value="/searchtemplate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Audit Search Template", description="This is a convenience resource. It can be useful when building an Audit Search UI. \"appUsers\" are data scoped to the office/branch the requestor is associated with.\n\nExample Requests:\n\naudits/searchtemplate\naudits/searchtemplate?fields=actionNames")
    public AuditSearchData retrieveAuditSearchTemplate() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.auditReadPlatformService.retrieveSearchTemplate("audit");
    }

    private SQLBuilder getExtraCriteria(AuditRequest auditRequest) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addNonNullCriteria("aud.action_name = ", (Object)auditRequest.getActionName());
        if (auditRequest.getEntityName() != null) {
            extraCriteria.addCriteria("aud.entity_name like", (Object)(auditRequest.getEntityName() + "%"));
        }
        extraCriteria.addNonNullCriteria("aud.resource_id = ", (Object)auditRequest.getResourceId());
        extraCriteria.addNonNullCriteria("aud.maker_id = ", (Object)auditRequest.getMakerId());
        extraCriteria.addNonNullCriteria("aud.checker_id = ", (Object)auditRequest.getCheckerId());
        if (auditRequest.getMakerDateTimeFrom() != null) {
            extraCriteria.addSubOperation(criteria -> {
                criteria.addNonNullCriteria("aud.made_on_date >= ", (Object)auditRequest.getMakerDateTimeFrom(), SQLBuilder.WhereLogicalOperator.NONE);
                criteria.addNonNullCriteria("aud.made_on_date_utc >= ", (Object)auditRequest.getMakerDateTimeFrom(), SQLBuilder.WhereLogicalOperator.OR);
            });
        }
        if (auditRequest.getMakerDateTimeTo() != null) {
            extraCriteria.addSubOperation(criteria -> {
                criteria.addNonNullCriteria("aud.made_on_date <= ", (Object)auditRequest.getMakerDateTimeTo(), SQLBuilder.WhereLogicalOperator.NONE);
                criteria.addNonNullCriteria("aud.made_on_date_utc <= ", (Object)auditRequest.getMakerDateTimeTo(), SQLBuilder.WhereLogicalOperator.OR);
            });
        }
        if (auditRequest.getCheckerDateTimeFrom() != null) {
            extraCriteria.addSubOperation(criteria -> {
                criteria.addNonNullCriteria("aud.checked_on_date >= ", (Object)auditRequest.getCheckerDateTimeFrom(), SQLBuilder.WhereLogicalOperator.NONE);
                criteria.addNonNullCriteria("aud.checked_on_date_utc >= ", (Object)auditRequest.getCheckerDateTimeFrom(), SQLBuilder.WhereLogicalOperator.OR);
            });
        }
        if (auditRequest.getCheckerDateTimeTo() != null) {
            extraCriteria.addSubOperation(criteria -> {
                criteria.addNonNullCriteria("aud.checked_on_date <= ", (Object)auditRequest.getCheckerDateTimeTo(), SQLBuilder.WhereLogicalOperator.NONE);
                criteria.addNonNullCriteria("aud.checked_on_date_utc <= ", (Object)auditRequest.getCheckerDateTimeTo(), SQLBuilder.WhereLogicalOperator.OR);
            });
        }
        extraCriteria.addNonNullCriteria("aud.status = ", (Object)auditRequest.getStatus());
        extraCriteria.addNonNullCriteria("aud.office_id = ", (Object)auditRequest.getOfficeId());
        extraCriteria.addNonNullCriteria("aud.group_id = ", (Object)auditRequest.getGroupId());
        extraCriteria.addNonNullCriteria("aud.client_id = ", (Object)auditRequest.getClientId());
        extraCriteria.addNonNullCriteria("aud.loan_id = ", (Object)auditRequest.getLoanId());
        extraCriteria.addNonNullCriteria("aud.savings_account_id = ", (Object)auditRequest.getSavingsAccountId());
        return extraCriteria;
    }

    @Generated
    public AuditsApiResource(PlatformSecurityContext context, AuditReadPlatformService auditReadPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, ToApiJsonSerializer<String> toApiJsonSerializer) {
        this.context = context;
        this.auditReadPlatformService = auditReadPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

