/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class ApplyChargeToOverdueLoansBusinessStep
implements LoanCOBBusinessStep {
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanChargeWritePlatformService loanChargeWritePlatformService;

    public Loan execute(Loan loan) {
        Collection overdueLoanScheduleDataList = this.loanReadPlatformService.retrieveAllOverdueInstallmentsForLoan(loan);
        if (!overdueLoanScheduleDataList.isEmpty()) {
            this.loanChargeWritePlatformService.applyOverdueChargesForLoan((Long)loan.getId(), overdueLoanScheduleDataList);
        }
        return loan;
    }

    public String getEnumStyledName() {
        return "APPLY_CHARGE_TO_OVERDUE_LOANS";
    }

    public String getHumanReadableName() {
        return "Apply charge to overdue loans";
    }

    @Generated
    public ApplyChargeToOverdueLoansBusinessStep(LoanReadPlatformService loanReadPlatformService, LoanChargeWritePlatformService loanChargeWritePlatformService) {
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanChargeWritePlatformService = loanChargeWritePlatformService;
    }
}

